
C
C     Version 3.1.0 03-DEC-2016 (NJB)
C
C        Bug fix: now checks for room in the epoch buffer
C        before reading data from a segment.
C
C        Segment IDs now are just the first SIDLEN characters
C        of the input file name.
C
C     Version 3.0.0 18-APR-2016 (NJB)
C
C        Increased parameter MAXREC from 100K to 1M.
C
C     Version 2.1.0 25-FEB-2015 (NJB)
C
C
C     Convert a type 18 SPK to a type 19 SPK.
C
C     The input SPK file must satisfy the following 
C     constraints:
C 
C        - The segments occur in increasing time order.
C
C        - There are no gaps between segments.
C
C        - All segments are type 18
C
C        - All segments have the same
C
C            > body
C            > center
C            > frame
C            > subtype
C            > degree
C
C
C        - The stop time of each segment but the last
C          is exactly the start time of the next.
C
C        - The segments have no padding: the first and
C          last epochs of each segment coincide with
C          that segment's descriptor bounds.
C
C        - No segment containts more than MAXREC 
C          packets.
C
C
C     To build this program, link against the support
C     and SPICELIB libraries.
C
C     To run this program, type on the command line
C
C        spk18to19 <input spk name> <output spk name>
C     

      PROGRAM SPK18TO19
      IMPLICIT NONE

      INCLUDE 'spk19.inc'

C
C     SPICELIB functions
C
      INTEGER               RTRIM
      LOGICAL               EXISTS
      
C
C     Local parameters
C
      CHARACTER*(*)         VERSN
      PARAMETER           ( VERSN  = '3.1.0 03-DEC-2016 (NJB)' )


      INTEGER               CMDLEN
      PARAMETER           ( CMDLEN = 2000 )

      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 255 )
      
      INTEGER               CTBSIZ
      PARAMETER           ( CTBSIZ = 4 )

      INTEGER               DSCSIZ
      PARAMETER           ( DSCSIZ = 5 )

      INTEGER               FILSIZ
      PARAMETER           ( FILSIZ = 255 )

      INTEGER               FRNMLN
      PARAMETER           ( FRNMLN = 32 )

C
C     Number of records that can be stored in local buffers.
C     This number should be at least as large as the largest
C     segment this program is expected to find in an input file.
C
      INTEGER               MAXREC
      PARAMETER           ( MAXREC = 1000000 )

      INTEGER               MAXIVL
      PARAMETER           ( MAXIVL = MAXREC )

      INTEGER               MBFSIZ
      PARAMETER           ( MBFSIZ = MAXREC * S19PS0 )


      INTEGER               ND
      PARAMETER           ( ND     = 2 )

      INTEGER               NI
      PARAMETER           ( NI     = 6 )
      
      INTEGER               SIDLEN
      PARAMETER           ( SIDLEN = 40 )

      INTEGER               MAXCOM
      PARAMETER           ( MAXCOM = 10 )

      INTEGER               TIMLEN
      PARAMETER           ( TIMLEN = 45 )

C
C     Local variables
C
      CHARACTER*(LNSIZE)    ASTRLN
      CHARACTER*(CMDLEN)    CMD
      CHARACTER*(LNSIZE)    CMNBUF ( MAXCOM )
      CHARACTER*(FRNMLN)    FRAME
      CHARACTER*(FILSIZ)    INSPK
      CHARACTER*(LNSIZE)    LINE
      CHARACTER*(FILSIZ)    OUTSPK
      CHARACTER*(SIDLEN)    SEGID
      CHARACTER*(TIMLEN)    TSTAMP

      DOUBLE PRECISION      CTRLBF ( CTBSIZ )
      DOUBLE PRECISION      DC     ( ND )
      DOUBLE PRECISION      EPOCHS ( MAXREC )
      DOUBLE PRECISION      FIRST
      DOUBLE PRECISION      IVLBDS ( MAXIVL + 1 )
      DOUBLE PRECISION      LAST
      DOUBLE PRECISION      PACKTS ( MBFSIZ )
      DOUBLE PRECISION      SEGEND
      DOUBLE PRECISION      SUM    ( DSCSIZ )
      DOUBLE PRECISION      TVEC   ( 6 )

      INTEGER               BADDR
      INTEGER               BODY
      INTEGER               CENTER
      INTEGER               DEGRES ( MAXIVL )
      INTEGER               DTYPE
      INTEGER               EADDR
      INTEGER               FRCODE
      INTEGER               HAN1
      INTEGER               HAN2
      INTEGER               IC     ( NI )
      INTEGER               L
      INTEGER               N
      INTEGER               NIVALS
      INTEGER               NPKTS  ( MAXIVL )
      INTEGER               NREC
      INTEGER               PKTSIZ
      INTEGER               PKTTOT
      INTEGER               ROOM
      INTEGER               SEGNO
      INTEGER               SEGSIZ
      INTEGER               SUBTPS ( MAXIVL )
      INTEGER               SUBTYP
      INTEGER               TO
      INTEGER               WINSIZ

      LOGICAL               DONE
      LOGICAL               FOUND
      LOGICAL               SELLST

C
C     Initial values
C
      DATA                  SUM    / 5 * 0.D0 /

      DATA                  SELLST / .TRUE. /

C
C     Get file names.
C
      CALL GETCML ( CMD )

      CALL NEXTWD ( CMD, INSPK, OUTSPK )

C
C     Check the input file.
C
      CALL DAFOPR ( INSPK, HAN1 )

      CALL DAFBFS ( HAN1 )

      CALL DAFFNA ( FOUND )

      IF ( .NOT. FOUND ) THEN

         CALL SETMSG ( 'No segments found in file #.' )
         CALL ERRCH  ( '#', INSPK                     )
         CALL SIGERR ( 'SPICE(NOSEGMENTS)'            )

      END IF

C
C     Extract the attributes of the first segment.
C
      CALL DAFGS ( SUM )
      CALL DAFUS ( SUM, ND, NI, DC, IC )

      BODY   = IC(1)
      CENTER = IC(2)
      FRCODE = IC(3)
      DTYPE  = IC(4)
      SEGEND = DC(2)
      
      IF ( DTYPE .NE. 18 ) THEN
         
         CALL SETMSG ( 'First segment has type #; only '
     .   //            'type 18 is allowed.'            )
         CALL ERRINT ( '#', DTYPE                       )
         CALL SIGERR ( 'SPICE(INVALIDTYPE)'             )

      END IF

C
C     We'll need a frame name in order to call the segment
C     writer SPKW19.
C
      CALL FRMNAM ( FRCODE, FRAME )

      IF ( FRAME .EQ. ' ' ) THEN

         CALL SETMSG ( 'Could not map frame ID # to a name.' )
         CALL ERRINT ( '#',  FRCODE                          )
         CALL SIGERR ( 'SPICE(NOTRANSLATION)'                )

      END IF
C
C     Read the remaining segment descriptors and check the
C     segments' attributes.
C
      SEGNO = 1

      CALL DAFFNA( FOUND )

      DO WHILE ( FOUND )

         SEGNO = SEGNO + 1

         CALL DAFGS ( SUM )
         CALL DAFUS ( SUM, ND, NI, DC, IC )
         
         IF ( IC(1) .NE. BODY ) THEN

            CALL SETMSG ( 'Body ID # of segment # '
     .      //            'doesn''t match body ID # '
     .      //            'of the first segment.'     )
            CALL ERRINT ( '#',  IC(1)                 )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL ERRINT ( '#',  BODY                  )
            CALL SIGERR ( 'SPICE(BODYMISMATCH)'       )

         END IF

         IF ( IC(2) .NE. CENTER ) THEN

            CALL SETMSG ( 'Center ID # of segment # '
     .      //            'doesn''t match center ID # '
     .      //            'of the first segment.'     )
            CALL ERRINT ( '#',  IC(2)                 )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL ERRINT ( '#',  CENTER                )
            CALL SIGERR ( 'SPICE(CENTERMISMATCH)'     )

         END IF

         IF ( IC(3) .NE. FRCODE ) THEN

            CALL SETMSG ( 'Frame ID # of segment # '
     .      //            'doesn''t match frame ID # '
     .      //            'of the first segment.'     )
            CALL ERRINT ( '#',  IC(3)                 )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL ERRINT ( '#',  FRCODE                )
            CALL SIGERR ( 'SPICE(FRAMEMISMATCH)'      )

         END IF

         IF ( IC(4) .NE. DTYPE ) THEN

            CALL SETMSG ( 'Data type # of segment # '
     .      //            'is not type 18.'           )
            CALL ERRINT ( '#',  IC(3)                 )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL SIGERR ( 'SPICE(BADDATATYPE)'        )

         END IF

         IF ( DC(1) .NE. SEGEND ) THEN

            CALL SETMSG ( 'Start time # of segment # '
     .      //            'doesn''t match end time # '
     .      //            'of previous segment. The '
     .      //            'difference is #.'          )
            CALL ERRDP  ( '#',  DC(1)                 )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL ERRDP  ( '#',  SEGEND                )
            CALL ERRDP  ( '#',  DC(1) - SEGEND        )
            CALL SIGERR ( 'SPICE(TIMEMISMATCH)'       )

         END IF

C
C        Make sure we can handle a segment of this size.
C        
C
C        Make sure we can handle a segment of this size.
C        
         CALL DAFGDA ( HAN1, IC(6), IC(6), CTRLBF )

         NREC = NINT( CTRLBF(1) )

         IF ( NREC .GT. MAXREC ) THEN

            CALL SETMSG ( 'Record count # of segment # '
     .      //            'exceeds buffer limit #.'   )
            CALL ERRINT ( '#',  NREC                  )
            CALL ERRINT ( '#',  SEGNO                 )
            CALL ERRINT ( '#',  MAXREC                )
            CALL SIGERR ( 'SPICE(BUFFERTOOSMALL)'     )

         END IF


         SEGEND = DC(2)
         
         CALL DAFFNA( FOUND )

      END DO

C
C     At this point, the input file has been validated.
C     Open the output file.
C     
      IF ( EXISTS(OUTSPK) ) THEN
         CALL DELFIL( OUTSPK )
      END IF

      CALL SPKOPN ( OUTSPK, OUTSPK, 0, HAN2 )

C
C     Write a comment header to the output SPK.
C
C     Comment area separator line.
C
      ASTRLN = '****************************************' //
     .         '****************************************'

      CALL CPUTIM ( TVEC )
      TSTAMP = 'YYYY-MM-DDTHR:MN:SC'

      CALL DPFMT ( TVEC(1), '0YYY',  TSTAMP(1:4)   )
      CALL DPFMT ( TVEC(2), '0M',    TSTAMP(6:7)   )
      CALL DPFMT ( TVEC(3), '0D',    TSTAMP(9:10)  )
      CALL DPFMT ( TVEC(4), '0h',    TSTAMP(12:13) )
      CALL DPFMT ( TVEC(5), '0m',    TSTAMP(15:16) )
      CALL DPFMT ( TVEC(6), '0s',    TSTAMP(18:19) )
      
      CMNBUF ( 1 ) = ' ' 
      CMNBUF ( 2 ) =  ASTRLN 
      CMNBUF ( 3 ) = 'This file was converted to type 19 by SPK18TO19'
      CMNBUF ( 4 ) = ' '
      CMNBUF ( 5 ) = 
     .   'SPK18TO19 VERSION:       ' // VERSN
      CMNBUF ( 6 ) = 
     .   'SPK18TO19 RUN DATE/TIME: ' // TSTAMP(:RTRIM(TSTAMP)) 
      CMNBUF ( 7 ) = 
     .   'SPK18TO19 INPUT FILE:    ' // INSPK (:RTRIM(INSPK)) 
      CMNBUF ( 8 ) = 
     .   'SPK18TO19 OUTPUT FILE:   ' // OUTSPK(:RTRIM(OUTSPK))
      CMNBUF ( 9 ) = ASTRLN 
      CMNBUF (10 ) = ' ' 

      L            = 10

      CALL DAFAC ( HAN2, L, CMNBUF )
         

C
C     Copy the comments from the input SPK to the output SPK.
C
      CALL DAFEC ( HAN1, 1, N, LINE, DONE )

      DO WHILE ( .NOT. DONE )
C
C        Write these comments to the output SPK file.
C
         CALL DAFAC ( HAN2, 1, LINE )

C
C        Get the next comment line.
C        
         CALL DAFEC ( HAN1, 1, N, LINE, DONE )

      END DO

C
C     Traverse the input file's descriptor list again in
C     forward order. This time collect data and write
C     out type 19 segments as we go.
C
C     We'll buffer input segments until we run out of buffer
C     space or run out of input segments. We'll use a buffer
C     large enough to hold the largest segment we expect to
C     see; we won't split input segments across multiple 
C     output segments.
C
C     Below, we'll let N be the number of elements in the
C     mini-segment buffer.
C
      N      = 0
      ROOM   = MBFSIZ
      TO     = 1
      NIVALS = 0
      SEGNO  = 0

      CALL DAFBFS( HAN1 )

      CALL DAFFNA( FOUND )

      DO WHILE ( FOUND )

         SEGNO  = SEGNO  + 1

C         WRITE (*,*) 'Reading segment ', SEGNO

C
C        Read the input segment descriptor; we need the
C        segment time bounds.
C
         CALL DAFGS( SUM )
         CALL DAFUS( SUM, ND, NI, DC, IC )

C
C        Get the segment's address range; compute the
C        segment size.
C
         BADDR  = IC(5)
         EADDR  = IC(6)
 
         SEGSIZ = EADDR - BADDR + 1

         
         IF ( SEGSIZ .GT. MBFSIZ ) THEN
            
            CALL SETMSG ( 'Segment size is #; '
     .      //            'MBFSIZ = #. This segment cannot '
     .      //            'be buffered.'                   )
            CALL ERRINT ( '#',  SEGSIZ                     )
            CALL ERRINT ( '#',  MBFSIZ                     )
            CALL SIGERR ( 'SPICE(BUFFERTOOSMALL)'          )

         END IF 
 
         CALL DAFGDA ( HAN1, IC(6)-2, IC(6), CTRLBF )

         SUBTYP = NINT( CTRLBF(1) )
         NREC   = NINT( CTRLBF(3) )

         IF ( SUBTYP .EQ. S19TP0 ) THEN

            PKTSIZ = S19PS0

         ELSE IF ( SUBTYP .EQ. S19TP1 ) THEN

            PKTSIZ = S19PS1

         ELSE
         
            CALL SETMSG ( 'Unexpected SPK type 19 subtype # '
     .      //            'found in segment #.'               )
            CALL ERRINT ( '#',  SUBTYP                        )
            CALL ERRINT ( '#',  SEGNO                         )
            CALL SIGERR ( 'SPICE(INVALIDSUBTYPE)'             )
            CALL CHKOUT ( 'SPKW19'                            )
      
         END IF         

         PKTTOT = NREC * PKTSIZ

C
C        Buffer the packets of the current input segment if we have
C        room for them. There must be room in both the mini-segment
C        buffer and the mini-segment size buffer.
C
         IF (       ( PKTTOT .LE. ROOM   ) 
     .        .AND. ( N+NREC .LT. MAXREC )
     .        .AND. ( NIVALS .LT. MAXIVL )  ) THEN

C
C           We have a new interpolation interval/mini segment.
C
            NIVALS = NIVALS + 1

C
C           Copy both the interval start and stop times into
C           the interval buffer. We'll overwrite the previous
C           stop time with the current start time. This process
C           will leave the buffer containing all of the interval
C           start times and the final interval stop time when
C           we're ready to write out a segment.
C
            IVLBDS ( NIVALS   ) = DC(1)
            IVLBDS ( NIVALS+1 ) = DC(2)

C
C           Read the input segment packets into the mini-segment
C           buffer.
C           
            CALL DAFGDA ( HAN1, BADDR, BADDR-1+PKTTOT, PACKTS(TO) )

            TO   = TO   + PKTTOT
            ROOM = ROOM - PKTTOT

C
C           Read the input segment epochs into the epochs buffer.
C
            CALL DAFGDA ( HAN1, 
     .                    BADDR+PKTTOT, 
     .                    BADDR+PKTTOT+NREC-1, 
     .                    EPOCHS(N+1)          )
            N = N + NREC

C
C           Store the subtype, degree, and record count.
C            
            WINSIZ = NINT( CTRLBF(2) )

            IF ( SUBTYP .EQ. S19TP0 ) THEN

               DEGRES( NIVALS ) = ( 2 * WINSIZ ) - 1

            ELSE IF ( SUBTYP .EQ. S19TP1 ) THEN

               DEGRES( NIVALS ) = WINSIZ - 1

            ELSE

               CALL SETMSG ( 'SUBTYPE # is not supported.' )
               CALL ERRINT ( '#',  SUBTYP                  )
               CALL SIGERR ( 'SPICE(BUG)'                  )

            END IF
            
 
            SUBTPS( NIVALS ) = SUBTYP
            NPKTS ( NIVALS ) = NREC

C
C           Seek the next input segment.
C
            CALL DAFFNA ( FOUND )

         ELSE
C
C           We can't buffer the current segment. Write out the
C           buffer contents.
C
C            WRITE (*,*) 'About to write segment; SEGNO = ', SEGNO-1

C
C           Create a segment ID.
C
            SEGID = INSPK(:SIDLEN)
C
C           Set the segment bounds using the interval bounds.
C
            FIRST = IVLBDS ( 1          )
            LAST  = IVLBDS ( NIVALS + 1 )
            
C
C           Write the segment. Note that the buffer doesn't contain
C           data from the last segment we located with DAFFNA.
C
            CALL SPKW19 ( HAN2,    BODY,    CENTER,  FRAME,    
     .                    FIRST,   LAST,    SEGID,   NIVALS,  
     .                    NPKTS,   SUBTPS,  DEGRES,  PACKTS,
     .                    EPOCHS,  IVLBDS,  SELLST          )
 
C
C           Re-set the interval and buffer entry counts.
C        
            NIVALS = 0
            N      = 0
            PKTTOT = 0
            ROOM   = MBFSIZ
            TO     = 1

C
C           Re-process the current segment at the top of the loop.
C
            SEGNO = SEGNO - 1

         END IF

C
C        Note that DAFFNA gets called only when we're able
C        to buffer data from the last segment seen. If we
C        were forced to write out a segment, we still have
C        one waiting to be processed, so we don't call DAFFNA.
C
      END DO


C
C     Unless the input file had no segments, we will have 
C     buffered data at this point. If so, write a segment.
C
      IF ( N .GT. 0 ) THEN
C
C        Create a segment ID.
C
         SEGID = INSPK(:SIDLEN)

C
C        Set the segment bounds using the interval bounds.
C
         FIRST = IVLBDS ( 1          )
         LAST  = IVLBDS ( NIVALS + 1 )

C
C        Write the segment.
C
         CALL SPKW19 ( HAN2,    BODY,    CENTER,  FRAME,    
     .                 FIRST,   LAST,    SEGID,   NIVALS,  
     .                 NPKTS,   SUBTPS,  DEGRES,  PACKTS,
     .                 EPOCHS,  IVLBDS,  SELLST          )

      END IF

C
C     Close the output file.
C
      CALL SPKCLS( HAN2 )

      WRITE (*,*) 'SPK file was written.'
      END 

