C$Procedure      ZZAXUTIL ( Axis Utility )
 
      SUBROUTINE ZZAXUTIL ( AXIS, DOFLIP, ONEWRD, WHCHAX )
 
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines. Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     This routine returns information about the axis specified
C     through the string AXIS.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         AXIS
      LOGICAL               DOFLIP
      LOGICAL               ONEWRD
      INTEGER               WHCHAX
  
C$ Brief_I/O
C
C     VARIABLE  I/O  ENTRY
C     --------  ---  --------------------------------------------------
C     AXIS       I   ZZDOFLIP, ZZONEWRD, ZZWHCHAX
C     DOFLIP     O   ZZDOFLIP
C     ONEWRD     O   ZZONEWRD
C     WHCHAX     O   ZZWHCHAX
C
C$ Detailed_Input
C
C     See the ENTRY points for a discussion of their arguments.
C
C$ Detailed_Output
C
C     See the ENTRY points for a discussion of their arguments.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If ZZAXUTIL is called directly, the error SPICE(BOGUSENTRY) is
C        signaled.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This is a utility that serves as an umbrella for other entry
C     points routines that return information about the specified axis.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    SPICELIB Version 2.0.0, 29-APR-2009 (BVS)
C
C        Bug fix: converted from a function with entry points to a
C        subroutine with entry points because some compilers cannot
C        handle function entry points with different return types
C        (LOGICAL vs. INTEGER)
C
C        Added SPICE(BOGUSENTRY) exception.
C
C-    SPICELIB Version 1.0.0, 07-AUG-2000 (WLT)
C
C-&

C
C     Spicelib Functions
C
      INTEGER               BSRCHC
 
      CHARACTER*(3)         KNOWN ( 18 )
      INTEGER               WHICH ( 18 )
      LOGICAL               FLIP  ( 18 )
      LOGICAL               ORDER ( 18 )
 
      LOGICAL               FIRST
 
      SAVE                  KNOWN
      SAVE                  WHICH
      SAVE                  FLIP
      SAVE                  FIRST
 
 
      CHARACTER*(3)         MYAXIS
      INTEGER               B
      INTEGER               E
      INTEGER               I
      INTEGER               START
 
      DATA                  FIRST   / .TRUE. /
 
 
C
C     The umbrella routine should not be called directly.
C
      CALL CHKIN  ( 'ZZAXUTIL'                                       )
      CALL SETMSG ( 'This is an umbrella routine. It should not be' //
     .              'called directly.'                               )
      CALL SIGERR ( 'SPICE(BOGUSENTRY)'                              )
      CALL CHKOUT ( 'ZZAXUTIL'                                       )

      RETURN
 
 
C$Procedure ZZDOFLIP ( Is Axis Negative or Positive? )
 
      ENTRY ZZDOFLIP ( AXIS, DOFLIP )
 
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines. Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     Indicate whether AXIS is + or - {x,y,z,X,Y,Z}.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations
C
C     CHARACTER*(*)         AXIS
C     LOGICAL               DOFLIP
C
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     AXIS       I   Axis: { ,+,-}{x,y,z,X,Y,Z}
C     DOFLIP     O   .TRUE. if the first character in AXIS is '-'
C
C$ Detailed_Input
C
C     See Brief_I/O.
C
C$ Detailed_Output
C
C     See Brief_I/O.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) Signals the error 'SPICE(UNKNOWN_AXIS)' if the axis is not
C        recognized.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    SPICELIB Version 2.0.0, 29-APR-2009 (BVS)
C
C        Bug fix: converted from a function entry point to a subroutine
C        entry point because some compilers cannot handle function
C        entry points with different return types (LOGICAL vs. INTEGER)
C
C-    SPICELIB Version 1.0.0, 07-AUG-2000 (WLT)
C
C
C-&
C
C     Initialization block
C
      IF ( FIRST ) THEN
         FIRST     = .FALSE.
 
         KNOWN( 1) = '+X'
         KNOWN( 2) = '+Y'
         KNOWN( 3) = '+Z'
         KNOWN( 4) = '+x'
         KNOWN( 5) = '+y'
         KNOWN( 6) = '+z'
         KNOWN( 7) = '-X'
         KNOWN( 8) = '-Y'
         KNOWN( 9) = '-Z'
         KNOWN(10) = '-x'
         KNOWN(11) = '-y'
         KNOWN(12) = '-z'
         KNOWN(13) = 'X'
         KNOWN(14) = 'Y'
         KNOWN(15) = 'Z'
         KNOWN(16) = 'x'
         KNOWN(17) = 'y'
         KNOWN(18) = 'z'
 
 
         FLIP ( 1) = .FALSE.
         FLIP ( 2) = .FALSE.
         FLIP ( 3) = .FALSE.
         FLIP ( 4) = .FALSE.
         FLIP ( 5) = .FALSE.
         FLIP ( 6) = .FALSE.
         FLIP ( 7) = .TRUE.
         FLIP ( 8) = .TRUE.
         FLIP ( 9) = .TRUE.
         FLIP (10) = .TRUE.
         FLIP (11) = .TRUE.
         FLIP (12) = .TRUE.
         FLIP (13) = .FALSE.
         FLIP (14) = .FALSE.
         FLIP (15) = .FALSE.
         FLIP (16) = .FALSE.
         FLIP (17) = .FALSE.
         FLIP (18) = .FALSE.
 
 
         WHICH( 1) = 1
         WHICH( 2) = 2
         WHICH( 3) = 3
         WHICH( 4) = 1
         WHICH( 5) = 2
         WHICH( 6) = 3
         WHICH( 7) = 1
         WHICH( 8) = 2
         WHICH( 9) = 3
         WHICH(10) = 1
         WHICH(11) = 2
         WHICH(12) = 3
         WHICH(13) = 1
         WHICH(14) = 2
         WHICH(15) = 3
         WHICH(16) = 1
         WHICH(17) = 2
         WHICH(18) = 3
 
         CALL ORDERC ( KNOWN, 18, ORDER )
 
         CALL REORDC ( ORDER, 18, KNOWN )
         CALL REORDL ( ORDER, 18, FLIP  )
         CALL REORDI ( ORDER, 18, WHICH )
 
      END IF
 
      CALL CMPRSS ( ' ', 0, AXIS, MYAXIS )
 
      I = BSRCHC ( MYAXIS, 18, KNOWN )
 
      IF ( I .GT. 0 ) THEN
         DOFLIP = FLIP(I)
      ELSE
         DOFLIP = .FALSE.
         CALL CHKIN  ( 'ZZDOFLIP' )
         CALL SETMSG ( 'The axis ''#'' is not recognized.' )
         CALL ERRCH  ( '#', AXIS )
         CALL SIGERR ( 'SPICE(UNKNOWN_AXIS)' )
         CALL CHKOUT ( 'ZZDOFLIP' )
      END IF
 
      RETURN
 
 
C$Procedure      ZZWHCHAX ( Which axis )
 
      ENTRY ZZWHCHAX ( AXIS, WHCHAX )
 
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines.  Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     Return the index of the coordinate axis.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations
C
C     IMPLICIT NONE
C     CHARACTER*(*)         AXIS
C     INTEGER               WHCHAX
C
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     AXIS       I   Axis: { ,+,-}{x,y,z,X,Y,Z}
C     WHCHAX     O   The index of the coordinate axis: {1,2,3}
C
C$ Detailed_Input
C
C     See Brief_I/O.
C
C$ Detailed_Output
C
C     See Brief_I/O.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) Signals the error 'SPICE(UNKNOWN_AXIS)' if the axis is not
C        recognized.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    SPICELIB Version 2.0.0, 29-APR-2009 (BVS)
C
C        Bug fix: converted from a function entry point to a subroutine
C        entry point because some compilers cannot handle function
C        entry points with different return types (LOGICAL vs. INTEGER)
C
C-    SPICELIB Version 1.0.0, 07-AUG-2000 (WLT)
C
C
C-&
 
 
      IF ( FIRST ) THEN
         FIRST     = .FALSE.
 
         KNOWN( 1) = '+X'
         KNOWN( 2) = '+Y'
         KNOWN( 3) = '+Z'
         KNOWN( 4) = '+x'
         KNOWN( 5) = '+y'
         KNOWN( 6) = '+z'
         KNOWN( 7) = '-X'
         KNOWN( 8) = '-Y'
         KNOWN( 9) = '-Z'
         KNOWN(10) = '-x'
         KNOWN(11) = '-y'
         KNOWN(12) = '-z'
         KNOWN(13) = 'X'
         KNOWN(14) = 'Y'
         KNOWN(15) = 'Z'
         KNOWN(16) = 'x'
         KNOWN(17) = 'y'
         KNOWN(18) = 'z'
 
 
         FLIP ( 1) = .FALSE.
         FLIP ( 2) = .FALSE.
         FLIP ( 3) = .FALSE.
         FLIP ( 4) = .FALSE.
         FLIP ( 5) = .FALSE.
         FLIP ( 6) = .FALSE.
         FLIP ( 7) = .TRUE.
         FLIP ( 8) = .TRUE.
         FLIP ( 9) = .TRUE.
         FLIP (10) = .TRUE.
         FLIP (11) = .TRUE.
         FLIP (12) = .TRUE.
         FLIP (13) = .FALSE.
         FLIP (14) = .FALSE.
         FLIP (15) = .FALSE.
         FLIP (16) = .FALSE.
         FLIP (17) = .FALSE.
         FLIP (18) = .FALSE.
 
 
         WHICH( 1) = 1
         WHICH( 2) = 2
         WHICH( 3) = 3
         WHICH( 4) = 1
         WHICH( 5) = 2
         WHICH( 6) = 3
         WHICH( 7) = 1
         WHICH( 8) = 2
         WHICH( 9) = 3
         WHICH(10) = 1
         WHICH(11) = 2
         WHICH(12) = 3
         WHICH(13) = 1
         WHICH(14) = 2
         WHICH(15) = 3
         WHICH(16) = 1
         WHICH(17) = 2
         WHICH(18) = 3
 
         CALL ORDERC ( KNOWN, 18, ORDER )
 
         CALL REORDC ( ORDER, 18, KNOWN )
         CALL REORDL ( ORDER, 18, FLIP  )
         CALL REORDI ( ORDER, 18, WHICH )
 
      END IF
 
      CALL CMPRSS ( ' ', 0, AXIS, MYAXIS )
 
      I = BSRCHC ( MYAXIS, 18, KNOWN )
 
      IF ( I .GT. 0 ) THEN
         WHCHAX = WHICH(I)
      ELSE
         WHCHAX = 0
         CALL CHKIN  ( 'ZZWHCHAX' )
         CALL SETMSG ( 'The axis ''#'' is not recognized.' )
         CALL ERRCH  ( '#', AXIS )
         CALL SIGERR ( 'SPICE(UNKNOWN_AXIS)' )
         CALL CHKOUT ( 'ZZWHCHAX' )
      END IF
 
      RETURN
 
 
C$Procedure      ZZONEWRD ( One word )
 
      ENTRY ZZONEWRD ( AXIS, ONEWRD )
 
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines. Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     Return true in the input string consists of a single word.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations
C
C
C     IMPLICIT NONE
C     CHARACTER*(*)         AXIS
C     LOGICAL               ONEWRD
C
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     AXIS       I   Axis: { ,+,-}{x,y,z,X,Y,Z}
C     ONEWRD     O   .TRUE. if AXIS consists of a single word
C
C$ Detailed_Input
C
C     See Brief_I/O.
C
C$ Detailed_Output
C
C     ONEWRD     is TRUE if AXIS contains just one word. Otherwise it
C                is .FALSE.  (including the case of a blank string).
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    SPICELIB Version 2.0.0, 29-APR-2009 (BVS)
C
C        Bug fix: converted from a function entry point to a subroutine
C        entry point because some compilers cannot handle function
C        entry points with different return types (LOGICAL vs. INTEGER)
C
C-    SPICELIB Version 1.0.0, 07-AUG-2000 (WLT)
C
C
C-&
 
      START = 1
      CALL FNDNWD  ( AXIS, START, B, E )
 
      IF ( B .GT. 0 ) THEN
         START = E + 1
         CALL FNDNWD ( AXIS, START, B, E )
 
         ONEWRD = B .EQ. 0
 
      ELSE
         ONEWRD = .FALSE.
      END IF
 
      RETURN
 
 
      END
