C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C     Get the value of some component of an object.
C
      SUBROUTINE OBJVAL ( OBJ, COMP, OBJLIS, VALUE )
 
      IMPLICIT NONE
      INCLUDE              'object.inc'
 
      INTEGER               OBJ    ( 2 )
      INTEGER               COMP
      INTEGER               VALUE
      INTEGER               OBJLIS ( LBCELL: * )
C
C     Local Variables
C
      INTEGER               I
      INTEGER               OBJSIZ
      LOGICAL               OK
 
      CALL OBJCHK ( 'OBJVAL', OBJ, OBJLIS, OK )
 
      IF ( .NOT. OK ) THEN
         RETURN
      END IF
 
      IF ( OBJ(2) .EQ. NULL ) THEN
         CALL CHKIN ( 'OBJVAL' )
         CALL SETMSG('You are attempting to fetch a value of an '
     .   //          'inactive object.  You can only fetch a '
     .   //          'value of an active object.  The object '
     .   //          'pointer has value #. ' )
         CALL ERRINT( '#', OBJ(1) )
         CALL SIGERR( 'SPICE(INACTIVEOBJECT)'  )
         CALL CHKOUT( 'OBJVAL' )
         RETURN
      END IF
 
      OBJSIZ = OBJLIS(RMPOBJ) - 1
 
      IF ( COMP .LT. 1 .OR. COMP .GT. OBJSIZ ) THEN
         CALL CHKIN ( 'OBJVAL' )
         CALL SETMSG( 'Objects in the list supplied have # '
     .   //           'components. You are attempting to modify '
     .   //           'component # of the object. ' )
         CALL ERRINT( '#', OBJSIZ )
         CALL ERRINT( '#', COMP   )
         CALL SIGERR( 'SPICE(BADCOMPNUMBER)'  )
         CALL CHKOUT( 'OBJVAL' )
         RETURN
      END IF
 
      I      = OBJ(1) + COMP
      VALUE  = OBJLIS(I)
 
      RETURN
      END
