from datetime import datetime, timedelta

def sepm_to_cog(source):

    #
    # We need to negate the positions and convert it to KM (it is in M)
    #
    cog_list = []
    with open(source, 'r') as t:
        for line in t.readlines():
            if 'INITIAL TIME' in line:
                ITDB = line.split('TDB:')[1].split('(')[0].replace('/', '-')
                #
                # this section only appends and state from the second thruster firing on for propagating the last step
                #
                if cog_list:
                    ITDBp = (datetime.strptime(ITDB[1:-1], "%Y-%m-%d %H:%M:%S.%f") - timedelta(seconds=1)).strftime(" %Y-%m-%d %H:%M:%S.%f ")
                    line = ITDBp + FCOM + ' 0.0 0.0 0.0'
                    line = line.split()
                    line[2] = str(-float(line[2]) / 1000)
                    line[3] = str(-float(line[3]) / 1000)
                    line[4] = str(-float(line[4]) / 1000)
                    line = ' '.join(line).replace(' ', 'T', 1)
                    cog_list.append(line)

            #
            # append the initial and final COM states
            #
            if 'FINAL TIME' in line: FTDB = line.split('TDB:')[1].split('(')[0].replace('/', '-')
            if 'INITIAL S/C COM' in line: ICOM = line.split('[m]:')[1].split('\n')[0]
            if 'FINAL S/C COM' in line:
                FCOM = line.split('[m]:')[1].split('\n')[0]

                line = ITDB + ICOM + ' 0.0 0.0 0.0'
                line = line.split()
                line[2] = str(-float(line[2]) / 1000)
                line[3] = str(-float(line[3]) / 1000)
                line[4] = str(-float(line[4]) / 1000)
                line = ' '.join(line).replace(' ', 'T', 1)
                cog_list.append(line)

                line = FTDB + FCOM + ' 0.0 0.0 0.0'
                line = line.split()
                line[2] = str(-float(line[2]) / 1000)
                line[3] = str(-float(line[3]) / 1000)
                line[4] = str(-float(line[4]) / 1000)
                line = ' '.join(line).replace(' ', 'T', 1)
                cog_list.append(line)
    return cog_list


def events_to_sep(source):
    sep_list = []
    with open(source, 'r') as t:
        flag = False
        for line in t.readlines():
            if 'EMAS' in line and flag == False:
                flag = True
                utcdateS = datetime.strptime(line.split('time="')[1].split('Z')[0], '%Y-%jT%H:%M:%S.%f').strftime("%Y-%m-%dT%H:%M:%S.%f ")
                if sep_list and utcdateE != utcdateS:
                    sep_list.append(utcdateE + utcdateS + ' 0 0 0 0 0 0')
            if 'EMAE' in line and flag == True:
                flag = False
                utcdateE = datetime.strptime(line.split('time="')[1].split('Z')[0], '%Y-%jT%H:%M:%S.%f').strftime("%Y-%m-%dT%H:%M:%S.%f ")
                if utcdateE != utcdateS:
                    sep_list.append(utcdateS + utcdateE + ' 180 0 0 0 0 0')
    return sep_list
