'''
Created on Jan 17, 2020
@author: Marc Costa Sitja
'''
import os
import glob
import unittest
import HtmlTestRunner

from pathlib import Path

import adcsng.tests.em16.exomars2016 as exomars2016
import adcsng.tests.emrsp.exomarsrsp as exomarsrsp
import adcsng.tests.solo.solar_orbiter as solar_orbiter
import adcsng.tests.bepic.bepicolombo as bepicolombo
import adcsng.tests.mex.mars_express as mars_express

try:
    f = open(os.path.dirname(__file__) + '/../config/version','r')
except:
    f = open('../config/version', 'r')
with f:
    for line in f:
        version = line

html_report_dir = '../reports'

class TestRegression(unittest.TestCase):

    # This method will be executed only once for this test case class.
    # It will execute before all test methods. Must decorated with
    # @classmethod.
    @classmethod
    def setUpClass(cls):
        print("setUpClass execute. ")
        exomars2016.cleanup()
        exomarsrsp.cleanup()
        solar_orbiter.cleanup()
        bepicolombo.cleanup()
        mars_express.cleanup()

    # Similar with setupClass method, it will be executed after all test
    # method run.
    @classmethod
    def tearDownClass(cls):
        exomars2016.cleanup()
        exomarsrsp.cleanup()
        solar_orbiter.cleanup()
        bepicolombo.cleanup()
        mars_express.cleanup()

    # This method will be executed after each test function.
    def tearDown(self):
        unittest.TestCase.tearDown(self)


    def sources2ancdr(self):

        logs = glob.glob('log/*')

        inputs = []
        for log in logs:
            with open(log, 'r') as l:
                for line in l:
                    if '   >>' in line: inputs.append(
                        line.split('>>')[-1].strip())

        inputs = list(dict.fromkeys(inputs))

        ancdr = []
        for path in Path('ancdr').rglob('*.*'):
            if 'aareadme' not in str(path):
                ancdr.append(str(path).split(os.sep)[-1].strip())

        if set(inputs) > set(ancdr):
            raise NameError('Sources have not been moved to ancdr directory')


    #####################################
    #####   E X O M A R S 2 0 1 6   #####
    #####################################
    def test_em16__1_runMkADCSng__(self):
        exomars2016.runMkADCSng(version)

    def test_em16__2_runADCSng____(self):
        exomars2016.runADCSng(version)
        self.sources2ancdr()

    def test_em16__3_SPKcompare___(self):
        exomars2016.SPKcompare()

    def test_em16__4_CKcompare____(self):
        exomars2016.CKcompare()

    def test_em16__5_SCLKcompare__(self):
        exomars2016.SCLKcompare()

    def test_em16__6_MKcompare____(self):
        exomars2016.MKcompare()


    #####################################
    #####   E X O M A R S  R S P    #####
    #####################################
    def test_emrsp_1_runADCSng____(self):
        exomarsrsp.runADCSng(version)

    def test_emrsp_2_SPKcompare___(self):
        exomarsrsp.SPKcompare()

    def test_emrsp_3_CKcompare____(self):
        exomarsrsp.CKcompare()

    #def test_emrsp_4_SCLKcompare__(self):
    #    exomars2016.SCLKcompare()

    def test_emrsp_4_MKcompare____(self):
        exomarsrsp.MKcompare()


    ####################################
    ##### S O L A R  O R B I T E R #####
    ####################################
    def test_solo__1_runADCSng____(self):
        solar_orbiter.runADCSng(version)
        self.sources2ancdr()

    def test_solo__2_SPKcompare___(self):
        solar_orbiter.SPKcompare()

    def test_solo__3_CKcompare____(self):
        solar_orbiter.CKcompare()

    def test_solo__4_MKcompare____(self):
        solar_orbiter.MKcompare()


    #####################################
    #####   B E P I C O L O M B O   #####
    #####################################
    def test_bepic_1_runADCSng____(self):
        bepicolombo.runADCSng(version)
        self.sources2ancdr()

    def test_bepic_2_SPKcompare___(self):
        bepicolombo.SPKcompare()

    def test_bepic_3_CKcompare____(self):
        bepicolombo.CKcompare()

    def test_bepic_4_SCLKcompare__(self):
        bepicolombo.SCLKcompare()

    def test_bepic_5_MKcompare____(self):
        bepicolombo.MKcompare()

    def test_bepic_6_LOGcompare___(self):
        bepicolombo.LOGcompare()


    #####################################
    #####  M A R S   E X P R E S S  #####
    #####################################
    def test_mex___1_runADCSng____(self):
        mars_express.runADCSng(version)
        self.sources2ancdr()

    def test_mex___2_SPKcompare___(self):
        mars_express.SPKcompare()

    def test_mex___3_MKcompare____(self):
        mars_express.MKcompare()

    def test_mex___4_ORBNUMcompare(self):
        mars_express.ORBNUMcompare()


if __name__ == '__main__':

    unittest.main(testRunner=HtmlTestRunner.HTMLTestRunner(output=html_report_dir,
                                                           report_title=f'ADCSng v{version} Regression Tests',
                                                           report_name=f'adcsng_v{version}'))
