C$PROCEDURE
 
      SUBROUTINE ZZEVALDG ( LIMIT, NAME )
C
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines.  Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     This routine diagnoses the possible reasons for filling the
C     NAME stack in the routine EVALDR
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     KEYWORD
C
C$ Declarations
 
      IMPLICIT NONE
      INTEGER               LIMIT
      CHARACTER*(*)         NAME ( * )
 
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     LIMIT      I   The depth limit of the NAME stack
C     NAME       I   The NAME stack for directions.
C
C$ Detailed_Input
C
C     LIMIT      The maximum depth allowed for the name stack.
C
C     NAME       The name stack (an array of direction names).
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     1) If the same name appears twice in the name stack, the routine
C        signals the error SPICE(RECURSIVEDEFINITION).
C
C     2) If there are no duplicate names in the name stack, the routine
C        signals the error SPICE(STACKEXHAUSTED).
C
C     This routine does not check in or out.  It is simply a "macro"
C     that handles the task of diagnosing one of two possible errors.
C
C$ Particulars
C
C     This is a "macro" routine that diagnoses why the name stack has
C     filled.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 20-July-2000 (WLT)
C
C
C-&
 
      INTEGER               WHICH
      INTEGER               I
      INTEGER               J
 
 
C
C     See if we have a recursive definition on our hands. We do if any
C     name appears twice in the name stack.
C
 
      WHICH = 0
      J     = 1
      DO WHILE ( J .LT. LIMIT .AND. WHICH .EQ. 0 )
 
         I = J + 1
 
         DO WHILE ( I .LE. LIMIT .AND. WHICH .EQ. 0 )
 
            IF ( NAME(I) .EQ. NAME(J) ) THEN
               WHICH = I
            END IF
 
            I = I + 1
 
         END DO
 
         J = J + 1
 
      END DO
 
C
C     We have recursion only if WHICH is greater than zero.
C
      IF ( WHICH .GT. 0 ) THEN
 
         IF ( NAME(WHICH) .EQ. NAME(1) ) THEN
 
            CALL SETMSG ( 'The direction ''#'' is '
     .      //            'recursively defined:  Briefly '
     .      //            '# uses ##' )
            CALL ERRCH  ( '#', NAME(1) )
            CALL ERRCH  ( '#', NAME(1) )
            CALL ERRCH  ( '#', NAME(2) )
 
         ELSE
            CALL SETMSG ( 'The definition of the direction '
     .      //            '''#'' makes use of the direction '
     .      //            '''#'' which is defined '
     .      //            'recursively. Briefly # uses ##' )
 
            CALL ERRCH  ( '#', NAME(1) )
            CALL ERRCH  ( '#', NAME(WHICH) )
            CALL ERRCH  ( '#', NAME(1) )
            CALL ERRCH  ( '#', NAME(2) )
         END IF
 
         I = 2
         DO WHILE ( I .LT. WHICH )
            CALL ERRCH  ( '#', ', # uses ##' )
            CALL ERRCH  ( '#', NAME(I)   )
            CALL ERRCH  ( '#', NAME(I+1) )
            I = I+1
         END DO
         CALL ERRCH  ( '#', '.' )
         CALL SIGERR ( 'SPICE(RECURSIVEDEFINITION)'  )
 
      ELSE
 
         CALL SETMSG ( 'The definition of the the '
     .   //            'direction # requires too many '
     .   //            'subcomponents for evaluation.  You '
     .   //            'have two options: (a) Simplify '
     .   //            'your definition of #; (b) increase '
     .   //            'the parameter LIMIT in the routine '
     .   //            'EVALDR to allow directions to be '
     .   //            'implicitely defined in terms of a '
     .   //            'larger set of intermediary '
     .   //            'directions. Then rebuild the '
     .   //            'program that ' )
 
         CALL ERRCH ( '#', NAME(1) )
         CALL ERRCH ( '#', NAME(1) )
         CALL SIGERR ( 'SPICE(STACKEXHAUSTED)' )
      END IF
      RETURN
 
      END
