C$Procedure GETLN ( Get line from standard input )
 
      SUBROUTINE GETLN ( LINE, EOF )
 
C$ Abstract
C
C     Read a single line of text from the standard input file.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     FILES
C     UTILITY
C
C$ Declarations
 
      CHARACTER*(*)         LINE
      LOGICAL               EOF
 
C$ Brief_I/O
C
C     Variable  I/O  Description
C     --------  ---  --------------------------------------------------
C     LINE       O   Line of text.
C     EOF        O   End-of-file indicator.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     LINE        is the next line of text from the standard input
C                 file.
C
C     EOF         is true if the end of the standard input file has
C                 been reached, and is false otherwise.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If EOF is true, LINE is blank.
C
C     2) If the declared length of LINE is too short to contain
C        the entire line fromthe file, the line is truncated on
C        the right.
C
C     3) If an error occurs while reading from standard input,
C        the error 'STDIO(CANNOTREAD)' is signalled.
C
C$ Files
C
C     The standard input and output files are determined by module
C     STDIO.
C
C$ Particulars
C
C     GETLN (get line), GETNBL (get non-blank line), and PUTLN (put
C     line) are designed to work with programs that read from the
C     standard input file and write to the standard output file, as
C     described in module STDIO.
C
C$ Examples
C
C     The following code fragment shows how GETLN, and PUTLN can
C     be used to process each of the lines in the standard input
C     file, sending the results to the standard output file.
C
C        CALL GETLN ( LINE, EOF )
C
C        DO WHILE ( .NOT. EOF )
C            .
C            .
C
C           CALL PUTLN ( LINE      )
C           CALL GETLN ( LINE, EOF )
C        END DO
C
C     Note that it is not necessary to call STDIO.
C
C$ Restrictions
C
C     See STDIO.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     I.M. Underwood (JPL)
C
C$ Version
C
C-    Beta Version 1.0.0, 7-APR-1989 (IMU)
C
C-&
 
C
C     SPICELIB functions
C
      LOGICAL               RETURN
      INTEGER               LASTNB
 
C
C     Local variables
C
      INTEGER               STDIN
      INTEGER               STDOUT
      INTEGER               IOSTAT
      INTEGER               L
 
C
C     Standard SPICE error handling.
C
      IF ( RETURN () ) THEN
         RETURN
      ELSE
         CALL CHKIN ( 'GETLN' )
      END IF
 
 
      CALL STDIO ( STDIN, STDOUT )
      READ (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
 
      IF ( IOSTAT .LT. 0 ) THEN
         LINE = ' '
         EOF  = .TRUE.
 
      ELSE IF ( IOSTAT .GT. 0 ) THEN
         CALL SETMSG ( 'Value of IOSTAT was #.' )
         CALL ERRINT ( '#', IOSTAT              )
         CALL SIGERR ( 'STDIO(CANNOTREAD)'      )
 
      ELSE
 
         EOF = .FALSE.
      END IF
 
 
      CALL CHKOUT ( 'GETLN' )
      RETURN
 
 
 
C$Procedure PUTLN ( Put line to standard output )
 
      ENTRY PUTLN ( LINE )
 
C$ Abstract
C
C     Write a single line of text to the standard input file.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     FILES
C     UTILITY
C
C$ Declarations
C
C     CHARACTER*(*)         LINE
C
C$ Brief_I/O
C
C     Variable  I/O  Description
C     --------  ---  --------------------------------------------------
C     LINE       I   Line of text.
C
C$ Detailed_Input
C
C     LINE        is an arbitrary line of text, to be written to
C                 the standard output file. Trailing blanks are
C                 ignored.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If an error occurs while writing to standard output,
C        the error 'STDIO(CANNOTWRITE)' is signalled.
C
C$ Files
C
C     The standard input and output files are determined by module
C     STDIO.
C
C$ Particulars
C
C     GETLN (get line), GETNBL (get non-blank line), and PUTLN (put
C     line) are designed to work with programs that read from the
C     standard input file and write to the standard output file, as
C     described in module STDIO.
C
C$ Examples
C
C     The following code fragment shows how GETLN, and PUTLN can
C     be used to process each of the lines in the standard input
C     file, sending the results to the standard output file.
C
C        CALL GETLN ( LINE, EOF )
C
C        DO WHILE ( .NOT. EOF )
C            .
C            .
C
C           CALL PUTLN ( LINE      )
C           CALL GETLN ( LINE, EOF )
C        END DO
C
C     Note that it is not necessary to call STDIO.
C
C$ Restrictions
C
C     See STDIO.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     I.M. Underwood (JPL)
C
C$ Version
C
C-    Beta Version 2.0.0, 29-MAY-1996 (WLT)
C
C        Modified PUTLN so that it calls WRITLN instead of using
C        the FORTRAN "WRITE" statement.  This makes this portable.
C
C-    Beta Version 1.0.0, 7-APR-1989 (IMU)
C
C-&
 
C
C     Standard SPICE error handling.
C
      IF ( RETURN () ) THEN
         RETURN
      ELSE
         CALL CHKIN ( 'PUTLN' )
      END IF
 
      L = MAX ( 1, LASTNB ( LINE ) )
 
      CALL STDIO  ( STDIN,     STDOUT )
      CALL WRITLN ( LINE(1:L), STDOUT )
 
 
      CALL CHKOUT ( 'PUTLN' )
      RETURN
 
 
 
C$Procedure GETNBL ( Get non-blank line from standard input )
 
      ENTRY GETNBL ( LINE, EOF )
 
C$ Abstract
C
C     Read a single non-blank line of text from the standard input file.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     FILES
C     UTILITY
C
C$ Declarations
C
C     CHARACTER*(*)         LINE
C     LOGICAL               EOF
C
C$ Brief_I/O
C
C     Variable  I/O  Description
C     --------  ---  --------------------------------------------------
C     LINE       O   Line of text.
C     EOF        O   End-of-file indicator.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     LINE        is the next line of text from the standard input
C                 file that contains non-blank characters.
C
C     EOF         is true if the end of the standard input file has
C                 been reached, and is false otherwise.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If EOF is true, LINE is blank.
C
C     2) If the declared length of LINE is too short to contain
C        the entire line fromthe file, the line is truncated on
C        the right.
C
C     3) If an error occurs while reading from standard input,
C        the error 'STDIO(CANNOTREAD)' is signalled.
C
C$ Files
C
C     The standard input and output files are determined by module
C     STDIO.
C
C$ Particulars
C
C     GETLN (get line), GETNBL (get non-blank line), and PUTLN (put
C     line) are designed to work with programs that read from the
C     standard input file and write to the standard output file, as
C     described in module STDIO.
C
C$ Examples
C
C     The following code fragment shows how GETNBL, and PUTLN can
C     be used to process each of the non-blank lines in the standard
C     input file, sending the results to the standard output file.
C
C        CALL GETNBL ( LINE, EOF )
C
C        DO WHILE ( .NOT. EOF )
C            .
C            .
C
C           CALL PUTLN  ( LINE      )
C           CALL GETNBL ( LINE, EOF )
C        END DO
C
C     Note that it is not necessary to call STDIO.
C
C$ Restrictions
C
C     See STDIO.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     I.M. Underwood (JPL)
C
C$ Version
C
C-    Beta Version 1.0.0, 7-APR-1989 (IMU)
C
C-&
 
C
C     Standard SPICE error handling.
C
      IF ( RETURN () ) THEN
         RETURN
      ELSE
         CALL CHKIN ( 'GETNBL' )
      END IF
 
      CALL STDIO ( STDIN, STDOUT )
      READ (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
 
      DO WHILE ( IOSTAT .EQ. 0  .AND.  LINE .EQ. ' ' )
         READ (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
      END DO
 
      IF ( IOSTAT .LT. 0 ) THEN
         LINE = ' '
         EOF  = .TRUE.
 
      ELSE IF ( IOSTAT .GT. 0 ) THEN
         CALL SETMSG ( 'Value of IOSTAT was #.' )
         CALL ERRINT ( '#', IOSTAT              )
         CALL SIGERR ( 'STDIO(CANNOTREAD)'      )
 
      ELSE
         EOF = .FALSE.
      END IF
 
      CALL CHKOUT ( 'GETNBL' )
      RETURN
      END
