import logging
import os
import subprocess

def quaternions_filter(append_bool, line, row, row_prev, index, tm_list,
                       filter_flag, sclk_fraction_prev, sclk_fraction_pprev,
                       sclk_fraction_ppprev, sclk_fraction_pppprev,sclk_initial,
                       info_quaternions):

    #
    # We add a tolerance in the SCLK fraction for it to be considered spureous.
    #
    sclk_fraction = line.split(':')[-1].split(' ')[0]

    if not sclk_fraction_pppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_ppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_pprev:
        sclk_fraction_pprev = 0
    if not sclk_fraction_prev:
        sclk_fraction_prev = 0
    if not sclk_initial:
        sclk_initial = 0

    prev = False

    tolerance = 5  # Tolerance is manually set no need for it to be a configuration item.
    threshold_prev  = abs(int(sclk_fraction) - int(sclk_fraction_prev))
    threshold_init  = abs(int(sclk_fraction) - int(sclk_initial))

    if filter_flag:

        if threshold_prev < tolerance:
            row_prev.append(row)
        elif len(row_prev) <= 5 and  threshold_init < tolerance:

            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            for element in row_prev:
                #logging.warning('   ' + str(element).split('\n')[0])
                tm_list.remove(element)

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True


        #
        # This is the extra filtering we add to remove single SCLK fraction differences
        #
        elif len(row_prev) == 1 and threshold_init > tolerance:
            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            #logging.warning('   ' + str(row_prev[0]).split('\n')[0])

            append_bool = False

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True

        else:
            row_prev = []
            filter_flag = False

    if sclk_fraction_prev and threshold_prev > tolerance and not filter_flag:
        filter_flag = True
        row_prev.append(row)

        sclk_initial = sclk_fraction_prev

    sclk_fraction_pppprev = sclk_fraction_ppprev
    sclk_fraction_ppprev = sclk_fraction_pprev
    sclk_fraction_pprev = sclk_fraction_prev
    if not prev:
        sclk_fraction_prev = sclk_fraction


    threshold_ppprev = abs(int(sclk_fraction) - int(sclk_fraction_pppprev))
    if threshold_ppprev < tolerance:
        append_bool = True


    return append_bool, line, row, row_prev, index, tm_list, filter_flag, sclk_fraction_prev, \
           sclk_fraction_pprev, sclk_fraction_ppprev, sclk_fraction_ppprev, sclk_initial, info_quaternions


def cassis_processing(tm_list, kernel):
    line_minus_one = ''
    line_minus_two = ''

    for line in tm_list:

        if line_minus_one:
            line_minus_two = line_minus_one

        if line_minus_two:
            ang_data_minus_two = line_minus_two.split()[3]
            ang_data_minus_one = line_minus_one.split()[3]
            ang_data = line.split()[3]

            if ang_data == ang_data_minus_two and ang_data_minus_one != ang_data:

                time_minus_two = line_minus_two.split()[0]
                time_minus_one = line_minus_one.split()[0]

                cmd = kernel.directories.executables + os.sep + 'utc2tdb ' + time_minus_two \
                      + ' ' + kernel.directories.kernels + os.sep + \
                      kernel.config['lsk']
                command_line_process = subprocess.Popen(cmd, shell=True,
                                                        stdout=subprocess.PIPE,
                                                        stderr=subprocess.STDOUT)

                process_output = command_line_process.communicate()[0]
                et_minus_two = float(process_output.decode('utf-8'))

                cmd = kernel.directories.executables + os.sep + 'utc2tdb ' + time_minus_one \
                      + ' ' + kernel.directories.kernels + os.sep + \
                      kernel.config['lsk']
                command_line_process = subprocess.Popen(cmd, shell=True,
                                                        stdout=subprocess.PIPE,
                                                        stderr=subprocess.STDOUT)

                process_output = command_line_process.communicate()[0]
                et_minus_one = float(process_output.decode('utf-8'))

                if et_minus_one - et_minus_two < 5:
                    tm_list.remove(line_minus_one)

        line_minus_one = line

        return tm_list