KPL/FK

ExoMarsRSP Rover Module (RM) Frames Kernel
===============================================================================

   This frame kernel contains a complete set of frame definitions for the
   ExoMars RSP Rover Module (RM) including definitions for the RM structures 
   and RM science instrument frames. This kernel also contains NAIF ID/name 
   mapping for the RM instruments.


Version and Date
------------------------------------------------------------------------

   Version 0.0 -- June 8, 2018 -- Marc Costa Sitja, ESAC/ESA
   
      Preliminary version.


References
------------------------------------------------------------------------

    1. ``Frames Required Reading'', NAIF 

    2. ``Kernel Pool Required Reading'', NAIF 

    3. ``C-Kernel Required Reading'', NAIF

    4. ``ExoMars Rover and Surface Platform Mission Implementation Plan'',
       EXM-G2-PLN-ESC-00004, ExoMars Ground Segment Team, Issue 1, Revision 2,
       ESOC, August 8, 2017.

    5. ``EXOMARS 2018 ROVER MODULE Coordinate Systems & Conventions for RM 
       control'', EXM-RM-TNO-AI-0448, A. Merlo,

    6. ExoMars RSP Mars Local Geodetic Frames (emrsp_mlg_vVVV.tf),
       latest version.

    7. EXM-RM-SYS-ASU-00101

      

Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESA:

           Marc Costa Sitja
           (+34) 91-8131-457
           mcosta@sciops.esa.int, esa_spice@sciops.esa.int

   or ROCC at Altec Space:
   
           Federico Salvioli
           +1 (818) 354-8136
           federico.salvioli@altecspace.it
      
     
Implementation Notes
------------------------------------------------------------------------

  This file is used by the SPICE system as follows: programs that make use
  of this frame kernel must "load" the kernel normally during program
  initialization. Loading the kernel associates the data items with
  their names in a data structure called the "kernel pool".  The SPICELIB
  routine FURNSH loads a kernel into the pool as shown below:

    FORTRAN: (SPICELIB)

      CALL FURNSH ( frame_kernel_name )

    C: (CSPICE)

      furnsh_c ( frame_kernel_name );

    IDL: (ICY)

      cspice_furnsh, frame_kernel_name

    MATLAB: (MICE)
      
         cspice_furnsh ( 'frame_kernel_name' )

    PYTHON: (SPICEYPY)*

         furnsh( frame_kernel_name )

  In order for a program or routine to extract data from the pool, the
  SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
  more details.

  This file was created and may be updated with a text editor or word
  processor.

  * SPICEPY is a non-official, community developed Python wrapper for the
    NAIF SPICE toolkit. Its development is managed on Github.
    It is available at: https://github.com/AndrewAnnex/SpiceyPy

   
RM NAIF ID Codes -- Summary Section
------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the ExoMars RSP
   rover, its structures and science instruments (the keywords implementing
   these definitions are located in the section "RM NAIF ID Codes --
   Definition Section" at the end of this file):
   
   TGO rover and rover Structures names/IDs:

            RM                       -999   (synonyms: EXOMARS RSP RM,
                                                       EXOMARS RSP ROVER,
                                                       EXOMARS RSP ROVER MODULE
                                                  and  EXOMARS ROVER)

            RM_ROVER                 -999000
            RM_MAST                  -999010
            RM_PTR                   -999012
            RM_PB                    -999013
            RM_NAVCAM_L              -999021
            RM_NAVCAM_R              -999022

   PanCam names/IDs:
   
            RM_PANCAM                -999100
            RM_PANCAM_WAC_L          -999110
            RM_PANCAM_WAC_R          -999120
            RM_PANCAM_HRC            -999130


RM Frames
------------------------------------------------------------------------

   The following RM frames are defined in this kernel file:

           Name                    Relative to           Type        NAIF ID
      ======================    ===================  ============    =======

   RM Rover and Rover Structures frames:
   ------------------------------------------------
      RM_ROVER                    RM_MLG_NN*             CK          -999000
      RM_MAST                     RM_ROVER               FIXED       -999010
      RM_PTR_ZERO                 RM_MAST                FIXED       -999011
      RM_PTR                      RM_PTRM_ZERO           CK          -999012
      RM_PB                       RM_PTR                 FIXED       -999013
      RM_NAVCAM_BASE              RM_PB                  FIXED       -999020
      RM_NAVCAM_L                 RM_NAVCAM_BASE         FIXED       -999021
      RM_NAVCAM_R                 RM_NAVCAM_BASE         FIXED       -999022

   RM PanCam frames:
   ------------------------------------------------
      RM_PANCAM_BASE              RM_PB                  FIXED       -999100
      RM_PANCAM_WAC_L             RM_PANCAM_BASE         FIXED       -999110
      RM_PANCAM_WAC_R             RM_PANCAM_BASE         FIXED       -999120
      RM_PANCAM_HRC               RM_PANCAM_BASE         FIXED       -999130

   In addition, the following frames, in use by the ExoMars RSP mission, are
   defined in another kernel:
   
           Name                    Relative to           Type        NAIF ID
      ======================    ===================  ============    =======

   ExoMars RSP Local Geodetic Frames (1):
   ---------------------------------------------------
       RM_MLG_DISPOSAL            IAU_MARS              FIXED        -999900
       RM_MLG_DISPOSAL_FIXED      IAU_MARS              FIXED        -999910
       RM_MLG_NN*                 IAU_MARS              FIXED        -9999NN0
       RM_MLG_DISPISAL_NN_FIXED*  IAU_MARS              FIXED        -9999NN1


      * NN corresponds to the travel sequence number. 00 refers to the
        position of the Rover after Rover Disposal and this frame definition
        is equivalent to the RM_MLG_DISPOSAL frame.

      (1) This frame is defined in the ExoMars RSP Mars Local Geodetic Frames
          Definitions kernel file (see [6]).


ExoMars RSP Mission Description
--------------------------------------------------------------------------

   The mission can be broadly described as follows: launch the ExoMarsRSP 
   Spacecraft and fly it to Mars; land on Mars, deliver the Rover to the 
   surface and perform the nominal exploration mission on the surface. 
   The launch configuration is the Spacecraft Composite (SCC), which is 
   composed of the Carrier Module (CM) and the Descent Module (DM). The CM 
   is jettisoned upon arrival at Mars, and the DM will enter the Mars 
   atmosphere and land, carrying the Surface Platform (SP) and the Rover (RM). 
   The CM and the RM are developed by ESA. The DM and SP are developed by 
   Roscosmos with ESA contributions. The elements of the spacecraft composite 
   are shown below.

     CM          DM            SP                  RM

     |           .'.                           =
     |--.      .'   |               |          | 
   )-|  |     |     |     -------------       |-----------                 RM
     |--'      '.   |       '-------'          /\____\|
     |           '.'         /     \          0  0    0
 
     |           |              |                |
     |           |              |                |
     |           |              |                |
     |           |              |                V           _=_______  
     |           |              |                           |0  0    0\ 
     |           |              '-------------> (+) ---->  -------------   LPC
     |           |                                           '-------'   
     |           |                               |            /     \    
     |           |                               |            
     |           |                               |
     |           |                               V               .'. 
     |           |                                             .' -o|
     |           '----------------------------> (+) ---->     |  | ||      DM
     |                                                         '.._o|
     |                                           |               '.' 
     |                                           |
     |                                           |
     |                                           V            |      .'. 
     |                                                        |--. .' -o|
     '----------------------------------------> (+) ---->   )-|  ||  | ||  SCC
                                                              |--' '.._o|
                                                              |      '.' 

   Please note that this Frames Kernel file solely implements the Frames for
   the ExoMars RSP Lander Component (RM).


RM Frames Hierarchy
--------------------------------------------------------------------------

   The diagram below shows the ExoMars RM frames hierarchy (except
   for science operations frames):


                               "J2000" INERTIAL
                               +---------------------------------+
                                      |                          |
                                      |<-pck                     |<-pck
                                      |                          |
                                      v                          v
                                  "IAU_MARS"                "IAU_EARTH"
                                MARS BODY-FIXED           EARTH BODY-FIXED
                              +------------------+        ----------------
                              |                  |
   "RM_MLG_DISPOSAL_FIXED"    |<-fixed           |<-fixed    "RM_MLG_NN*_FIXED"
   -----------------------    |                  |           ------------------
              ^               |                  |                  ^
              |               v                  v                  |
       fixed->|       "RM_MLG_DISPOSAL"     "RM_MLG_NN*"            |<-fixed
              |       MARS TOPOGRAPHIC    MARS TOPOGRAPHIC          |
              +-----------------------+   +-------------------------+
                            |                    |
                            |<-ck                |<-ck
                            |                    |
                            |                    |
                            v     "RM_ROVER"     v
                    +----------------------------+
                    |
                    |<-fixed
                    |
                    v
                "RM_MAST"
                ---------
                    |
                    |<-fixed
                    |
                    v
              "RM_PTR_ZERO"
              -------------
                    |
                    |<-ck
                    |
                    v
                 "RM_PTR"
                 --------
                    |
                    |<-fixed
                    |
                    v
                  "RM_PB"
               +------------------------+
               |                        .
               |<-fixed                 .
               |                        .
               V                        .
            "RM_NAVCAM_BASE"            .
          +-----------------+           .
          |                 |           .
          |<-fixed   fixed->|           .
          |                 |           .
          v                 v           .
     "RM_NAVCAM_L"     "RM_NAVCAM_R"    .
     -------------     -------------    .
                                        .
                                        V
                Individual instrument frame trees are provided
                      in the other sections of this file
   
   
   Please refer to the PanCam, NavCam sections for the frame
   hierarchy of each payload; and to the RM science operations frame
   definitions kernel for further details on these frame definitions.


RM Surface Frames
------------------------------------------------------------------------

   This section defines a series of Rover Module Mars Surface Frames.

Mars Local Geodetic Frames
-------------------------------------------------

   A series of Rover Module Mars Local Geodetic and Mars Local Geodetic Fixed
   frames (topocentric) frames are defined. The definition of their axis
   is common whereas the Rover Module Mars Local Geodetic have the origin on
   the origin of the Rover Body Frame and the Fixed ones have their origin
   fixed on the coordinates of the site.

   The Rover Module Mars Local Geodetic frames -- RM_MLG_NN -- are defined as
   follows:

      - +Z axis is in the direction of the vertical (i.e. approximately the
        negative gravity vector; "Zenith", assuming that the small local
        variation can be ignored),

      - +X axis is tangential to the local geodetic horizontal in an eastern
        direction (i.e. parallel to lines of latitude; "East"),

     - +Y axis completes the right hand frame ("North");

     - the origin of the frame the origin of the frame is initially defined
       to be coincident with the origin of the Rover Body frame, RM_ROVER,
       prior to the start of travel. During a travel sequence, this frame
       remains fixed with Mars, but becomes reset at the start of a new travel
       sequence. The rationale for this is that a travel sequence requires a
       stationary reference frame in which to measure position and coordinate
       navigation maps. The start of travel when the frame is reset may be at
       the start of each sol, or when new targets are generated.


   The Rover Mars Local Geodetic Fixed frames -- RM_MLG_NN_FIXED --  are
   equivalent to their corresponding RM_MLG_NN frames but its
   origin does not move during the mission and corresponds to a the surface
   point given by the travel sequence. Therefore, these frames are defined as
   zero-offset, fixed frames with respect to the RM_MLG_NN frames.

   The implementation of the Mars Local Geodetic Frames for the different
   travel sequences is provided by the ExoMars RSP Mars Local Geodetic Frames
   Kernel (see [6]) nevertheless this file provides the definition for the
   Local Geodetic Frame after rover disposal.

   If we assume that the total traverse distance during the mission will be
   relatively short (hundreds of meters, not kilometers) and, therefore, the
   local north and nadir directions, defining surface frame orientations, will
   be approximately the same at any point along the traverse path. This
   assumption allows defining surface frames as fixed offset frames with
   respect to each other and/or to Mars body-fixed frame, IAU_MARS. With this
   assumption we could always used the Mars Local Geodetic Disposal frame
   that is defined hereafter.


Mars Local Geodetic Disposal Frame:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The Rover disposal site Gaussian longitude and latitude upon which the
   definition is built are:

      Lon = 335.45 degrees East
      Lat =  18.20 degrees North

   This corresponds to one of the two final landing site locations.

   The coordinates specified above are given with respect to the 'IAU_MARS'
   instance defined by the rotation/shape model from the the PCK file
   'pck00010.tpc'.

   Topocentric frame RM_MLG_DISPOSAL is centered at the site RM_SITE_DISPOSAL
   which has planetodetic coordinates

      Longitude (deg):       -24.5500000000000
      Latitude  (deg):        18.2000000000000
      Altitude   (km):        -0.0000000000000E+00

   These planetodetic coordinates are expressed relative to
   a reference spheroid having the dimensions

      Equatorial radius (km):  3.3961900000000E+03
      Polar radius      (km):  3.3762000000000E+03

   These keywords implement the frame definition.

   \begindata

      FRAME_RM_MLG_DISPOSAL               =  -999900
      FRAME_-999900_NAME                  =  'RM_MLG_DISPOSAL'
      FRAME_-999900_CLASS                 =  4
      FRAME_-999900_CLASS_ID              =  -999900
      FRAME_-999900_CENTER                =  -999000

      OBJECT_-999900_FRAME                =  'RM_MLG_DISPOSAL'

      TKFRAME_-999900_RELATIVE            =  'IAU_MARS'
      TKFRAME_-999900_SPEC                =  'ANGLES'
      TKFRAME_-999900_UNITS               =  'DEGREES'
      TKFRAME_-999900_AXES                =  ( 3, 2, 3 )
      TKFRAME_-999900_ANGLES              =  ( -335.4500000000000,
                                                -71.8000000000000,
                                                270.0000000000000 )

   \begintext


Mars Local Geodetic Disposal Fixed Frame:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   MSL surface fixed frame -- MSL_SURFACE_FIXED -- is nominally
   co-aligned in orientation with the MSL_LOCAL_LEVEL frame but its
   origin does not move during the mission. Therefore, this frame is
   defined as a zero-offset, fixed frame with respect to the MSL_LOCAL_LEVEL
   frame.

   \begindata

      FRAME_RM_MLG_DISPOSAL_FIXED     = -999910
      FRAME_-999910_NAME              = 'RM_MLG_DISPOSAL_FIXED'
      FRAME_-999910_CLASS             =  4
      FRAME_-999910_CLASS_ID          = -999010
      FRAME_-999910_CENTER            = -999900
      TKFRAME_-999910_RELATIVE        = 'RM_ROVER'
      TKFRAME_-999910_SPEC            = 'ANGLES'
      TKFRAME_-999910_UNITS           = 'DEGREES'
      TKFRAME_-999910_AXES            = (     3,      1,     2 )
      TKFRAME_-999910_ANGLES          = (   0.0,    0.0,   0.0 )

   \begintext


RM Lander and Lander Structures Frames
------------------------------------------------------------------------

   This section of the file contains the definitions of the rover
   and rover structures frames.

   DISCLAIMER: The origin of the frames specified in the following 
   definitions are not implemented. The ``true'' origin of all frames 
   is in the center of the RM_ROVER frame, the center of which
   is defined by the position given by the SPK (ephemeris) kernel in 
   use. 


RM Rover Frames
--------------------------------------

   According to [4] the RM rover reference frame -- RM_ROVER -- is 
   defined as follows:

      -  +Z axis, lies vertically upwards, antiparallel to the gravity vector
         when the rover is on flat, horizontal terrain;

      -  +X axis lies towards the front of the Rover in the nominal direction
         of travel;
      
      -  +Y axis completes the right-handed frame;

      -  the origin of this frame at the intersection of the following planes:
         
            - A plane 252.5 mm aft (i.e. negative offset in +X axis) and  
              parallel to Plane 1 (the plane formed by the nominal bolt axes 
              of the front body HDRMs);

            - Plane 2, the plane of symmetry between the front body HDRM   
              nominal bolt axes - equivalent to the rover body mid-plane;

            - A plane 30 mm below and parallel to Plane 3 (the plane of the 
              rover body base).


   These diagrams illustrate the RM_ROVER frame:

   -Y Rover side view:
   -------------------

                .-.
                | |
                | |
                |_|
                |_|
                 |
                 |
                 |
                 |
                 | 
                 |
                 |
                 |
                 |        +Zrm
                _|_         ^
               |   |        |
         -------------------|-------------------------------------
               ,------------|------------.
               |            |             |
            ___|            |             |
           /   | +Xrm       |             |
           \___|__<---------o ____________.         +Yrm is out the page
                | |        +Yrm          | |
        __------/ \-----__               / \.__
       |  |-----\_/----|  |              \__.  | 
      .|  |.          .|  |.               .|  |.    
     / |__| \        / |__| \             / |__| \    
     \      /        \      /             \      /      
      `-..-'          `-..-'               `-..-'    


   +Z Rover side view:
   -------------------

          .-------------------------..-------------------------.
    .-----|                         ||                         |
    | .--.|                         ||                         |
    | |  ||                         ||                         |
    `-|  |'-------------------------''-------------------------'
     .------------------.
     |                  '----------.
     '----.                         |
       |  |                         |
       |  |    .-.                 .'
       |  |    | +Xrm      +Zrm    |
       |  |    | |<---------o      |
       |  |    | |          |      |
       |  |    '-'          |       '.
       '--|                 |        |            +Yrm is out of the page
          '-----.         .-|--------'
                '---------' v
          .--------------- +Yrm -----..-------------------------.
          |                         ||                         |
          |                         ||                         |
          |                         ||                         |
          '-------------------------''-------------------------'

   +X Rover side view:
   -------------------


                    o-o-=O===O--o
                       |o|___|
                          _\/
                         |_|_
                           |_|
                            |
                            |
                            |
                            |
                            |
                            |
                            |
                            |
                            |
                           _|_ +Zrm
                          |   | ^
      --------------------------|--------------------------
             |   |          |   |             |  |
             '---|          |   |          .--'--'
                 '--.-----------|----------|
                 .--|           |          |---.
            .-.  |============= o--------> ====|  .-.
           |___|=|            +Xrm      +Yrm   |=|___|
           |.-.                                   .-.|
           || |                                   | ||    +Yrm is out of the
           `| |                                   | |'    page
            '_'                                   '_'
          ~~~~~~~~                             ~~~~~~~~


   Since the RM bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

   These sets of keywords define the RM_ROVER frame:

   \begindata

      FRAME_RM_ROVER                   = -999000
      FRAME_-999000_NAME               = 'RM_ROVER'
      FRAME_-999000_CLASS              =  3
      FRAME_-999000_CLASS_ID           = -999000
      FRAME_-999000_CENTER             = -999
      CK_-999000_SCLK                  = -999
      CK_-999000_SPK                   = -999
      OBJECT_-999_FRAME                = 'RM_ROVER'

   \begintext
   

RM Deployable Mast, Pan & Tilt Mechanism and Payload Bracket Frames
----------------------------------------------------------------------------

   The RM Deployable Mast Assembly (RM_MAST) accommodates the Pan & Tilt
   Mechanism and the PanCam, NavCam and ISEM instruments, The DMA frame is
   positioned at the base of the mast. The frame RM_MAST has its origin at the
   base of the mast and its axes are nominally co-aligned to the RM_ROVER frame
   axes (within knowledge alignment errors).

   The Mast Pan & Tilt Rotation Mechanism (PTR) is the structure on top of the
   Rover Module mast that accommodates the Stereo Bench where PanCam and the
   NAVCAMs re placed. A series of reference frames are defined in order to
   capture the Pan and Tilt rotations of the structure.

   The Pan & Tilt Zero Rotation frame -- RM_PTR_ZERO -- has the origin at the
   top of the mast, just below the actual pan & tilt mechanism. The axes are
   nominally aligned to the RM_LANDER frame with null pan & tilt; however the
   RM_PTR_ZERO frame can take into account possible deformations of the mast
   and knowledge alignment errors. The frame is defined as follows:

      -  +Y axis is parallel to tilt axis of rotation, and nominally lies
         horizontally sideways

      -  +Z axis, is parallel to the pan axis of rotation, and nominally
         lies vertically upwards;

      -  +X axis completes the right-handed frame;

      -  the origin of this frame is defined as the intersection of the tilt
         axis of rotation and a line intersecting the axis which lies normal
         to both the tilt axis and pan axis. This intersection is assumed
         fixed with respect to the top of the mast. and allows for the
         eventually of the tilt axis and pan axis not intersecting.


   In order to incorporate the pan & tilt rotations, the Pan & Tilt Rotating
   frame is defined -- RM_PTR -- , it is identical to the RM_PTR_ZERO frame
   (i.e. a fixed translation in the Rover Body frame), but rotating with the
   direction of the Pan & Tilt. Pan and Tilt are then defined by the 3-2-1
   Euler rotation, where pan is the first rotation (about the +Z axis), tilt is
   the second rotation (about the +Y axis), and there is no possibility of
   rotation about the +X axis.

   The Payload Bracket frame -- RM_PB -- is fixed relative to the payload
   bracket (which itself is fixed to the tilt actuator rotor). The orientation
   of this frame is not fixed with respect to the RM_LANDER frame, but it
   changes, e.g. when the Deployable Mast Assembly is deployed or when, while
   in deployed configuration, the mast bends or either the pan and tilt angles
   are modified. The frame is defined as follows:

      -  +X axis is perpendicular to the +Y axis and is parallel to the
         interface plane between the payload bracket and the PanCam;

      -  +Y axis is co-aligned with the tilt axis;

      -  +Z axis completes the right-handed frame;

      -  the origin of this frame is the intersection of the pan and tilt axes,
         therefore it is located within the tilt actuator, along the axis of
         the tilt actuator shaft where this intersects with the pan axis.


   This diagram illustrates the RM_MAST, RM_PTR_ZERO, RM_PTR and RM_PB frames:

   +X Rover side view:
   -------------------

                        +Zptr0
                           ^
                           |
                    o-o-=O=|=O--o
                       |o|_|_|
                          _|/
                         |_|_
                           o------------> +Yptr0
                        +Xptr0
                            |
                            |
                          +Zmast
                            ^
                            |
                            |
                            |
                            |
                           _|_ +Zrm
                          | o----------> +Ymast
      ------------------ +Xmast ---------------------------
             |   |          |   ^ +Zrm        |  |
             '---|          |   |          .--'--'
                 '--.-----------|----------|
                 .--|           |          |---.
            .-.  |============= o--------> ====|  .-.
           |___|=|            +Xrm      +Yrm   |=|___|
           |.-.                                   .-.|
           || |                                   | ||    +Yrm, +Xmast and
           `| |                                   | |'    +Zptr0 are out of
            '_'                                   '_'     the page.
          ~~~~~~~~                             ~~~~~~~~


   -Y Rover side view:
   -------------------

                .-.
                | |
                | |
                |_|
                |_|
                 |
                 |
                 |
                 |
                 |
                 |
                 |
                 |
                 |        +Zrm
                _|_         ^
               |   |        |
         -------------------|-------------------------------------
               ,------------|------------.
               |            |             |
            ___|            |             |
           /   | +Xrm       |             |
           \___|__<---------o ____________.         +Yrm is out of the page
                | |        +Yrm          | |
        __------/ \-----__               / \.__
       |  |-----\_/----|  |              \__.  |
      .|  |.          .|  |.               .|  |.
     / |__| \        / |__| \             / |__| \
     \      /        \      /             \      /
      `-..-'          `-..-'               `-..-'



   These sets of keywords define the Pan & Tilt Mechanism and Rotation and
   Payload Bracket frames:

   \begindata

      FRAME_RM_MAST                   = -999010
      FRAME_-999010_NAME              = 'RM_MAST'
      FRAME_-999010_CLASS             =  4
      FRAME_-999010_CLASS_ID          = -999010
      FRAME_-999010_CENTER            = -999
      TKFRAME_-999010_RELATIVE        = 'RM_ROVER'
      TKFRAME_-999010_SPEC            = 'ANGLES'
      TKFRAME_-999010_UNITS           = 'DEGREES'
      TKFRAME_-999010_AXES            = (     3,      1,     2 )
      TKFRAME_-999010_ANGLES          = (   0.0,    0.0,   0.0 )

      FRAME_RM_PTR_ZERO               = -999011
      FRAME_-999011_NAME              = 'RM_PTR_ZERO'
      FRAME_-999011_CLASS             =  4
      FRAME_-999011_CLASS_ID          = -999011
      FRAME_-999011_CENTER            = -999
      TKFRAME_-999011_RELATIVE        = 'RM_MAST'
      TKFRAME_-999011_SPEC            = 'ANGLES'
      TKFRAME_-999011_UNITS           = 'DEGREES'
      TKFRAME_-999011_AXES            = (     3,      1,     2 )
      TKFRAME_-999011_ANGLES          = (   0.0,    0.0,   0.0 )


      FRAME_RM_PTR                    = -999012
      FRAME_-999012_NAME              = 'RM_PTR'
      FRAME_-999012_CLASS             =  3
      FRAME_-999012_CLASS_ID          = -999012
      FRAME_-999012_CENTER            = -999
      CK_-999012_SCLK                 = -999
      CK_-999012_SPK                  = -999

      FRAME_RM_PB                     = -999013
      FRAME_-999013_NAME              = 'RM_PB'
      FRAME_-999013_CLASS             =  4
      FRAME_-999013_CLASS_ID          = -999013
      FRAME_-999013_CENTER            = -999
      TKFRAME_-999013_RELATIVE        = 'RM_PTR'
      TKFRAME_-999013_SPEC            = 'ANGLES'
      TKFRAME_-999013_UNITS           = 'DEGREES'
      TKFRAME_-999013_AXES            = (      1,      2,     3 )
      TKFRAME_-999013_ANGLES          = (    0.0,    0.0,   0.0 )

   \begintext


RM NavCam Frames
----------------------------------------------------------------------------

   The Navigation Cameras reference frame -- RM_NAVCAM_BASE --, where the
   terrain stereo reconstruction (for Navigation) occurs, is attached to the
   cameras stereo bench, the axes are aligned to the PTR frame (moving
   according to pan & tilt mechanisms rotations) and is defined as follows:

      -  +X axis is defined as the projection of the cameras optical axis on
         the plane perpendicular to the +Y axis;

      -  +Y axis is in the direction from the right camera optical centre to
         the left camera optical centre;

      -  +Z axis completes the right-handed frame;

      -  The origin is a fixed translation from the PTR frame.


   \begindata

      FRAME_RM_NAVCAM_BASE            = -999020
      FRAME_-999020_NAME              = 'RM_NAVCAM_BASE'
      FRAME_-999020_CLASS             =  4
      FRAME_-999020_CLASS_ID          = -999020
      FRAME_-999020_CENTER            = -999
      TKFRAME_-999020_RELATIVE        = 'RM_PB'
      TKFRAME_-999020_SPEC            = 'ANGLES'
      TKFRAME_-999020_UNITS           = 'DEGREES'
      TKFRAME_-999020_AXES            = (      1,      2,     3 )
      TKFRAME_-999020_ANGLES          = (    0.0,    0.0,   0.0 )

      FRAME_RM_NAVCAM_L               = -999021
      FRAME_-999021_NAME              = 'RM_NAVCAM_L'
      FRAME_-999021_CLASS             =  4
      FRAME_-999021_CLASS_ID          = -999021
      FRAME_-999021_CENTER            = -999
      TKFRAME_-999021_RELATIVE        = 'RM_NAVCAM_BASE'
      TKFRAME_-999021_SPEC            = 'ANGLES'
      TKFRAME_-999021_UNITS           = 'DEGREES'
      TKFRAME_-999021_AXES            = (      1,      2,     3 )
      TKFRAME_-999021_ANGLES          = (    0.0,  -90.0,   0.0 )

      FRAME_RM_NAVCAM_R               = -999022
      FRAME_-999022_NAME              = 'RM_NAVCAM_R'
      FRAME_-999022_CLASS             =  4
      FRAME_-999022_CLASS_ID          = -999022
      FRAME_-999022_CENTER            = -999
      TKFRAME_-999022_RELATIVE        = 'RM_NAVCAM_BASE'
      TKFRAME_-999022_SPEC            = 'ANGLES'
      TKFRAME_-999022_UNITS           = 'DEGREES'
      TKFRAME_-999022_AXES            = (      1,      2,     3 )
      TKFRAME_-999022_ANGLES          = (    0.0,  -90.0,   0.0 )

   \begintext


PanCam Frames
------------------------------------------------------------------------

   This section of the file contains the definitions of the Panoramic
   Camera (PanCam) instrument frames
   

PanCam Frame Tree
~~~~~~~~~~~~~~~~~

   The diagram below shows the PanCam frame hierarchy.

                                  .
                                  .
                                  V
                               "RM_PB"
              +-------------------------------------+
              |                                     |
              |<-fixed                              |<-fixed
              |                                     |
              V                                     V
           "RM_NAVCAM_BASE"                      "RM_NAVCAM_BASE"
         +-----------------+          +-------------------------------+
         |                 |          |           |                   |
         |<-fixed   fixed->|          |<-fixed    |<-fixed     fixed->|
         |                 |          |           |                   |
         v                 v          |           v                   v
    "RM_NAVCAM_L"     "RM_NAVCAM_R"   |   "RM_PANCAM_WAC_L"   "RM_PANCAM_WAC_R"
    -------------     -------------   |   -----------------   -----------------
                                      |
                                      v
                               "RM_PANCAM_HRC"
                               ---------------


PanCam Base Frame
~~~~~~~~~~~~~~~~~~~~~

   The Panoramic Cameras reference frame (PANCAM) is attached to the PanCam
   stereo bench that is rigidly mounted on the Payload Bench on top of the
   Rover Mast. Therefore, the base frame associated with it -- the
   RM PANCAM Base rame, RM_PANCAM_BASE --  is specified as a fixed offset frame
   with its orientation given relative to the RM_ROVER frame as follows:

      -  +X axis is defined as the projection of the cameras optical axis on
         the plane perpendicular to the +Y axis;

      -  +Y axis is in the direction from the right WAC camera optical centre
         to the left WAC camera optical centre;

      -  +Z axis completes the right-handed frame;

      -  The origin is located at the middle of the segment linking the optical
         centres of the left and right WAC cameras.


   These diagrams illustrate the nominal RM_PANCAM_BASE frame with
   respect to the rover frame.
   
   
   +X Rover side view:
   -------------------

                        +Zpancam
                          ^
                          |
                          |
                          |
                          |
                    o-o-=Oo--------> +Ypancam
                   +Xpancam _|
                          _\/
                         |_|_
                           |_|
                             |
                            |
                            |
                            |
                            |
                            |
                            |
                            |
                            |
                           _|_ +Zrm
                          |   | ^
      --------------------------|--------------------------
             |   |          |   |             |  |
             '---|          |   |          .--'--'
                 '--.-----------|----------|
                 .--|           |          |---.
            .-.  |============= o--------> ====|  .-.
           |___|=|            +Xrm      +Yrm   |=|___|
           |.-.                                   .-.|
           || |                                   | ||    +Yrm is out of the
           `| |                                   | |'    page
            '_'                                   '_'
          ~~~~~~~~                             ~~~~~~~~

   
   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.
   
  \begindata

      FRAME_RM_PANCAM_BASE             =  -999100
      FRAME_-999100_NAME               = 'RM_PANCAM_BASE'
      FRAME_-999100_CLASS              =   4
      FRAME_-999100_CLASS_ID           =  -999100
      FRAME_-999100_CENTER             =  -999
      TKFRAME_-999100_RELATIVE         = 'RM_PB'
      TKFRAME_-999100_SPEC             = 'ANGLES'
      TKFRAME_-999100_UNITS            = 'DEGREES'
      TKFRAME_-999100_AXES             = ( 3,     2,      1   )
      TKFRAME_-999100_ANGLES           = ( 0.0,   0.0,    0.0 )

      FRAME_RM_PANCAM_WAC_L            =  -999110
      FRAME_-999110_NAME               = 'RM_PANCAM_WAC_L'
      FRAME_-999110_CLASS              =   4
      FRAME_-999110_CLASS_ID           =  -999110
      FRAME_-999110_CENTER             =  -999
      TKFRAME_-999110_RELATIVE         = 'RM_PANCAM_BASE'
      TKFRAME_-999110_SPEC             = 'ANGLES'
      TKFRAME_-999110_UNITS            = 'DEGREES'
      TKFRAME_-999110_AXES             = ( 3,     2,      1   )
      TKFRAME_-999110_ANGLES           = ( 0.0, -90.0,    0.0 )

      FRAME_RM_PANCAM_WAC_R            =  -999120
      FRAME_-999120_NAME               = 'RM_PANCAM_WAC_R'
      FRAME_-999120_CLASS              =   4
      FRAME_-999120_CLASS_ID           =  -999120
      FRAME_-999120_CENTER             =  -999
      TKFRAME_-999120_RELATIVE         = 'RM_PANCAM_BASE'
      TKFRAME_-999120_SPEC             = 'ANGLES'
      TKFRAME_-999120_UNITS            = 'DEGREES'
      TKFRAME_-999120_AXES             = ( 3,     2,      1   )
      TKFRAME_-999120_ANGLES           = ( 0.0, -90.0,    0.0 )

      FRAME_RM_PANCAM_HRC              =  -999130
      FRAME_-999130_NAME               = 'RM_PANCAM_HRC'
      FRAME_-999130_CLASS              =   4
      FRAME_-999130_CLASS_ID           =  -999130
      FRAME_-999130_CENTER             =  -999
      TKFRAME_-999130_RELATIVE         = 'RM_PANCAM_BASE'
      TKFRAME_-999130_SPEC             = 'ANGLES'
      TKFRAME_-999130_UNITS            = 'DEGREES'
      TKFRAME_-999130_AXES             = ( 3,     2,      1   )
      TKFRAME_-999130_ANGLES           = ( 0.0, -90.0,    0.0 )

  \begintext

 
RM NAIF ID Codes -- Definitions
===============================================================================

   This section contains name to NAIF ID mappings for the ExoMarsRSP RM
   mission. Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------

   rover:
   -----------
      RM                     -999     EXOMARS RSP ROVER MODULE
                                      EXOMARS RSP RM
                                      EXOMARS RSP ROVER
                                      EXOMARS ROVER


      RM_ROVER               -999000
      RM_MAST                -999010
      RM_PTR                 -999012
      RM_PB                  -999013
      RM_NAVCAM_L            -999021
      RM_NAVCAM_R            -999022



   PanCam:
   -----------
      RM_PANCAM              -999100
      RM_PANCAM_WAC_L        -999110
      RM_PANCAM_WAC_R        -999120
      RM_PANCAM_HRC          -999130


   The mappings summarized in this table are implemented by the keywords
   below.

  \begindata

      NAIF_BODY_NAME += ( 'RM'                          )
      NAIF_BODY_CODE += ( -999                          )

      NAIF_BODY_NAME += ( 'EXOMARS RSP ROVER MODULE'    )
      NAIF_BODY_CODE += ( -999                          )

      NAIF_BODY_NAME += ( 'EXOMARS RSP RM'              )
      NAIF_BODY_CODE += ( -999                          )
      
      NAIF_BODY_NAME += ( 'EXOMARS RSP ROVER'           )
      NAIF_BODY_CODE += ( -999                          )

      NAIF_BODY_NAME += ( 'EXOMARS ROVER'               )
      NAIF_BODY_CODE += ( -999                          )

      NAIF_BODY_NAME += ( 'RM_ROVER'                    )
      NAIF_BODY_CODE += ( -999000                       )

      NAIF_BODY_NAME += ( 'RM_SITE_DISPOSAL'            )
      NAIF_BODY_CODE += ( -999900                       )

      NAIF_BODY_NAME += ( 'RM_MAST'                     )
      NAIF_BODY_CODE += ( -999010                       )

      NAIF_BODY_NAME += ( 'RM_PTR'                      )
      NAIF_BODY_CODE += ( -999012                       )

      NAIF_BODY_NAME += ( 'RM_NAVCAM_L'                 )
      NAIF_BODY_CODE += ( -999021                       )

      NAIF_BODY_NAME += ( 'RM_NAVCAM_R'                 )
      NAIF_BODY_CODE += ( -999022                       )

      NAIF_BODY_NAME += ( 'RM_NAVCAM_R'                 )
      NAIF_BODY_CODE += ( -999022                       )

      NAIF_BODY_NAME += ( 'RM_PANCAM'                   )
      NAIF_BODY_CODE += ( -999100                       )

      NAIF_BODY_NAME += ( 'RM_PANCAM_WAC_L'             )
      NAIF_BODY_CODE += ( -999110                       )

      NAIF_BODY_NAME += ( 'RM_PANCAM_WAC_R'             )
      NAIF_BODY_CODE += ( -999120                       )

      NAIF_BODY_NAME += ( 'RM_PANCAM_HRC'               )
      NAIF_BODY_CODE += ( -999130                       )

  \begintext
  
  
End of FK file.