KPL/MK

Meta-kernel for MARS EXPRESS Archived Kernels
==========================================================================

   This meta-kernel lists the MARS EXPRESS Archived SPICE kernels
   providing information for the full mission. All of the kernels listed
   below are archived in the PSA MARS EXPRESS SPICE kernel archive.

   This set of files and the order in which they are listed were picked to
   provide the best available data and the most complete coverage for the
   specified year based on the information about the kernels available at
   the time this meta-kernel was made. For detailed information about the
   kernels listed below refer to the internal comments included in the
   kernels and the documentation accompanying the MARS EXPRESS
   SPICE kernel archive.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".
   The SPICELIB routine FURNSH loads a kernel into the pool.


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the MARS EXPRESS SPICE data set's ``data'' directory
   on their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on 2024-09-06 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was MEX_V11.TM.


   \begindata

     PATH_VALUES       = ( './DATA' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

'$KERNELS/CK/ATNM_T6_P030602191822_00135.BC'
'$KERNELS/CK/ATNM_T6_P050401000000_00260.BC'
'$KERNELS/CK/ATNM_T6_P060401000000_01346.BC'
'$KERNELS/CK/ATNM_T6_P170331235152_01873.BC'
'$KERNELS/CK/ATNM_MEASURED_2003_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2004_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2005_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2006_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2007_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2008_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2009_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2010_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2011_V04.BC'
'$KERNELS/CK/ATNM_MEASURED_2012_V04.BC'
'$KERNELS/CK/ATNM_MEASURED_2013_V04.BC'
'$KERNELS/CK/ATNM_MEASURED_2014_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2015_V04.BC'
'$KERNELS/CK/ATNM_MEASURED_2016_V04.BC'
'$KERNELS/CK/ATNM_MEASURED_2017_V02.BC'
'$KERNELS/CK/ATNM_MEASURED_2018_V02.BC'
'$KERNELS/CK/ATNM_MEASURED_2019_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2020_V03.BC'
'$KERNELS/CK/ATNM_MEASURED_2021_V02.BC'
'$KERNELS/CK/ATNM_MEASURED_2022_V01.BC'
'$KERNELS/CK/ATNM_MEASURED_2023_V01.BC'
'$KERNELS/CK/ATNM_RECONSTITUTED_00004.BC'
'$KERNELS/CK/MEX_ASPERA_SAF_030603_91.BC'
'$KERNELS/CK/MEX_SA_2003_V0002.BC'
'$KERNELS/CK/MEX_SA_2004_V0002.BC'
'$KERNELS/CK/MEX_SA_2005_V0002.BC'
'$KERNELS/CK/MEX_SA_2006_V0002.BC'
'$KERNELS/CK/MEX_SA_2007_V0002.BC'
'$KERNELS/CK/MEX_SA_2008_V0034.BC'
'$KERNELS/CK/MEX_SA_2009_V0055.BC'
'$KERNELS/CK/MEX_SA_2010_V0049.BC'
'$KERNELS/CK/MEX_SA_2011_V0050.BC'
'$KERNELS/CK/MEX_SA_2012_V0048.BC'
'$KERNELS/CK/MEX_SA_2013_V0050.BC'
'$KERNELS/CK/MEX_SA_2014_V0046.BC'
'$KERNELS/CK/MEX_SA_2015_V0004.BC'
'$KERNELS/CK/MEX_SA_2016_V0024.BC'
'$KERNELS/CK/MEX_SA_2017_V0003.BC'
'$KERNELS/CK/MEX_SA_2018_V0010.BC'
'$KERNELS/CK/MEX_SA_2019_V0003.BC'
'$KERNELS/CK/MEX_SA_2020_V0002.BC'
'$KERNELS/CK/MEX_SA_2021_V0002.BC'
'$KERNELS/CK/MEX_SA_2022_V0001.BC'
'$KERNELS/CK/MEX_SA_2023_V0001.BC'

'$KERNELS/FK/MEX_DSK_SURFACES_V04.TF'
'$KERNELS/FK/MEX_SCI_V01.TF'
'$KERNELS/FK/MEX_PFS_ROIS_V02.TF'
'$KERNELS/FK/MEX_RELAY_LOCATIONS_V03.TF'
'$KERNELS/FK/EARTH_TOPO_050714.TF'
'$KERNELS/FK/EARTHFIXEDIAU.TF'
'$KERNELS/FK/ESTRACK_V04.TF'
'$KERNELS/FK/EARTHSTNS_RU_20210706.TF'
'$KERNELS/FK/RSSD0002.TF'
'$KERNELS/FK/MEX_V16.TF'

'$KERNELS/IK/MEX_ASPERA_V09.TI'
'$KERNELS/IK/MEX_HRSC_V09.TI'
'$KERNELS/IK/MEX_MARSIS_V02.TI'
'$KERNELS/IK/MEX_OMEGA_V03.TI'
'$KERNELS/IK/MEX_PFS_V06.TI'
'$KERNELS/IK/MEX_SPICAM_V03.TI'
'$KERNELS/IK/MEX_STR_V02.TI'
'$KERNELS/IK/MEX_VMC_V04.TI'
'$KERNELS/IK/MEX_MELACOM_V01.TI'

'$KERNELS/LSK/NAIF0012.TLS'

'$KERNELS/PCK/PCK00010.TPC'
'$KERNELS/PCK/DE403_MASSES.TPC'

'$KERNELS/PCK/EARTH_000101_241128_240905.BPC'

'$KERNELS/SCLK/MEX_240904_STEP.TSC'

'$KERNELS/SPK/DE405.BSP'
'$KERNELS/SPK/EARTHSTNS_ITRF93_050714.BSP'
'$KERNELS/SPK/ESTRACK_V04.BSP'
'$KERNELS/SPK/EARTHSTNS_RU_20210706.BSP'
'$KERNELS/SPK/MAR097_030101_300101_V0001.BSP'
'$KERNELS/SPK/C2013A1_S105_MERGED.BSP'
'$KERNELS/SPK/MEX_STRUCT_V01.BSP'
'$KERNELS/SPK/MEX_ASPERA_STRUCT_V12.BSP'
'$KERNELS/SPK/MEX_RELAY_LOCATIONS_V03.BSP'
'$KERNELS/SPK/MEX_PFS_ROIS_V01.BSP'
'$KERNELS/SPK/ORHM_______________00038.BSP'
'$KERNELS/SPK/ORMM_T19_031222180906_00052.BSP'
'$KERNELS/SPK/ORMM_T19_040201000000_00060.BSP'
'$KERNELS/SPK/ORMM_T19_040301000000_00068.BSP'
'$KERNELS/SPK/ORMM_T19_040401000000_00072.BSP'
'$KERNELS/SPK/ORMM_T19_040501000000_00076.BSP'
'$KERNELS/SPK/ORMM_T19_040601000000_00080.BSP'
'$KERNELS/SPK/ORMM_T19_040701000000_00086.BSP'
'$KERNELS/SPK/ORMM_T19_040801000000_00088.BSP'
'$KERNELS/SPK/ORMM_T19_040901000000_00091.BSP'
'$KERNELS/SPK/ORMM_T19_041001000000_00096.BSP'
'$KERNELS/SPK/ORMM_T19_041101000000_00100.BSP'
'$KERNELS/SPK/ORMM_T19_041201000000_00105.BSP'
'$KERNELS/SPK/ORMM_T19_050101000000_00109.BSP'
'$KERNELS/SPK/ORMM_T19_050201000000_00113.BSP'
'$KERNELS/SPK/ORMM_T19_050301000000_00117.BSP'
'$KERNELS/SPK/ORMM_T19_050401000000_00122.BSP'
'$KERNELS/SPK/ORMM_T19_050501000000_00129.BSP'
'$KERNELS/SPK/ORMM_T19_050601000000_00136.BSP'
'$KERNELS/SPK/ORMM_T19_050701000000_00140.BSP'
'$KERNELS/SPK/ORMM_T19_050801000000_00153.BSP'
'$KERNELS/SPK/ORMM_T19_050901000000_00165.BSP'
'$KERNELS/SPK/ORMM_T19_051001000000_00181.BSP'
'$KERNELS/SPK/ORMM_T19_051101000000_00194.BSP'
'$KERNELS/SPK/ORMM_T19_051201000000_00203.BSP'
'$KERNELS/SPK/ORMM_T19_060101000000_00217.BSP'
'$KERNELS/SPK/ORMM_T19_060201000000_00229.BSP'
'$KERNELS/SPK/ORMM_T19_060301000000_00241.BSP'
'$KERNELS/SPK/ORMM_T19_060401000000_00253.BSP'
'$KERNELS/SPK/ORMM_T19_060501000000_00263.BSP'
'$KERNELS/SPK/ORMM_T19_060601000000_00274.BSP'
'$KERNELS/SPK/ORMM_T19_060701000000_00290.BSP'
'$KERNELS/SPK/ORMM_T19_060801000000_00294.BSP'
'$KERNELS/SPK/ORMM_T19_060901000000_00307.BSP'
'$KERNELS/SPK/ORMM_T19_061001000000_00310.BSP'
'$KERNELS/SPK/ORMM_T19_061101000000_00324.BSP'
'$KERNELS/SPK/ORMM_T19_061201000000_00336.BSP'
'$KERNELS/SPK/ORMM_T19_070101000000_00349.BSP'
'$KERNELS/SPK/ORMM_T19_070201000000_00361.BSP'
'$KERNELS/SPK/ORMM_T19_070301000000_00371.BSP'
'$KERNELS/SPK/ORMM_T19_070401000000_00387.BSP'
'$KERNELS/SPK/ORMM_T19_070501000000_00395.BSP'
'$KERNELS/SPK/ORMM_T19_070601000000_00403.BSP'
'$KERNELS/SPK/ORMM_T19_070701000000_00414.BSP'
'$KERNELS/SPK/ORMM_T19_070801000000_00423.BSP'
'$KERNELS/SPK/ORMM_T19_070901000000_00431.BSP'
'$KERNELS/SPK/ORMM_T19_071001000000_00441.BSP'
'$KERNELS/SPK/ORMM_T19_071101000000_00449.BSP'
'$KERNELS/SPK/ORMM_T19_071201000000_00457.BSP'
'$KERNELS/SPK/ORMM_T19_080101000000_00465.BSP'
'$KERNELS/SPK/ORMM_T19_080201000000_00474.BSP'
'$KERNELS/SPK/ORMM_T19_080301000000_00484.BSP'
'$KERNELS/SPK/ORMM_T19_080401000000_00490.BSP'
'$KERNELS/SPK/ORMM_T19_080501000000_00498.BSP'
'$KERNELS/SPK/ORMM_T19_080601000000_00508.BSP'
'$KERNELS/SPK/ORMM_T19_080701000000_00516.BSP'
'$KERNELS/SPK/ORMM_T19_080801000000_00525.BSP'
'$KERNELS/SPK/ORMM_T19_080901000000_00536.BSP'
'$KERNELS/SPK/ORMM_T19_081001000000_00544.BSP'
'$KERNELS/SPK/ORMM_T19_081101000000_00549.BSP'
'$KERNELS/SPK/ORMM_T19_081201000000_00553.BSP'
'$KERNELS/SPK/ORMM_T19_090101000000_00562.BSP'
'$KERNELS/SPK/ORMM_T19_090201000000_00570.BSP'
'$KERNELS/SPK/ORMM_T19_090301000000_00580.BSP'
'$KERNELS/SPK/ORMM_T19_090401000000_00586.BSP'
'$KERNELS/SPK/ORMM_T19_090501000000_00594.BSP'
'$KERNELS/SPK/ORMM_T19_090601000000_00602.BSP'
'$KERNELS/SPK/ORMM_T19_090701000000_00611.BSP'
'$KERNELS/SPK/ORMM_T19_090801000000_00619.BSP'
'$KERNELS/SPK/ORMM_T19_090901000000_00628.BSP'
'$KERNELS/SPK/ORMM_T19_091001000000_00637.BSP'
'$KERNELS/SPK/ORMM_T19_091101000000_00648.BSP'
'$KERNELS/SPK/ORMM_T19_091201000000_00654.BSP'
'$KERNELS/SPK/ORMM_T19_100101000000_00662.BSP'
'$KERNELS/SPK/ORMM_T19_100201000000_00674.BSP'
'$KERNELS/SPK/ORMM_T19_100301000000_00682.BSP'
'$KERNELS/SPK/ORMM_T19_100401000000_00688.BSP'
'$KERNELS/SPK/ORMM_T19_100501000000_00696.BSP'
'$KERNELS/SPK/ORMM_T19_100601000000_00704.BSP'
'$KERNELS/SPK/ORMM_T19_100701000000_00712.BSP'
'$KERNELS/SPK/ORMM_T19_100801000000_00723.BSP'
'$KERNELS/SPK/ORMM_T19_100901000000_00731.BSP'
'$KERNELS/SPK/ORMM_T19_101001000000_00739.BSP'
'$KERNELS/SPK/ORMM_T19_101101000000_00749.BSP'
'$KERNELS/SPK/ORMM_T19_101201000000_00755.BSP'
'$KERNELS/SPK/ORMM_T19_110101000000_00758.BSP'
'$KERNELS/SPK/ORMM_T19_110201000000_00766.BSP'
'$KERNELS/SPK/ORMM_T19_110301000000_00774.BSP'
'$KERNELS/SPK/ORMM_T19_110401000000_00780.BSP'
'$KERNELS/SPK/ORMM_T19_110501000000_00788.BSP'
'$KERNELS/SPK/ORMM_T19_110601000000_00794.BSP'
'$KERNELS/SPK/ORMM_T19_110701000000_00802.BSP'
'$KERNELS/SPK/ORMM_T19_110801000000_00815.BSP'
'$KERNELS/SPK/ORMM_T19_110901000000_00824.BSP'
'$KERNELS/SPK/ORMM_T19_111001000000_00834.BSP'
'$KERNELS/SPK/ORMM_T19_111101000000_00842.BSP'
'$KERNELS/SPK/ORMM_T19_111201000000_00848.BSP'
'$KERNELS/SPK/ORMM_T19_120101000000_00859.BSP'
'$KERNELS/SPK/ORMM_T19_120201000000_00867.BSP'
'$KERNELS/SPK/ORMM_T19_120301000000_00873.BSP'
'$KERNELS/SPK/ORMM_T19_120401000000_00879.BSP'
'$KERNELS/SPK/ORMM_T19_120501000000_00887.BSP'
'$KERNELS/SPK/ORMM_T19_120601000000_00896.BSP'
'$KERNELS/SPK/ORMM_T19_120701000000_00906.BSP'
'$KERNELS/SPK/ORMM_T19_120801000000_00914.BSP'
'$KERNELS/SPK/ORMM_T19_120901000000_00920.BSP'
'$KERNELS/SPK/ORMM_T19_121001000000_00930.BSP'
'$KERNELS/SPK/ORMM_T19_121101000000_00936.BSP'
'$KERNELS/SPK/ORMM_T19_121201000000_00944.BSP'
'$KERNELS/SPK/ORMM_T19_130101000000_00952.BSP'
'$KERNELS/SPK/ORMM_T19_130201000000_00961.BSP'
'$KERNELS/SPK/ORMM_T19_130301000000_00964.BSP'
'$KERNELS/SPK/ORMM_T19_130401000000_00970.BSP'
'$KERNELS/SPK/ORMM_T19_130501000000_00977.BSP'
'$KERNELS/SPK/ORMM_T19_130601000000_00985.BSP'
'$KERNELS/SPK/ORMM_T19_130701000000_00995.BSP'
'$KERNELS/SPK/ORMM_T19_130801000000_01003.BSP'
'$KERNELS/SPK/ORMM_T19_130901000000_01011.BSP'
'$KERNELS/SPK/ORMM_T19_131001000000_01019.BSP'
'$KERNELS/SPK/ORMM_T19_131101000000_01025.BSP'
'$KERNELS/SPK/ORMM_T19_131201000000_01033.BSP'
'$KERNELS/SPK/ORMM_T19_140101000000_01041.BSP'
'$KERNELS/SPK/ORMM_T19_140201000000_01050.BSP'
'$KERNELS/SPK/ORMM_T19_140301000000_01058.BSP'
'$KERNELS/SPK/ORMM_T19_140401000000_01064.BSP'
'$KERNELS/SPK/ORMM_T19_140501000000_01070.BSP'
'$KERNELS/SPK/ORMM_T19_140601000000_01076.BSP'
'$KERNELS/SPK/ORMM_T19_140701000000_01084.BSP'
'$KERNELS/SPK/ORMM_T19_140801000000_01092.BSP'
'$KERNELS/SPK/ORMM_T19_140901000000_01102.BSP'
'$KERNELS/SPK/ORMM_T19_141001000000_01110.BSP'
'$KERNELS/SPK/ORMM_T19_141101000000_01118.BSP'
'$KERNELS/SPK/ORMM_T19_141201000000_01124.BSP'
'$KERNELS/SPK/ORMM_T19_150101000000_01132.BSP'
'$KERNELS/SPK/ORMM_T19_150201000000_01140.BSP'
'$KERNELS/SPK/ORMM_T19_150301000000_01148.BSP'
'$KERNELS/SPK/ORMM_T19_150401000000_01152.BSP'
'$KERNELS/SPK/ORMM_T19_150501000000_01154.BSP'
'$KERNELS/SPK/ORMM_T19_150601000000_01162.BSP'
'$KERNELS/SPK/ORMM_T19_150701000000_01170.BSP'
'$KERNELS/SPK/ORMM_T19_150801000000_01181.BSP'
'$KERNELS/SPK/ORMM_T19_150901000000_01191.BSP'
'$KERNELS/SPK/ORMM_T19_151001000000_01201.BSP'
'$KERNELS/SPK/ORMM_T19_151101000000_01211.BSP'
'$KERNELS/SPK/ORMM_T19_151201000000_01215.BSP'
'$KERNELS/SPK/ORMM_T19_160101000000_01222.BSP'
'$KERNELS/SPK/ORMM_T19_160201000000_01231.BSP'
'$KERNELS/SPK/ORMM_T19_160301000000_01239.BSP'
'$KERNELS/SPK/ORMM_T19_160401000000_01245.BSP'
'$KERNELS/SPK/ORMM_T19_160501000000_01253.BSP'
'$KERNELS/SPK/ORMM_T19_160601000000_01259.BSP'
'$KERNELS/SPK/ORMM_T19_160701000000_01267.BSP'
'$KERNELS/SPK/ORMM_T19_160801000000_01278.BSP'
'$KERNELS/SPK/ORMM_T19_160901000000_01285.BSP'
'$KERNELS/SPK/ORMM_T19_161001000000_01294.BSP'
'$KERNELS/SPK/ORMM_T19_161101000000_01303.BSP'
'$KERNELS/SPK/ORMM_T19_161201000000_01309.BSP'
'$KERNELS/SPK/ORMM_T19_170101000000_01318.BSP'
'$KERNELS/SPK/ORMM_T19_170201000000_01326.BSP'
'$KERNELS/SPK/ORMM_T19_170301000000_01336.BSP'
'$KERNELS/SPK/ORMM_T19_170401000000_01344.BSP'
'$KERNELS/SPK/ORMM_T19_170501000000_01351.BSP'
'$KERNELS/SPK/ORMM_T19_170601000000_01358.BSP'
'$KERNELS/SPK/ORMM_T19_170701000000_01360.BSP'
'$KERNELS/SPK/ORMM_T19_170801000000_01369.BSP'
'$KERNELS/SPK/ORMM_T19_170901000000_01375.BSP'
'$KERNELS/SPK/ORMM_T19_171001000000_01383.BSP'
'$KERNELS/SPK/ORMM_T19_171101000000_01391.BSP'
'$KERNELS/SPK/ORMM_T19_171201000000_01395.BSP'
'$KERNELS/SPK/ORMM_T19_180101000000_01406.BSP'
'$KERNELS/SPK/ORMM_T19_180201000000_01414.BSP'
'$KERNELS/SPK/ORMM_T19_180301000000_01420.BSP'
'$KERNELS/SPK/ORMM_T19_180401000000_01428.BSP'
'$KERNELS/SPK/ORMM_T19_180501000000_01434.BSP'
'$KERNELS/SPK/ORMM_T19_180601000000_01442.BSP'
'$KERNELS/SPK/ORMM_T19_180701000000_01452.BSP'
'$KERNELS/SPK/ORMM_T19_180801000000_01460.BSP'
'$KERNELS/SPK/ORMM_T19_180901000000_01466.BSP'
'$KERNELS/SPK/ORMM_T19_181001000000_01476.BSP'
'$KERNELS/SPK/ORMM_T19_181101000000_01484.BSP'
'$KERNELS/SPK/ORMM_T19_181201000000_01490.BSP'
'$KERNELS/SPK/ORMM_T19_190101000000_01498.BSP'
'$KERNELS/SPK/ORMM_T19_190201000000_01512.BSP'
'$KERNELS/SPK/ORMM_T19_190301000000_01518.BSP'
'$KERNELS/SPK/ORMM_T19_190401000000_01526.BSP'
'$KERNELS/SPK/ORMM_T19_190501000000_01532.BSP'
'$KERNELS/SPK/ORMM_T19_190601000000_01538.BSP'
'$KERNELS/SPK/ORMM_T19_190701000000_01546.BSP'
'$KERNELS/SPK/ORMM_T19_190801000000_01548.BSP'
'$KERNELS/SPK/ORMM_T19_190901000000_01556.BSP'
'$KERNELS/SPK/ORMM_T19_191001000000_01564.BSP'
'$KERNELS/SPK/ORMM_T19_191101000000_01572.BSP'
'$KERNELS/SPK/ORMM_T19_191201000000_01578.BSP'
'$KERNELS/SPK/ORMM_T19_200101000000_01586.BSP'
'$KERNELS/SPK/ORMM_T19_200201000000_01592.BSP'
'$KERNELS/SPK/ORMM_T19_200301000000_01603.BSP'
'$KERNELS/SPK/ORMM_T19_200401000000_01611.BSP'
'$KERNELS/SPK/ORMM_T19_200501000000_01615.BSP'
'$KERNELS/SPK/ORMM_T19_200601000000_01624.BSP'
'$KERNELS/SPK/ORMM_T19_200701000000_01632.BSP'
'$KERNELS/SPK/ORMM_T19_200801000000_01638.BSP'
'$KERNELS/SPK/ORMM_T19_200901000000_01648.BSP'
'$KERNELS/SPK/ORMM_T19_201001000000_01656.BSP'
'$KERNELS/SPK/ORMM_T19_201101000000_01664.BSP'
'$KERNELS/SPK/ORMM_T19_201201000000_01670.BSP'
'$KERNELS/SPK/ORMM_T19_210101000000_01678.BSP'
'$KERNELS/SPK/ORMM_T19_210201000000_01687.BSP'
'$KERNELS/SPK/ORMM_T19_210301000000_01695.BSP'
'$KERNELS/SPK/ORMM_T19_210401000000_01705.BSP'
'$KERNELS/SPK/ORMM_T19_210501000000_01713.BSP'
'$KERNELS/SPK/ORMM_T19_210601000000_01723.BSP'
'$KERNELS/SPK/ORMM_T19_210701000000_01727.BSP'
'$KERNELS/SPK/ORMM_T19_210801000000_01733.BSP'
'$KERNELS/SPK/ORMM_T19_210901000000_01748.BSP'
'$KERNELS/SPK/ORMM_T19_211001000000_01737.BSP'
'$KERNELS/SPK/ORMM_T19_211101000000_01743.BSP'
'$KERNELS/SPK/ORMM_T19_211201000000_01745.BSP'
'$KERNELS/SPK/ORMM_T19_220101000000_01752.BSP'
'$KERNELS/SPK/ORMM_T19_220201000000_01756.BSP'
'$KERNELS/SPK/ORMM_T19_220301000000_01760.BSP'
'$KERNELS/SPK/ORMM_T19_220401000000_01762.BSP'
'$KERNELS/SPK/ORMM_T19_220501000000_01768.BSP'
'$KERNELS/SPK/ORMM_T19_220601000000_01772.BSP'
'$KERNELS/SPK/ORMM_T19_220701000000_01777.BSP'
'$KERNELS/SPK/ORMM_T19_220801000000_01781.BSP'
'$KERNELS/SPK/ORMM_T19_220901000000_01786.BSP'
'$KERNELS/SPK/ORMM_T19_221001000000_01791.BSP'
'$KERNELS/SPK/ORMM_T19_221101000000_01795.BSP'
'$KERNELS/SPK/ORMM_T19_221201000000_01797.BSP'
'$KERNELS/SPK/ORMM_T19_230101000000_01801.BSP'
'$KERNELS/SPK/ORMM_T19_230201000000_01805.BSP'
'$KERNELS/SPK/ORMM_T19_230301000000_01813.BSP'
'$KERNELS/SPK/ORMM_T19_230401000000_01813.BSP'
'$KERNELS/SPK/ORMM_T19_230501000000_01815.BSP'
'$KERNELS/SPK/ORMM_T19_230601000000_01819.BSP'
'$KERNELS/SPK/ORMM_T19_230701000000_01823.BSP'
'$KERNELS/SPK/ORMM_T19_230801000000_01825.BSP'
'$KERNELS/SPK/ORMM_T19_230801000000_01827.BSP'
'$KERNELS/SPK/ORMM_T19_230901000000_01831.BSP'
'$KERNELS/SPK/ORMM_T19_231001000000_01837.BSP'
'$KERNELS/SPK/ORMM_T19_231101000000_01837.BSP'
'$KERNELS/SPK/ORMM_T19_231201000000_01841.BSP'
'$KERNELS/SPK/ORMM_T19_240101000000_01847.BSP'
'$KERNELS/SPK/ORMM_T19_240201000000_01852.BSP'
'$KERNELS/SPK/ORMM_T19_240301000000_01856.BSP'
'$KERNELS/SPK/ORMM_T19_240401000000_01858.BSP'
'$KERNELS/SPK/ORMM_T19_240501000000_01862.BSP'
'$KERNELS/SPK/ORMM_T19_240601000000_01865.BSP'
'$KERNELS/SPK/ORMM_T19_240701000000_01871.BSP'
'$KERNELS/SPK/ORMM_T19_240801000000_01873.BSP'

                         )

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91 813 14 29
           spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           +1 (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


End of MK file.
