KPL/FK

Mars Express Target Body DSK Surface ID Codes
========================================================================

   This frame kernel contains a set of Mars Express Target Body DSK Surface
   ID Codes for Phobos, Deimos and Mars.


Version and Date
------------------------------------------------------------------------

   Version 0.4 -- May 22, 2024 -- Alfredo Escalante Lopez, ESAC/ESA

      Added Surface ID definition for Mars global surface.

   Version 0.3 -- May 10, 2023 -- Alfredo Escalante Lopez, ESAC/ESA

      Added Surface ID definitions for corrected Deimos model.

   Version 0.2 -- April 20, 2021 -- Alfredo Escalante Lopez, ESAC/ESA

      Corrected Surface ID definitions.

   Version 0.1 -- April 24, 2020 -- Marc Costa Sitja, ESAC/ESA

      Added new surfaces for Phobos: PHOBOS_M003_GAS_V01 and
      PHOBOS_K275_DLR_V02 and S/C-related Surfaces and IDs.

   Version 0.0 -- January 13, 2019 -- Marc Costa Sitja, ESAC/ESA

      First version.


References
------------------------------------------------------------------------

   1. ``Frames Required Reading''

   2. ``Kernel Pool Required Reading''

   3. ``DS-Kernel Required Reading''

   4. Mars Express Frames Kernel.


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH and CSPICE
   function furnsh_c load a kernel file into the kernel pool as shown
   below.

      CALL FURNSH ( 'frame_kernel_name' )
      furnsh_c    ( "frame_kernel_name" );

   This file was created and may be updated with a text editor or word
   processor.


Definition Section
------------------------------------------------------------------------

   This section contains name to ID mappings for the Mars Express
   target body DSK surfaces. These mappings are supported by all SPICE
   toolkits with integrated DSK capabilities (version N0066 or later).

   MEX Spacecraft Surface name/IDs:

          DSK Surface Name           ID      Body ID
      ===========================  =======  ========

      MEX_SC_BUS                   -41000   -41000
      MEX_SC_SA+Z                  -41011   -41011
      MEX_SC_SA-Z                  -41012   -41012

   Name-ID Mapping keywords:

   \begindata

       NAIF_SURFACE_NAME += 'MEX_SC_BUS'
       NAIF_SURFACE_CODE += -41000
       NAIF_SURFACE_BODY += -41000

       NAIF_SURFACE_NAME += 'MEX_SC_SA+Z'
       NAIF_SURFACE_CODE += -41011
       NAIF_SURFACE_BODY += -41011

       NAIF_SURFACE_NAME += 'MEX_SC_SA-Z'
       NAIF_SURFACE_CODE += -41012
       NAIF_SURFACE_BODY += -41012

   \begintext


   Mars global Surface name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      MARS_M005_MOL_V03            49903      499


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'MARS_M005_MOL_V03'
      NAIF_SURFACE_CODE += 49903
      NAIF_SURFACE_BODY += 499

   \begintext


   Mars Satellite Phobos Surface name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      PHOBOS_M157_GAS_V01          14011      401
      PHOBOS_M003_GAS_V01          14012      401
      PHOBOS_K137_DLR_V01          10041      401
      PHOBOS_K275_DLR_V02          10042      401


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'PHOBOS_M157_GAS_V01'
      NAIF_SURFACE_CODE += 14011
      NAIF_SURFACE_BODY += 401

      NAIF_SURFACE_NAME += 'PHOBOS_M003_GAS_V01'
      NAIF_SURFACE_CODE += 14012
      NAIF_SURFACE_BODY += 401

      NAIF_SURFACE_NAME += 'PHOBOS_K137_DLR_V01'
      NAIF_SURFACE_CODE += 10041
      NAIF_SURFACE_BODY += 401

      NAIF_SURFACE_NAME += 'PHOBOS_K275_DLR_V02'
      NAIF_SURFACE_CODE += 10042
      NAIF_SURFACE_BODY += 401

   \begintext


   Mars Satellite Deimos Surface name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      DEIMOS_K002_THO_V01          14020      402
      DEIMOS_K005_THO_V02          14021      402


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'DEIMOS_K002_THO_V01'
      NAIF_SURFACE_CODE += 14020
      NAIF_SURFACE_BODY += 402

      NAIF_SURFACE_NAME += 'DEIMOS_K005_THO_V02'
      NAIF_SURFACE_CODE += 14021
      NAIF_SURFACE_BODY += 402

   \begintext


End of FK file.