KPL/FK

BepiColombo MMO Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   BepiColombo Mercury Magnetospheric Orbiter Spacecraft (MMO), also known
   as Mio, including definitions for the MMO fixed and MMO science instrument
   frames. This kernel also contains NAIF ID/name mapping for the MMO science
   instruments and S/C structures (see the last section of the file).


Version and Date
-----------------------------------------------------------------------------

   Version 1.0 -- May 18, 2022 -- Ricardo Valles Blanco, ESAC/ESA
                                  Alfredo Escalante Lopez, ESAC/ESA
                                  Marc Costa Sitja, NAIF/JPL

      Added reference frames, diagrams and body/ID associations for
      PWI, MDM and MGF.

      Fixed typos and formatting for PDS4 Bundle release version 1.0.

      Corrected HEP-ION reference frame relative angles.

   Version 0.9 -- December 21, 2021 -- Go Murakami, ISAS/JAXA
                                       Ricardo Valles Blanco, ESAC/ESA

      Add frame information of MMO_SSAS for MSASI operation simulation.

   Version 0.8 -- May 25, 2021 -- Ricardo Valles Blanco, ESAC/ESA

      Fixed typos in naming of MMO_SPIN_AXIS and MMO_MGF
      frames at spacecraft frames table.

   Version 0.7 -- April 29, 2021 -- Alfredo Escalante Lopez, ESAC/ESA

      Defined reference frames for MPPE MEA, MSA and MIA

   Version 0.6 -- July 7, 2020 -- Alfredo Escalante Lopez, ESAC/ESA
                                  Marc Costa Sitja, ESAC/ESA

      Corrected MPPE reference frames and updated several diagrams and
      descriptions. Added MIO and BEPICOLOMBO MIO as MMO synonyms.

   Version 0.5 -- June 28, 2019 -- Tomoki Kimura, Tohoku University

      Add frame information of MMO_MSASI for MSASI operation simulation.

   Version 0.4 -- November 30, 2018 -- Marc Costa Sitja, ESAC/ESA

      Reordered the IDs to obtain MMO_SPACECRAFT as default name.

   Version 0.3 -- March 12, 2018 -- Marc Costa Sitja, ESAC/ESA

      Updated contact information and set MMO_SPACECRAFT_CRUISE frame
      relative to MPO_SPACECRAFT frame.

   Version 0.2 -- July 17, 2017 -- Marc Costa Sitja, ESAC/ESA

      Added MPO_SPIN_AXIS reference frame to implement the science phase
      nominal attitude.

   Version 0.1 -- March 1, 2017 -- Marc Costa Sitja, ESAC/ESA

      Added basic reference frames in order to incorporate HEP-ELE, ENA and
      MPPE-LEP instrument kernels and to map the MMO reference frames to the
      MCS/MPO Spacecraft.

   Version 0.0 -- February 7, 2017 -- Marc Costa Sitja, ESAC/ESA

      Preliminary Version. Only NAIF IDs for the spacecraft are defined.


References
-----------------------------------------------------------------------------

   1. ``Frames Required Reading'', NAIF.

   2. ``Kernel Pool Required Reading'', NAIF.

   3. ``C-Kernel Required Reading'', NAIF.

   4. ``HEP-e field-of-view analysis (Feasibility study for Venus flyby)'',
      Go Murakami (ISAS/JAXA), 5th September 2016.

   5. ``Scientific objectives and instrumentation of Mercury Plasma
      Particle Experiment(MPPE) onboard MMO'', Y. Saito, J.A. Sauvaud,
      et al., Planetary and Space Science, 2010, Volume 58, Issue 1-2,
      Page 182-200.

   6. ``Request for the 1st Venus flyby: Mio observations'',
      Go Murakami, BepiColombo, Mio Science Working Group, 7th May 2020.

   7. ``Development of the Mercury dust monitor (MDM) onboard the
      BepiColombo mission'', K. Nogami, Planetary and Space Science, 2010,
      Volume 58, Page 108-115.

   8. ``The BepiColombo-Mio Magnetometer en Route to Mercury'', W. Baumjohann,
      Space Science Review, 216, 2020.

   9. ``Plasma Wave Investigation (PWI) Aboard BepiColombo Mio on the Trip
      to the First Measurement of Electric Fields, Electromagnetic Waves,
      and Radio Waves Around Mercury'', Y. Kasaba, Space Science Review,
      216, 2020.

  10. Email communication from Go Murakami at 20th December 2021
      ``CK generation tips for spinner spacecraft'', which includes the updated
      ``bc_mmo_v06_msasi_test.tf''.


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the ESA SPICE
   Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int

   or the SPICE support at Tohoku University:

           Tomoki KIMURA
           (+81) 22-795-6518
           kimura@stpp.gp.tohoku.ac.jp

   or NAIF at JPL:

           Marc Costa Sitja
           (818) 354-4852
           Marc.Costa.Sitja@jpl.nasa.gov


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEYPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


BepiColombo MMO Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the MMO spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "BepiColombo Mission NAIF ID
   Codes -- Definition Section" at the end of this file):

      MMO Spacecraft and Spacecraft Structures names/IDs:

             MMO                          -68  (synonyms: BEPICOLOMBO MMO,
                                                MERCURY MAGNETOSPHERIC
                                                ORBITER, MIO, BEPICOLOMBO MIO)

             MMO_SPACECRAFT            -68000  (synonym: MMO_SC)


BepiColombo MMO Mission Frames
-----------------------------------------------------------------------------

   The following MMO frames are defined in this kernel file:

           Name                  Relative to           Type          NAIF ID
      ======================  =====================  ============   =========

   Spacecraft frames:
   ------------------
      MMO_SPACECRAFT          J2000                  CK                -68000
      MMO_SPACECRAFT_CRUISE   MPO_SPACECRAFT         FIXED             -68001
      MMO_SPIN_AXIS           MMO_SPACECRAFT         CK                -68900

   Science instruments frames:
   ---------------------------
      MMO_MDM                 MMO_SPACECRAFT         FIXED             -68100

      MMO_MGF-I               MMO_SPACECRAFT         FIXED             -68201
      MMO_MGF-O               MMO_SPACECRAFT         FIXED             -68202

      MMO_MPPE_MEA1           MMO_SPACECRAFT         FIXED             -68310
      MMO_MPPE_MEA2           MMO_SPACECRAFT         FIXED             -68320
      MMO_MPPE_HEP-ELE        MMO_SPACECRAFT         FIXED             -68330
      MMO_MPPE_HEP-ION        MMO_SPACECRAFT         FIXED             -68335
      MMO_MPPE_MSA            MMO_SPACECRAFT         FIXED             -68340
      MMO_MPPE_MIA            MMO_SPACECRAFT         FIXED             -68350
      MMO_MPPE_ENA            MMO_SPACECRAFT         FIXED             -68370
      MMO_MPPE-LEP            MMO_SPACECRAFT         FIXED             -68380

      MMO_MSASI               MMO_SPACECRAFT         FIXED             -68400

      MMO_SSAS                MMO_SPACECRAFT         FIXED             -68500

      MMO_PWI_MEF1            MMO_SPACECRAFT         FIXED             -68501
      MMO_PWI_MEF2            MMO_SPACECRAFT         FIXED             -68502
      MMO_PWI_WPT1            MMO_SPACECRAFT         FIXED             -68503
      MMO_PWI_WPT2            MMO_SPACECRAFT         FIXED             -68504
      MMO_PWI_SC_MAST         MMO_SPACECRAFT         FIXED             -68505
      MMO_PWI_SC              MMO_SPACECRAFT         FIXED             -68506

   In addition, the following frames, in use by the BepiColombo mission, are
   defined in other kernels or `built into' the SPICE system:

           Name                  Relative to           Type          NAIF ID
      ======================  =====================  ============   =========

   BepiColombo mission specific science frames (2):
   ------------------------------------------------
      BC_MME_IAU2006_OF_DATE  J2000                  DYNAMIC         -121921
      BC_MME_IAU2006_J2000    J2000                  FIXED           -121922
      BC_MME_IAU2009_OF_DATE  J2000                  DYNAMIC         -121923
      BC_MME_IAU2009_J2000    J2000                  FIXED           -121924


      (2) These frames are defined in the frame kernel file
          "bc_sci_vVV.tf" (VV is the version number)


   SPICE 'Built-in' PCK frames in use by BepiColombo (3):
   ------------------------------------------------------
      IAU_MERCURY             J2000                  PCK            built-in
      IAU_EARTH               J2000                  PCK            built-in
      IAU_VENUS               J2000                  PCK            built-in

      (3) Data for these frames is loaded using either the PCK file
          "pckVVVVV.tpc" (VVVVV is the version number)


BepiColombo MMO Frames Hierarchy
-----------------------------------------------------------------------------

   The diagram below shows the BepiColombo MMO frames hierarchy (except
   for science operations frames):


                               "J2000" INERTIAL
          +-----------------------------------------------+
          |        |       |              |               |
          |<-pck   |<-pck  |<-pck         |               |<-ck
          |        |       |              |               |
          v        |       v              |               v
      "IAU_EARTH"  |   "IAU_MERCURY"      |        "MPO_SPACECRAFT"
      -----------  |   -------------      |        ----------------
                   |                      |               |
                   v                      |               |
              "IAU_VENUS"                 |               |
              -----------                 |               |<-fixed
                                          |               v
                                          |      "MMO_SPACECRAFT_CRUISE"
                                          |      -----------------------
                                          |               |
                                          |<-ck(*)        |<-ck(*)
                                          |               |
                                          v               |
                                    "MMO_SPACECRAFT"      v
                                    +---------------------+
                                          .
                                          .
                                          .
                                          V
                     Individual instrument frame trees are provided
                         in the other sections of this file

   (*)      In these cases transformation is fixed but it has to be
            stored in a CK to make SPICE ``traverse'' appropriate frame
            tree branch based on the time of interest and/or loaded
            kernels.


Implementation of Frame Chains for Different Mission Phases
-----------------------------------------------------------------------------

   Different routes along the branches of the MMO frame hierarchy
   are implemented for different mission phases depending on the
   availability of the orientation data and the source, format and type
   of the data.

   This subsection summarizes mission phase specific implementations.


Cruise
------

     "J2000" Inertial
     ----------------
            |
            | <----------- CK segment containing TLM quaternions, AEM data or
            |              test attitude generated by the BepiColombo SGS
            v              and the ESA SPICE Service.
     "MPO_SPACECRAFT"
     ----------------
            |
            | <----------- Fixed rotation based on frame definitions.
            |
            V
   "MMO_SPACECRAFT_CRUISE"
   -----------------------
            |
            | <----------- CK segment representing fixed rotation defined
            |              by the MMO design and to make SPICE "transverse"
            V              to the appropriate frame chain.
     "MMO_SPACECRAFT"
     ----------------


Science Phase
-------------

     "J2000" Inertial
     ----------------
            |
            | <----------- CK segment containing TLM quaternions, AEM data or
            |              test attitude generated by the BepiColombo MMO SGS
            |              and the ESA SPICE Service.
            V
     "MMO_SPACECRAFT"
     ----------------


MMO Spacecraft and Spacecraft Structures Frames
-----------------------------------------------------------------------------

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.

   DISCLAIMER: The origin of the frames specified in the following
   definitions are not implemented. The ``true'' origin of all frames
   is in the center of the MMO_SPACECRAFT frame, the center of which
   is defined by the position given by the SPK (ephemeris) kernel in
   use.


MMO Spacecraft Bus Frame
-----------------------------------------------------------------------------

   The MMO spacecraft frame -- MMO_SPACECRAFT -- is defined by the S/C
   design as follows (from [4]):

      -  +Z axis is perpendicular to the MPO-MOSIF separation plane
         and points to the HGA in deployed configuration;

      -  +X axis is parallel to the MPO-MOSIF separation plane and points to
         WPT-S1 antenna;

      -  +Y axis completes the right-handed frame and is parallel to the
         MEFISTO antennas;

      -  the origin of this frame is the Mercury Transfer Module/MPO interface
         point on the separation plane.


   These diagram(s) illustrate the MMO_SPACECRAFT frame:

   +Z S/C side (HGA) view:
   -----------------------
                                             _ HEP-ele
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'            +Ysc  |_|      '.
                     '.'               ^               '.
                     .'                |                 '.
                    .                  |                   .
              ENA __|              , - | - ,               |
                 |  |            /     |     \             |
                 '--|           `,     |+Zsc  ,            |    +Zsc is
                    |           ,  ` , o------------>      |     out of the
                    |           |   /  '/,    ,  +Xsc      |     page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   -Y S/C side view:
   -----------------

                                   , - - - ,
                                 / \       / \
                                .   \     /   .
                                |    \ _ /    |
                                .     | |     ,
                                 \    | |    /
                                   ' ----- '
                                      | |
                                  ____| |_____
                     _____________\__________|_____________
                    |////|///||////////|/////////||///|////|     +Ysc is
                    |----|---||--------|---------||---|----|      into the
                    |////|///||////////|/////////||///|////|      page.
                    |----|---||--------|---------||---|----|
                    |////|///||////////|/////////||///|////|
                    |----|---||--------|---------||---|----|
                    |////|///||////////|/////////||///|////|
                    |----|---|---------|----------|---|----| Upper Deck
                    |        ||       +Zsc       ||        |
               ENA _|        ||         ^        ||  ,--.  |
                  |_|        ||        _|        ||  |  |  |
                    |        ||       |_||       ||  |__|  |
                    |________||_________|________||________| Lower Deck
                                        x------------>+Xsc
                                       +Ysc


   Since the S/C bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

   \begindata

      FRAME_MMO_SPACECRAFT          = -68000
      FRAME_-68000_NAME             = 'MMO_SPACECRAFT'
      FRAME_-68000_CLASS            =  3
      FRAME_-68000_CLASS_ID         = -68000
      FRAME_-68000_CENTER           = -68
      CK_-68000_SCLK                = -68
      CK_-68000_SPK                 = -68

   \begintext


MMO Spacecraft Cruise Frame
----------------------------------------------------------------------------

   The MMO Spacecraft Cruise frame -- MMO_SPACECRAFT_CRUISE -- is a special
   frame used in cruise in order to "attach" the MMO spacecraft to the MPO
   during the cruise phase, it is defined as follows (from [4]):

      -  +Z axis is perpendicular to the MPO-MOSIF separation plane
         and is anti-parallel to the MPO S/C +Z axis;

      -  +X axis is parallel to the MPO-MOSIF separation plane and points to
         WPT-S1 antenna; it is rotated -30 degrees with respect to the MPO
         +X axis around the +Z axis

      -  +Y axis completes the right-handed frame;

      -  the origin of this frame is the MMO/MPO interface point on the
         separation plane.


   This frame is defined a fixed-offset frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_SPACECRAFT_CRUISE     = -68001
      FRAME_-68001_NAME               = 'MMO_SPACECRAFT_CRUISE'
      FRAME_-68001_CLASS              =  4
      FRAME_-68001_CLASS_ID           = -68001
      FRAME_-68001_CENTER             = -68
      TKFRAME_-68001_RELATIVE         = 'MPO_SPACECRAFT'
      TKFRAME_-68001_SPEC             = 'ANGLES'
      TKFRAME_-68001_UNITS            = 'DEGREES'
      TKFRAME_-68001_AXES             = (    1,     3,       1  )
      TKFRAME_-68001_ANGLES           = (  0.0, -30.0,    180.0  )

   \begintext


MMO Spin Axis Frame
----------------------------------------------------------------------------

   The MMO Spin Axis frame -- MMO_SPIN_AXIS -- is a special frame used in
   the science phase default orientation CK files. In these files the
   MMO_SPACECRAFT frame orientation is not stored relative to the J2000
   frame. Instead it is ``decomposed'' into two orientations: the nominal spin
   axis orientation captured in the segments providing the orientation of
   the MMO_SPIN_AXIS frame relative to the J2000 frame and the nominal
   rotation about the spin axis captured in the segments providing the
   orientation of the MMO_SPACECRAFT frame relative to the MMO_SPIN_AXIS
   frame.

   The MMO Spin Axis frame -- MMO_SPIN_AXIS -- is defined as follows:

      -  +Z axis is nominally co-aligned with the IAU_MERCURY +Z axis;

      -  +X axis is parallel to the MMO orbital velocity;

      -  +Y axis completes the right-handed frame;

      -  the origin of this frame is the Mercury Transfer Module/MPO interface
         point on the separation plane.

   MMO_SPIN_AXIS is defined as a CK-based frame.

   \begindata

      FRAME_MMO_SPIN_AXIS          = -68900
      FRAME_-68900_NAME            = 'MMO_SPIN_AXIS'
      FRAME_-68900_CLASS           =  3
      FRAME_-68900_CLASS_ID        = -68900
      FRAME_-68900_CENTER          = -68
      CK_-68900_SCLK               = -68
      CK_-68900_SPK                = -68

   \begintext


MDM (Mercury Dust Monitor) Frames:
-----------------------------------------------------------------------------

   This section of the file contains the definitions for the Mercury Dust
   Monitor instrument [7].


MDM Frame Tree:
~~~~~~~~~~~~~~~

   The diagram below shows the MDM frame hierarchy.


                         "J2000" INERTIAL
                         ----------------
                                |
                                |<-ck
                                |
                                V
                         "MMO_SPACECRAFT"
                         ----------------
                                |
                                |<-fixed
                                |
                                V
                            "MMO_MDM"
                            ---------


MDM Frame:
~~~~~~~~~~~~

   The MDM frame -- MMO_MDM -- is defined as a fixed offset with respect to the
   MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally anti-parallel with the +Ysc axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the geometrical center of the
         detector.


   This diagram illustrates the MDM frame:

   +Z S/C side (HGA) view:
   -----------------------

                                             _
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'             +Ysc |_|      '.
                     '.'               ^               '.
                     /                 |                 '.
                    .                  |                   .
                  __|                  |                   |
                 |  |                  | +Zsc              |
                 '--|                  o------------>      |
                    |                             +Xsc     |
                    |                                      |
                    |                                      |
                    .                                     /
                     '.                                  /
                       '.                              .' '.  +Ymdm and +Zsc
                         '.  +Ymdm                   .', ,'   are out of the
                           '.   o------> +Xmdm     .'   '     page.
                             '--|-----------------'
                                |
                                V
                             +Zmdm


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MDM                   = -68100
      FRAME_-68100_NAME               = 'MMO_MDM'
      FRAME_-68100_CLASS              =  4
      FRAME_-68100_CLASS_ID           = -68100
      FRAME_-68100_CENTER             = -68100
      TKFRAME_-68100_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68100_SPEC             = 'ANGLES'
      TKFRAME_-68100_UNITS            = 'DEGREES'
      TKFRAME_-68100_ANGLES           = ( -90.0,  0.0, 0.0  )
      TKFRAME_-68100_AXES             = (   1,    2,   3    )

   \begintext


MGF (MMO Fluxgate Magnetometer) Frames:
-----------------------------------------------------------------------------

   This section of the file contains the definitions for the MMO Fluxgate
   magnetometer instrument [8].


MGF Frame Tree:
~~~~~~~~~~~~~~~

   The diagram below shows the MGF frame hierarchy.


                         "J2000" INERTIAL
                          ---------------
                                |
                                |<-ck
                                |
                                V
                         "MMO_SPACECRAFT"
              +----------------------------------+
              |                                  |
              |<-fixed                           |<-fixed
              |                                  |
              V                                  V
        "MMO_MGF-I"                         "MMO_MGF-O"
        -----------                         -----------


MGF Frames:
~~~~~~~~~~~

   The MGF frames -- MMO_MGF-I -- and -- MMO_MGF-O -- are defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned with the +Zsc axis;

      -  +Y axis is nominally rotated 45 degrees around the +Zsc axis; and
         co-aligned with the boom such that this axis points from the inboard
         magnetometer sensor towards the outboard magnetometer.

      -  +X axis completes the right hand frame;

      -  the origin of these frames are located at the geometrical center of
         the each detector.


   This diagram illustrates the MGF frames:

   +Z S/C side (HGA) view:
   -----------------------

                +Ymgf-o
                    ^           .> +Xmgf-o
                     '.+Ymgf-i.'
                       '^   .'      .> +Xmgf-i
                         'o'.     .'
                         '.'.'. .'
                           '.'o'.
                             '.  '.       +Ysc
                               '.  '.       ^
                                 '.  '._.---|---._
                                   '..'     |     '.
                                    |       |       |
                                    |       o--------> +Xsc
        +Zmgf-i, +Zmgf-o            |     +Zsc      |
        and +Zsc are out             '.            .'
        of the page.                   '._______..' '.
                                                  '.  '.
                                                    '.  '.
                                                      '.  '.


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MGF-I                 = -68201
      FRAME_-68201_NAME               = 'MMO_MGF-I'
      FRAME_-68201_CLASS              =  4
      FRAME_-68201_CLASS_ID           = -68201
      FRAME_-68201_CENTER             = -68201
      TKFRAME_-68201_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68201_SPEC             = 'ANGLES'
      TKFRAME_-68201_UNITS            = 'DEGREES'
      TKFRAME_-68201_ANGLES           = ( 0.0,  0.0, -45.0  )
      TKFRAME_-68201_AXES             = ( 1,    2,    3     )

      FRAME_MMO_MGF-O                 = -68202
      FRAME_-68202_NAME               = 'MMO_MGF-O'
      FRAME_-68202_CLASS              =  4
      FRAME_-68202_CLASS_ID           = -68202
      FRAME_-68202_CENTER             = -68202
      TKFRAME_-68202_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68202_SPEC             = 'ANGLES'
      TKFRAME_-68202_UNITS            = 'DEGREES'
      TKFRAME_-68202_ANGLES           = ( 0.0,  0.0, -45.0  )
      TKFRAME_-68202_AXES             = ( 1,    2,    3     )

   \begintext


MPPE (Mercury Plasma Particle Experiment) Frames:
-----------------------------------------------------------------------------

   This section of the file contains the definitions for the Mercury Plasma
   Particle Experiment (MPPE) instrument package.


MPPE Frame Tree:
~~~~~~~~~~~~~~~~

   The diagram below shows the MPPE frame hierarchy.

                       "J2000" INERTIAL
                       ----------------
                               |
                               |<-ck
                               |
                               V
                       "MMO_SPACECRAFT"
        +------------------------------------------------------+
        |          |          |          |          |          |
        |<-fixed   |<-fixed   |<-fixed   |<-fixed   |<-fixed   |<-fixed
        |          |          |          |          |          |
        V          |          V          |          V          |
   MMO_MPPE_MEA    |     MMO_MPPE_MSA    |     MMO_MPPE_ENA    |
   ------------    |     ------------    |     ------------    |
                   V                     V                     V
            MMO_MPPE_HEP-ELE        MMO_MPPE_MIA        MMO_MPPE_HEP-ION
            ----------------        ------------        ----------------


MEA Frames:
~~~~~~~~~~~

   The MEA1 frame -- MMO_MPPE_MEA1 -- is defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally rotated -157.5 degrees around the +Zsc axis from
         the -Ysc axis to -Xsc axis;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   The MEA2 frame -- MMO_MPPE_MEA2 -- is defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally rotated -67.5 degrees around the +Zsc axis from
         the -Ysc axis to -Xsc axis;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   These diagram(s) illustrate the MEA1 and MEA2 frames:

   +Z S/C side (HGA) view:
   -----------------------

                          ^ +Zmea1
                           \
                           _\.                _
                           \.\\--------------| |--.
                      ,', .'\_o+Ymea1        | |   '.
                    .'  .'   /               |_|     '.
                     '.'    /                          '.
                     .'    /           ^+Ysc             '.
                    .     V            |                   .
                  __|  +Xmea1      , - | - ,               |
                 |  |            /     |     \             |
                 '--|           `,     |+Zsc  ,            |    +Zsc, +Ymea1
                    |           ,  ` , o------------>      |     and +Ymea2
                    |+Ymea2     |   /  '/,    ,  +Xsc      |     are out of
                  .-__-o\       |\ /  ,'   ` /             |     the page.
         +Zmea2 <--'_.-'\       | /'/----- '              /
                     '.  \      |/,'                     .
                       '. \                            .' '.
                         '.V                         .', ,'
                       +Xmea2.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_MEA1             = -68310
      FRAME_-68310_NAME               = 'MMO_MPPE_MEA1'
      FRAME_-68310_CLASS              =  4
      FRAME_-68310_CLASS_ID           = -68310
      FRAME_-68310_CENTER             = -68310
      TKFRAME_-68310_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68310_SPEC             = 'ANGLES'
      TKFRAME_-68310_UNITS            = 'DEGREES'
      TKFRAME_-68310_ANGLES           = ( 157.5,  0.0,  -90.0 )
      TKFRAME_-68310_AXES             = (   3,    2,      1   )

      FRAME_MMO_MPPE_MEA2             = -68320
      FRAME_-68320_NAME               = 'MMO_MPPE_MEA2'
      FRAME_-68320_CLASS              =  4
      FRAME_-68320_CLASS_ID           = -68320
      FRAME_-68320_CENTER             = -68320
      TKFRAME_-68320_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68320_SPEC             = 'ANGLES'
      TKFRAME_-68320_UNITS            = 'DEGREES'
      TKFRAME_-68320_ANGLES           = (  67.5,  0.0,  -90.0 )
      TKFRAME_-68320_AXES             = (   3,    2,      1   )

   \begintext


HEP-ELE Frame:
~~~~~~~~~~~~~~

   The HEP-ELE frame -- MMO_MPPE_HEP-ELE -- is defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally co-aligned with the +Ysc axis;

      -  +X axis completes the right hand frame and is nominally anti-parallel
         to the +Xsc axis;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   These diagram(s) illustrate the HEP-ELE frame:

   +Z S/C side (HGA) view:
   -----------------------
                                            +Zele
                                              ^
                                              |
                                              | HEP-ele
                            .----------------|||--.
                      ,', .'    +Xele <------|o|+Yele
                    .'  .'                   |_|     '.
                     '.'                               '.
                     .'                ^+Ysc             '.
                    .                  |                   .
                  __|              , - | - ,               |
                 |  |            /     |     \             |
                 '--|           `,     |+Zsc  ,            |    +Zsc, +Yele
                    |           ,  ` , o------------>      |     are out of
                    |           |   /  '/,    ,  +Xsc      |     the page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_HEP-ELE          = -68330
      FRAME_-68330_NAME               = 'MMO_MPPE_HEP-ELE'
      FRAME_-68330_CLASS              =  4
      FRAME_-68330_CLASS_ID           = -68330
      FRAME_-68330_CENTER             = -68330
      TKFRAME_-68330_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68330_SPEC             = 'ANGLES'
      TKFRAME_-68330_UNITS            = 'DEGREES'
      TKFRAME_-68330_ANGLES           = (   0.0, 180.0,  90.0 )
      TKFRAME_-68330_AXES             = (   3,    2,      1   )

   \begintext


HEP-ION Frame:
~~~~~~~~~~~~~~

   The HEP-ION frame -- MMO_MPPE_HEP-ION -- is defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally rotated 300 degrees around the +Zsc axis from
         the +Ysc axis to the +Xsc;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   These diagram(s) illustrate the HEP-ION frame:

   +Z S/C side (HGA) view:
   -----------------------


                                              _
                            .----------------| |--.
                      ,', .'                 | |   +Yion _.-> + Xion
                    .'  .'                   |_| .-'  'o'
                     '.'                          '..-' .\
                     .'                ^+Ysc             '.\
                    .                  |                   . v + Zion
                  __|              , - | - ,               |
                 |  |            /     |     \             |
                 '--|           `,     |+Zsc  ,            |    +Zsc, +Yion
                    |           ,  ` , o------------>      |     are out of
                    |           |   /  '/,    ,  +Xsc      |     the page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_HEP-ION          = -68335
      FRAME_-68335_NAME               = 'MMO_MPPE_HEP-ION'
      FRAME_-68335_CLASS              =  4
      FRAME_-68335_CLASS_ID           = -68335
      FRAME_-68335_CENTER             = -68335
      TKFRAME_-68335_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68335_SPEC             = 'ANGLES'
      TKFRAME_-68335_UNITS            = 'DEGREES'
      TKFRAME_-68335_ANGLES           = ( 300.0,  0.0,  -90.0 )
      TKFRAME_-68335_AXES             = (   3,    2,      1   )

   \begintext


MSA Frame:
~~~~~~~~~~

   The MSA frame -- MMO_MPPE_MSA -- is defined as a fixed offset with respect
   to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally rotated 22.5 degrees around the +Zsc axis from
         the -Ysc axis to +Xsc axis;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   This diagram illustrates the MSA frame:

   +Z S/C side (HGA) view:
   -----------------------
                                             _
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'            +Ysc  |_|      '.
                     '.'               ^               '.
                     .'                |                 '.
                    .                  |                   .
                    |              , - | - ,               |
                    |            /     |     \             |
                    |           `,     |+Zsc  ,            |    +Zsc, +Ymsa
                    |           ,  ` , o------------>      |     are out of
                    |           |   /  '/,    ,  +Xsc      |     the page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', __-> +Xmsa
                           '.                +Ymsa'\'_--'
                             '------------------\ o'\
                                                 \.\'
                                                    \
                                                     V
                                                   +Zmsa


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_MSA              = -68340
      FRAME_-68340_NAME               = 'MMO_MPPE_MSA'
      FRAME_-68340_CLASS              =  4
      FRAME_-68340_CLASS_ID           = -68340
      FRAME_-68340_CENTER             = -68340
      TKFRAME_-68340_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68340_SPEC             = 'ANGLES'
      TKFRAME_-68340_UNITS            = 'DEGREES'
      TKFRAME_-68340_ANGLES           = ( -22.5,  0.0,  -90.0 )
      TKFRAME_-68340_AXES             = (   3,    2,      1   )

   \begintext


MIA Frame:
~~~~~~~~~~

   The MIA frame -- MMO_MPPE_MIA -- is defined as a fixed offset with respect
   to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally rotated -247.5 degrees around the +Zsc axis from
         the -Ysc axis to -Xsc axis;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   This diagram illustrates the MIA frame:

   +Z S/C side (HGA) view:
   -----------------------
                                              _
                            .----------------| |--.   +Xmia
                      ,', .'                 | |   '.   ^
                    .'  .'                   |_|     '.  \
                     '.'                               '. \
                     .'                ^+Ysc             '.\    __--> +Zmia
                    .                  |                 .-'o--'
                  __|              , - | - ,            '._+Ymia
                 |  |            /     |     \             |
                 '--|           `,     |+Zsc  ,            |    +Zsc, +Ymia
                    |           ,  ` , o------------>      |     are out of
                    |           |   /  '/,    ,  +Xsc      |     the page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_MIA              = -68350
      FRAME_-68350_NAME               = 'MMO_MPPE_MIA'
      FRAME_-68350_CLASS              =  4
      FRAME_-68350_CLASS_ID           = -68350
      FRAME_-68350_CENTER             = -68350
      TKFRAME_-68350_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68350_SPEC             = 'ANGLES'
      TKFRAME_-68350_UNITS            = 'DEGREES'
      TKFRAME_-68350_ANGLES           = ( 247.5,  0.0,  -90.0 )
      TKFRAME_-68350_AXES             = (   3,    2,      1   )

   \begintext


ENA Frame:
~~~~~~~~~~

   The ENA frame -- MMO_MPPE_ENA -- is defined as a fixed offset with respect
   to the MMO_SPACECRAFT frame as follows:

      -  +Y axis is nominally co-aligned with the +Zsc axis;

      -  +Z axis is nominally anti-parallel to the +Xsc axis;

      -  +X axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   This diagram illustrates the ENA frame:

   +Z S/C side (HGA) view:
   -----------------------
                                             _
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'            +Ysc  |_|      '.
                     '.'               ^               '.
                     .'                |                 '.
                    .                  |                   .
              ENA __|              , - | - ,               |
      +Zena <------o +Yena       /     |     \             |
                 '-||           `,     |+Zsc  ,            |    +Zsc, +Yena
                   ||           ,  ` , o------------>      |     are out of
                   V|           |   /  '/,    ,  +Xsc      |     the page.
                 +Xena          |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE_ENA              = -68370
      FRAME_-68370_NAME               = 'MMO_MPPE_ENA'
      FRAME_-68370_CLASS              =  4
      FRAME_-68370_CLASS_ID           = -68370
      FRAME_-68370_CENTER             = -68370
      TKFRAME_-68370_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68370_SPEC             = 'ANGLES'
      TKFRAME_-68370_UNITS            = 'DEGREES'
      TKFRAME_-68370_ANGLES           = ( -90.0, 90.0, 0.0 )
      TKFRAME_-68370_AXES             = (   1,     2,   3   )

   \begintext


LEP Frame:
~~~~~~~~~~

   The LEP frame -- MMO_MPPE-LEP -- is nominally co-aligned with the
   MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X is nominally co-aligned to the +Xsc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is the Mercury Transfer Module/MPO interface
         point on the separation plane.


   This diagram illustrates the LEP frame:

   +Z S/C side (HGA) view:
   -----------------------
                                              _
                             .---------------| |--.
                      ,', .'                 | |   '.
                    .'  .'            +Ysc   |_|     '.
                     '.'               ^               '.
                     /                 |                 '.
                    .                  |^ +Ylep            .
                  __|              , - ||- ,               |
                 |  |            /     ||    \             |
                 '--|           `, +Zsc|o------> +Xlep     |    +Zsc, +Zlep
                    |           ,  ` , o------------>      |     are out of
                    |           |   /  '/,    ,  +Xsc      |     the page.
                    |           |\ /  ,'   ` /             |
                    .           | /'/----- '              /
                     '.         |/,'                     .
                       '.                              .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MPPE-LEP              = -68380
      FRAME_-68380_NAME               = 'MMO_MPPE-LEP'
      FRAME_-68380_CLASS              =  4
      FRAME_-68380_CLASS_ID           = -68380
      FRAME_-68380_CENTER             = -68
      TKFRAME_-68380_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68380_SPEC             = 'ANGLES'
      TKFRAME_-68380_UNITS            = 'DEGREES'
      TKFRAME_-68380_ANGLES           = ( 0.0, 0.0, 0.0 )
      TKFRAME_-68380_AXES             = ( 1,    2,   3   )

   \begintext


MSASI (Mercury Sodium Atmosphere Spectral Imager) Frames:
-----------------------------------------------------------------------------

   This section of the file contains the definitions for the Mercury Sodium
   Atmosphere Spectral Imager instrument.


MSASI Frame Tree:
~~~~~~~~~~~~~~~~~

   The diagram below shows the MSASI frame hierarchy.


                         "J2000" INERTIAL
                          ---------------
                                |
                                |<-ck
                                |
                                V
                         "MMO_SPACECRAFT"
                         ----------------
                                |
                                |<-fixed
                                |
                                V
                           "MMO_MSASI"
                           -----------


MSASI Frame:
~~~~~~~~~~~~

   The MSASI frame -- MMO_MSASI -- is defined as a fixed offset with respect
   to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned with the +Zsc axis;

      -  +X axis is rotated -337.5 degrees around the +Zsc axis from
         the +Xsc axis to -Ysc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   This diagram illustrates the MSASI frame:

   +Z S/C side (HGA) view:
   -----------------------

                                             _
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'             +Ysc |_|      '.
                     '.'               ^               '.
                     /                 |                 '.
                    .                  |                   .
                  __|                  |                   |
                 |  |                  | +Zsc              |
                 '--|                  o------------>      |
                    |  +Ymsasi         >           +Xsc    |
                    |    ^.          .' +Xmsasi            |
                    |      '.      .'                      |
                    .        '.  .' '. 22.5 deg           /
                     '.        o----------               .
                       '.    +Zmsasi                   .' '.  +Zmsasi and +Zsc
                         '.                          .', ,'   are out of the
                           '.                      .'   '     page.
                             '--------------------'


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_MSASI                 = -68400
      FRAME_-68400_NAME               = 'MMO_MSASI'
      FRAME_-68400_CLASS              =  4
      FRAME_-68400_CLASS_ID           = -68400
      FRAME_-68400_CENTER             = -68400
      TKFRAME_-68400_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68400_SPEC             = 'ANGLES'
      TKFRAME_-68400_UNITS            = 'DEGREES'
      TKFRAME_-68400_ANGLES           = ( 0.0,  0.0, 337.5 )
      TKFRAME_-68400_AXES             = ( 1,    2,   3     )

   \begintext


SSAS (Spin type Sun Aspect Sensor) Frames:
--------------------------------------------------------

   This section of the file contains the definitions for the Spin type Sun
   Aspect Sensor instrument.


SSAS Frame Tree:
~~~~~~~~~~~~~~~~

    The diagram below shows the SSAS frame hierarchy.


                         "J2000" INERTIAL
                          ---------------
                                |
                                |<-ck
                                |
                                V
                         "MMO_SPACECRAFT"
                         ----------------
                                |
                                |<-fixed
                                |
                                V
                            "MMO_SSAS"
                            ----------


SSAS frame:
~~~~~~~~~~~

   The Spin type Sun Aspect Sensor frame -- MMO_SSAS -- is defined as a fixed
   offset with respect to the MMO_SPACECRAFT frame as follows (from [10]):

      -  +Y axis is quasi-parallel to the +Zsc axis;

      -  +X axis is rotated approximately -45 degrees around the +Zsc axis
         from the +Xsc axis to -Ysc axis;

      -  +Z axis completes the right handed frame.

      -  the origin of this frame is the Mercury Transfer Module/MPO interface
         point on the separation plane.


   These diagram(s) illustrate the SSAS frame:

   +Z S/C side (HGA) view:
   -----------------------

                                             _
                             .--------------| |---.
                      ,', .'                | |    '.
                    .'  .'             +Ysc |_|      '.
                     '.'               ^               '.
                     /                 |                 '.
                    .                  |                   .
                  __|                  |                   |
                 |  |                / |+Zsc,~+Yssas       |
                 '--|      134.895deg\ o------------> +Xsc |
                    |                .'_.'135.105deg       |
                    |              .'    '.                |
                    |            .' '.__.' '.              |
                    .         <    90.0deg   '.            /
                     '.     +Zssas             >         .'
                       '.                     +Xssas   .' '.
                         '.                          .', ,'
                           '.                      .'   '
                             '--------------------'

                                                       +Zsc is out of the
                                                        page.


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_SSAS                  = -68500
      FRAME_-68500_NAME               = 'MMO_SSAS'
      FRAME_-68500_CLASS              =  4
      FRAME_-68500_CLASS_ID           = -68500
      FRAME_-68500_CENTER             = -68
      TKFRAME_-68500_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68500_SPEC             = 'ANGLES'
      TKFRAME_-68500_UNITS            = 'DEGREES'
      TKFRAME_-68500_ANGLES           = ( 269.8762,  45.105, 0.0 )
      TKFRAME_-68500_AXES             = (   1,        2,     3   )

   \begintext


PWI (Plasma Wave Investigation) Frames:
-----------------------------------------------------------------------------

   This section of the file contains the definitions for the MMO Plasma
   Wave Investigation instrument [9].


PWI Frame Tree:
~~~~~~~~~~~~~~~

   The diagram below shows the PWI frame hierarchy.


                                 "J2000" INERTIAL
                                  ---------------
                                        |
                                        |<-ck
                                        |
                                        V
                                 "MMO_SPACECRAFT"
           +---------------------------------------------------------+
           |           |           |          |           |          |
           |<-fixed    |<-fixed    |<-fixed   |<-fixed    |<-fixed   |<-fixed
           |           |           |          |           |          |
           V           |           V          |           V          |
    "MMO_PWI_MEF1"     |     "MMO_PWI_WPT1"   |   "MMO_PWI_SC_MAST"  |
    --------------     |     --------------   |   -----------------  |
                       V                      V                      V
                 "MMO_PWI_MEF2"         "MMO_PWI_WPT2"          "MMO_PWI_SC"
                 --------------         --------------          ------------


PWI Frames:
~~~~~~~~~~~

   The PWI_MEF1 and PWI_SC frames -- MMO_PWI_MEF1 -- and -- MMO_PWI_SC-- are
   defined as a fixed offset with respect to the MMO_SPACECRAFT frame as
   follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X axis is nominally co-aligned to the +Xsc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   The PWI_MEF2 frame -- MMO_PWI_MEF2 -- is defined as a fixed offset with
   respect to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X axis is rotated 180 degrees degrees around the +Zsc axis
         from the +Xsc axis to +Ysc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   The PWI_WPT1 frame -- MMO_PWI_WPT1 -- is defined as a fixed offset with
   respect to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X axis is rotated -90 degrees around the +Zsc axis
         from the +Xsc axis to -Ysc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   The PWI_WPT2 frame -- MMO_PWI_WPT2 -- is defined as a fixed offset with
   respect to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X axis is rotated 90 degrees around the +Zsc axis
         from the +Xsc axis to +Ysc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometrical center of
         the detector.


   The PWI_SC_MAST frame -- MMO_PWI_SC_MAST -- is defined as a fixed offset
   with respect to the MMO_SPACECRAFT frame as follows:

      -  +Z axis is nominally co-aligned to the +Zsc axis;

      -  +X axis is rotated -135 degrees around the +Zsc axis
         from the +Xsc axis to -Ysc axis;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is the Mercury Transfer Module/MPO interface
         point on the separation plane.


   This diagram illustrates the PWI frames:

   +Z S/C side (HGA) view:
   -----------------------
                                           ~~~
                                            |
                                            |
                    +Zpwi_sc                |
          +Xpwi_sc <----o .            +Ypwi_mef2
                       '|  '.               ^
                        |'.  '.             |.>+Xpwi_mast
                        V  +Ypwi_mast       '
                    +Ypwi_sc '. ^'        .'|
                              +Xpwi_wpt1.'  o---->+Xpwi_mef2
                                 '.^.'.'.-------._
          \                        |.o            '.                      \
          /                        ||     +Zsc      |                     /
          \------------------<-----o|  <----o       |o----->--------------\
          /             +Ypwi_wpt1  |+Xsc   |       ||   +Ypwi_wpt2       /
          \                          '.     V +Ysc .'|                    \
                                       '._______..' 'V
                             +Xpwi_mef1<----o     +Xpwi_wpt2
    +Zpwi_wpt1, +Zpwi_wpt2,                 |       '.  '.
    +Zpwi_mef1, +Zpwi_mef2,                 |         '.  '.
    +Zpwi_sc, +Zpwi_sc_mast,                V           '.  '.
    and +Zsc are out of the page.       +Ypwi_mef1        '.  '.
                                            |               '.  '.
                                           ~~~              ~~~~~~~~


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_MMO_PWI_MEF1              = -68501
      FRAME_-68501_NAME               = 'MMO_PWI_MEF1'
      FRAME_-68501_CLASS              =  4
      FRAME_-68501_CLASS_ID           = -68501
      FRAME_-68501_CENTER             = -68501
      TKFRAME_-68501_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68501_SPEC             = 'ANGLES'
      TKFRAME_-68501_UNITS            = 'DEGREES'
      TKFRAME_-68501_ANGLES           = ( 0.0,  0.0,  0.0   )
      TKFRAME_-68501_AXES             = ( 1,    2,    3     )

      FRAME_MMO_PWI_MEF2              = -68502
      FRAME_-68502_NAME               = 'MMO_PWI_MEF2'
      FRAME_-68502_CLASS              =  4
      FRAME_-68502_CLASS_ID           = -68502
      FRAME_-68502_CENTER             = -68502
      TKFRAME_-68502_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68502_SPEC             = 'ANGLES'
      TKFRAME_-68502_UNITS            = 'DEGREES'
      TKFRAME_-68502_ANGLES           = ( 0.0,  0.0,  180.0   )
      TKFRAME_-68502_AXES             = ( 1,    2,      3     )

      FRAME_MMO_PWI_WPT1              = -68503
      FRAME_-68503_NAME               = 'MMO_PWI_WPT1'
      FRAME_-68503_CLASS              =  4
      FRAME_-68503_CLASS_ID           = -68503
      FRAME_-68503_CENTER             = -68503
      TKFRAME_-68503_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68503_SPEC             = 'ANGLES'
      TKFRAME_-68503_UNITS            = 'DEGREES'
      TKFRAME_-68503_ANGLES           = ( 0.0,  0.0,   90.0   )
      TKFRAME_-68503_AXES             = ( 1,    2,      3     )

      FRAME_MMO_PWI_WPT2              = -68504
      FRAME_-68504_NAME               = 'MMO_PWI_WPT2'
      FRAME_-68504_CLASS              =  4
      FRAME_-68504_CLASS_ID           = -68504
      FRAME_-68504_CENTER             = -68504
      TKFRAME_-68504_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68504_SPEC             = 'ANGLES'
      TKFRAME_-68504_UNITS            = 'DEGREES'
      TKFRAME_-68504_ANGLES           = ( 0.0,  0.0,  -90.0   )
      TKFRAME_-68504_AXES             = ( 1,    2,      3     )

      FRAME_MMO_PWI_SC_MAST           = -68505
      FRAME_-68505_NAME               = 'MMO_PWI_SC_MAST'
      FRAME_-68505_CLASS              =  4
      FRAME_-68505_CLASS_ID           = -68505
      FRAME_-68505_CENTER             = -68
      TKFRAME_-68505_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68505_SPEC             = 'ANGLES'
      TKFRAME_-68505_UNITS            = 'DEGREES'
      TKFRAME_-68505_ANGLES           = ( 0.0,  0.0,   135.0   )
      TKFRAME_-68505_AXES             = ( 1,    2,       3     )

      FRAME_MMO_PWI_SC                = -68506
      FRAME_-68506_NAME               = 'MMO_PWI_SC'
      FRAME_-68506_CLASS              =  4
      FRAME_-68506_CLASS_ID           = -68506
      FRAME_-68506_CENTER             = -68506
      TKFRAME_-68506_RELATIVE         = 'MMO_SPACECRAFT'
      TKFRAME_-68506_SPEC             = 'ANGLES'
      TKFRAME_-68506_UNITS            = 'DEGREES'
      TKFRAME_-68506_ANGLES           = ( 0.0,  0.0,    0.0   )
      TKFRAME_-68506_AXES             = ( 1,    2,      3     )

   \begintext


BepiColombo MMO NAIF ID Codes to Name Mapping
-----------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the BepiColombo MMO
   mission. Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

   Spacecraft:
   ----------------------------------------------------------------

      This table presents the BepiColombo Spacecraft and its main
      structures' names and

      ---------------------   -------  --------------------------
       Name                    ID       Synonyms
      ---------------------   -------  --------------------------
       MMO                        -68   BEPICOLOMBO MMO,
                                        MERCURY MAGNETOSPHERIC
                                        ORBITER, MIO, BEPICOLOMBO
                                        MIO
       MMO_SPACECRAFT          -68000   MMO_SC
      ----------------------  -------  --------------------------

      Notes:

         -- 'MMO', 'BEPICOLOMBO MMO', 'MERCURY MAGNETOSPHERIC ORBITER',
            'MIO', and 'BEPICOLOMBO MIO' are synonyms and all map to the
            BepiColombo MMO spacecraft ID (-68);

         -- 'MMO_SC' and 'MMO_SPACECRAFT' are synonyms and all map to the
            BepiColombo MMO S/C bus structure ID (-68000);

   \begindata

      NAIF_BODY_NAME += ( 'BEPICOLOMBO MMO'                 )
      NAIF_BODY_CODE += ( -68                               )

      NAIF_BODY_NAME += ( 'MIO'                             )
      NAIF_BODY_CODE += ( -68                               )

      NAIF_BODY_NAME += ( 'BEPICOLOMBO MIO'                 )
      NAIF_BODY_CODE += ( -68                               )

      NAIF_BODY_NAME += ( 'MERCURY MAGNETOSPHERIC ORBITER'  )
      NAIF_BODY_CODE += ( -68                               )

      NAIF_BODY_NAME += ( 'MMO'                             )
      NAIF_BODY_CODE += ( -68                               )

      NAIF_BODY_NAME += ( 'MMO_SC'                          )
      NAIF_BODY_CODE += ( -68000                            )

      NAIF_BODY_NAME += ( 'MMO_SPACECRAFT'                  )
      NAIF_BODY_CODE += ( -68000                            )

   \begintext


   MDM:
   ----

   This table summarizes MDM IDs:

      ----------------------       --------
       Name                         ID
      ----------------------       --------
       MMO_MDM                      -68100
      ----------------------       --------

   Name-ID Mapping keywords:

   \begindata

      NAIF_BODY_NAME   += (  'MMO_MDM'                 )
      NAIF_BODY_CODE   += (  -68100                    )

   \begintext


   MGF:
   ----

   This table summarizes MGF IDs:

      ----------------------       --------
       Name                         ID
      ----------------------       --------
       MMO_MGF_BOOM                 -68200
       MMO_MGF-I                    -68201
       MMO_MGF-O                    -68202
      ----------------------       --------

   Name-ID Mapping keywords:

   \begindata

      NAIF_BODY_NAME   += (  'MMO_MGF_BOOM'            )
      NAIF_BODY_CODE   += (  -68200                    )

      NAIF_BODY_NAME   += (  'MMO_MGF-I'               )
      NAIF_BODY_CODE   += (  -68201                    )

      NAIF_BODY_NAME   += (  'MMO_MGF-O'               )
      NAIF_BODY_CODE   += (  -68202                    )

   \begintext


   MPPE:
   -----

   This table summarizes MPPE IDs:

      ----------------------       --------
       Name                         ID
      ----------------------       --------
       MMO_MPPE                     -68300

       MMO_MPPE_MEA1                -68310
       MMO_MPPE_MEA1_CRUISE         -68311
       MMO_MPPE_MEA2                -68320
       MMO_MPPE_MEA2_CRUISE         -68321
       MMO_MPPE_HEP-ELE             -68330
       MMO_MPPE_HEP-ELE_UPPER       -68331
       MMO_MPPE_HEP-ELE_LOWER       -68332
       MMO_MPPE_HEP-ELE-CRUISE      -68333
       MMO_MPPE_HEP-ION             -68335
       MMO_MPPE_MSA                 -68340
       MMO_MPPE_MSA_CRUISE          -68341
       MMO_MPPE_MIA                 -68350
       MMO_MPPE_MIA_CRUISE          -68351

       MMO_MPPE_ENA                 -68370
       MMO_MPPE_ENA_CRUISE          -68371

       MMO_MPPE-LEP                 -68380
      ----------------------       --------

   Name-ID Mapping keywords:

   \begindata

      NAIF_BODY_NAME   += (  'MMO_MPPE'                )
      NAIF_BODY_CODE   += (  -68300                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MEA1'           )
      NAIF_BODY_CODE   += (  -68310                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MEA1_CRUISE'    )
      NAIF_BODY_CODE   += (  -68311                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MEA2'           )
      NAIF_BODY_CODE   += (  -68320                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MEA2_CRUISE'    )
      NAIF_BODY_CODE   += (  -68321                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_HEP-ELE'        )
      NAIF_BODY_CODE   += (  -68330                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_HEP-ELE_UPPER'  )
      NAIF_BODY_CODE   += (  -68331                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_HEP-ELE_LOWER'  )
      NAIF_BODY_CODE   += (  -68332                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_HEP-ELE_CRUISE' )
      NAIF_BODY_CODE   += (  -68333                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_HEP-ION'        )
      NAIF_BODY_CODE   += (  -68335                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MSA'            )
      NAIF_BODY_CODE   += (  -68340                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MSA_CRUISE'     )
      NAIF_BODY_CODE   += (  -68341                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MIA'            )
      NAIF_BODY_CODE   += (  -68350                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_MIA_CRUISE'     )
      NAIF_BODY_CODE   += (  -68351                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_ENA'            )
      NAIF_BODY_CODE   += (  -68370                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE_ENA_CRUISE'     )
      NAIF_BODY_CODE   += (  -68371                    )

      NAIF_BODY_NAME   += (  'MMO_MPPE-LEP'            )
      NAIF_BODY_CODE   += (  -68380                    )

   \begintext


   MSASI:
   ------

   This table summarizes MSASI IDs:

      ----------------------       --------
       Name                         ID
      ----------------------       --------
       MMO_MSASI                    -68400
       MMO_MSASI_SLIT               -68401
      ----------------------       --------

   Name-ID Mapping keywords:

   \begindata

      NAIF_BODY_NAME   += (  'MMO_MSASI'               )
      NAIF_BODY_CODE   += (  -68400                    )

      NAIF_BODY_NAME   += (  'MMO_MSASI_SLIT'          )
      NAIF_BODY_CODE   += (  -68401                    )

   \begintext


   SSAS:
   ------

     This table summarizes SSAS IDs:

       ----------------------       --------
        Name                         ID
       ----------------------       --------
        MMO_SSAS                     -68500
        MMO_SSAS_SLIT                -68501
       ----------------------       --------

     Name-ID Mapping keywords:


    \begindata

       NAIF_BODY_NAME   += (  'MMO_SSAS'                )
       NAIF_BODY_CODE   += (  -68500                    )

       NAIF_BODY_NAME   += (  'MMO_SSAS_SLIT'           )
       NAIF_BODY_CODE   += (  -68501                    )

   \begintext


   PWI:
   ----

   This table summarizes PWI IDs:

      ----------------------       --------
       Name                         ID
      ----------------------       --------
       MMO_PWI_MEF1                 -68501
       MMO_PWI_MEF1                 -68502
       MMO_PWI_WPT1                 -68503
       MMO_PWI_WPT2                 -68504
       MMO_PWI_SC_MAST              -68505
       MMO_PWI_SC                   -68506
      ----------------------       --------

   Name-ID Mapping keywords:

   \begindata

      NAIF_BODY_NAME   += (  'MMO_PWI_MEF1'            )
      NAIF_BODY_CODE   += (  -68501                    )

      NAIF_BODY_NAME   += (  'MMO_PWI_MEF2'            )
      NAIF_BODY_CODE   += (  -68502                    )

      NAIF_BODY_NAME   += (  'MMO_PWI_WPT1'            )
      NAIF_BODY_CODE   += (  -68503                    )

      NAIF_BODY_NAME   += (  'MMO_PWI_WPT2'            )
      NAIF_BODY_CODE   += (  -68504                    )

      NAIF_BODY_NAME   += (  'MMO_PWI_SC_MAST'         )
      NAIF_BODY_CODE   += (  -68505                    )

      NAIF_BODY_NAME   += (  'MMO_PWI_SC'              )
      NAIF_BODY_CODE   += (  -68506                    )

   \begintext


End of FK file.
