KPL/FK

BepiColombo Target Body DSK Surface ID Codes
=============================================================================

   This frame kernel contains a set of BepiColombo Target Body DSK Surface ID
   Codes for BepiColombo spacecraft.


Version and Date
-----------------------------------------------------------------------------

   Version 0.2 -- May 20, 2021 -- Alfredo Escalante Lopez, ESAC/ESA

      Updated definitions and contact information.

   Version 0.1 -- April 6, 2020 -- Alfredo Escalante Lopez, ESAC/ESA
                                   Marc Costa Sitja, ESAC/ESA

      Added MPO SA, HGA, MGA, MOSIF and MMO Bus.

   Version 0.0 -- September 27, 2019 -- Marc Costa Sitja, ESAC/ESA

      First version.


References
-----------------------------------------------------------------------------

   1. ``Frames Required Reading''

   2. ``Kernel Pool Required Reading''

   3. ``DS-Kernel Required Reading''

   4. BC Frames Kernel.


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           +1 (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

          cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

          furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEYPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


Definition Section
-----------------------------------------------------------------------------

   This section contains name to ID mappings for the BepiColombo target
   body DSK surfaces. These mappings are supported by all SPICE
   toolkits with integrated DSK capabilities (version N0066 or later).

   MTM Spacecraft Surface name/IDs:

          DSK Surface Name           ID     Body ID
      ===========================  =======  =======

      MTM_SPACECRAFT               -652000  -652000
      MTM_SA+X                     -652011  -652011
      MTM_SA-X                     -652013  -652013


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'MTM_SPACECRAFT'
      NAIF_SURFACE_CODE += -652000
      NAIF_SURFACE_BODY += -652000

      NAIF_SURFACE_NAME += 'MTM_SA+X'
      NAIF_SURFACE_CODE += -652011
      NAIF_SURFACE_BODY += -652011

      NAIF_SURFACE_NAME += 'MTM_SA-X'
      NAIF_SURFACE_CODE += -652013
      NAIF_SURFACE_BODY += -652013

   \begintext


   MPO Spacecraft Surface name/IDs:

          DSK Surface Name           ID     Body ID
      ===========================  =======  =======

      MPO_SPACECRAFT               -121000  -121000
      MPO_SA                       -121012  -121012
      MPO_HGA                      -121859  -121859
      MPO_MGA                      -121040  -121040
      MPO_MOSIF                    -121090  -121090


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'MPO_SPACECRAFT'
      NAIF_SURFACE_CODE += -121000
      NAIF_SURFACE_BODY += -121000

      NAIF_SURFACE_NAME += 'MPO_SA'
      NAIF_SURFACE_CODE += -121012
      NAIF_SURFACE_BODY += -121012

      NAIF_SURFACE_NAME += 'MPO_HGA'
      NAIF_SURFACE_CODE += -121859
      NAIF_SURFACE_BODY += -121859

      NAIF_SURFACE_NAME += 'MPO_MGA'
      NAIF_SURFACE_CODE += -121040
      NAIF_SURFACE_BODY += -121040

      NAIF_SURFACE_NAME += 'MPO_MOSIF'
      NAIF_SURFACE_CODE += -121090
      NAIF_SURFACE_BODY += -121090

   \begintext


   MMO Spacecraft Surface name/IDs:

          DSK Surface Name           ID     Body ID
      ===========================  =======  =======

      MMO_SPACECRAFT                -68000   -68000


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'MMO_SPACECRAFT'
      NAIF_SURFACE_CODE += -68000
      NAIF_SURFACE_BODY += -68000

   \begintext


End of FK file.