import numpy as np
import matplotlib.pyplot as plt

#
# Input longitudes are provided as EAST longitudes, therefore they need
# to be converted.
#

def poinpoint_config(file):

    with open(file, 'r') as i:
        id =1
        with open('pinpoint.defs', 'w') as o:
            o.write("      \\begindata\nSITES = (")
            o_string = ''
            for roi in i:
                o_string += (f"'JUICE_ROI_{id}',\n")
                id += 1
            o_string = o_string[:-2]
            o.write(o_string+')\n\n')
        id = 1
    with open(file, 'r') as i:
        with open('pinpoint.defs', 'a+') as o:
            for line in i:
                lat = float(line.split(';')[1])
                lon = float(line.split(';')[2])
                #if lon >= 180: lon -= 360
                o.write(
f'''      JUICE_ROI_{id}_CENTER = 503
          JUICE_ROI_{id}_FRAME  = 'IAU_GANYMEDE'
          JUICE_ROI_{id}_IDCODE = -28000{id}
          JUICE_ROI_{id}_LATLON = ( {lat}, {lon}, 0.5 )
          JUICE_ROI_{id}_BOUNDS = ( @2020-01-01T00:00:00, @2100-01-01 )

          JUICE_ROI_{id}_UP    =  'Z'
          JUICE_ROI_{id}_NORTH =  'Y'

          JUICE_ROI_{id}_TOPO_FRAME = 'JUICE_ROI_{id}'
          JUICE_ROI_{id}_TOPO_ID    = -280001{id}\n\n''')
                id += 1
    return


def pck_cosmo_config(file):
    with open(file, 'r') as i:
        with open('spacecraft_ROI.json', 'w') as c:
            with open('juice_roi_v00.tpc', 'w') as o:
                o.write('KPL/PCK\n   \\begindata\n\n')
                id = 1
                for line in i:
                    lat_min = float(line.split(';')[4])
                    lat_max = float(line.split(';')[5])

                    lon_min = float(line.split(';')[6])
                    #if lon_min >= 180: lon_min -=  360
                    lon_max = float(line.split(';')[7])
                    #if lon_max >= 180: lon_max -= 360

                    R = 2634.1
                    (rlong, rlat, rn) = latrange2ellipse([lat_min, lat_max],
                                                         [lon_min, lon_max],
                                                         R, inout='in')

                    o.write(f'      BODY-28000{id}_RADII     = ( {rlat} {rlong} 0.1 )\n')
                    c.write(
                            f'''     {{
                             "class": "spacecraft",
                             "name": "JUICE_ROI_{id}",
                             "startTime": "2025-01-01 00:00:00 UTC",
                             "center": "Ganymede",
                             "trajectory": {{
                                "type": "Spice",
                                "target": "JUICE_ROI_{id}",
                                "center": "Ganymede"
                             }},
                             "bodyFrame": {{
                                "type": "Spice",
                                "name": "JUICE_ROI_{id}"
                             }},
                           "geometry": {{
                                "type": "Globe",
                                "radii": [ // 2033-Jan-23 09:50:00.029
                                   {rlat},
                                   {rlong},
                                   0.1
                                ]
                             }}
                          }},''')
                    id += 1



    return


def latrange2ellipse(latr, longr, radius, inout):
    dlat = np.deg2rad(latr[1] - latr[0])
    dlong = np.deg2rad(longr[1] - longr[0])
    rlat = radius * np.sqrt(2 - 2*np.cos(dlat))/2
    rlong = radius * np.sqrt(2 - 2*np.cos(dlong))/2
    rn = radius * (1 - np.cos(dlat/2))
    y1 = rlat
    x1 = rlong
    y2 = rlat*1.3
    x2 = 0
    b = np.sqrt(((x2/x1*y1)**2 - y2**2)/((x2/x1)**2 - 1))
    a = np.sqrt((x1**2)/(1-(y1/b)**2))
    if inout=='out':
        rlat = b
        rlong = a
    return rlat, rlong, rn

#
# Test generation of the ellipse
#
#latr = [-26,-20]
#longr = [40, 45]
#R = 2634.1
#inscript = latrange2ellipse(latr=latr, longr=longr, radius=R, inout='in')
#circumsc = latrange2ellipse(latr=latr, longr=longr, radius=R, inout='out')
#xin = np.linspace(-inscript[1], inscript[1], 1000)
#yin = np.sqrt(inscript[0]**2*(1-xin**2/inscript[1]**2))
#x = np.linspace(-circumsc[1], circumsc[1], 1000)
#y = np.sqrt(circumsc[0]**2*(1-x**2/circumsc[1]**2))
#plt.scatter(xin, yin)
#plt.scatter(x, y)
#plt.plot([-inscript[1], -inscript[1]], [0, inscript[0]], color='black', marker='x')
#plt.plot([inscript[1], inscript[1]], [0, inscript[0]], color='black', marker='x')
#plt.plot([inscript[1], -inscript[1]], [inscript[0], inscript[0]], color='black', marker='x')
#plt.grid()
#plt.show()

poinpoint_config('rois.input')
pck_cosmo_config('rois.input')