# Dimorphos Tumbling package - OS-X

## Requirements
* MAC OS-X 
* Python 3.9+
* spiceypy

**Please, check that the tool dimorphos_tumbling/msopck/dm_msopck, included in the pack, has execution permissions.**


## Usage
The tool processes the binary files containing the propagator information, generating an intermediate CSV file and a SPICE CK.

The tool needs the didymos/dimorphos geometric information to be provided as a SPICE metarkernel (please, see Dart kernels repository section) 

The **output CK** is intended to be used inside metakernels of the https://s2e2.cosmos.esa.int/bitbucket/projects/SPICE_KERNELS/repos/hera/commits?until=refs%2Fheads%2Fdevelop (**develop branch**)

``````
usage: dimorphos_tumbling.py [-h] -t TIME -d DATA -m METAKERNEL -o OUTPUT [-i IMPACT_UTC]

Reader and CK generator for the dimorphos tumbling model

optional arguments:
  -h, --help            show this help message and exit
  -t TIME, --time TIME  Path of the binary file with time information t_out.bin
  -d DATA, --data DATA  Path of the binary file with position and rotation data x_out.bin
  -m METAKERNEL, --metakernel METAKERNEL
                        Path of the metakernel
  -o OUTPUT, --output OUTPUT
                        output files prefix
  -i IMPACT_UTC, --impact_utc IMPACT_UTC
                        Dart impact time utc
``````

### Usage sample
``` 
python dimorphos_tumbling.py -t example/t_out.bin -d example/x_out.bin -m /spice/d520/mk/d520_v02.tm  -o demo

INFO:root:DART Impact Time 2022-09-26T23:14:24.183Z
INFO:root:Generated demo.csv
INFO:root:Starting msopck
INFO:root:CK generated: /Users/randres/git/spice/ess-sandbox/src/dimorphos_tumbling/demo.bc
```

## Dart kernels repository

https://dart.jhuapl.edu/SPICE_kernels/ contains latest SPICE kernels with the latest orbit of Dimorphos and pole orientation.

We used this package (~3Gb) that it is inline with the dart impact time used in the sample

https://dart.jhuapl.edu/SPICE_kernels/d520.tar.gz

Concretely, we use the metakernel **d520_v02.tm**.

**Please, don't forget update the PATH_VALUES with your local folder**


## Reviewing the CK in Cosmographia
After the CK generation, the results can be visualized in Cosmographia following the instructions described in this section.

### Requirements
* Cosmographia 4.2 installed
* HERA SKD

### Preparing the Cosmographia Catalog

A template catalog has been included under the cosmographia folder. Before using some updates shall be done on the files.

#### cosmographia/dimorphos_load.json
Replace the HERA SKD path with the proper absolute path in your computer

![Modifications to dimorphos_load.json](images/load_json.png)


#### cosmographia/dimorphos_spice.json
Replace the **d520 path** with the proper absolute path in your computer and add the absolute path to the **CK to be visualized**
![Modifications to dimorphos_spice.json](images/spice_json.png)

### Visualizing the results

* Open Cosmographia
* Load the 'cosmographia/dimorphos_load.json' `File > Open Catalog`
* The following warning/error shall appear, ignore it. This is expected, we are not loading a proper HERA scene.
```
Error Item 'DART_IMPACT_SITE': Unknown target 'DART_IMPACT_SITE' for SPICE trajectory.
````
* Select the `2022-09-26T23:17:00Z` date
* Go to `Dimorphos` object
* Select the following SPICE frames (Right click - dimorphos)

![Spice Frames](images/spice_frames.png)