import cosmoscripting
cosmo = cosmoscripting.Cosmo()

cosmo.showTrajectory("C-G").wait ( 0 )
cosmo.showTrajectory("ROS").wait ( 0 )

cosmo.displayNote('Jump to August 3, 2014', 2).wait(0)

cosmo.setTime("2014-08-03 00:00:00.000 UTC").wait( 0 )
cosmo.setTimeRate(1).wait( 1 )
cosmo.unpause().wait( 0 )

cosmo.displayNote('Set observer between Sun and the comet looking at the comet', 3).wait(1)

cosmo.setCameraToInertialFrame().wait( 0 )
cosmo.setCentralObject("C-G").wait( 0 )
cosmo.setCameraPosition([-3,0,3]).wait( 0 )
cosmo.pointAtObject("Sun").wait( 0 )
cosmo.rollToBodyFixedVector("Sun",[0,0,-1],0.01).wait( 0.01 )
cosmo.setCameraToLockedFrame("Sun").wait( 0 )
cosmo.dollyForward(1000,0.01).wait( 0.01 )
cosmo.tiltUp(180,0.01).wait( 0.01 )

cosmo.displayNote('Speed up time to see Rosetta approach and orbit the comet', 3).wait( 0 )

cosmo.setTimeRate(1000000).wait( 0 )

cosmo.dollyForward(900,5).wait( 10 )
cosmo.dollyBackward(900,5).wait( 14 )

cosmo.setTimeRate(1).wait( 0 )

cosmo.displayNote('Jump back to August 3, 2014', 2).wait(2)

cosmo.setTime("2014-08-03 00:00:00.000 UTC").wait( 0 )
cosmo.setTimeRate(1).wait( 0 )

cosmo.displayNote('Set observer above the comet looking at the comet', 3).wait(1)
cosmo.circleCenterUp(90,2).wait(2)

cosmo.displayNote('Speed up time to see Rosetta approach and orbit the comet from above', 3).wait( 0 )

cosmo.setTimeRate(1000000).wait( 0 )

cosmo.dollyForward(900,5).wait( 10 )
cosmo.dollyBackward(900,5).wait( 14 )

cosmo.setTimeRate(1).wait( 1 )

cosmo.displayNote('Jump back to August 3, 2014', 2).wait(2)

cosmo.setTime("2014-08-03 00:00:00.000 UTC").wait( 0 )
cosmo.setTimeRate(1).wait( 0 )

cosmo.setTime("2014-08-03 00:00:00.000 UTC").wait( 0 )
cosmo.setTimeRate(1).wait( 0 )

cosmo.gotoObject('ROS',3)
cosmo.circleCenterDown(110,3)
cosmo.circleCenterRight(20,2)




