KPL/MK

Meta-kernel for CReMA Issue 3 Revision 0 Baseline Trajectory               
==========================================================================

   This meta-kernel lists the JUICE SPICE kernels providing information 
   for the full mission based on the following mission scenario:

     mantra_juice_jup_a5d_141a_lau_c5e_016.oem


Usage of the Meta-kernel                               
-------------------------------------------------------------------------    

   This metakernel contains all kernels to be used for the Working 
   Groups Level 0 analysis (2016).

   The kernels cover the following trajectory and attitude intervals 
   for JUPITER ICY MOONS EXPLORER (-28):

      Start of Interval (ET)              End of Interval (ET)
      -----------------------------       -----------------------------
      2022 MAY 31 23:59:59.999            2033 JUN 04 02:51:00.546

   Note that a default Attitude profile has been implemented for the whole
   mission by the following C-Kernels:

      juice_sc_sat_crema_x_y_default_20220601_20330911_f20160326_vnn.bc
      juice_sc_sat_crema_x_y_comms_20220601_20330911_f20160326_vnn.bc
      juice_sc_sat_crema_x_y_flybys_20220601_20330911_f20160326_vnn.bc

   Please note that the order in which the previous kernels is loaded is
   important. The *_default_* kernel implements the default attitude 
   during the main phases of he mission (interplanetary transfer with
   planetary swing-bys, Jupiter Tour and Ganymede Phase) this kernel
   needs to be loaded first and is followed by *_comms_* which provides
   a baseline of the communications attitude (required to perform an 8 hours 
   daily pass with Malargue). If desired this kernel can be removed to
   omit this attitude. Finally the *_flybys_* kernel is loaded which
   includes the default s/c orientation for the moon flybys. Note that
   it is important to load this kernel after the *_comms_* one in order to
   prioritize the flyby attitude. 
   
   Reading the comments of the binary C-Kernels is very helpful to 
   understand the implemented attitude. You can use the following NAIF
   command line utility to extract that information from the kernels:

      > commnt -r juice_sc_*.bc

   The kernels listed below can be obtained from the ESAC FTP server:
      
      ftp://spiftp.esac.esa.int/data/SPICE/JUICE/kernels/


Implementation Notes
-------------------------------------------------------------------------    

   IMPORTANT: this trajectory is designed using the latest Jupiter Moons 
   ephemeris data as provided by the IMCCE - so called IMCCE L2 model

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the JUICE SPICE data set's ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.

   DISCLAIMER: Pleae note that the current kernels are pre-operational and 
   they are subject to change.

-------------------   

   This file was last updated on Dec 5, 2016 by Marc Costa Sitja ESAC/ESA.
   This file was created on July 28, 2016 by Marc Costa Sitja ESAC/ESA.


   \begindata

     PATH_VALUES       = ( '/Users/mcosta/Dropbox/SPICE/SPICE_JUICE/ftp/data/SPICE/JUICE/kernels' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

        '$KERNELS/ck/juice_sc_sat_crema_3_0_default_20220601_20330604_f20160326_v01.bc'
        '$KERNELS/ck/juice_sc_sat_crema_3_0_comms_20220601_20330604_f20160326_v01.bc'
        '$KERNELS/ck/juice_sc_sat_crema_3_0_flybys_20220601_20330604_f20160326_v01.bc'
        '$KERNELS/ck/juice_lpbooms_f20160326_v01.bc'
        '$KERNELS/ck/juice_magboom_f20160326_v03.bc'
        '$KERNELS/ck/juice_mga_zero_f20160326_v01.bc'
        '$KERNELS/ck/juice_majis_scan_zero_f20160326_v02.bc'                          
        '$KERNELS/ck/juice_swi_scan_zero_f20160326_v02.bc'

        '$KERNELS/fk/juice_v12.tf'
        '$KERNELS/fk/juice_sci_v05.tf'
        '$KERNELS/fk/juice_ops_v03.tf'
        '$KERNELS/fk/rssd0002.tf'
        '$KERNELS/fk/earth_topo_050714.tf'
        '$KERNELS/fk/earthfixediau.tf'
        '$KERNELS/fk/estrack_v01.tf'

        '$KERNELS/ik/juice_gala_v03.ti'
        '$KERNELS/ik/juice_janus_v05.ti'
        '$KERNELS/ik/juice_jmc_v00.ti'
        '$KERNELS/ik/juice_majis_v04.ti'
        '$KERNELS/ik/juice_navcam_v00.ti'
        '$KERNELS/ik/juice_pep_v05.ti'
        '$KERNELS/ik/juice_rime_v04.ti'
        '$KERNELS/ik/juice_rpwi_v02.ti'
        '$KERNELS/ik/juice_str_v00.ti'
        '$KERNELS/ik/juice_swi_v06.ti'
        '$KERNELS/ik/juice_uvs_v03.ti'
        
        '$KERNELS/lsk/naif0011.tls'

        '$KERNELS/pck/pck00010.tpc'
        '$KERNELS/pck/de-403-masses.tpc'
        '$KERNELS/pck/gm_de431.tpc'
        '$KERNELS/pck/juice_jup000.tpc'

        '$KERNELS/sclk/juice_fict_20160326.tsc'
        
        '$KERNELS/spk/juice_mat_crema_3_0_20220601_20330604_v01.bsp'
        '$KERNELS/spk/juice_struct_v04.bsp'
        '$KERNELS/spk/de430.bsp'
        '$KERNELS/spk/mar085.bsp'
        '$KERNELS/spk/earthstns_fx_050714.bsp'                          
        '$KERNELS/spk/estrack_v01.bsp'
        '$KERNELS/spk/jup282.bsp'
        '$KERNELS/spk/jup230.bsp'
        '$KERNELS/spk/jup310.bsp'
        '$KERNELS/spk/noe-5-2010-gal-a2.bsp'

     )


   \begintext

   End of MK file.