KPL/MK

Meta-kernel for the BepiColombo dataset release v0.4.1            
==========================================================================

   This meta-kernel lists the BepiColombo SPICE kernels providing 
   test and optionaly, measured data.


Usage of the Meta-kernel                               
-------------------------------------------------------------------------    

   This meta-kernel lists the BepiColombo SPICE kernels providing coverage
   for the following mission period:

      Summary for: ../spk/bc_mcs_mct_50034_20181016_20251205_v02.bsp
       
      Body: MERCURY PLANETARY ORBITER (-121)
            Start of Interval (ET)              End of Interval (ET)
            -----------------------------       -----------------------------
            2018 OCT 16 01:54:54.782            2025 DEC 05 01:03:38.943
       
       
      Summary for: ../spk/bc_mpo_mlt_50037_20260314_20280529_v01.bsp
       
      Body: MERCURY PLANETARY ORBITER (-121)*
            Start of Interval (ET)              End of Interval (ET)
            -----------------------------       -----------------------------
            2026 MAR 14 15:41:49.985            2028 MAY 29 14:32:10.384
       
       
      Summary for: ../spk/bc_mmo_mlt_50038_20251220_20280305_v01.bsp
       
      Body: MERCURY MAGNETOSPHERIC ORBITER (-68)*
            Start of Interval (ET)              End of Interval (ET)
            -----------------------------       -----------------------------
            2025 DEC 20 09:18:27.711            2028 MAR 05 08:03:07.611
      
   Reading the comments of the binary SPK and C-Kernels is very helpful to 
   understand the implemented SC position and orientation. You can use the 
   following NAIF command line utility to extract that information from the 
   kernels:

      > commnt -r bc_mpo_sc_*.bc

   The kernels listed below can be found at:

      ftp://spiftp.esac.esa.int/data/SPICE/BEPICOLOMBO/misc/kernels/

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the BepiColombo SPICE ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.


Implementation Notes
-------------------------------------------------------------------------    

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the BepiColombo SPICE data set's ``data'' directory on 
   their system. Replacing ``/'' with ``\'' and converting line 
   terminators to the format native to the user's system may also be 
   required if this meta-kernel is to be used on a non-UNIX workstation.

   
-------------------   

   This file was created on March 1, 2017 by Marc Costa Sitja (ESAC/ESA).


\begindata

  PATH_VALUES     = ( '/Users/mcosta/Dropbox/SPICE/SPICE_BEPI/ftp/data/SPICE/BEPICOLOMBO/kernels')

  PATH_SYMBOLS    = ( 'KERNELS')

  KERNELS_TO_LOAD = (
 
                      '$KERNELS/ck/bc_mpo_hga_sot_default_20180317_20500101_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mpo_magboom_sot_default_20180317_20500101_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mpo_mga_sot_default_20180317_20500101_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mpo_mgaboom_sot_default_20180317_20500101_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mpo_sa_sot_default_20180317_20500101_f20150124_v01.bc'

                      '$KERNELS/ck/bc_mmo_sc_scp_cruise_20180317_20260314_f20170228_v01.bc'

                      '$KERNELS/ck/bc_mcs_sc_sct_cruise_50034_20181016_20251205_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mpo_sc_slt_nominal_50028_20260314_20280529_f20150124_v01.bc'
                      '$KERNELS/ck/bc_mcs_sc_sat_venus_flyby_1_50034_f20150124_v01.bc'


                      '$KERNELS/fk/bc_mmo_v01.tf'
                      '$KERNELS/fk/bc_mpo_v09.tf'
                      '$KERNELS/fk/bc_ops_v00.tf'
                      '$KERNELS/fk/bc_sci_v01.tf'

                      '$KERNELS/fk/earth_topo_050714.tf'
                      '$KERNELS/fk/earthfixediau.tf'
                      '$KERNELS/fk/earthfixeditrf93.tf'
                      '$KERNELS/fk/estrack_v01.tf'


                      '$KERNELS/ik/bc_mpo_bela_v03.ti'
                      '$KERNELS/ik/bc_mpo_mertis_v02.ti'
                      '$KERNELS/ik/bc_mpo_mgns_v01.ti'
                      '$KERNELS/ik/bc_mpo_mixs_v03.ti'
                      '$KERNELS/ik/bc_mpo_phebus_v00.ti'
                      '$KERNELS/ik/bc_mpo_serena_v00.ti'
                      '$KERNELS/ik/bc_mpo_simbio-sys_v02.ti'
                      '$KERNELS/ik/bc_mpo_sixs_v04.ti'
                     
                      '$KERNELS/ik/bc_mmo_mppe_v00.ti'


                      '$KERNELS/lsk/naif0012.tls'


                      '$KERNELS/pck/de403_masses.tpc'
                      '$KERNELS/pck/earth_000101_160528_160307.bpc'
                      '$KERNELS/pck/earth_070425_370426_predict.bpc'
                      '$KERNELS/pck/earth_latest_high_prec.bpc'
                      '$KERNELS/pck/gm_de431.tpc'
                      '$KERNELS/pck/pck00010.tpc'


                      '$KERNELS/sclk/bc_mpo_fict_20150124.tsc'
                      '$KERNELS/sclk/bc_mmo_fict_20170228.tsc'


                      '$KERNELS/spk/bc_mcs_mct_50034_20181016_20251205_v03.bsp'
                      '$KERNELS/spk/bc_mpo_mlt_50037_20260314_20280529_v01.bsp'

                      '$KERNELS/spk/bc_mmo_scp_cruise_20181016_20251205_v01.bsp'
                      '$KERNELS/spk/bc_mmo_mlt_50038_20251220_20280305_v01.bsp'


                      '$KERNELS/spk/de432s.bsp'
                      '$KERNELS/spk/earthstns_fx_050714.bsp'
                      '$KERNELS/spk/earthstns_itrf93050714.bsp'
                      '$KERNELS/spk/estrack_v01.bsp'
                      '$KERNELS/spk/new_norcia.bsp'

                    )

\begintext


End of MK file.