KPL/FK

XMM Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   XMM-Newton (X-ray Multi-mirror Mission - Newton). This kernel also contains
   NAIF ID/name mapping for the different XMM spacecrafts.


Version and Date
-----------------------------------------------------------------------------

   Version 0.0 -- February 24, 2023 -- Ricardo Valles Blanco, ESAC/ESA

      Preliminary Version. Only XMM Name to NAIF ID mappings and frame for
      their use with available SPK kernels.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''

   4.   ``XMM-Newton's operational challenge of changing the attitude control
        to 4 active reaction wheels, after 12 years of routine operations.''
        M. Pantaleoni et al., June 2012, 10.2514/6.2012-1275587


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEYPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy



XMM NAIF ID Codes -- Summary Section
------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the XMM spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "XMM NAIF ID Codes to Name Mapping"
   at the end of this file):

   XMM Spacecraft and Spacecraft Structures names/IDs:

            XMM                   -125989     (synonyms: XMM-NEWTON)


XMM Frames
-----------------------------------------------------------------------------

   The following XMM frames are defined in this kernel file:

      Name                    Relative to               Type         NAIF ID
      ======================  ========================  ==========   =========

      XMM Spacecraft and Spacecraft Structures frames:
      ------------------------------------------------
      XMM_SPACECRAFT          J2000,                     CK          -125989


XMM Frames Hierarchy
--------------------------------------------------------------------------

   The diagram below shows the XMM frames hierarchy:


                         "J2000" INERTIAL
                      +--------------------+
                      |                    |
                      |<--pck              |<--ck
                      |                    |
                      v                    v
                 "IAU_EARTH"       "XMM_SPACECRAFT"
                 -----------       ----------------


XMM Spacecraft and Spacecraft Structures Frames
-----------------------------------------------------------------------------

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


XMM Spacecraft Frame
--------------------

   According to [4] the XMM spacecraft reference frame -- XMM_SPACECRAFT --
   is defined as follows:

      -  +X axis is anti-parallel to the Star Tracker viewing direction,
         and points from the Service Module to the Focal plane assembly;

      -  +Y axis is parallel to the solar arrays rotation axis;

      -  +Z axis completes the right-handed frame and is the nominally aligned
         with the Sun direction.

      -  the origin of this frame is the spacecraft's center of mass.


   This diagram illustrate the XMM_SPACECRAFT frame:

   +Z S/C side (Nominal Sun direction side) view:
   ----------------------------------------------

                                .___________.
                               /             \
                              /               \
                             /                 \  <- Focal plane assembly
                            |                   |
                            .___________________.
                                |           |
                                |           |
                                |           |
                                |           |
                                |           |
                                |           |
                                |           |
                                |           |
                               |             |  <- Telescope tube
                               |     +Xsc    |
                               |      ^      |
                               |      |      |
                               |      |      |
                               |      |      |      Mirror support platform
                        +Ysc <--------o      |     /  (Service Module)
   .__  ___________.           |       +Zsc  |    /       .__________  ___.
   |  \ \           \    ._________________________.    /           \ \  |
   |  / /            \   |      |           |      |   /            / /  |
   |  \ \             `. |      |           |      | .'             \ \  |
   |  / /             | >|      |           |      |< |             / /  |
   |  \ \             .' |     |             |     | `.             \ \  |
   |  / /            /   |     |             |     |   \            / /  |
   .__\ \___________/   _._____|_____________|_____._   \___________\ \__.
       +Y Solar Array   \      |             |      /     -Y Solar Array
                         \     |             |     /
                          \   |               |   /
  Telescope sunshield -->  \  |               |  /
  deployed                  .|_________________|.

                                      |                    +Zsc is out
      Star Tracker viewing direction  |                     of the page.
                              (-Xsc)  V


   Since the S/C bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

   These sets of keywords define the XMM_SPACECRAFT frame:

   \begindata

      FRAME_XMM_SPACECRAFT             = -125989
      FRAME_-125989_NAME               = 'XMM_SPACECRAFT'
      FRAME_-125989_CLASS              =  3
      FRAME_-125989_CLASS_ID           = -125989
      FRAME_-125989_CENTER             = -125989
      CK_-125989_SCLK                  = -125989
      CK_-125989_SPK                   = -125989
      OBJECT_-125989_FRAME             = 'XMM_SPACECRAFT'

   \begintext


XMM NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the XMM spacecrafts.
   Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  XMM spacecraft:
  ----------------------------------------------------------------

      This table presents the XMM spacecraft names.

      ---------------------  -------  --------------------------
      Name                   ID       Synonyms
      ---------------------  -------  --------------------------

      XMM                    -125989  XMM-NEWTON

      ---------------------  -------  --------------------------

     \begindata

      NAIF_BODY_NAME += ( 'XMM-NEWTON'                  )
      NAIF_BODY_CODE += ( -125989                       )

      NAIF_BODY_NAME += ( 'XMM'                         )
      NAIF_BODY_CODE += ( -125989                       )

     \begintext

End of FK file.