KPL/FK

Huygens Probe Frame Definitions Kernel
==============================================================================
 
   This frame kernel contains the Huygens Probe frame definitions.


   Version 0.0 -- Jul 30, 2018 -- Alfredo Escalante (ESAC/ESA)

            --   Initial Release.
 
 
References
----------------------------------------------------------
 
            1.   ``C-kernel Required Reading''
 
            2.   ``Kernel Pool Required Reading''
 
            3.   ``Frames Required Reading''
 
            4.   Huygens User Manual. Aerospatiale Espace and Defense.

 
 
Contact Information
----------------------------------------------------------
 
   Direct questions, comments, or concerns about the contents of this kernel
   to:
 

 
 
Implementation Notes
----------------------------------------------------------
 
   This file is used by the SPICE system as follows: programs that make use of
   this frame kernel must `load' the kernel, normally during program
   initialization. The SPICELIB routine FURNSH loads a kernel file as shown
   below:
 
           FORTRAN: (SPICELIB)
 
              CALL FURNSH ( frame_kernel_name )
 
           C: (CSPICE)
 
              furnsh_c ( frame_kernel_name );
 
           IDL: (Icy)
 
              cspice_furnsh, frame_kernel_name
 
           MATLAB: (Mice)
 
              cspice_furnsh( frame_kernel_name )
 
   This file was created and may be updated with a text editor or word
   processor.
 
 
Huygens Frames
----------------------------------------------------------
 
   The following Huygens frames are defined in this kernel file:
 
         Frame Name                  Relative To              Type     NAIF ID
         =======================     ===================      =======  =======
 
         Spacecraft Frame:
         -----------
          HUYGENS_PROBE              J2000                    FIXED    -150000

         Science Instrument frames:
         --------------------------
          HUYGENS_DISR               HUYGENS_PROBE            CK       -150100
 
 
Huygens Frames Hierarchy
----------------------------------------------------------
 
   Notes:
 
   This diagram is subject to major revisions as this kernel evolves to suit
   the needs of each instrument.
 
   The diagram below shows the Huygens frames hierarchy:
 
 
             'IAU_TITAN' (TITAN BODY FIXED)
              |
              |<--- pck
              |
           'J2000' INERTIAL
              |
              |<--- ck
              |
             'HUYGENS_DISR'
              |
              |<--- fixed
              |
             'HUYGENS_PROBE'
 

Spacecraft Configuration Description
----------------------------------------------------------

The Probe can be schematically described as a kernel surrounded by a shell,
the kernel carrying all the experiments and service units operating during the
decent while the shell protects it during the Cruise, Coast and Entry phases
and is then jettisoned at the beginning of the Descent. The kernel is mainly
constituted by two platforms supporting the Experiments and the equipment units
assembled by light secondary structures.

The jettisonable shell is constituted by a spherical-conical front shield and
a back cover to complete the thermal protection during atmospheric entry. This
jettison is aerodinamically operated by a Main Parachute large enough to pull
the kernel rearwards from the Front Shield. This Main Parachute itself is
extracted, along with the Back Cover, by the Pilot Chute which deployment is
triggered by an acceleration threshold and extracted by a Pilot chute
Deployment device (PDD).

The threshold is detected by the Command and Data Management Subsystem (CDMS)
accelerometers, then the Main Chute is jettisoned and a smaller Stabilizer
Chute is deployed which allows the required Descent time.

Swivels ensure decoupling of the Probe from possible parachute rotations. Probe
controlled spin is provided by a series of aerodynamic winglets.


Spacecraft Frame
----------------------------------------------------------
 
   This scheme shows in a simplified way the body fixed reference frame as
   defined in [4], for more detailed description of the layout of the probe
   in descent configuration, refer to section 2.2 "Probe systems description",
   in [4]


                                     Huygens Probe

                                           +X
                                            ^
                                            |
                                            |
                           ----------------------------------
                          /                                   \
                         /                                     \
                        /                                       \
                        --------------------|--------------------
                       |                    |                    |
                       ---------------------x--------------------- ----> +Y
                       \_                                       _/
                         \_ \   \   \   |   |   |   /   /   /__/
                            \_______________________________/




                                           +Z
                                            ^
                                            |
                                         ___|___
                                  ______|_______|______
                              ___/      | DISR  |      \___
                             /          |_______|          \
                          __/                               \__
                         /                                     \
                        /                   ^                   \
                       |                    |                    |
                       |                    |                    |
                       |                    o----->              | ---> +Y
                       |                                         |
					   |                                         |
                       |                                         |
					   |                                         |
                        \                                       /
                         \__                                 __/
                            \                               /
                             \___                       ___/
                                 \_____________________/


   From [4]:
 
   ``The spacecraft reference frame is a structural reference frame, defined
   when the probe has ejected the front and back shields and is in descent
   configuration as described in [4].

   The origin of the reference frame axis is located on the bottom face of the
   experiment platform. The +X axis is coincident with the axis of revolution
   of the probe cover. The +Z axis is parallel to the line joining the origin
   of the reference frame with the DISR instrument center. The +Y axis completes
   the orthonormal reference frame. ''

   Spacecraft attitude with respect to an inertial frame is provided by a
   C kernel (see [1] for more information).

   \begindata

       FRAME_HUYGENS_PROBE       = -150000
       FRAME_-150000_NAME         = 'HUYGENS_PROBE'
       FRAME_-150000_CLASS        = 4
       FRAME_-150000_CLASS_ID     = -150000
       FRAME_-150000_CENTER       = -150
       TKFRAME_-150000_SPEC      = 'ANGLES'
       TKFRAME_-150000_RELATIVE  = 'HUYGENS_DISR'
       TKFRAME_-150000_ANGLES    = ( 0.0, 0.0, 0.0 )
       TKFRAME_-150000_AXES      = (   1,   2,   3 )
       TKFRAME_-150000_UNITS     = 'DEGREES'

   \begintext

DISR: Descent Imager/Spectral Radiometer Frame
-------------------------------------------------------------------------------

   \begindata

        FRAME_HUYGENS_DISR       = -150100
        FRAME_-150100_NAME        = 'HUYGENS_DISR'
        FRAME_-150100_CLASS       = 3
        FRAME_-150100_CLASS_ID    = -150100
        FRAME_-150100_CENTER      = -150
        CK_-150100_SCLK           = -150
        CK_-150100_SPK            = -150

   \begintext


HUYGENS NAIF ID Codes -- Definition Section
========================================================================

   This section contains name to NAIF ID mappings for the Huygens Probe.
   Once the contents of this file is loaded into the KERNEL POOL, these
   mappings become available within SPICE, making it possible to use names
   instead of ID code in the high level SPICE routine calls.

   Spacecraft and its structures:
   ------------------------------

      HUYGENS                           -150
      CASSINI PROBE                     -150
      CASP                              -150

      HUYGENS_PROBE                  -150000
      HUYGENS_SPACECRAFT             -150000
      HUYGENS_BUS                    -150000

      HUYGENS_INSTRUMENT_PLATFORM    -150000
      HUYGENS_PLATFORM               -150000

   Science Instruments:
   --------------------

      HUYGENS_DISR                   -150100
	  HUYGENS_DISR_SLI               -150101
	  HUYGENS_DISR_MRI               -150102
	  HUYGENS_DISR_HRI               -150103

   The mappings summarized in this table are implemented by the keywords
   below.

   \begindata

      NAIF_BODY_NAME += ( 'HUYGENS'                         )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'CASSINI PROBE'                   )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'CASP'                            )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'HUYGENS_PROBE'                   )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_SPACECRAFT'              )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_BUS'                     )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_INSTRUMENT_PLATFORM'     )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_PLATFORM'                )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_DISR'                    )
      NAIF_BODY_CODE += ( -150100                           )
	  
	  NAIF_BODY_NAME += ( 'HUYGENS_DISR_SLI'                )
      NAIF_BODY_CODE += ( -150101                           )
	  
	  NAIF_BODY_NAME += ( 'HUYGENS_DISR_MRI'                )
      NAIF_BODY_CODE += ( -150102                           )
	  
	  NAIF_BODY_NAME += ( 'HUYGENS_DISR_HRI'                )
      NAIF_BODY_CODE += ( -150103                           )

\begintext

Definition of the nadir frame
-----------------------------
  All vectors are geometric: no aberration corrections are used.

  The +X axis points from the center of Titan to the Spacecraft.

  The component of Titan's north pole direction orthogonal to
  to X is aligned with the +Z axis; the +Z axis points North.

  The +Y axis is the cross product of the +Z axis and the -X axis;
  the +Y axis points West.
  
  Frame specification data
------------------------

\begindata

  FRAME_HUYGENS_NADIR         = 1400150
  FRAME_1400150_NAME           = 'HUYGENS_NADIR'
  FRAME_1400150_CLASS          = 5
  FRAME_1400150_CLASS_ID       = 1400150
  FRAME_1400150_CENTER         = -150
  FRAME_1400150_RELATIVE       = 'J2000'
  FRAME_1400150_DEF_STYLE      = 'PARAMETERIZED'
  FRAME_1400150_FAMILY         = 'TWO-VECTOR'
  FRAME_1400150_PRI_AXIS       = '-X'
  FRAME_1400150_PRI_VECTOR_DEF = 'OBSERVER_TARGET_POSITION'
  FRAME_1400150_PRI_OBSERVER   = -150
  FRAME_1400150_PRI_TARGET     = 'TITAN'
  FRAME_1400150_PRI_ABCORR     = 'NONE'
  FRAME_1400150_SEC_AXIS       = 'Y'
  FRAME_1400150_SEC_VECTOR_DEF = 'CONSTANT'
  FRAME_1400150_SEC_SPEC       = 'RECTANGULAR'
  FRAME_1400150_SEC_VECTOR     = ( 0, 0, 1 )
  FRAME_1400150_SEC_FRAME      = 'IAU_TITAN'
  FRAME_1400150_SEC_ABCORR     = 'NONE'

\begintext
