KPL/MK

Meta-kernel for James Webb Space Telescope Dataset v011 -- Planning 20251212_001
============================================================================

   This meta-kernel lists the JWST Planning SPICE kernels
   that provide information for the Planning scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the JWST Planning scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.6.7.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/JWST/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/JWST/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the JWST SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on December 12, 2025 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was jwst_plan_v011_20251212_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/fk/jwst_v00.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/de-403-masses.tpc'
                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/jwst_horizons_20211225_20240221_v01.bsp'
                           '$KERNELS/spk/jwst_pre_211225_301201_v01.bsp'
                           '$KERNELS/spk/jwst_rec_211225_251201_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v011_20251212_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'jwst_plan_v011_20251212_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.