James Webb Space Telescope SPICE Kernel Dataset
===============================================

SPICE is an essential tool for scientists and engineers alike in the
planetary science field for Solar System Geometry. Please visit the
[ESA SPICE Service (ESS) website](https://spice.esac.esa.int).



The JWST SPICE Kernel Dataset (SKD) consists on a complete set of SPICE
Kernels that cover the whole mission lifespan including reconstructed and long
term predicted trajectory and orientation. The SKD has the following directory
structure:

* root directory (named after the mission: JWST)
  * kernels
    * fk: Kernels that define reference frames needed for the Mission.
    * lsk: Leapseconds kernel.
    * mk: Meta-kernel files (a.k.a "furnsh" files) that provide lists of kernels
          suitable for a given mission period.
    * pck: Kernels that define planetary constants.
    * spk: Orbit kernels, for the spacecraft and other solar system bodies.
  * misc
    * cosmo: The SPICE-enhanced configuration for the JWST mission.
    * git_hooks: Includes available Git Hooks to automatically handle SKD updates.
    * models: Includes available 3D models and images.
    * release notes: Includes the Release Notes of the SKD.
    * source: Includes some source files used for orbit kernels generation.

The SKD also include text files that help to understand the contents of every 
directory. Those files are named aareadme.txt.

Please note that this Git repository provides a subset of the full SKD which is
available in the [ESA SPICE FTP](https://spiftp.esac.esa.int/data/SPICE/JWST).


Installation
------------

In order to use Git to obtain the operational subset of the SKD, the user needs
to have Git installed. You can clone the repository with

    git clone --depth 1 <repo_url>

Please be aware that due to the large historic of the repository and the large 
size of some binary kernels, timeout errors may occur if the --depth option is 
not used for performing a shallow clone. For more information please see the 
Known Issues section. 

In order to run the SKD in SPICE outside the mk directory of the Git
repository the user needs to modify the following the PATH_VALUE variable
of the meta-kernel:

    PATH_VALUES       = ( '..' )

It is recommended for users to make a local copy of this file and
modify the value of the PATH_VALUES keyword to point to the actual
location of the JWST SPICE data set's 'data' directory on
their system. Replacing '/' with '\' and converting line
terminators to the format native to the user's system may also be
required if this meta-kernel is to be used on a non-UNIX workstation.

Note that there is also a Git Hook available in order to generate and update
all this local meta-kernels every time you do a "git pull", "git merge" 
or a "git checkout". You can find more information on how to set up this Git Hook
at "misc\git_hooks\skd_post_merge\README.md".

Finally, please note that in order to use the SPICE kernels you need to install
your preferred SPICE Library. You can find instructions on how to install
SPICE [here](https://naif.jpl.nasa.gov/naif/toolkit.html)



Function and Purpose
--------------------

ESA has a number of science missions under development and in operation that 
are dedicated to the study of our Solar System (i.e. MEX, Rosetta, ExoMars, 
BepiColombo, Solar Orbiter and JUICE). The Science Operations Centres for 
these missions, located at the European Space Astronomy Centre (ESAC) in Spain,
are responsible for all science operations planning, data processing and 
archiving tasks, being the essential interface between the science instruments
and the spacecraft, and with the scientific community.

From the concept study phase to the day-to-day science operations, these
missions produce and use auxiliary data (spacecraft orbital state information,
attitude, event information and relevant spacecraft housekeeping data) to assist
science planning, data processing, analysis and archiving.

Within the Solar System scientific community, the SPICE information system is 
the 'de facto' standard for auxiliary data handling and geometry computations,
and has been adopted and is extensively used in ESA missions. SPICE is developed
and maintained by the Navigation and Ancillary Information Facility (NAIF) of
the Jet Propulsion Laboratory (JPL).

The SPICE format includes definitions for orbit, attitude and event information,
and the data files describing these categories are called ‘SPICE kernels’.
These kernels contain sufficient information to compute derived geometrical or
positional values using the existing NAIF SPICE toolkit.

For ESA missions, there are three different sources of SPICE kernels:
* The spacecraft orbit (SPK), attitude (CK) and clock correlation (SCLK) kernels,
  produced regularly for each mission from Mission Analysis and Flight Dynamics
  products and spacecraft telemetry.
* Generic kernels, such as planetary constants (PCK), leap seconds (LSK) and
  ephemerides (SPK), mostly provided by NAIF.
* Instrument kernels (IK) and the frames specification kernel (FK),
  created in collaboration with the Instruments Teams.

The SKD contain two different types of kernels:
* Setup kernels (STK) FK, IK, PCK, LSK: they are typically text files and
  they are developed by ESS and are reviewed and iterated with the SGS and
  with the Instrument Teams when need be during the whole duration of the mission.
  The STKs include the following information:
  *	Set of Reference Frames of interest for geometry computations.
  *	FoV and boresight modeling for science payload.
  *	Study trajectory default orientation for S/C.
  *	Physical models for natural bodies of the mission.
* Time-varying kernels (TVK) SPK, CK, SCLK, MK: are either text or binary files
  and are generated with the Auxiliary Data Conversion System (ADCSng) and the
  source data is provided by the Flight Dynamics in terms of OEMs, AEMs and
  Housekeeping TM data. The TVKs include the following information:
  *	Predicted attitude and predicted/reconstructed trajectory.
  *	OBT to UTC/CAL time conversion.
  *	Reconstructed trajectory and measured orientation for S/C.
  *	Orientation of Solar Arrays and HGA (if applicable).
  *	Position of scans or turn-tables or articulations of payload.


Environmental Considerations
----------------------------

 At least a basic knowledge of the SPICE system is needed in order to
 use these kernels. The SPICE toolkit provides versions in Fortran
 (SPICELIB), C (CSPICE), IDL (icy), Matlab (mice) and Python (SpiceyPy),
 and the user can choose any one that suits him/her.

 The SPICELIB routine FURNSH, CSPICE function furnsh_c, icy routine
 cspice_furnsh and SpiceyPy routine furnsh load a kernel file into the
 kernel pool as shown below.

    CALL FURNSH  ( 'kernel_name' )
    furnsh_c     ( "kernel_name" );
    cspice_furnsh, 'kernel_name'
    cspice_funsh( 'kernel_name' );
    spiceypy.furnsh( 'kernel_name' )


Documentation
-------------

The HTML documentation for the JWST SKD is available
[here](https://spiftp.esac.esa.int/data/SPICE/JWST/misc/JWST.html).


Known Issues
------------

Due to the large historic of the repository and the large size of some binary
kernels, timeout errors may occur when trying to clone the repository with slow
internet connection. The error may look something like the following:

    error: RPC failed; curl 56 LibreSSL SSL_read: SSL_ERROR_SYSCALL, errno 60
    fatal: the remote end hung up unexpectedly
    fatal: early EOF
    
A workaround to this issue is to perform a shallow clone instead, using the
keyword *depth* in order to indicate how deep the clone should reach into the
repository historic. For example, in order to get just the last version of the
repository, type in the command line:

    git clone --depth 1 <repo_url>


How to Help
-----------

Please note that the JWST SKD might contain bugs and is being constantly updated.
Feedback is always welcome. If you discover a bug please do not hesitate to
contact the [ESA SPICE Service](spice@sciops.esa.int).
