KPL/MK

Meta-kernel for INTEGRAL Dataset v100 -- Operational 20250910_001
============================================================================

   This meta-kernel lists the INTEGRAL Operational SPICE kernels
   that provide information for the Operational scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the INTEGRAL Operational scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.5.3.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/INTEGRAL/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/INTEGRAL/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the INTEGRAL SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on September 10, 2025 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was integral_ops_v100_20250910_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/integral_sc_ssm_20021017_20030101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20030101_20040101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20040101_20050101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20050101_20060101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20060101_20070101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20070101_20080101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20080101_20090101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20090101_20100101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20100101_20110101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20110101_20120101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20120101_20130101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20130101_20140101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20140101_20150101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20150101_20160101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20160101_20170101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20170101_20180101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20180101_20190101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20190101_20200101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20200101_20210101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20210101_20220101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20220101_20230101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20230101_20240101_f20220208_v02.bc'
                           '$KERNELS/ck/integral_sc_ssm_20240101_20250101_f20220208_v01.bc'
                           '$KERNELS/ck/integral_sc_ssm_20250101_20250325_f20220208_v01.bc'

                           '$KERNELS/fk/integral_v01.tf'
                           '$KERNELS/fk/earth_topo_050714.tf'
                           '$KERNELS/fk/estrack_v04.tf'

                           '$KERNELS/ik/integral_ibis_v01.ti'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/pck00010.tpc'
                           '$KERNELS/pck/de-403-masses.tpc'

                           '$KERNELS/pck/earth_070425_370426_predict.bpc'

                           '$KERNELS/sclk/integral_fict_20220208.tsc'

                           '$KERNELS/spk/integral_sc_ssm_20021017_20250325_v02.bsp'
                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/estrack_v04.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v100_20250910_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'integral_ops_v100_20250910_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.