KPL/FK

INTEGRAL Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   INTEGRAL (International Gamma Ray Astrophysics Laboratory) including
   definitions for the INTEGRAL fixed and INTEGRAL science instrument frames.
   This kernel also contains NAIF ID/name mapping for the INTEGRAL science
   instruments and s/c structures (see the last section of the file).


Version and Date
-----------------------------------------------------------------------------

   Version 0.1 -- July 14, 2022 -- Alfredo Escalante Lopez, ESAC/ESA

      Added IBIS fully coded NAIF/ID body association.

   Version 0.0 -- March 16, 2022 -- Alfredo Escalante Lopez, ESAC/ESA

      Preliminary Version. Only basic ID and frame definitions.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the ESA SPICE
   Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


INTEGRAL Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the INTEGRAL
   spacecraft, its structures and science instruments (the keywords
   implementing these definitions are located in the section "INTEGRAL
   Mission NAIF ID Codes -- Definition Section" at the end of this file):

      INTEGRAL Spacecraft and Spacecraft Structures names/IDs:

            INTEGRAL                    -275

            INTEGRAL_SPACECRAFT         -275000  (synonym: INTEGRAL_SC)

      Imager on Board the Integral Satellite (IBIS) names/IDs:

            INTEGRAL_IBIS               -275110


INTEGRAL Mission Frames
-----------------------------------------------------------------------------

   The following INTEGRAL frames are defined in this kernel file:

           Name                  Relative to               Type       NAIF ID
      ======================  ========================  ==========   =========

    Spacecraft frames:
    ------------------
      INTEGRAL_SPACECRAFT       J2000                    CK           -275000


    Imager on Board the Integral Satellite Frames (IBIS):
    -----------------------------------------------------
      INTEGRAL_IBIS             INTEGRAL_SPACECRAFT      FIXED        -275110


INTEGRAL Frames Hierarchy
-----------------------------------------------------------------------------

  The diagram below shows the INTEGRAL spacecraft and its structures frame
  hierarchy (not including science instrument frames.)

                  "J2000" INERTIAL
           +----------------------------+
           |                            |
           |<-pck                       |
           |                            |
           V                            |
      "EARTH_FIXED"                     |
      -------------                     |
                                        |
                                        |<-ck
                                        |
                                        V
                               "INTEGRAL_SPACECRAFT"
                                        +
                                        .
                                        .
                                        .
                                        .
                                        .
                                        .
                                        .
                                        V
                   Individual instrument frame trees are provided
                     in the corresponding sections of this file


INTEGRAL Spacecraft and Spacecraft Structures Frames
========================================================================

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


INTEGRAL Spacecraft Frame
--------------------------------------

   The INTEGRAL spacecraft frame is defined as follows:

      -  +X axis is along the nominal boresight direction of instrument deck;

      -  +Y axis is along the positive Solar Arrays axis;

      -  +Z axis completes the right-hand frame;

      -  the origin of this frame is the launch vehicle interface point.

   These diagrams illustrate the INTEGRAL_SPACECRAFT frame:


   +X s/c side (science deck side) view:
   -------------------------------------

                               ._____+Zsc_____.
                              /  | |   ^   | |  \
                             /   | |   |   | |   \
                            |    | |   |   | |+Ysc|
   o==/ /==-=============--o|    | .___o------->  |o---===============-=/ /==o
       -Y Solar Array       |    |   /+Xsc   |    |               +Y Solar Array
                            |    \  |     |  /    |
                             \    \  \___/  /    /
                              \____\_______/____/

                                                       +Xsc is out of
                                                        the page.


   -Z s/c side view:
   -------------------------------------

                                .-------------.
                                |             |
                                |             |
                                |             |
                                |             |
   .__  __..___________.        |             |       .___________..__  ___.
   |  / / ||           | \      |    +Xsc     |      / |          ||  \ \  |
   |  \ \ ||           |  \ .__/|______^______|\__. /  |          ||  / /  |
   |  / / ||           |   o| |        |        | |o   |          ||  \ \  |
   |  \ \ ||           |  / | |        |  +Ysc  | | \  |          ||  / /  |
   .__\ \_..___________|./  ._|_______ x----->__|_.  \.|__________..__\ \__.
                                     +Zsc

                                                          +Zsc is into
                                                           the page.


   Since the orientation of the INTEGRAL_SPACECRAFT frame is computed
   on-board, sent down in telemetry, and stored in the s/c CK files, it
   is defined as a CK-based frame.

   \begindata

      FRAME_INTEGRAL_SPACECRAFT        = -275000
      FRAME_-275000_NAME               = 'INTEGRAL_SPACECRAFT'
      FRAME_-275000_CLASS              =  3
      FRAME_-275000_CLASS_ID           = -275000
      FRAME_-275000_CENTER             = -275
      CK_-275000_SCLK                  = -275
      CK_-275000_SPK                   = -275

   \begintext


IBIS Frames
========================================================================

   This section of the file contains the definitions of the Imager Board
   the Integral Satellite (IBIS) frames.


IBIS Frame Tree
--------------------------------------

   The diagram below shows the IBIS frame hierarchy.

                  "J2000" INERTIAL
           +----------------------------+
           |                            |
           |<-pck                       |
           |                            |
           V                            |
      "EARTH_FIXED"                     |
      -------------                     |
                                        |
                                        |<-ck
                                        |
                                        V
                                "INTEGRAL_SPACECRAFT"
                                ---------------------
                                        |
                                        |<-fixed
                                        |
                                        V
                                  "INTEGRAL_IBIS"
                                  ---------------


IBIS Frames
--------------------------------------

   The Imager Board the Integral Satellite frame -- INTEGRAL_IBIS --
   is defined as follows:

      -  +Z axis points along the camera boresight;

      -  +X axis is parallel to the apparent image lines; it is
         nominally co-aligned with the s/c +X axis;

      -  +Y axis completes the right handed frame; it is nominally
         parallel to the apparent image columns and co-aligned with
         the s/c +Y axis;

      -  the origin of the frame is located at the camera focal point.

   This diagram illustrates the IBIS imager frames:


   -Z s/c side view:
   -----------------

                                .-------------.
                                |   +Zibis    |
                                |      ^      |
                                |      |      |
                                |      |  +Yibis
   .__  __..___________.        |      o----->|       .___________..__  ___.
   |  / / ||           | \      |   +Xibis    |      / |          ||  \ \  |
   |  \ \ ||           |  \ .__/|______^+Xsc__|\__. /  |          ||  / /  |
   |  / / ||           |   o| |        |        | |o   |          ||  \ \  |
   |  \ \ ||           |  / | |        |  +Ysc  | | \  |          ||  / /  |
   .__\ \_..___________|./  ._|_______ x----->__|_.  \.|__________..__\ \__.
                                     +Zsc

                                          +Zsc is into the page.
                                          +Xibis is out of the page.


   Nominally, the IBIS frame is rotated 90 degrees around the +Y s/c frame:

   \begindata

      FRAME_INTEGRAL_IBIS              = -275110
      FRAME_-275110_NAME               = 'INTEGRAL_IBIS'
      FRAME_-275110_CLASS              =  4
      FRAME_-275110_CLASS_ID           = -275110
      FRAME_-275110_CENTER             = -275
      TKFRAME_-275110_RELATIVE         = 'INTEGRAL_SPACECRAFT'
      TKFRAME_-275110_SPEC             = 'ANGLES'
      TKFRAME_-275110_UNITS            = 'DEGREES'
      TKFRAME_-275110_ANGLES           = ( 0.0, -90.0,  0.0 )
      TKFRAME_-275110_AXES             = ( 1,     2,    3   )

   \begintext


INTEGRAL NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the INTEGRAL mission.
   Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  Spacecraft:
  ----------------------------------------------------------------

      This table presents the INTEGRAL Spacecraft and its main
      structures' names.

      ---------------------  -------  --------------------------
       Name                   ID       Synonyms
      ---------------------  -------  --------------------------
       INTEGRAL                 -275
       INTEGRAL_SPACECRAFT   -275000   INTEGRAL_SC
      ---------------------  -------  --------------------------

      Notes:

         -- 'INTEGRAL_SC' and 'INTEGRAL_SPACECRAFT' are synonyms and
            all map to the INTEGRAL s/c bus structure ID (-275000);

     \begindata

        NAIF_BODY_NAME += ( 'INTEGRAL'                        )
        NAIF_BODY_CODE += ( -275                              )

        NAIF_BODY_NAME += ( 'INTEGRAL_SC'                     )
        NAIF_BODY_CODE += ( -275000                           )

        NAIF_BODY_NAME += ( 'INTEGRAL_SPACECRAFT'             )
        NAIF_BODY_CODE += ( -275000                           )

     \begintext


  IBIS:
  -----

    This table summarizes IBIS IDs:

      ----------------------  --------
       Name                    ID
      ----------------------  --------
      INTEGRAL_IBIS            -275110
      ----------------------  --------

    Name-ID Mapping keywords:

   \begindata

       NAIF_BODY_NAME += ( 'INTEGRAL_IBIS'                    )
       NAIF_BODY_CODE += ( -275110                            )

       NAIF_BODY_NAME += ( 'INTEGRAL_IBIS_FC'                 )
       NAIF_BODY_CODE += ( -275111                            )

   \begintext


End of FK file.