KPL/FK

Cassini-Huygens Probe (HUYGENS) Frames Kernel
==============================================================================

   This frame kernel contains a complete set of frame definitions for the
   Cassini-Huygens Probe (HUYGENS) including definitions for the HUYGENS
   structures and HUYGENS science instrument frames. This kernel also
   contains NAIF ID/name mapping for the HUYGENS instruments.


Version and Date
------------------------------------------------------------------------

   Version 0.1 -- Jul 30, 2018 -- Marc Costa Sitja (ESAC/ESA)

      Format corrections for first release.

   Version 0.0 -- Jul 30, 2018 -- Alfredo Escalante (ESAC/ESA)

      First Draft.


References
------------------------------------------------------------------------

    1. ``Frames Required Reading'', NAIF

    2. ``Kernel Pool Required Reading'', NAIF

    3. ``C-Kernel Required Reading'', NAIF

    4. ``HUYGENS User Manual Description'', HUY.AS/c.100.OP.0201,
        Aerospatiale Espace and Defense, 15th September 1997


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           esa_spice@sciops.esa.int, marc.costa@esa.int

           Alfredo Escalante Lopez
           alfredoescalante95@gmail.com


Implementation Notes
------------------------------------------------------------------------

  This file is used by the SPICE system as follows: programs that make use
  of this frame kernel must "load" the kernel normally during program
  initialization. Loading the kernel associates the data items with
  their names in a data structure called the "kernel pool".  The SPICELIB
  routine FURNSH loads a kernel into the pool as shown below:

    FORTRAN: (SPICELIB)

      CALL FURNSH ( frame_kernel_name )

    C: (CSPICE)

      furnsh_c ( frame_kernel_name );

    IDL: (ICY)

      cspice_furnsh, frame_kernel_name

    MATLAB: (MICE)

         cspice_furnsh ( 'frame_kernel_name' )

    PYTHON: (SPICEYPY)*

         furnsh( frame_kernel_name )

  In order for a program or routine to extract data from the pool, the
  SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
  more details.

  This file was created and may be updated with a text editor or word
  processor.

  * SPICEPY is a non-official, community developed Python wrapper for the
    NAIF SPICE toolkit. Its development is managed on Github.
    It is available at: https://github.com/AndrewAnnex/SpiceyPy


HUYGENS NAIF ID Codes -- Summary Section
------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the TGO spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "HUYGENS NAIF ID Codes -- Definition
   Section" at the end of this file):

   HUYGENS Probe and Probe Structures names/IDs:

            HUYGENS            -150          (synonyms: HUYGENS PROBE,
                                              CASSINI PROBE and CASP)
   DISR names/IDs:

            HUYGENS_DISR       -150100
	          HUYGENS_DISR_SLI   -150101
	          HUYGENS_DISR_MRI   -150102
	          HUYGENS_DISR_HRI   -150103



HUYGENS Frames
------------------------------------------------------------------------

   The following HUYGENS frames are defined in this kernel file:

        Name                      Relative to                 Type    NAIF ID
      ======================    ==========================   =======  =======

   HUYGENS Probe and Probe Structures frames:
   ------------------------------------------------
        HUYGENS_NADIR             J2000                        DYNAMIC -150001
        HUYGENS_PROBE             HUYGENS_NADIR                FIXED   -150000

   Science Instrument frames:
   --------------------------
        HUYGENS_DISR              HUYGENS_PROBE                CK      -150100


HUYGENS Probe Frames Hierarchy
------------------------------------------------------------------------

   The diagram below shows the Cassini-Huygens Probe frames hierarchy:


                           "J2000" INERTIAL
                           ----------------
                                  |
                                  |<-pck
                                  |
                                  v
                             "IAU_TITAN"
                           TITAN BODY FIXED
                           ----------------
                                  |
                                  |<-dyn
                                  |
                                  v
                            "HUYGENS_NADIR"
                            ---------------
                                  |
                                  |<--- ck
                                  |
                                  V
                            "HUYGENS_PROBE"
                            ---------------
                                  |
                                  |<--- ck
                                  |
                                  V
                            "HUYGENS_DISR"
                            --------------



Probe Configuration Description
------------------------------------------------------------------------

   The Probe can be schematically described as a kernel surrounded by a
   shell, the kernel carrying all the experiments and service units
   operating during the descent while the shell protects it during the
   Cruise, Coast and Entry phases and is then jettisoned at the beginning
   of the Descent. The kernel is mainly constituted by two platforms
   supporting the Experiments and the equipment units assembled by light
   secondary structures.

   The jettisonable shell is constituted by a spherical-conical front shield
   and a back cover to complete the thermal protection during atmospheric
   entry. This jettison is aerodinamically operated by a Main Parachute
   large enough to pull the kernel rearwards from the Front Shield. This
   Main Parachute itself is extracted, along with the Back Cover, by the
   Pilot Chute which deployment is triggered by an acceleration threshold
   and extracted by a Pilot chute Deployment device (PDD).

   The threshold is detected by the Command and Data Management Subsystem
   (CDMS) accelerometers, then the Main Chute is jettisoned and a smaller
   Stabilizer Chute is deployed which allows the required Descent time.

   Swivels ensure decoupling of the Probe from possible parachute rotations.
   Probe controlled spin is provided by a series of aerodynamic winglets.


HUYGENS Probe and Probe Structures Frames
------------------------------------------------------------------------

   This section of the file contains the definitions of the probe
   and probe structures frames.

   DISCLAIMER: The origin of the frames specified in the following
   definitions are not implemented. The ``true'' origin of all frames
   is in the center of the HUYGENS_PROBE frame, the center of which
   is defined by the position given by the SPK (ephemeris) kernel in
   use.


HUYGENS Nadir frame
----------------------------------------------------------

   Definition:
   -----------

   The HUYGENS Nadir frame is defined as follows:

      -  +Z axis is aligned with the component of Titan's north pole
         direction orthogonal to the +X axis (+Z axis points North);

      -  +X axis is the primary vector and points from  center of Titan
         to HUYGENS (anti-Nadir direction);

      -  +Y axis completes the right-handed system (points West);

      -  the original of this frame is the probe's center of mass.

   All vectors are geometric: no corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame.

   Both the primary and the secondary vector are defined as an
   'observer-target position' vectors, therefore, the ephemeris data
   required to compute both the TGO-Mars position and the TGO-Sun
   position in J2000 frame have to be loaded before using this frame.


   Remarks:
   --------
   Since the primary and secondary vectors of this frame are defined
   based on the TGO-Mars position and TGO-Sun position vectors, the usage
   of different ephemerides to compute these vectors may lead to different
   frame orientation at given time.


   \begindata

      FRAME_HUYGENS_NADIR          = -150001
      FRAME_-150001_NAME           = 'HUYGENS_NADIR'
      FRAME_-150001_CLASS          = 5
      FRAME_-150001_CLASS_ID       = -150001
      FRAME_-150001_CENTER         = -150
      FRAME_-150001_RELATIVE       = 'J2000'
      FRAME_-150001_DEF_STYLE      = 'PARAMETERIZED'
      FRAME_-150001_FAMILY         = 'TWO-VECTOR'
      FRAME_-150001_PRI_AXIS       = '-X'
      FRAME_-150001_PRI_VECTOR_DEF = 'OBSERVER_TARGET_POSITION'
      FRAME_-150001_PRI_OBSERVER   = 'HUYGENS'
      FRAME_-150001_PRI_TARGET     = 'TITAN'
      FRAME_-150001_PRI_ABCORR     = 'NONE'
      FRAME_-150001_SEC_AXIS       = 'Y'
      FRAME_-150001_SEC_VECTOR_DEF = 'CONSTANT'
      FRAME_-150001_SEC_SPEC       = 'RECTANGULAR'
      FRAME_-150001_SEC_VECTOR     = ( 0, 0, 1 )
      FRAME_-150001_SEC_FRAME      = 'IAU_TITAN'
      FRAME_-150001_SEC_ABCORR     = 'NONE'

   \begintext


HUYGENS Probe Frame
----------------------------------------------------------

   The Probe frame is a structural reference frame, defined when the probe
   has ejected the front and back shields and is in descent configuration.
   According to [4] the HUYGENS probe reference frame -- HUYGENS_PROBE --
   is defined as follows:

      -  +Z axis is parallel to the line that joins the origin of the
         reference frame with the DISR instrument center;

      -  +X axis is coincident with the axis of revolution of the probe
         cover;

      -  +Y axis completes the right-handed frame.

      -  the origin of this frame is located on the bottom face of the
         experiment platform.


   These diagrams illustrate the TGO_SPACECRAFT frame:

   -Z Probe side view:
   -------------------


                                +Xpr
                                 ^
                                 |
                                 |
                ----------------------------------
               /                                   \
              /                                     \
             /                                       \
             --------------------|--------------------
            |                    |                    |
            ---------------------x--------------------  ----> +Ypr
            \_                                       _/
              \_ \   \   \   |   |   |   /   /   /__/
                 \_______________________________/          +Zpr is into
                                                             the page.


   -Z Probe side view:
   -------------------

                             _______
                      ______|_______|_____
                  ___/      | DISR  |      \___
                 /          |_______|          \
              __/                               \__
             /                 +Zpr                \
            /                   ^                   \
           |                    |                    |
           |                    |                    |
           |                    |                    |
           |                    o-------> +Ypr       |
					 |                                         |
           |                                         |
					 |                                         |    +Xpr is out of
            \                                       /      the page.
             \__                                 __/
                \                               /
                 \___                       ___/
                     \_____________________/


   Since the Probe kernel attitude with respect to the Huygens Nadir dynamic
   frame is provided by a C-kernel (see [3] for more information), this frame
   is defined as a CK-based frame.

   These sets of keywords define the HUYGENS_PROBE frame:

   \begindata

      FRAME_HUYGENS_PROBE       = -150000
      FRAME_-150000_NAME        = 'HUYGENS_PROBE'
      FRAME_-150000_CLASS       = 3
      FRAME_-150000_CLASS_ID    = -150000
      FRAME_-150000_CENTER      = -150
      CK_-150000_SCLK           = -150
      CK_-150000_SPK            = -150

   \begintext



DISR Frame
-------------------------------------------------------------------------------

   This section of the file contains the definition of the
   Descent Imager/Spectral Radiometer (DISR) instrument is rigidly
   mounted on the Probe. Therefore, the  frame associated with it
   -- HUYGENS_DSIR --  is specified as a fixed offset frame
   with its orientation given relative to the HUYGENS_PROBE frame.

  The DSIR frame is defined as follows:

      -  +Z axis is co-aligned with the probe +Z axis and is the
         the sensor boresight;

      -  +X axis is nominally co-aligned with the probe +X axis;

      -  +Y axis completes the right-handed frame;

      -  the origin of this frame is located at the sensor central pixel.


   These diagrams illustrate the HUYGENS_DSIR frame with respect to the
   probe frame.


   -Z Probe side view:
   -------------------

                              +Zds
                                ^
                                |
                                |
                             ___|___
                      ______|___o-------> +Yds
                  ___/      | DISR  |      \___
                 /          |_______|          \
              __/                               \__
             /                 +Zpr                \
            /                   ^                   \
           |                    |                    |
           |                    |                    |
           |                    |                    |
           |                    o-------> +Ypr       |
					 |                                         |
           |                                         |
					 |                                         |    +Xpr and +Xds are
            \                                       /      ouf of the page.
             \__                                 __/
                \                               /
                 \___                       ___/
                     \_____________________/


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_HUYGENS_DISR               =  -150100
      FRAME_-150100_NAME               = 'HUYGENS_DISR'
      FRAME_-150100_CLASS              =   4
      FRAME_-150100_CLASS_ID           =  -150100
      FRAME_-150100_CENTER             =  -150
      TKFRAME_-150100_RELATIVE         = 'HUYGENS_PROBE'
      TKFRAME_-150100_SPEC             = 'ANGLES'
      TKFRAME_-150100_UNITS            = 'DEGREES'
      TKFRAME_-150100_AXES             = ( 3,     2,      1   )
      TKFRAME_-150100_ANGLES           = ( 0.0,   0.0,    0.0 )

   \begintext


HUYGENS NAIF ID Codes -- Definition Section
========================================================================

   This section contains name to NAIF ID mappings for the Huygens Probe.
   Once the contents of this file is loaded into the KERNEL POOL, these
   mappings become available within SPICE, making it possible to use names
   instead of ID code in the high level SPICE routine calls.

      Name                     ID       Synonyms
      ---------------------    -------  -----------------------

   Probe:
   ------

      HUYGENS                  -150      HUYGENS PROBE
                                         CASSINI PROBE
                                         CASP

      HUYGENS_PROBE            -150000   HUYGENS_SPACECRAFT
                                         HUYGENS_BUS

   DISR:
   -----

      HUYGENS_DISR             -150100
	    HUYGENS_DISR_SLI         -150101
	    HUYGENS_DISR_MRI         -150102
	    HUYGENS_DISR_HRI         -150103


   The mappings summarized in this table are implemented by the keywords
   below.

   \begindata

      NAIF_BODY_NAME += ( 'CASSINI PROBE'                   )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'CASP'                            )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'HUYGENS'                         )
      NAIF_BODY_CODE += ( -150                              )

      NAIF_BODY_NAME += ( 'HUYGENS_SPACECRAFT'              )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_BUS'                     )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_PROBE'                   )
      NAIF_BODY_CODE += ( -150000                           )

      NAIF_BODY_NAME += ( 'HUYGENS_DISR'                    )
      NAIF_BODY_CODE += ( -150100                           )

	    NAIF_BODY_NAME += ( 'HUYGENS_DISR_SLI'                )
      NAIF_BODY_CODE += ( -150101                           )

	    NAIF_BODY_NAME += ( 'HUYGENS_DISR_MRI'                )
      NAIF_BODY_CODE += ( -150102                           )

	    NAIF_BODY_NAME += ( 'HUYGENS_DISR_HRI'                )
      NAIF_BODY_CODE += ( -150103                           )

\begintext


End of FK file.
