KPL/MK

Meta-kernel for GNSS Dataset v002 -- Operational 20251205_001
============================================================================

   This meta-kernel lists the GNSS Operational SPICE kernels
   that provide information for the Operational scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the GNSS Operational scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.6.7.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/GNSS/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/GNSS/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the GNSS SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on December 5, 2025 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was gnss_v002_20251205_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/fk/earth_topo_201023.tf'
                           '$KERNELS/fk/estrack_v04.tf'
                           '$KERNELS/fk/gnss_v21.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/de-403-masses.tpc'
                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/pck/earth_070425_370426_predict.bpc'
                           '$KERNELS/pck/earth_000101_221022_220729.bpc'

                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/gnss_221113_251211_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v002_20251205_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'gnss_v002_20251205_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.