KPL/FK

GNSS Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   Global Navigation Satellite System (GNSS). This kernel also contains
   NAIF ID/name mapping for the different GNSS spacecrafts.


Version and Date
------------------------------------------------------------------------

   Version 2.1 -- October 22, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.6.3.

      The following updates were performed:
         - Added body and frame for 'COSMOS_2596'

   Version 2.0 -- October 3, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.6.1.

      The following updates were performed:
         - Renamed 'GPS_BII-4' to 'GPS_BIIR-4'

   Version 1.9 -- October 2, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.6.1.

      The following updates were performed:
         - Renamed 'GPS_BIIR-4' to 'GPS_BII-4'

   Version 1.8 -- June 10, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.9.

      The following updates were performed:
         - Renamed synonym 'PRN_21' to 'PRN_21_GPS_BIIR-9' for 'GPS_BIIR-9'

   Version 1.7 -- June 8, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.8.

      The following updates were performed:
         - Added body and frame for 'GPS_BIII-8'

   Version 1.6 -- April 29, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.7.

      The following updates were performed:
         - Renamed 'E_117_W_B' to 'EUTELSAT_117_WEST_B'
         - Renamed 'E_5_W_B' to 'EUTELSAT_5_WEST_B'
         - Renamed 'IOR-W' to 'INMARSAT_4-F2'

   Version 1.5 -- April 15, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.7.

      The following updates were performed:
         - Added body and frame for 'E_5_W_B'

   Version 1.4 -- April 5, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.6.

      The following updates were performed:
         - Added body and frame for 'COSMOS_2584'

   Version 1.3 -- February 27, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.4.

      The following updates were performed:
         - Added body and frame for 'BEIDOU-3_M25'
         - Added body and frame for 'BEIDOU-3_M27'

   Version 1.2 -- January 30, 2025

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.4.1.

      The following updates were performed:
         - Renamed 'IRNSS-1J' to 'NVS-01'
         - Added body and frame for 'NVS-02'

   Version 1.1 -- December 22, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.3.8.

      The following updates were performed:
         - Added body and frame for 'GPS_BIII-7'

   Version 1.0 -- October 5, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.3.0.

      The following updates were performed:
         - Added synonym 'C62' to 'BEIDOU-3_G4'
         - Added synonym 'C48' to 'BEIDOU-3_M26'
         - Renamed 'BEIDOU-3_M25' to 'BEIDOU-3_M28'
         - Added body and frame for 'GSAT0226'
         - Added body and frame for 'GSAT0232'

   Version 0.9 -- July 27, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.1.9.

      The following updates were performed:
         - Added synonym 'GALILEO_30' to 'GSAT0227'

   Version 0.8 -- July 23, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.1.9.

      The following updates were performed:
         - Added synonym 'GALILEO-PFM' to 'GSAT0101'
         - Added synonym 'GALILEO-FM2' to 'GSAT0102'
         - Added synonym 'GALILEO-FM3' to 'GSAT0103'
         - Added synonym 'GALILEO_5' to 'GSAT0201'
         - Added synonym 'GALILEO_6' to 'GSAT0202'
         - Added synonym 'GALILEO_7' to 'GSAT0203'
         - Added synonym 'GALILEO_8' to 'GSAT0204'
         - Added synonym 'GALILEO_9' to 'GSAT0205'
         - Added synonym 'GALILEO_10' to 'GSAT0206'
         - Added synonym 'GALILEO_15' to 'GSAT0207'
         - Added synonym 'GALILEO_11' to 'GSAT0208'
         - Added synonym 'GALILEO_12' to 'GSAT0209'
         - Added synonym 'GALILEO_13' to 'GSAT0210'
         - Added synonym 'GALILEO_14' to 'GSAT0211'
         - Added synonym 'GALILEO_16' to 'GSAT0212'
         - Added synonym 'GALILEO_17' to 'GSAT0213'
         - Added synonym 'GALILEO_18' to 'GSAT0214'
         - Added synonym 'GALILEO_19' to 'GSAT0215'
         - Added synonym 'GALILEO_20' to 'GSAT0216'
         - Added synonym 'GALILEO_21' to 'GSAT0217'
         - Added synonym 'GALILEO_22' to 'GSAT0218'
         - Added synonym 'GALILEO_23' to 'GSAT0219'
         - Added synonym 'GALILEO_24' to 'GSAT0220'
         - Added synonym 'GALILEO_25' to 'GSAT0221'
         - Added synonym 'GALILEO_26' to 'GSAT0222'
         - Added synonym 'GALILEO_27' to 'GSAT0223'
         - Added synonym 'GALILEO_28' to 'GSAT0224'
         - Added synonym 'GALILEO_29' to 'GSAT0225'

   Version 0.7 -- May 19, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.1.3.

      The following updates were performed:
         - Added body and frame for 'GSAT0225'
         - Added body and frame for 'GSAT0227'

   Version 0.6 -- May 6, 2024

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v4.1.1.

      The following updates were performed:
         - Renamed 'NAVSTAR_65' to 'GPS_BIIF-1'
         - Renamed 'NAVSTAR_74' to 'GPS_BIIF-10'
         - Renamed 'NAVSTAR_75' to 'GPS_BIIF-11'
         - Renamed 'NAVSTAR_76' to 'GPS_BIIF-12'
         - Renamed 'NAVSTAR_67' to 'GPS_BIIF-3'
         - Renamed 'NAVSTAR_68' to 'GPS_BIIF-4'
         - Renamed 'NAVSTAR_69' to 'GPS_BIIF-5'
         - Renamed 'NAVSTAR_70' to 'GPS_BIIF-6'
         - Renamed 'NAVSTAR_71' to 'GPS_BIIF-7'
         - Renamed 'NAVSTAR_72' to 'GPS_BIIF-8'
         - Renamed 'NAVSTAR_73' to 'GPS_BIIF-9'
         - Renamed 'NAVSTAR_77' to 'GPS_BIII-1'
         - Renamed 'NAVSTAR_78' to 'GPS_BIII-2'
         - Renamed 'NAVSTAR_79' to 'GPS_BIII-3'
         - Renamed 'NAVSTAR_80' to 'GPS_BIII-4'
         - Renamed 'NAVSTAR_81' to 'GPS_BIII-5'
         - Renamed 'NAVSTAR_82' to 'GPS_BIII-6'
         - Renamed 'NAVSTAR_54' to 'GPS_BIIR-11'
         - Renamed 'NAVSTAR_56' to 'GPS_BIIR-13'
         - Renamed 'NAVSTAR_43' to 'GPS_BIIR-2'
         - Renamed 'NAVSTAR_47' to 'GPS_BIIR-4'
         - Added body and frame for 'GPS_BIIR-5'
         - Renamed 'NAVSTAR_51' to 'GPS_BIIR-8'
         - Renamed 'NAVSTAR_52' to 'GPS_BIIR-9'
         - Renamed 'NAVSTAR_57' to 'GPS_BIIRM-1'
         - Renamed 'NAVSTAR_58' to 'GPS_BIIRM-2'
         - Renamed 'NAVSTAR_59' to 'GPS_BIIRM-3'
         - Renamed 'NAVSTAR_60' to 'GPS_BIIRM-4'
         - Renamed 'NAVSTAR_61' to 'GPS_BIIRM-5'
         - Renamed 'NAVSTAR_62' to 'GPS_BIIRM-6'
         - Renamed 'NAVSTAR_64' to 'GPS_BIIRM-8'
         - Added synonym 'EGNOS_PRN_123' to 'ASTRA_5B'
         - Renamed 'ANIK_F1R' to 'CRE'
         - Renamed 'EUTELSAT_117_WEST_B' to 'E_117_W_B'
         - Added synonym 'WAAS_PRN_135' to 'GALAXY_30'
         - Renamed 'INMARSAT_4-F2' to 'IOR-W'
         - Renamed 'LUCH-5A' to 'LUCH_5A'
         - Renamed 'LUCH-5B' to 'LUCH_5B'
         - Renamed 'LUCH-5V' to 'LUCH_5V'
         - Added synonym 'QZSS_PRN_196' to 'QZS-1R'
         - Added synonym 'QZSS_PRN_194' to 'QZS-2'
         - Added synonym 'QZSS_PRN_199' to 'QZS-3'
         - Added synonym 'QZSS_PRN_195' to 'QZS-4'
         - Added synonym 'WAAS_PRN_133' to 'SES-15'
         - Added synonym 'EGNOS_PRN_136' to 'SES-5'
         - Added synonym '702K' to 'COSMOS_2501'
         - Added synonym '705K' to 'COSMOS_2547'
         - Added synonym '706K' to 'COSMOS_2557'
         - Added synonym '707K' to 'COSMOS_2559'
         - Added synonym '703K' to 'COSMOS_2569'
         - Added synonym 'C04' to 'BEIDOU-2_G4'
         - Added synonym 'C05' to 'BEIDOU-2_G5'
         - Added synonym 'C02' to 'BEIDOU-2_G6'
         - Added synonym 'C03' to 'BEIDOU-2_G7'
         - Added synonym 'C01' to 'BEIDOU-2_G8'
         - Added synonym 'C06' to 'BEIDOU-2_IGSO-1'
         - Added synonym 'C07' to 'BEIDOU-2_IGSO-2'
         - Added synonym 'C08' to 'BEIDOU-2_IGSO-3'
         - Added synonym 'C09' to 'BEIDOU-2_IGSO-4'
         - Added synonym 'C10' to 'BEIDOU-2_IGSO-5'
         - Added synonym 'C13' to 'BEIDOU-2_IGSO-6'
         - Added synonym 'C16' to 'BEIDOU-2_IGSO-7'
         - Added synonym 'C11' to 'BEIDOU-2_M3'
         - Added synonym 'C12' to 'BEIDOU-2_M4'
         - Added synonym 'C14' to 'BEIDOU-2_M6'
         - Added synonym 'C31' to 'BEIDOU-3S_IGSO-1S'
         - Added synonym 'C56' to 'BEIDOU-3S_IGSO-2S'
         - Added synonym 'C57' to 'BEIDOU-3S_M1S'
         - Added synonym 'C58' to 'BEIDOU-3S_M2S'
         - Added synonym 'C59' to 'BEIDOU-3_G1'
         - Added synonym 'C60' to 'BEIDOU-3_G2'
         - Added synonym 'C61' to 'BEIDOU-3_G3'
         - Added synonym 'C38' to 'BEIDOU-3_IGSO-1'
         - Added synonym 'C39' to 'BEIDOU-3_IGSO-2'
         - Added synonym 'C40' to 'BEIDOU-3_IGSO-3'
         - Added synonym 'C19' to 'BEIDOU-3_M1'
         - Added synonym 'C30' to 'BEIDOU-3_M10'
         - Added synonym 'C25' to 'BEIDOU-3_M11'
         - Added synonym 'C26' to 'BEIDOU-3_M12'
         - Added synonym 'C32' to 'BEIDOU-3_M13'
         - Added synonym 'C33' to 'BEIDOU-3_M14'
         - Added synonym 'C34' to 'BEIDOU-3_M15'
         - Added synonym 'C35' to 'BEIDOU-3_M16'
         - Added synonym 'C36' to 'BEIDOU-3_M17'
         - Added synonym 'C37' to 'BEIDOU-3_M18'
         - Added synonym 'C41' to 'BEIDOU-3_M19'
         - Added synonym 'C20' to 'BEIDOU-3_M2'
         - Added synonym 'C42' to 'BEIDOU-3_M20'
         - Added synonym 'C43' to 'BEIDOU-3_M21'
         - Added synonym 'C44' to 'BEIDOU-3_M22'
         - Added synonym 'C45' to 'BEIDOU-3_M23'
         - Added synonym 'C46' to 'BEIDOU-3_M24'
         - Added synonym 'C21' to 'BEIDOU-3_M3'
         - Added synonym 'C22' to 'BEIDOU-3_M4'
         - Added synonym 'C23' to 'BEIDOU-3_M5'
         - Added synonym 'C24' to 'BEIDOU-3_M6'
         - Added synonym 'C27' to 'BEIDOU-3_M7'
         - Added synonym 'C28' to 'BEIDOU-3_M8'
         - Added synonym 'C29' to 'BEIDOU-3_M9'
         - Added synonym 'GAGAN_PRN_128' to 'GSAT-10'
         - Added synonym 'GAGAN_PRN_139' to 'GSAT-15'
         - Added synonym 'GAGAN_PRN_127' to 'GSAT-8'
         - Added synonym 'PRN_E11' to 'GSAT0101'
         - Added synonym 'PRN_E12' to 'GSAT0102'
         - Added synonym 'PRN_E19' to 'GSAT0103'
         - Added synonym 'PRN_E18' to 'GSAT0201'
         - Added synonym 'PRN_E14' to 'GSAT0202'
         - Added synonym 'PRN_E26' to 'GSAT0203'
         - Added synonym 'PRN_E22' to 'GSAT0204'
         - Added synonym 'PRN_E24' to 'GSAT0205'
         - Added synonym 'PRN_E30' to 'GSAT0206'
         - Added synonym 'PRN_E07' to 'GSAT0207'
         - Added synonym 'PRN_E08' to 'GSAT0208'
         - Added synonym 'PRN_E09' to 'GSAT0209'
         - Added synonym 'PRN_E01' to 'GSAT0210'
         - Added synonym 'PRN_E02' to 'GSAT0211'
         - Added synonym 'PRN_E03' to 'GSAT0212'
         - Added synonym 'PRN_E04' to 'GSAT0213'
         - Added synonym 'PRN_E05' to 'GSAT0214'
         - Added synonym 'PRN_E21' to 'GSAT0215'
         - Added synonym 'PRN_E25' to 'GSAT0216'
         - Added synonym 'PRN_E27' to 'GSAT0217'
         - Added synonym 'PRN_E31' to 'GSAT0218'
         - Added synonym 'PRN_E36' to 'GSAT0219'
         - Added synonym 'PRN_E13' to 'GSAT0220'
         - Added synonym 'PRN_E15' to 'GSAT0221'
         - Added synonym 'PRN_E33' to 'GSAT0222'
         - Added synonym 'PRN_E34' to 'GSAT0223'
         - Added synonym 'PRN_E10' to 'GSAT0224'

   Version 0.5 -- December 29, 2023

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v3.9.5.

      The following updates were performed:
         - Added body and frame for 'COSMOS_2569'
         - Added body and frame for 'BEIDOU-3_M25'
         - Added body and frame for 'BEIDOU-3_M26'

   Version 0.4 -- November 13, 2023 -- Ricardo Valles Blanco, ESAC/ESA

      - Renamed frames with suffix '_NPO' to suffix '_IGS'.
      - Added frames from manufacturer specifications relative to IGS.

   Version 0.3 -- June 8, 2023

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v3.7.7.

      The following updates were performed:
         - Renamed 'GPS_BIIR-2' to 'NAVSTAR_43'
         - Renamed 'GPS_BIIR-4' to 'NAVSTAR_47'
         - Renamed 'GPS_BIIR-8' to 'NAVSTAR_51'
         - Renamed 'GPS_BIIR-9' to 'NAVSTAR_52'
         - Renamed 'GPS_BIIR-11' to 'NAVSTAR_54'
         - Renamed 'GPS_BIIR-13' to 'NAVSTAR_56'
         - Renamed 'GPS_BIIRM-1' to 'NAVSTAR_57'
         - Renamed 'GPS_BIIRM-2' to 'NAVSTAR_58'
         - Renamed 'GPS_BIIRM-3' to 'NAVSTAR_59'
         - Renamed 'GPS_BIIRM-4' to 'NAVSTAR_60'
         - Renamed 'GPS_BIIRM-5' to 'NAVSTAR_61'
         - Renamed 'GPS_BIIRM-6' to 'NAVSTAR_62'
         - Renamed 'GPS_BIIRM-8' to 'NAVSTAR_64'
         - Renamed 'GPS_BIIF-1' to 'NAVSTAR_65'
         - Renamed 'GPS_BIIF-2' to 'NAVSTAR_66'
         - Renamed 'GPS_BIIF-3' to 'NAVSTAR_67'
         - Renamed 'GPS_BIIF-4' to 'NAVSTAR_68'
         - Renamed 'GPS_BIIF-5' to 'NAVSTAR_69'
         - Renamed 'GPS_BIIF-6' to 'NAVSTAR_70'
         - Renamed 'GPS_BIIF-7' to 'NAVSTAR_71'
         - Renamed 'GPS_BIIF-8' to 'NAVSTAR_72'
         - Renamed 'GPS_BIIF-9' to 'NAVSTAR_73'
         - Renamed 'GPS_BIIF-10' to 'NAVSTAR_74'
         - Renamed 'GPS_BIIF-11' to 'NAVSTAR_75'
         - Renamed 'GPS_BIIF-12' to 'NAVSTAR_76'
         - Renamed 'GPS_BIII-1' to 'NAVSTAR_77'
         - Renamed 'GPS_BIII-2' to 'NAVSTAR_78'
         - Renamed 'GPS_BIII-3' to 'NAVSTAR_79'
         - Renamed 'GPS_BIII-4' to 'NAVSTAR_80'
         - Renamed 'GPS_BIII-5' to 'NAVSTAR_81'
         - Renamed 'GPS_BIII-6' to 'NAVSTAR_82'
         - Renamed 'CRE' to 'ANIK_F1R'
         - Renamed 'E_117_W_B' to 'EUTELSAT_117_WEST_B'
         - Added synonym 'G-30' to 'GALAXY_30'
         - Renamed 'IOR-W' to 'INMARSAT_4-F2'
         - Added body and frame for 'IRNSS-1J'
         - Renamed 'LUCH_5A' to 'LUCH-5A'
         - Renamed 'LUCH_5B' to 'LUCH-5B'
         - Renamed 'LUCH_5V' to 'LUCH-5V'
         - Added synonym 'MICHIBIKI-1' to 'QZS-1'
         - Added synonym 'MICHIBIKI-2' to 'QZS-2'
         - Added synonym 'MICHIBIKI-3' to 'QZS-3'
         - Added synonym 'MICHIBIKI-4' to 'QZS-4'
         - Added body and frame for 'BEIDOU-3_G4'
         - Added synonym 'GALILEO-PFM' to 'GSAT0101'
         - Added synonym 'GALILEO-FM2' to 'GSAT0102'
         - Added synonym 'GALILEO-FM3' to 'GSAT0103'
         - Added synonym 'GALILEO-FM4' to 'GSAT0104'
         - Added synonym 'GALILEO_5' to 'GSAT0201'
         - Added synonym 'GALILEO_6' to 'GSAT0202'
         - Added synonym 'GALILEO_7' to 'GSAT0203'
         - Added synonym 'GALILEO_8' to 'GSAT0204'
         - Added synonym 'GALILEO_9' to 'GSAT0205'
         - Added synonym 'GALILEO_10' to 'GSAT0206'
         - Added synonym 'GALILEO_15' to 'GSAT0207'
         - Added synonym 'GALILEO_11' to 'GSAT0208'
         - Added synonym 'GALILEO_12' to 'GSAT0209'
         - Added synonym 'GALILEO_13' to 'GSAT0210'
         - Added synonym 'GALILEO_14' to 'GSAT0211'
         - Added synonym 'GALILEO_16' to 'GSAT0212'
         - Added synonym 'GALILEO_17' to 'GSAT0213'
         - Added synonym 'GALILEO_18' to 'GSAT0214'
         - Added synonym 'GALILEO_19' to 'GSAT0215'
         - Added synonym 'GALILEO_20' to 'GSAT0216'
         - Added synonym 'GALILEO_21' to 'GSAT0217'
         - Added synonym 'GALILEO_22' to 'GSAT0218'
         - Added synonym 'GALILEO_23' to 'GSAT0219'
         - Added synonym 'GALILEO_24' to 'GSAT0220'
         - Added synonym 'GALILEO_25' to 'GSAT0221'
         - Added synonym 'GALILEO_26' to 'GSAT0222'
         - Added synonym 'GALILEO_27' to 'GSAT0223'
         - Added synonym 'GALILEO_28' to 'GSAT0224'

   Version 0.2 -- February 28, 2023

      This file was generated with the Auxiliary Data Conversion
      System version: ADCSng v3.6.6.

      The following updates were performed:
         - Added body and frame for 'GPS_BIII-6'
         - Added synonym 'I01' to 'IRNSS-1A'
         - Added synonym 'I02' to 'IRNSS-1B'
         - Added synonym 'I03' to 'IRNSS-1C'
         - Added synonym 'I04' to 'IRNSS-1D'
         - Added synonym 'I05' to 'IRNSS-1E'
         - Added synonym 'I06' to 'IRNSS-1F'
         - Added synonym 'I07' to 'IRNSS-1G'
         - Added synonym 'I09' to 'IRNSS-1I'
         - Added synonym 'PRN_193_183' to 'QZS-1'
         - Added body and frame for 'QZS-1R'
         - Added synonym 'PRN_194_184' to 'QZS-2'
         - Added synonym 'PRN_199_189' to 'QZS-3'
         - Added synonym 'PRN_195_185' to 'QZS-4'
         - Added body and frame for 'COSMOS_2547'
         - Added body and frame for 'COSMOS_2557'
         - Added body and frame for 'COSMOS_2559'
         - Added body and frame for 'COSMOS_2564'
         - Renamed 'BEIDOU_6' to 'BEIDOU-2_G4'
         - Renamed 'BEIDOU_11' to 'BEIDOU-2_G5'
         - Renamed 'BEIDOU_16' to 'BEIDOU-2_G6'
         - Removed synonym 'C01' from 'BEIDOU_3'
         - Added synonym 'C01' to 'BEIDOU-2_G8'
         - Renamed 'BEIDOU_5' to 'BEIDOU-2_IGSO-1'
         - Renamed 'BEIDOU_7' to 'BEIDOU-2_IGSO-2'
         - Renamed 'BEIDOU_8' to 'BEIDOU-2_IGSO-3'
         - Renamed 'BEIDOU_9' to 'BEIDOU-2_IGSO-4'
         - Renamed 'BEIDOU_10' to 'BEIDOU-2_IGSO-5'
         - Renamed 'BEIDOU_IGSO-6' to 'BEIDOU-2_IGSO-6'
         - Renamed 'BEIDOU_IGSO-7' to 'BEIDOU-2_IGSO-7'
         - Renamed 'BEIDOU_12' to 'BEIDOU-2_M3'
         - Renamed 'BEIDOU_13' to 'BEIDOU-2_M4'
         - Renamed 'BEIDOU_15' to 'BEIDOU-2_M6'
         - Renamed 'BEIDOU_17' to 'BEIDOU-3S_IGSO-1S'
         - Renamed 'BEIDOU_20' to 'BEIDOU-3S_IGSO-2S'
         - Renamed 'BEIDOU_19' to 'BEIDOU-3S_M1S'
         - Renamed 'BEIDOU_18' to 'BEIDOU-3S_M2S'
         - Added synonym 'C60' to 'BEIDOU-3_G2'
         - Added synonym 'C61' to 'BEIDOU-3_G3'
         - Added synonym 'C40' to 'BEIDOU-3_IGSO-3'
         - Renamed 'BEIDOU-3_M8' to 'BEIDOU-3_M10'
         - Renamed 'BEIDOU-3_M12' to 'BEIDOU-3_M11'
         - Removed synonym 'C25' from 'BEIDOU-3_M11'
         - Renamed 'BEIDOU-3_M11' to 'BEIDOU-3_M12'
         - Removed synonym 'C26' from 'BEIDOU-3_M12'
         - Renamed 'BEIDOU-3_M16' to 'BEIDOU-3_M15'
         - Removed synonym 'C34' from 'BEIDOU-3_M15'
         - Renamed 'BEIDOU-3_M15' to 'BEIDOU-3_M16'
         - Removed synonym 'C35' from 'BEIDOU-3_M16'
         - Added synonym 'C41' to 'BEIDOU-3_M19'
         - Added synonym 'C42' to 'BEIDOU-3_M20'
         - Renamed 'BEIDOU-3_M22' to 'BEIDOU-3_M21'
         - Renamed 'BEIDOU-3_M21' to 'BEIDOU-3_M22'
         - Renamed 'BEIDOU-3_M24' to 'BEIDOU-3_M23'
         - Removed synonym 'C45' from 'BEIDOU-3_M23'
         - Renamed 'BEIDOU-3_M23' to 'BEIDOU-3_M24'
         - Removed synonym 'C46' from 'BEIDOU-3_M24'
         - Renamed 'BEIDOU-3_M6' to 'BEIDOU-3_M3'
         - Removed synonym 'C21' from 'BEIDOU-3_M5'
         - Renamed 'BEIDOU-3_M5' to 'BEIDOU-3_M4'
         - Removed synonym 'C22' from 'BEIDOU-3_M6'
         - Renamed 'BEIDOU-3_M9' to 'BEIDOU-3_M5'
         - Renamed 'BEIDOU-3_M10' to 'BEIDOU-3_M6'
         - Renamed 'BEIDOU-3_M3' to 'BEIDOU-3_M7'
         - Renamed 'BEIDOU-3_M4' to 'BEIDOU-3_M8'
         - Renamed 'BEIDOU-3_M7' to 'BEIDOU-3_M9'
         - Added body and frame for 'GSAT0223'
         - Added body and frame for 'GSAT0224'

   Version 0.1 -- February 10, 2023 -- Ricardo Valles Blanco, ESAC/ESA

      Fixed wrong indentations.

   Version 0.0 -- November 15, 2022 -- Ricardo Valles Blanco, ESAC/ESA

      Preliminary Version. Only basic IDs and frame definitions.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''

   4.   ``CelesTrak: Current GP Element Sets''
         https://celestrak.org/NORAD/elements/

   5.   ``GNSS satellite geometry and attitude models''
        O.Montenbruck et al., ``Advances in Space Research''
        Volume 56, Issue 6, 15 September 2015.
        https://doi.org/10.1016/j.asr.2015.06.019


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEYPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


GNSS Frames
-----------------------------------------------------------------------------

   The following GNSS frames are defined in this kernel file:

      Name                     Relative to              Type         NAIF ID
      =======================  =======================  ==========   =========

      Galileo spacecrafts frames:
      ---------------------------
      GSAT-10_IGS              J2000                    DYNAMIC      -38779000
      GSAT-15_IGS              J2000                    DYNAMIC      -41028000
      GSAT-8_IGS               J2000                    DYNAMIC      -37605000
      GSAT0101_IGS             J2000                    DYNAMIC      -37846000
      GSAT0101_MEC             GSAT0101_IGS             FIXED        -37846001
      GSAT0102_IGS             J2000                    DYNAMIC      -37847000
      GSAT0102_MEC             GSAT0102_IGS             FIXED        -37847001
      GSAT0103_IGS             J2000                    DYNAMIC      -38857000
      GSAT0103_MEC             GSAT0103_IGS             FIXED        -38857001
      GSAT0104_IGS             J2000                    DYNAMIC      -38858000
      GSAT0104_MEC             GSAT0104_IGS             FIXED        -38858001
      GSAT0201_IGS             J2000                    DYNAMIC      -40128000
      GSAT0201_MEC             GSAT0201_IGS             FIXED        -40128001
      GSAT0202_IGS             J2000                    DYNAMIC      -40129000
      GSAT0202_MEC             GSAT0202_IGS             FIXED        -40129001
      GSAT0203_IGS             J2000                    DYNAMIC      -40544000
      GSAT0203_MEC             GSAT0203_IGS             FIXED        -40544001
      GSAT0204_IGS             J2000                    DYNAMIC      -40545000
      GSAT0204_MEC             GSAT0204_IGS             FIXED        -40545001
      GSAT0205_IGS             J2000                    DYNAMIC      -40889000
      GSAT0205_MEC             GSAT0205_IGS             FIXED        -40889001
      GSAT0206_IGS             J2000                    DYNAMIC      -40890000
      GSAT0206_MEC             GSAT0206_IGS             FIXED        -40890001
      GSAT0207_IGS             J2000                    DYNAMIC      -41859000
      GSAT0207_MEC             GSAT0207_IGS             FIXED        -41859001
      GSAT0208_IGS             J2000                    DYNAMIC      -41175000
      GSAT0208_MEC             GSAT0208_IGS             FIXED        -41175001
      GSAT0209_IGS             J2000                    DYNAMIC      -41174000
      GSAT0209_MEC             GSAT0209_IGS             FIXED        -41174001
      GSAT0210_IGS             J2000                    DYNAMIC      -41550000
      GSAT0210_MEC             GSAT0210_IGS             FIXED        -41550001
      GSAT0211_IGS             J2000                    DYNAMIC      -41549000
      GSAT0211_MEC             GSAT0211_IGS             FIXED        -41549001
      GSAT0212_IGS             J2000                    DYNAMIC      -41860000
      GSAT0212_MEC             GSAT0212_IGS             FIXED        -41860001
      GSAT0213_IGS             J2000                    DYNAMIC      -41861000
      GSAT0213_MEC             GSAT0213_IGS             FIXED        -41861001
      GSAT0214_IGS             J2000                    DYNAMIC      -41862000
      GSAT0214_MEC             GSAT0214_IGS             FIXED        -41862001
      GSAT0215_IGS             J2000                    DYNAMIC      -43055000
      GSAT0215_MEC             GSAT0215_IGS             FIXED        -43055001
      GSAT0216_IGS             J2000                    DYNAMIC      -43056000
      GSAT0216_MEC             GSAT0216_IGS             FIXED        -43056001
      GSAT0217_IGS             J2000                    DYNAMIC      -43057000
      GSAT0217_MEC             GSAT0217_IGS             FIXED        -43057001
      GSAT0218_IGS             J2000                    DYNAMIC      -43058000
      GSAT0218_MEC             GSAT0218_IGS             FIXED        -43058001
      GSAT0219_IGS             J2000                    DYNAMIC      -43566000
      GSAT0219_MEC             GSAT0219_IGS             FIXED        -43566001
      GSAT0220_IGS             J2000                    DYNAMIC      -43567000
      GSAT0220_MEC             GSAT0220_IGS             FIXED        -43567001
      GSAT0221_IGS             J2000                    DYNAMIC      -43564000
      GSAT0221_MEC             GSAT0221_IGS             FIXED        -43564001
      GSAT0222_IGS             J2000                    DYNAMIC      -43565000
      GSAT0222_MEC             GSAT0222_IGS             FIXED        -43565001
      GSAT0223_IGS             J2000                    DYNAMIC      -49809000
      GSAT0223_MEC             GSAT0223_IGS             FIXED        -49809001
      GSAT0224_IGS             J2000                    DYNAMIC      -49810000
      GSAT0224_MEC             GSAT0224_IGS             FIXED        -49810001
      GSAT0225_IGS             J2000                    DYNAMIC      -59598000
      GSAT0225_MEC             GSAT0225_IGS             FIXED        -59598001
      GSAT0226_IGS             J2000                    DYNAMIC      -61183000
      GSAT0226_MEC             GSAT0226_IGS             FIXED        -61183001
      GSAT0227_IGS             J2000                    DYNAMIC      -59600000
      GSAT0227_MEC             GSAT0227_IGS             FIXED        -59600001
      GSAT0232_IGS             J2000                    DYNAMIC      -61182000
      GSAT0232_MEC             GSAT0232_IGS             FIXED        -61182001


      GPS spacecrafts frames:
      -----------------------
      GPS_BIIF-1_IGS           J2000                    DYNAMIC      -36585000
      GPS_BIIF-10_IGS          J2000                    DYNAMIC      -40730000
      GPS_BIIF-11_IGS          J2000                    DYNAMIC      -41019000
      GPS_BIIF-12_IGS          J2000                    DYNAMIC      -41328000
      GPS_BIIF-3_IGS           J2000                    DYNAMIC      -38833000
      GPS_BIIF-4_IGS           J2000                    DYNAMIC      -39166000
      GPS_BIIF-5_IGS           J2000                    DYNAMIC      -39533000
      GPS_BIIF-6_IGS           J2000                    DYNAMIC      -39741000
      GPS_BIIF-7_IGS           J2000                    DYNAMIC      -40105000
      GPS_BIIF-8_IGS           J2000                    DYNAMIC      -40294000
      GPS_BIIF-9_IGS           J2000                    DYNAMIC      -40534000
      GPS_BIII-1_IGS           J2000                    DYNAMIC      -43873000
      GPS_BIII-2_IGS           J2000                    DYNAMIC      -44506000
      GPS_BIII-3_IGS           J2000                    DYNAMIC      -45854000
      GPS_BIII-4_IGS           J2000                    DYNAMIC      -46826000
      GPS_BIII-5_IGS           J2000                    DYNAMIC      -48859000
      GPS_BIII-6_IGS           J2000                    DYNAMIC      -55268000
      GPS_BIII-7_IGS           J2000                    DYNAMIC      -62339000
      GPS_BIII-8_IGS           J2000                    DYNAMIC      -64202000
      GPS_BIIR-11_IGS          J2000                    DYNAMIC      -28190000
      GPS_BIIR-13_IGS          J2000                    DYNAMIC      -28474000
      GPS_BIIR-2_IGS           J2000                    DYNAMIC      -24876000
      GPS_BIIR-4_IGS           J2000                    DYNAMIC      -26360000
      GPS_BIIR-5_IGS           J2000                    DYNAMIC      -26407000
      GPS_BIIR-8_IGS           J2000                    DYNAMIC      -27663000
      GPS_BIIR-9_IGS           J2000                    DYNAMIC      -27704000
      GPS_BIIRM-1_IGS          J2000                    DYNAMIC      -28874000
      GPS_BIIRM-2_IGS          J2000                    DYNAMIC      -29486000
      GPS_BIIRM-3_IGS          J2000                    DYNAMIC      -29601000
      GPS_BIIRM-4_IGS          J2000                    DYNAMIC      -32260000
      GPS_BIIRM-5_IGS          J2000                    DYNAMIC      -32384000
      GPS_BIIRM-6_IGS          J2000                    DYNAMIC      -32711000
      GPS_BIIRM-8_IGS          J2000                    DYNAMIC      -35752000
      NAVSTAR_66_IGS           J2000                    DYNAMIC      -37753000
      NAVSTAR_66_MEC           NAVSTAR_66_IGS           FIXED        -37753001


      Glonass spacecrafts frames:
      ---------------------------
      COSMOS_2432_IGS          J2000                    DYNAMIC      -32276000
      COSMOS_2432_MEC          COSMOS_2432_IGS          FIXED        -32276001
      COSMOS_2433_IGS          J2000                    DYNAMIC      -32275000
      COSMOS_2433_MEC          COSMOS_2433_IGS          FIXED        -32275001
      COSMOS_2434_IGS          J2000                    DYNAMIC      -32393000
      COSMOS_2434_MEC          COSMOS_2434_IGS          FIXED        -32393001
      COSMOS_2436_IGS          J2000                    DYNAMIC      -32395000
      COSMOS_2436_MEC          COSMOS_2436_IGS          FIXED        -32395001
      COSMOS_2456_IGS          J2000                    DYNAMIC      -36111000
      COSMOS_2456_MEC          COSMOS_2456_IGS          FIXED        -36111001
      COSMOS_2457_IGS          J2000                    DYNAMIC      -36112000
      COSMOS_2457_MEC          COSMOS_2457_IGS          FIXED        -36112001
      COSMOS_2460_IGS          J2000                    DYNAMIC      -36402000
      COSMOS_2460_MEC          COSMOS_2460_IGS          FIXED        -36402001
      COSMOS_2475_IGS          J2000                    DYNAMIC      -37869000
      COSMOS_2475_MEC          COSMOS_2475_IGS          FIXED        -37869001
      COSMOS_2476_IGS          J2000                    DYNAMIC      -37867000
      COSMOS_2476_MEC          COSMOS_2476_IGS          FIXED        -37867001
      COSMOS_2477_IGS          J2000                    DYNAMIC      -37868000
      COSMOS_2477_MEC          COSMOS_2477_IGS          FIXED        -37868001
      COSMOS_2485_IGS          J2000                    DYNAMIC      -39155000
      COSMOS_2485_MEC          COSMOS_2485_IGS          FIXED        -39155001
      COSMOS_2492_IGS          J2000                    DYNAMIC      -39620000
      COSMOS_2492_MEC          COSMOS_2492_IGS          FIXED        -39620001
      COSMOS_2500_IGS          J2000                    DYNAMIC      -40001000
      COSMOS_2500_MEC          COSMOS_2500_IGS          FIXED        -40001001
      COSMOS_2501_IGS          J2000                    DYNAMIC      -40315000
      COSMOS_2501_MEC          COSMOS_2501_IGS          FIXED        -40315001
      COSMOS_2514_IGS          J2000                    DYNAMIC      -41330000
      COSMOS_2514_MEC          COSMOS_2514_IGS          FIXED        -41330001
      COSMOS_2516_IGS          J2000                    DYNAMIC      -41554000
      COSMOS_2516_MEC          COSMOS_2516_IGS          FIXED        -41554001
      COSMOS_2522_IGS          J2000                    DYNAMIC      -42939000
      COSMOS_2522_MEC          COSMOS_2522_IGS          FIXED        -42939001
      COSMOS_2527_IGS          J2000                    DYNAMIC      -43508000
      COSMOS_2527_MEC          COSMOS_2527_IGS          FIXED        -43508001
      COSMOS_2529_IGS          J2000                    DYNAMIC      -43687000
      COSMOS_2529_MEC          COSMOS_2529_IGS          FIXED        -43687001
      COSMOS_2534_IGS          J2000                    DYNAMIC      -44299000
      COSMOS_2534_MEC          COSMOS_2534_IGS          FIXED        -44299001
      COSMOS_2544_IGS          J2000                    DYNAMIC      -44850000
      COSMOS_2544_MEC          COSMOS_2544_IGS          FIXED        -44850001
      COSMOS_2545_IGS          J2000                    DYNAMIC      -45358000
      COSMOS_2545_MEC          COSMOS_2545_IGS          FIXED        -45358001
      COSMOS_2547_IGS          J2000                    DYNAMIC      -46805000
      COSMOS_2547_MEC          COSMOS_2547_IGS          FIXED        -46805001
      COSMOS_2557_IGS          J2000                    DYNAMIC      -52984000
      COSMOS_2557_MEC          COSMOS_2557_IGS          FIXED        -52984001
      COSMOS_2559_IGS          J2000                    DYNAMIC      -54031000
      COSMOS_2559_MEC          COSMOS_2559_IGS          FIXED        -54031001
      COSMOS_2564_IGS          J2000                    DYNAMIC      -54377000
      COSMOS_2564_MEC          COSMOS_2564_IGS          FIXED        -54377001
      COSMOS_2569_IGS          J2000                    DYNAMIC      -57517000
      COSMOS_2569_MEC          COSMOS_2569_IGS          FIXED        -57517001
      COSMOS_2584_IGS          J2000                    DYNAMIC      -63130000
      COSMOS_2584_MEC          COSMOS_2584_IGS          FIXED        -63130001
      COSMOS_2596_IGS          J2000                    DYNAMIC      -65590000
      COSMOS_2596_MEC          COSMOS_2596_IGS          FIXED        -65590001


      BeiDou spacecrafts frames:
      --------------------------
      BEIDOU-2_G4_IGS          J2000                    DYNAMIC      -37210000
      BEIDOU-2_G4_MEC          BEIDOU-2_G4_IGS          FIXED        -37210001
      BEIDOU-2_G5_IGS          J2000                    DYNAMIC      -38091000
      BEIDOU-2_G5_MEC          BEIDOU-2_G5_IGS          FIXED        -38091001
      BEIDOU-2_G6_IGS          J2000                    DYNAMIC      -38953000
      BEIDOU-2_G6_MEC          BEIDOU-2_G6_IGS          FIXED        -38953001
      BEIDOU-2_G7_IGS          J2000                    DYNAMIC      -41586000
      BEIDOU-2_G7_MEC          BEIDOU-2_G7_IGS          FIXED        -41586001
      BEIDOU-2_G8_IGS          J2000                    DYNAMIC      -44231000
      BEIDOU-2_G8_MEC          BEIDOU-2_G8_IGS          FIXED        -44231001
      BEIDOU-2_IGSO-1_IGS      J2000                    DYNAMIC      -36828000
      BEIDOU-2_IGSO-1_MEC      BEIDOU-2_IGSO-1_IGS      FIXED        -36828001
      BEIDOU-2_IGSO-2_IGS      J2000                    DYNAMIC      -37256000
      BEIDOU-2_IGSO-2_MEC      BEIDOU-2_IGSO-2_IGS      FIXED        -37256001
      BEIDOU-2_IGSO-3_IGS      J2000                    DYNAMIC      -37384000
      BEIDOU-2_IGSO-3_MEC      BEIDOU-2_IGSO-3_IGS      FIXED        -37384001
      BEIDOU-2_IGSO-4_IGS      J2000                    DYNAMIC      -37763000
      BEIDOU-2_IGSO-4_MEC      BEIDOU-2_IGSO-4_IGS      FIXED        -37763001
      BEIDOU-2_IGSO-5_IGS      J2000                    DYNAMIC      -37948000
      BEIDOU-2_IGSO-5_MEC      BEIDOU-2_IGSO-5_IGS      FIXED        -37948001
      BEIDOU-2_IGSO-6_IGS      J2000                    DYNAMIC      -41434000
      BEIDOU-2_IGSO-6_MEC      BEIDOU-2_IGSO-6_IGS      FIXED        -41434001
      BEIDOU-2_IGSO-7_IGS      J2000                    DYNAMIC      -43539000
      BEIDOU-2_IGSO-7_MEC      BEIDOU-2_IGSO-7_IGS      FIXED        -43539001
      BEIDOU-2_M3_IGS          J2000                    DYNAMIC      -38250000
      BEIDOU-2_M3_MEC          BEIDOU-2_M3_IGS          FIXED        -38250001
      BEIDOU-2_M4_IGS          J2000                    DYNAMIC      -38251000
      BEIDOU-2_M4_MEC          BEIDOU-2_M4_IGS          FIXED        -38251001
      BEIDOU-2_M6_IGS          J2000                    DYNAMIC      -38775000
      BEIDOU-2_M6_MEC          BEIDOU-2_M6_IGS          FIXED        -38775001
      BEIDOU-3S_IGSO-1S_IGS    J2000                    DYNAMIC      -40549000
      BEIDOU-3S_IGSO-1S_MEC    BEIDOU-3S_IGSO-1S_IGS    FIXED        -40549001
      BEIDOU-3S_IGSO-2S_IGS    J2000                    DYNAMIC      -40938000
      BEIDOU-3S_IGSO-2S_MEC    BEIDOU-3S_IGSO-2S_IGS    FIXED        -40938001
      BEIDOU-3S_M1S_IGS        J2000                    DYNAMIC      -40749000
      BEIDOU-3S_M1S_MEC        BEIDOU-3S_M1S_IGS        FIXED        -40749001
      BEIDOU-3S_M2S_IGS        J2000                    DYNAMIC      -40748000
      BEIDOU-3S_M2S_MEC        BEIDOU-3S_M2S_IGS        FIXED        -40748001
      BEIDOU-3_G1_IGS          J2000                    DYNAMIC      -43683000
      BEIDOU-3_G1_MEC          BEIDOU-3_G1_IGS          FIXED        -43683001
      BEIDOU-3_G2_IGS          J2000                    DYNAMIC      -45344000
      BEIDOU-3_G2_MEC          BEIDOU-3_G2_IGS          FIXED        -45344001
      BEIDOU-3_G3_IGS          J2000                    DYNAMIC      -45807000
      BEIDOU-3_G3_MEC          BEIDOU-3_G3_IGS          FIXED        -45807001
      BEIDOU-3_G4_IGS          J2000                    DYNAMIC      -56564000
      BEIDOU-3_G4_MEC          BEIDOU-3_G4_IGS          FIXED        -56564001
      BEIDOU-3_IGSO-1_IGS      J2000                    DYNAMIC      -44204000
      BEIDOU-3_IGSO-1_MEC      BEIDOU-3_IGSO-1_IGS      FIXED        -44204001
      BEIDOU-3_IGSO-2_IGS      J2000                    DYNAMIC      -44337000
      BEIDOU-3_IGSO-2_MEC      BEIDOU-3_IGSO-2_IGS      FIXED        -44337001
      BEIDOU-3_IGSO-3_IGS      J2000                    DYNAMIC      -44709000
      BEIDOU-3_IGSO-3_MEC      BEIDOU-3_IGSO-3_IGS      FIXED        -44709001
      BEIDOU-3_M1_IGS          J2000                    DYNAMIC      -43001000
      BEIDOU-3_M1_MEC          BEIDOU-3_M1_IGS          FIXED        -43001001
      BEIDOU-3_M10_IGS         J2000                    DYNAMIC      -43246000
      BEIDOU-3_M10_MEC         BEIDOU-3_M10_IGS         FIXED        -43246001
      BEIDOU-3_M11_IGS         J2000                    DYNAMIC      -43603000
      BEIDOU-3_M11_MEC         BEIDOU-3_M11_IGS         FIXED        -43603001
      BEIDOU-3_M12_IGS         J2000                    DYNAMIC      -43602000
      BEIDOU-3_M12_MEC         BEIDOU-3_M12_IGS         FIXED        -43602001
      BEIDOU-3_M13_IGS         J2000                    DYNAMIC      -43622000
      BEIDOU-3_M13_MEC         BEIDOU-3_M13_IGS         FIXED        -43622001
      BEIDOU-3_M14_IGS         J2000                    DYNAMIC      -43623000
      BEIDOU-3_M14_MEC         BEIDOU-3_M14_IGS         FIXED        -43623001
      BEIDOU-3_M15_IGS         J2000                    DYNAMIC      -43648000
      BEIDOU-3_M15_MEC         BEIDOU-3_M15_IGS         FIXED        -43648001
      BEIDOU-3_M16_IGS         J2000                    DYNAMIC      -43647000
      BEIDOU-3_M16_MEC         BEIDOU-3_M16_IGS         FIXED        -43647001
      BEIDOU-3_M17_IGS         J2000                    DYNAMIC      -43706000
      BEIDOU-3_M17_MEC         BEIDOU-3_M17_IGS         FIXED        -43706001
      BEIDOU-3_M18_IGS         J2000                    DYNAMIC      -43707000
      BEIDOU-3_M18_MEC         BEIDOU-3_M18_IGS         FIXED        -43707001
      BEIDOU-3_M19_IGS         J2000                    DYNAMIC      -44864000
      BEIDOU-3_M19_MEC         BEIDOU-3_M19_IGS         FIXED        -44864001
      BEIDOU-3_M2_IGS          J2000                    DYNAMIC      -43002000
      BEIDOU-3_M2_MEC          BEIDOU-3_M2_IGS          FIXED        -43002001
      BEIDOU-3_M20_IGS         J2000                    DYNAMIC      -44865000
      BEIDOU-3_M20_MEC         BEIDOU-3_M20_IGS         FIXED        -44865001
      BEIDOU-3_M21_IGS         J2000                    DYNAMIC      -44794000
      BEIDOU-3_M21_MEC         BEIDOU-3_M21_IGS         FIXED        -44794001
      BEIDOU-3_M22_IGS         J2000                    DYNAMIC      -44793000
      BEIDOU-3_M22_MEC         BEIDOU-3_M22_IGS         FIXED        -44793001
      BEIDOU-3_M23_IGS         J2000                    DYNAMIC      -44543000
      BEIDOU-3_M23_MEC         BEIDOU-3_M23_IGS         FIXED        -44543001
      BEIDOU-3_M24_IGS         J2000                    DYNAMIC      -44542000
      BEIDOU-3_M24_MEC         BEIDOU-3_M24_IGS         FIXED        -44542001
      BEIDOU-3_M25_IGS         J2000                    DYNAMIC      -61186000
      BEIDOU-3_M25_MEC         BEIDOU-3_M25_IGS         FIXED        -61186001
      BEIDOU-3_M26_IGS         J2000                    DYNAMIC      -58655000
      BEIDOU-3_M26_MEC         BEIDOU-3_M26_IGS         FIXED        -58655001
      BEIDOU-3_M27_IGS         J2000                    DYNAMIC      -61187000
      BEIDOU-3_M27_MEC         BEIDOU-3_M27_IGS         FIXED        -61187001
      BEIDOU-3_M28_IGS         J2000                    DYNAMIC      -58654000
      BEIDOU-3_M28_MEC         BEIDOU-3_M28_IGS         FIXED        -58654001
      BEIDOU-3_M3_IGS          J2000                    DYNAMIC      -43208000
      BEIDOU-3_M3_MEC          BEIDOU-3_M3_IGS          FIXED        -43208001
      BEIDOU-3_M4_IGS          J2000                    DYNAMIC      -43207000
      BEIDOU-3_M4_MEC          BEIDOU-3_M4_IGS          FIXED        -43207001
      BEIDOU-3_M5_IGS          J2000                    DYNAMIC      -43581000
      BEIDOU-3_M5_MEC          BEIDOU-3_M5_IGS          FIXED        -43581001
      BEIDOU-3_M6_IGS          J2000                    DYNAMIC      -43582000
      BEIDOU-3_M6_MEC          BEIDOU-3_M6_IGS          FIXED        -43582001
      BEIDOU-3_M7_IGS          J2000                    DYNAMIC      -43107000
      BEIDOU-3_M7_MEC          BEIDOU-3_M7_IGS          FIXED        -43107001
      BEIDOU-3_M8_IGS          J2000                    DYNAMIC      -43108000
      BEIDOU-3_M8_MEC          BEIDOU-3_M8_IGS          FIXED        -43108001
      BEIDOU-3_M9_IGS          J2000                    DYNAMIC      -43245000
      BEIDOU-3_M9_MEC          BEIDOU-3_M9_IGS          FIXED        -43245001


      Other spacecrafts frames:
      -------------------------
      ASTRA_5B_IGS             J2000                    DYNAMIC      -39617000
      CRE_IGS                  J2000                    DYNAMIC      -28868000
      EUTELSAT_117_WEST_B_IGS  J2000                    DYNAMIC      -41589000
      EUTELSAT_5_WEST_B_IGS    J2000                    DYNAMIC      -44624000
      GALAXY_30_IGS            J2000                    DYNAMIC      -46114000
      INMARSAT_4-F2_IGS        J2000                    DYNAMIC      -28899000
      IRNSS-1A_IGS             J2000                    DYNAMIC      -39199000
      IRNSS-1A_MEC             IRNSS-1A_IGS             FIXED        -39199001
      IRNSS-1B_IGS             J2000                    DYNAMIC      -39635000
      IRNSS-1B_MEC             IRNSS-1B_IGS             FIXED        -39635001
      IRNSS-1C_IGS             J2000                    DYNAMIC      -40269000
      IRNSS-1C_MEC             IRNSS-1C_IGS             FIXED        -40269001
      IRNSS-1D_IGS             J2000                    DYNAMIC      -40547000
      IRNSS-1D_MEC             IRNSS-1D_IGS             FIXED        -40547001
      IRNSS-1E_IGS             J2000                    DYNAMIC      -41241000
      IRNSS-1E_MEC             IRNSS-1E_IGS             FIXED        -41241001
      IRNSS-1F_IGS             J2000                    DYNAMIC      -41384000
      IRNSS-1F_MEC             IRNSS-1F_IGS             FIXED        -41384001
      IRNSS-1G_IGS             J2000                    DYNAMIC      -41469000
      IRNSS-1G_MEC             IRNSS-1G_IGS             FIXED        -41469001
      IRNSS-1I_IGS             J2000                    DYNAMIC      -43286000
      IRNSS-1I_MEC             IRNSS-1I_IGS             FIXED        -43286001
      LUCH_5A_IGS              J2000                    DYNAMIC      -37951000
      LUCH_5B_IGS              J2000                    DYNAMIC      -38977000
      LUCH_5V_IGS              J2000                    DYNAMIC      -39727000
      NVS-01_IGS               J2000                    DYNAMIC      -56759000
      NVS-02_IGS               J2000                    DYNAMIC      -62850000
      QZS-1_IGS                J2000                    DYNAMIC      -37158000
      QZS-1_MEC                QZS-1_IGS                FIXED        -37158001
      QZS-1R_IGS               J2000                    DYNAMIC      -49336000
      QZS-1R_MEC               QZS-1R_IGS               FIXED        -49336001
      QZS-2_IGS                J2000                    DYNAMIC      -42738000
      QZS-2_MEC                QZS-2_IGS                FIXED        -42738001
      QZS-3_IGS                J2000                    DYNAMIC      -42917000
      QZS-3_MEC                QZS-3_IGS                FIXED        -42917001
      QZS-4_IGS                J2000                    DYNAMIC      -42965000
      QZS-4_MEC                QZS-4_IGS                FIXED        -42965001
      SES-15_IGS               J2000                    DYNAMIC      -42709000
      SES-5_IGS                J2000                    DYNAMIC      -38652000


GNSS Nadir Power Optimized Frames Definitions
-----------------------------------------------------------------------------

   All of these frames provides a default Nadir Power Optimized orientation
   defined as follows [5]:

      -  +Z axis is the primary vector and points from the spacecraft
         to the center of the Earth (Nadir direction);

      -  +X axis is the secondary vector and points from the spacecraft
         to the center of the Sun;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the spacecraft's center of mass.

   All the frame names with the suffix "_IGS" are related to the IGS
   reference frame standard from the International GNSS Service, from [5].

   All the frame names with the suffix "_MEC" are related to the manufacturer
   reference frame definition, from [5].

   \begindata


      FRAME_GSAT-10_IGS                = -38779000
      FRAME_-38779000_NAME             = 'GSAT-10_IGS'
      FRAME_-38779000_CLASS            =  5
      FRAME_-38779000_CLASS_ID         = -38779000
      FRAME_-38779000_CENTER           = -38779
      FRAME_-38779000_RELATIVE         = 'J2000'
      FRAME_-38779000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38779000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38779000_PRI_AXIS         = 'Z'
      FRAME_-38779000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38779000_PRI_OBSERVER     = 'GSAT-10'
      FRAME_-38779000_PRI_TARGET       = 'EARTH'
      FRAME_-38779000_PRI_ABCORR       = 'NONE'
      FRAME_-38779000_SEC_AXIS         = 'X'
      FRAME_-38779000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38779000_SEC_OBSERVER     = 'GSAT-10'
      FRAME_-38779000_SEC_TARGET       = 'SUN'
      FRAME_-38779000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT-15_IGS                = -41028000
      FRAME_-41028000_NAME             = 'GSAT-15_IGS'
      FRAME_-41028000_CLASS            =  5
      FRAME_-41028000_CLASS_ID         = -41028000
      FRAME_-41028000_CENTER           = -41028
      FRAME_-41028000_RELATIVE         = 'J2000'
      FRAME_-41028000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41028000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41028000_PRI_AXIS         = 'Z'
      FRAME_-41028000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41028000_PRI_OBSERVER     = 'GSAT-15'
      FRAME_-41028000_PRI_TARGET       = 'EARTH'
      FRAME_-41028000_PRI_ABCORR       = 'NONE'
      FRAME_-41028000_SEC_AXIS         = 'X'
      FRAME_-41028000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41028000_SEC_OBSERVER     = 'GSAT-15'
      FRAME_-41028000_SEC_TARGET       = 'SUN'
      FRAME_-41028000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT-8_IGS                 = -37605000
      FRAME_-37605000_NAME             = 'GSAT-8_IGS'
      FRAME_-37605000_CLASS            =  5
      FRAME_-37605000_CLASS_ID         = -37605000
      FRAME_-37605000_CENTER           = -37605
      FRAME_-37605000_RELATIVE         = 'J2000'
      FRAME_-37605000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37605000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37605000_PRI_AXIS         = 'Z'
      FRAME_-37605000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37605000_PRI_OBSERVER     = 'GSAT-8'
      FRAME_-37605000_PRI_TARGET       = 'EARTH'
      FRAME_-37605000_PRI_ABCORR       = 'NONE'
      FRAME_-37605000_SEC_AXIS         = 'X'
      FRAME_-37605000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37605000_SEC_OBSERVER     = 'GSAT-8'
      FRAME_-37605000_SEC_TARGET       = 'SUN'
      FRAME_-37605000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0101_IGS               = -37846000
      FRAME_-37846000_NAME             = 'GSAT0101_IGS'
      FRAME_-37846000_CLASS            =  5
      FRAME_-37846000_CLASS_ID         = -37846000
      FRAME_-37846000_CENTER           = -37846
      FRAME_-37846000_RELATIVE         = 'J2000'
      FRAME_-37846000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37846000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37846000_PRI_AXIS         = 'Z'
      FRAME_-37846000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37846000_PRI_OBSERVER     = 'GSAT0101'
      FRAME_-37846000_PRI_TARGET       = 'EARTH'
      FRAME_-37846000_PRI_ABCORR       = 'NONE'
      FRAME_-37846000_SEC_AXIS         = 'X'
      FRAME_-37846000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37846000_SEC_OBSERVER     = 'GSAT0101'
      FRAME_-37846000_SEC_TARGET       = 'SUN'
      FRAME_-37846000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0101_MEC               = -37846001
      FRAME_-37846001_NAME             = 'GSAT0101_MEC'
      FRAME_-37846001_CLASS            =  4
      FRAME_-37846001_CLASS_ID         = -37846001
      FRAME_-37846001_CENTER           = -37846
      TKFRAME_-37846001_RELATIVE       = 'GSAT0101_IGS'
      TKFRAME_-37846001_SPEC           = 'ANGLES'
      TKFRAME_-37846001_UNITS          = 'DEGREES'
      TKFRAME_-37846001_AXES           = (   3, 2, 1)
      TKFRAME_-37846001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0102_IGS               = -37847000
      FRAME_-37847000_NAME             = 'GSAT0102_IGS'
      FRAME_-37847000_CLASS            =  5
      FRAME_-37847000_CLASS_ID         = -37847000
      FRAME_-37847000_CENTER           = -37847
      FRAME_-37847000_RELATIVE         = 'J2000'
      FRAME_-37847000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37847000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37847000_PRI_AXIS         = 'Z'
      FRAME_-37847000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37847000_PRI_OBSERVER     = 'GSAT0102'
      FRAME_-37847000_PRI_TARGET       = 'EARTH'
      FRAME_-37847000_PRI_ABCORR       = 'NONE'
      FRAME_-37847000_SEC_AXIS         = 'X'
      FRAME_-37847000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37847000_SEC_OBSERVER     = 'GSAT0102'
      FRAME_-37847000_SEC_TARGET       = 'SUN'
      FRAME_-37847000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0102_MEC               = -37847001
      FRAME_-37847001_NAME             = 'GSAT0102_MEC'
      FRAME_-37847001_CLASS            =  4
      FRAME_-37847001_CLASS_ID         = -37847001
      FRAME_-37847001_CENTER           = -37847
      TKFRAME_-37847001_RELATIVE       = 'GSAT0102_IGS'
      TKFRAME_-37847001_SPEC           = 'ANGLES'
      TKFRAME_-37847001_UNITS          = 'DEGREES'
      TKFRAME_-37847001_AXES           = (   3, 2, 1)
      TKFRAME_-37847001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0103_IGS               = -38857000
      FRAME_-38857000_NAME             = 'GSAT0103_IGS'
      FRAME_-38857000_CLASS            =  5
      FRAME_-38857000_CLASS_ID         = -38857000
      FRAME_-38857000_CENTER           = -38857
      FRAME_-38857000_RELATIVE         = 'J2000'
      FRAME_-38857000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38857000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38857000_PRI_AXIS         = 'Z'
      FRAME_-38857000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38857000_PRI_OBSERVER     = 'GSAT0103'
      FRAME_-38857000_PRI_TARGET       = 'EARTH'
      FRAME_-38857000_PRI_ABCORR       = 'NONE'
      FRAME_-38857000_SEC_AXIS         = 'X'
      FRAME_-38857000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38857000_SEC_OBSERVER     = 'GSAT0103'
      FRAME_-38857000_SEC_TARGET       = 'SUN'
      FRAME_-38857000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0103_MEC               = -38857001
      FRAME_-38857001_NAME             = 'GSAT0103_MEC'
      FRAME_-38857001_CLASS            =  4
      FRAME_-38857001_CLASS_ID         = -38857001
      FRAME_-38857001_CENTER           = -38857
      TKFRAME_-38857001_RELATIVE       = 'GSAT0103_IGS'
      TKFRAME_-38857001_SPEC           = 'ANGLES'
      TKFRAME_-38857001_UNITS          = 'DEGREES'
      TKFRAME_-38857001_AXES           = (   3, 2, 1)
      TKFRAME_-38857001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0104_IGS               = -38858000
      FRAME_-38858000_NAME             = 'GSAT0104_IGS'
      FRAME_-38858000_CLASS            =  5
      FRAME_-38858000_CLASS_ID         = -38858000
      FRAME_-38858000_CENTER           = -38858
      FRAME_-38858000_RELATIVE         = 'J2000'
      FRAME_-38858000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38858000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38858000_PRI_AXIS         = 'Z'
      FRAME_-38858000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38858000_PRI_OBSERVER     = 'GSAT0104'
      FRAME_-38858000_PRI_TARGET       = 'EARTH'
      FRAME_-38858000_PRI_ABCORR       = 'NONE'
      FRAME_-38858000_SEC_AXIS         = 'X'
      FRAME_-38858000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38858000_SEC_OBSERVER     = 'GSAT0104'
      FRAME_-38858000_SEC_TARGET       = 'SUN'
      FRAME_-38858000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0104_MEC               = -38858001
      FRAME_-38858001_NAME             = 'GSAT0104_MEC'
      FRAME_-38858001_CLASS            =  4
      FRAME_-38858001_CLASS_ID         = -38858001
      FRAME_-38858001_CENTER           = -38858
      TKFRAME_-38858001_RELATIVE       = 'GSAT0104_IGS'
      TKFRAME_-38858001_SPEC           = 'ANGLES'
      TKFRAME_-38858001_UNITS          = 'DEGREES'
      TKFRAME_-38858001_AXES           = (   3, 2, 1)
      TKFRAME_-38858001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0201_IGS               = -40128000
      FRAME_-40128000_NAME             = 'GSAT0201_IGS'
      FRAME_-40128000_CLASS            =  5
      FRAME_-40128000_CLASS_ID         = -40128000
      FRAME_-40128000_CENTER           = -40128
      FRAME_-40128000_RELATIVE         = 'J2000'
      FRAME_-40128000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40128000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40128000_PRI_AXIS         = 'Z'
      FRAME_-40128000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40128000_PRI_OBSERVER     = 'GSAT0201'
      FRAME_-40128000_PRI_TARGET       = 'EARTH'
      FRAME_-40128000_PRI_ABCORR       = 'NONE'
      FRAME_-40128000_SEC_AXIS         = 'X'
      FRAME_-40128000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40128000_SEC_OBSERVER     = 'GSAT0201'
      FRAME_-40128000_SEC_TARGET       = 'SUN'
      FRAME_-40128000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0201_MEC               = -40128001
      FRAME_-40128001_NAME             = 'GSAT0201_MEC'
      FRAME_-40128001_CLASS            =  4
      FRAME_-40128001_CLASS_ID         = -40128001
      FRAME_-40128001_CENTER           = -40128
      TKFRAME_-40128001_RELATIVE       = 'GSAT0201_IGS'
      TKFRAME_-40128001_SPEC           = 'ANGLES'
      TKFRAME_-40128001_UNITS          = 'DEGREES'
      TKFRAME_-40128001_AXES           = (   3, 2, 1)
      TKFRAME_-40128001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0202_IGS               = -40129000
      FRAME_-40129000_NAME             = 'GSAT0202_IGS'
      FRAME_-40129000_CLASS            =  5
      FRAME_-40129000_CLASS_ID         = -40129000
      FRAME_-40129000_CENTER           = -40129
      FRAME_-40129000_RELATIVE         = 'J2000'
      FRAME_-40129000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40129000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40129000_PRI_AXIS         = 'Z'
      FRAME_-40129000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40129000_PRI_OBSERVER     = 'GSAT0202'
      FRAME_-40129000_PRI_TARGET       = 'EARTH'
      FRAME_-40129000_PRI_ABCORR       = 'NONE'
      FRAME_-40129000_SEC_AXIS         = 'X'
      FRAME_-40129000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40129000_SEC_OBSERVER     = 'GSAT0202'
      FRAME_-40129000_SEC_TARGET       = 'SUN'
      FRAME_-40129000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0202_MEC               = -40129001
      FRAME_-40129001_NAME             = 'GSAT0202_MEC'
      FRAME_-40129001_CLASS            =  4
      FRAME_-40129001_CLASS_ID         = -40129001
      FRAME_-40129001_CENTER           = -40129
      TKFRAME_-40129001_RELATIVE       = 'GSAT0202_IGS'
      TKFRAME_-40129001_SPEC           = 'ANGLES'
      TKFRAME_-40129001_UNITS          = 'DEGREES'
      TKFRAME_-40129001_AXES           = (   3, 2, 1)
      TKFRAME_-40129001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0203_IGS               = -40544000
      FRAME_-40544000_NAME             = 'GSAT0203_IGS'
      FRAME_-40544000_CLASS            =  5
      FRAME_-40544000_CLASS_ID         = -40544000
      FRAME_-40544000_CENTER           = -40544
      FRAME_-40544000_RELATIVE         = 'J2000'
      FRAME_-40544000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40544000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40544000_PRI_AXIS         = 'Z'
      FRAME_-40544000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40544000_PRI_OBSERVER     = 'GSAT0203'
      FRAME_-40544000_PRI_TARGET       = 'EARTH'
      FRAME_-40544000_PRI_ABCORR       = 'NONE'
      FRAME_-40544000_SEC_AXIS         = 'X'
      FRAME_-40544000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40544000_SEC_OBSERVER     = 'GSAT0203'
      FRAME_-40544000_SEC_TARGET       = 'SUN'
      FRAME_-40544000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0203_MEC               = -40544001
      FRAME_-40544001_NAME             = 'GSAT0203_MEC'
      FRAME_-40544001_CLASS            =  4
      FRAME_-40544001_CLASS_ID         = -40544001
      FRAME_-40544001_CENTER           = -40544
      TKFRAME_-40544001_RELATIVE       = 'GSAT0203_IGS'
      TKFRAME_-40544001_SPEC           = 'ANGLES'
      TKFRAME_-40544001_UNITS          = 'DEGREES'
      TKFRAME_-40544001_AXES           = (   3, 2, 1)
      TKFRAME_-40544001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0204_IGS               = -40545000
      FRAME_-40545000_NAME             = 'GSAT0204_IGS'
      FRAME_-40545000_CLASS            =  5
      FRAME_-40545000_CLASS_ID         = -40545000
      FRAME_-40545000_CENTER           = -40545
      FRAME_-40545000_RELATIVE         = 'J2000'
      FRAME_-40545000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40545000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40545000_PRI_AXIS         = 'Z'
      FRAME_-40545000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40545000_PRI_OBSERVER     = 'GSAT0204'
      FRAME_-40545000_PRI_TARGET       = 'EARTH'
      FRAME_-40545000_PRI_ABCORR       = 'NONE'
      FRAME_-40545000_SEC_AXIS         = 'X'
      FRAME_-40545000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40545000_SEC_OBSERVER     = 'GSAT0204'
      FRAME_-40545000_SEC_TARGET       = 'SUN'
      FRAME_-40545000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0204_MEC               = -40545001
      FRAME_-40545001_NAME             = 'GSAT0204_MEC'
      FRAME_-40545001_CLASS            =  4
      FRAME_-40545001_CLASS_ID         = -40545001
      FRAME_-40545001_CENTER           = -40545
      TKFRAME_-40545001_RELATIVE       = 'GSAT0204_IGS'
      TKFRAME_-40545001_SPEC           = 'ANGLES'
      TKFRAME_-40545001_UNITS          = 'DEGREES'
      TKFRAME_-40545001_AXES           = (   3, 2, 1)
      TKFRAME_-40545001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0205_IGS               = -40889000
      FRAME_-40889000_NAME             = 'GSAT0205_IGS'
      FRAME_-40889000_CLASS            =  5
      FRAME_-40889000_CLASS_ID         = -40889000
      FRAME_-40889000_CENTER           = -40889
      FRAME_-40889000_RELATIVE         = 'J2000'
      FRAME_-40889000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40889000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40889000_PRI_AXIS         = 'Z'
      FRAME_-40889000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40889000_PRI_OBSERVER     = 'GSAT0205'
      FRAME_-40889000_PRI_TARGET       = 'EARTH'
      FRAME_-40889000_PRI_ABCORR       = 'NONE'
      FRAME_-40889000_SEC_AXIS         = 'X'
      FRAME_-40889000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40889000_SEC_OBSERVER     = 'GSAT0205'
      FRAME_-40889000_SEC_TARGET       = 'SUN'
      FRAME_-40889000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0205_MEC               = -40889001
      FRAME_-40889001_NAME             = 'GSAT0205_MEC'
      FRAME_-40889001_CLASS            =  4
      FRAME_-40889001_CLASS_ID         = -40889001
      FRAME_-40889001_CENTER           = -40889
      TKFRAME_-40889001_RELATIVE       = 'GSAT0205_IGS'
      TKFRAME_-40889001_SPEC           = 'ANGLES'
      TKFRAME_-40889001_UNITS          = 'DEGREES'
      TKFRAME_-40889001_AXES           = (   3, 2, 1)
      TKFRAME_-40889001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0206_IGS               = -40890000
      FRAME_-40890000_NAME             = 'GSAT0206_IGS'
      FRAME_-40890000_CLASS            =  5
      FRAME_-40890000_CLASS_ID         = -40890000
      FRAME_-40890000_CENTER           = -40890
      FRAME_-40890000_RELATIVE         = 'J2000'
      FRAME_-40890000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40890000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40890000_PRI_AXIS         = 'Z'
      FRAME_-40890000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40890000_PRI_OBSERVER     = 'GSAT0206'
      FRAME_-40890000_PRI_TARGET       = 'EARTH'
      FRAME_-40890000_PRI_ABCORR       = 'NONE'
      FRAME_-40890000_SEC_AXIS         = 'X'
      FRAME_-40890000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40890000_SEC_OBSERVER     = 'GSAT0206'
      FRAME_-40890000_SEC_TARGET       = 'SUN'
      FRAME_-40890000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0206_MEC               = -40890001
      FRAME_-40890001_NAME             = 'GSAT0206_MEC'
      FRAME_-40890001_CLASS            =  4
      FRAME_-40890001_CLASS_ID         = -40890001
      FRAME_-40890001_CENTER           = -40890
      TKFRAME_-40890001_RELATIVE       = 'GSAT0206_IGS'
      TKFRAME_-40890001_SPEC           = 'ANGLES'
      TKFRAME_-40890001_UNITS          = 'DEGREES'
      TKFRAME_-40890001_AXES           = (   3, 2, 1)
      TKFRAME_-40890001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0207_IGS               = -41859000
      FRAME_-41859000_NAME             = 'GSAT0207_IGS'
      FRAME_-41859000_CLASS            =  5
      FRAME_-41859000_CLASS_ID         = -41859000
      FRAME_-41859000_CENTER           = -41859
      FRAME_-41859000_RELATIVE         = 'J2000'
      FRAME_-41859000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41859000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41859000_PRI_AXIS         = 'Z'
      FRAME_-41859000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41859000_PRI_OBSERVER     = 'GSAT0207'
      FRAME_-41859000_PRI_TARGET       = 'EARTH'
      FRAME_-41859000_PRI_ABCORR       = 'NONE'
      FRAME_-41859000_SEC_AXIS         = 'X'
      FRAME_-41859000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41859000_SEC_OBSERVER     = 'GSAT0207'
      FRAME_-41859000_SEC_TARGET       = 'SUN'
      FRAME_-41859000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0207_MEC               = -41859001
      FRAME_-41859001_NAME             = 'GSAT0207_MEC'
      FRAME_-41859001_CLASS            =  4
      FRAME_-41859001_CLASS_ID         = -41859001
      FRAME_-41859001_CENTER           = -41859
      TKFRAME_-41859001_RELATIVE       = 'GSAT0207_IGS'
      TKFRAME_-41859001_SPEC           = 'ANGLES'
      TKFRAME_-41859001_UNITS          = 'DEGREES'
      TKFRAME_-41859001_AXES           = (   3, 2, 1)
      TKFRAME_-41859001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0208_IGS               = -41175000
      FRAME_-41175000_NAME             = 'GSAT0208_IGS'
      FRAME_-41175000_CLASS            =  5
      FRAME_-41175000_CLASS_ID         = -41175000
      FRAME_-41175000_CENTER           = -41175
      FRAME_-41175000_RELATIVE         = 'J2000'
      FRAME_-41175000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41175000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41175000_PRI_AXIS         = 'Z'
      FRAME_-41175000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41175000_PRI_OBSERVER     = 'GSAT0208'
      FRAME_-41175000_PRI_TARGET       = 'EARTH'
      FRAME_-41175000_PRI_ABCORR       = 'NONE'
      FRAME_-41175000_SEC_AXIS         = 'X'
      FRAME_-41175000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41175000_SEC_OBSERVER     = 'GSAT0208'
      FRAME_-41175000_SEC_TARGET       = 'SUN'
      FRAME_-41175000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0208_MEC               = -41175001
      FRAME_-41175001_NAME             = 'GSAT0208_MEC'
      FRAME_-41175001_CLASS            =  4
      FRAME_-41175001_CLASS_ID         = -41175001
      FRAME_-41175001_CENTER           = -41175
      TKFRAME_-41175001_RELATIVE       = 'GSAT0208_IGS'
      TKFRAME_-41175001_SPEC           = 'ANGLES'
      TKFRAME_-41175001_UNITS          = 'DEGREES'
      TKFRAME_-41175001_AXES           = (   3, 2, 1)
      TKFRAME_-41175001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0209_IGS               = -41174000
      FRAME_-41174000_NAME             = 'GSAT0209_IGS'
      FRAME_-41174000_CLASS            =  5
      FRAME_-41174000_CLASS_ID         = -41174000
      FRAME_-41174000_CENTER           = -41174
      FRAME_-41174000_RELATIVE         = 'J2000'
      FRAME_-41174000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41174000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41174000_PRI_AXIS         = 'Z'
      FRAME_-41174000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41174000_PRI_OBSERVER     = 'GSAT0209'
      FRAME_-41174000_PRI_TARGET       = 'EARTH'
      FRAME_-41174000_PRI_ABCORR       = 'NONE'
      FRAME_-41174000_SEC_AXIS         = 'X'
      FRAME_-41174000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41174000_SEC_OBSERVER     = 'GSAT0209'
      FRAME_-41174000_SEC_TARGET       = 'SUN'
      FRAME_-41174000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0209_MEC               = -41174001
      FRAME_-41174001_NAME             = 'GSAT0209_MEC'
      FRAME_-41174001_CLASS            =  4
      FRAME_-41174001_CLASS_ID         = -41174001
      FRAME_-41174001_CENTER           = -41174
      TKFRAME_-41174001_RELATIVE       = 'GSAT0209_IGS'
      TKFRAME_-41174001_SPEC           = 'ANGLES'
      TKFRAME_-41174001_UNITS          = 'DEGREES'
      TKFRAME_-41174001_AXES           = (   3, 2, 1)
      TKFRAME_-41174001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0210_IGS               = -41550000
      FRAME_-41550000_NAME             = 'GSAT0210_IGS'
      FRAME_-41550000_CLASS            =  5
      FRAME_-41550000_CLASS_ID         = -41550000
      FRAME_-41550000_CENTER           = -41550
      FRAME_-41550000_RELATIVE         = 'J2000'
      FRAME_-41550000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41550000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41550000_PRI_AXIS         = 'Z'
      FRAME_-41550000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41550000_PRI_OBSERVER     = 'GSAT0210'
      FRAME_-41550000_PRI_TARGET       = 'EARTH'
      FRAME_-41550000_PRI_ABCORR       = 'NONE'
      FRAME_-41550000_SEC_AXIS         = 'X'
      FRAME_-41550000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41550000_SEC_OBSERVER     = 'GSAT0210'
      FRAME_-41550000_SEC_TARGET       = 'SUN'
      FRAME_-41550000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0210_MEC               = -41550001
      FRAME_-41550001_NAME             = 'GSAT0210_MEC'
      FRAME_-41550001_CLASS            =  4
      FRAME_-41550001_CLASS_ID         = -41550001
      FRAME_-41550001_CENTER           = -41550
      TKFRAME_-41550001_RELATIVE       = 'GSAT0210_IGS'
      TKFRAME_-41550001_SPEC           = 'ANGLES'
      TKFRAME_-41550001_UNITS          = 'DEGREES'
      TKFRAME_-41550001_AXES           = (   3, 2, 1)
      TKFRAME_-41550001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0211_IGS               = -41549000
      FRAME_-41549000_NAME             = 'GSAT0211_IGS'
      FRAME_-41549000_CLASS            =  5
      FRAME_-41549000_CLASS_ID         = -41549000
      FRAME_-41549000_CENTER           = -41549
      FRAME_-41549000_RELATIVE         = 'J2000'
      FRAME_-41549000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41549000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41549000_PRI_AXIS         = 'Z'
      FRAME_-41549000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41549000_PRI_OBSERVER     = 'GSAT0211'
      FRAME_-41549000_PRI_TARGET       = 'EARTH'
      FRAME_-41549000_PRI_ABCORR       = 'NONE'
      FRAME_-41549000_SEC_AXIS         = 'X'
      FRAME_-41549000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41549000_SEC_OBSERVER     = 'GSAT0211'
      FRAME_-41549000_SEC_TARGET       = 'SUN'
      FRAME_-41549000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0211_MEC               = -41549001
      FRAME_-41549001_NAME             = 'GSAT0211_MEC'
      FRAME_-41549001_CLASS            =  4
      FRAME_-41549001_CLASS_ID         = -41549001
      FRAME_-41549001_CENTER           = -41549
      TKFRAME_-41549001_RELATIVE       = 'GSAT0211_IGS'
      TKFRAME_-41549001_SPEC           = 'ANGLES'
      TKFRAME_-41549001_UNITS          = 'DEGREES'
      TKFRAME_-41549001_AXES           = (   3, 2, 1)
      TKFRAME_-41549001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0212_IGS               = -41860000
      FRAME_-41860000_NAME             = 'GSAT0212_IGS'
      FRAME_-41860000_CLASS            =  5
      FRAME_-41860000_CLASS_ID         = -41860000
      FRAME_-41860000_CENTER           = -41860
      FRAME_-41860000_RELATIVE         = 'J2000'
      FRAME_-41860000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41860000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41860000_PRI_AXIS         = 'Z'
      FRAME_-41860000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41860000_PRI_OBSERVER     = 'GSAT0212'
      FRAME_-41860000_PRI_TARGET       = 'EARTH'
      FRAME_-41860000_PRI_ABCORR       = 'NONE'
      FRAME_-41860000_SEC_AXIS         = 'X'
      FRAME_-41860000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41860000_SEC_OBSERVER     = 'GSAT0212'
      FRAME_-41860000_SEC_TARGET       = 'SUN'
      FRAME_-41860000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0212_MEC               = -41860001
      FRAME_-41860001_NAME             = 'GSAT0212_MEC'
      FRAME_-41860001_CLASS            =  4
      FRAME_-41860001_CLASS_ID         = -41860001
      FRAME_-41860001_CENTER           = -41860
      TKFRAME_-41860001_RELATIVE       = 'GSAT0212_IGS'
      TKFRAME_-41860001_SPEC           = 'ANGLES'
      TKFRAME_-41860001_UNITS          = 'DEGREES'
      TKFRAME_-41860001_AXES           = (   3, 2, 1)
      TKFRAME_-41860001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0213_IGS               = -41861000
      FRAME_-41861000_NAME             = 'GSAT0213_IGS'
      FRAME_-41861000_CLASS            =  5
      FRAME_-41861000_CLASS_ID         = -41861000
      FRAME_-41861000_CENTER           = -41861
      FRAME_-41861000_RELATIVE         = 'J2000'
      FRAME_-41861000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41861000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41861000_PRI_AXIS         = 'Z'
      FRAME_-41861000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41861000_PRI_OBSERVER     = 'GSAT0213'
      FRAME_-41861000_PRI_TARGET       = 'EARTH'
      FRAME_-41861000_PRI_ABCORR       = 'NONE'
      FRAME_-41861000_SEC_AXIS         = 'X'
      FRAME_-41861000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41861000_SEC_OBSERVER     = 'GSAT0213'
      FRAME_-41861000_SEC_TARGET       = 'SUN'
      FRAME_-41861000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0213_MEC               = -41861001
      FRAME_-41861001_NAME             = 'GSAT0213_MEC'
      FRAME_-41861001_CLASS            =  4
      FRAME_-41861001_CLASS_ID         = -41861001
      FRAME_-41861001_CENTER           = -41861
      TKFRAME_-41861001_RELATIVE       = 'GSAT0213_IGS'
      TKFRAME_-41861001_SPEC           = 'ANGLES'
      TKFRAME_-41861001_UNITS          = 'DEGREES'
      TKFRAME_-41861001_AXES           = (   3, 2, 1)
      TKFRAME_-41861001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0214_IGS               = -41862000
      FRAME_-41862000_NAME             = 'GSAT0214_IGS'
      FRAME_-41862000_CLASS            =  5
      FRAME_-41862000_CLASS_ID         = -41862000
      FRAME_-41862000_CENTER           = -41862
      FRAME_-41862000_RELATIVE         = 'J2000'
      FRAME_-41862000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41862000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41862000_PRI_AXIS         = 'Z'
      FRAME_-41862000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41862000_PRI_OBSERVER     = 'GSAT0214'
      FRAME_-41862000_PRI_TARGET       = 'EARTH'
      FRAME_-41862000_PRI_ABCORR       = 'NONE'
      FRAME_-41862000_SEC_AXIS         = 'X'
      FRAME_-41862000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41862000_SEC_OBSERVER     = 'GSAT0214'
      FRAME_-41862000_SEC_TARGET       = 'SUN'
      FRAME_-41862000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0214_MEC               = -41862001
      FRAME_-41862001_NAME             = 'GSAT0214_MEC'
      FRAME_-41862001_CLASS            =  4
      FRAME_-41862001_CLASS_ID         = -41862001
      FRAME_-41862001_CENTER           = -41862
      TKFRAME_-41862001_RELATIVE       = 'GSAT0214_IGS'
      TKFRAME_-41862001_SPEC           = 'ANGLES'
      TKFRAME_-41862001_UNITS          = 'DEGREES'
      TKFRAME_-41862001_AXES           = (   3, 2, 1)
      TKFRAME_-41862001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0215_IGS               = -43055000
      FRAME_-43055000_NAME             = 'GSAT0215_IGS'
      FRAME_-43055000_CLASS            =  5
      FRAME_-43055000_CLASS_ID         = -43055000
      FRAME_-43055000_CENTER           = -43055
      FRAME_-43055000_RELATIVE         = 'J2000'
      FRAME_-43055000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43055000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43055000_PRI_AXIS         = 'Z'
      FRAME_-43055000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43055000_PRI_OBSERVER     = 'GSAT0215'
      FRAME_-43055000_PRI_TARGET       = 'EARTH'
      FRAME_-43055000_PRI_ABCORR       = 'NONE'
      FRAME_-43055000_SEC_AXIS         = 'X'
      FRAME_-43055000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43055000_SEC_OBSERVER     = 'GSAT0215'
      FRAME_-43055000_SEC_TARGET       = 'SUN'
      FRAME_-43055000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0215_MEC               = -43055001
      FRAME_-43055001_NAME             = 'GSAT0215_MEC'
      FRAME_-43055001_CLASS            =  4
      FRAME_-43055001_CLASS_ID         = -43055001
      FRAME_-43055001_CENTER           = -43055
      TKFRAME_-43055001_RELATIVE       = 'GSAT0215_IGS'
      TKFRAME_-43055001_SPEC           = 'ANGLES'
      TKFRAME_-43055001_UNITS          = 'DEGREES'
      TKFRAME_-43055001_AXES           = (   3, 2, 1)
      TKFRAME_-43055001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0216_IGS               = -43056000
      FRAME_-43056000_NAME             = 'GSAT0216_IGS'
      FRAME_-43056000_CLASS            =  5
      FRAME_-43056000_CLASS_ID         = -43056000
      FRAME_-43056000_CENTER           = -43056
      FRAME_-43056000_RELATIVE         = 'J2000'
      FRAME_-43056000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43056000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43056000_PRI_AXIS         = 'Z'
      FRAME_-43056000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43056000_PRI_OBSERVER     = 'GSAT0216'
      FRAME_-43056000_PRI_TARGET       = 'EARTH'
      FRAME_-43056000_PRI_ABCORR       = 'NONE'
      FRAME_-43056000_SEC_AXIS         = 'X'
      FRAME_-43056000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43056000_SEC_OBSERVER     = 'GSAT0216'
      FRAME_-43056000_SEC_TARGET       = 'SUN'
      FRAME_-43056000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0216_MEC               = -43056001
      FRAME_-43056001_NAME             = 'GSAT0216_MEC'
      FRAME_-43056001_CLASS            =  4
      FRAME_-43056001_CLASS_ID         = -43056001
      FRAME_-43056001_CENTER           = -43056
      TKFRAME_-43056001_RELATIVE       = 'GSAT0216_IGS'
      TKFRAME_-43056001_SPEC           = 'ANGLES'
      TKFRAME_-43056001_UNITS          = 'DEGREES'
      TKFRAME_-43056001_AXES           = (   3, 2, 1)
      TKFRAME_-43056001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0217_IGS               = -43057000
      FRAME_-43057000_NAME             = 'GSAT0217_IGS'
      FRAME_-43057000_CLASS            =  5
      FRAME_-43057000_CLASS_ID         = -43057000
      FRAME_-43057000_CENTER           = -43057
      FRAME_-43057000_RELATIVE         = 'J2000'
      FRAME_-43057000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43057000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43057000_PRI_AXIS         = 'Z'
      FRAME_-43057000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43057000_PRI_OBSERVER     = 'GSAT0217'
      FRAME_-43057000_PRI_TARGET       = 'EARTH'
      FRAME_-43057000_PRI_ABCORR       = 'NONE'
      FRAME_-43057000_SEC_AXIS         = 'X'
      FRAME_-43057000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43057000_SEC_OBSERVER     = 'GSAT0217'
      FRAME_-43057000_SEC_TARGET       = 'SUN'
      FRAME_-43057000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0217_MEC               = -43057001
      FRAME_-43057001_NAME             = 'GSAT0217_MEC'
      FRAME_-43057001_CLASS            =  4
      FRAME_-43057001_CLASS_ID         = -43057001
      FRAME_-43057001_CENTER           = -43057
      TKFRAME_-43057001_RELATIVE       = 'GSAT0217_IGS'
      TKFRAME_-43057001_SPEC           = 'ANGLES'
      TKFRAME_-43057001_UNITS          = 'DEGREES'
      TKFRAME_-43057001_AXES           = (   3, 2, 1)
      TKFRAME_-43057001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0218_IGS               = -43058000
      FRAME_-43058000_NAME             = 'GSAT0218_IGS'
      FRAME_-43058000_CLASS            =  5
      FRAME_-43058000_CLASS_ID         = -43058000
      FRAME_-43058000_CENTER           = -43058
      FRAME_-43058000_RELATIVE         = 'J2000'
      FRAME_-43058000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43058000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43058000_PRI_AXIS         = 'Z'
      FRAME_-43058000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43058000_PRI_OBSERVER     = 'GSAT0218'
      FRAME_-43058000_PRI_TARGET       = 'EARTH'
      FRAME_-43058000_PRI_ABCORR       = 'NONE'
      FRAME_-43058000_SEC_AXIS         = 'X'
      FRAME_-43058000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43058000_SEC_OBSERVER     = 'GSAT0218'
      FRAME_-43058000_SEC_TARGET       = 'SUN'
      FRAME_-43058000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0218_MEC               = -43058001
      FRAME_-43058001_NAME             = 'GSAT0218_MEC'
      FRAME_-43058001_CLASS            =  4
      FRAME_-43058001_CLASS_ID         = -43058001
      FRAME_-43058001_CENTER           = -43058
      TKFRAME_-43058001_RELATIVE       = 'GSAT0218_IGS'
      TKFRAME_-43058001_SPEC           = 'ANGLES'
      TKFRAME_-43058001_UNITS          = 'DEGREES'
      TKFRAME_-43058001_AXES           = (   3, 2, 1)
      TKFRAME_-43058001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0219_IGS               = -43566000
      FRAME_-43566000_NAME             = 'GSAT0219_IGS'
      FRAME_-43566000_CLASS            =  5
      FRAME_-43566000_CLASS_ID         = -43566000
      FRAME_-43566000_CENTER           = -43566
      FRAME_-43566000_RELATIVE         = 'J2000'
      FRAME_-43566000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43566000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43566000_PRI_AXIS         = 'Z'
      FRAME_-43566000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43566000_PRI_OBSERVER     = 'GSAT0219'
      FRAME_-43566000_PRI_TARGET       = 'EARTH'
      FRAME_-43566000_PRI_ABCORR       = 'NONE'
      FRAME_-43566000_SEC_AXIS         = 'X'
      FRAME_-43566000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43566000_SEC_OBSERVER     = 'GSAT0219'
      FRAME_-43566000_SEC_TARGET       = 'SUN'
      FRAME_-43566000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0219_MEC               = -43566001
      FRAME_-43566001_NAME             = 'GSAT0219_MEC'
      FRAME_-43566001_CLASS            =  4
      FRAME_-43566001_CLASS_ID         = -43566001
      FRAME_-43566001_CENTER           = -43566
      TKFRAME_-43566001_RELATIVE       = 'GSAT0219_IGS'
      TKFRAME_-43566001_SPEC           = 'ANGLES'
      TKFRAME_-43566001_UNITS          = 'DEGREES'
      TKFRAME_-43566001_AXES           = (   3, 2, 1)
      TKFRAME_-43566001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0220_IGS               = -43567000
      FRAME_-43567000_NAME             = 'GSAT0220_IGS'
      FRAME_-43567000_CLASS            =  5
      FRAME_-43567000_CLASS_ID         = -43567000
      FRAME_-43567000_CENTER           = -43567
      FRAME_-43567000_RELATIVE         = 'J2000'
      FRAME_-43567000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43567000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43567000_PRI_AXIS         = 'Z'
      FRAME_-43567000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43567000_PRI_OBSERVER     = 'GSAT0220'
      FRAME_-43567000_PRI_TARGET       = 'EARTH'
      FRAME_-43567000_PRI_ABCORR       = 'NONE'
      FRAME_-43567000_SEC_AXIS         = 'X'
      FRAME_-43567000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43567000_SEC_OBSERVER     = 'GSAT0220'
      FRAME_-43567000_SEC_TARGET       = 'SUN'
      FRAME_-43567000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0220_MEC               = -43567001
      FRAME_-43567001_NAME             = 'GSAT0220_MEC'
      FRAME_-43567001_CLASS            =  4
      FRAME_-43567001_CLASS_ID         = -43567001
      FRAME_-43567001_CENTER           = -43567
      TKFRAME_-43567001_RELATIVE       = 'GSAT0220_IGS'
      TKFRAME_-43567001_SPEC           = 'ANGLES'
      TKFRAME_-43567001_UNITS          = 'DEGREES'
      TKFRAME_-43567001_AXES           = (   3, 2, 1)
      TKFRAME_-43567001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0221_IGS               = -43564000
      FRAME_-43564000_NAME             = 'GSAT0221_IGS'
      FRAME_-43564000_CLASS            =  5
      FRAME_-43564000_CLASS_ID         = -43564000
      FRAME_-43564000_CENTER           = -43564
      FRAME_-43564000_RELATIVE         = 'J2000'
      FRAME_-43564000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43564000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43564000_PRI_AXIS         = 'Z'
      FRAME_-43564000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43564000_PRI_OBSERVER     = 'GSAT0221'
      FRAME_-43564000_PRI_TARGET       = 'EARTH'
      FRAME_-43564000_PRI_ABCORR       = 'NONE'
      FRAME_-43564000_SEC_AXIS         = 'X'
      FRAME_-43564000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43564000_SEC_OBSERVER     = 'GSAT0221'
      FRAME_-43564000_SEC_TARGET       = 'SUN'
      FRAME_-43564000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0221_MEC               = -43564001
      FRAME_-43564001_NAME             = 'GSAT0221_MEC'
      FRAME_-43564001_CLASS            =  4
      FRAME_-43564001_CLASS_ID         = -43564001
      FRAME_-43564001_CENTER           = -43564
      TKFRAME_-43564001_RELATIVE       = 'GSAT0221_IGS'
      TKFRAME_-43564001_SPEC           = 'ANGLES'
      TKFRAME_-43564001_UNITS          = 'DEGREES'
      TKFRAME_-43564001_AXES           = (   3, 2, 1)
      TKFRAME_-43564001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0222_IGS               = -43565000
      FRAME_-43565000_NAME             = 'GSAT0222_IGS'
      FRAME_-43565000_CLASS            =  5
      FRAME_-43565000_CLASS_ID         = -43565000
      FRAME_-43565000_CENTER           = -43565
      FRAME_-43565000_RELATIVE         = 'J2000'
      FRAME_-43565000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43565000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43565000_PRI_AXIS         = 'Z'
      FRAME_-43565000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43565000_PRI_OBSERVER     = 'GSAT0222'
      FRAME_-43565000_PRI_TARGET       = 'EARTH'
      FRAME_-43565000_PRI_ABCORR       = 'NONE'
      FRAME_-43565000_SEC_AXIS         = 'X'
      FRAME_-43565000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43565000_SEC_OBSERVER     = 'GSAT0222'
      FRAME_-43565000_SEC_TARGET       = 'SUN'
      FRAME_-43565000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0222_MEC               = -43565001
      FRAME_-43565001_NAME             = 'GSAT0222_MEC'
      FRAME_-43565001_CLASS            =  4
      FRAME_-43565001_CLASS_ID         = -43565001
      FRAME_-43565001_CENTER           = -43565
      TKFRAME_-43565001_RELATIVE       = 'GSAT0222_IGS'
      TKFRAME_-43565001_SPEC           = 'ANGLES'
      TKFRAME_-43565001_UNITS          = 'DEGREES'
      TKFRAME_-43565001_AXES           = (   3, 2, 1)
      TKFRAME_-43565001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0223_IGS               = -49809000
      FRAME_-49809000_NAME             = 'GSAT0223_IGS'
      FRAME_-49809000_CLASS            =  5
      FRAME_-49809000_CLASS_ID         = -49809000
      FRAME_-49809000_CENTER           = -49809
      FRAME_-49809000_RELATIVE         = 'J2000'
      FRAME_-49809000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-49809000_FAMILY           = 'TWO-VECTOR'
      FRAME_-49809000_PRI_AXIS         = 'Z'
      FRAME_-49809000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49809000_PRI_OBSERVER     = 'GSAT0223'
      FRAME_-49809000_PRI_TARGET       = 'EARTH'
      FRAME_-49809000_PRI_ABCORR       = 'NONE'
      FRAME_-49809000_SEC_AXIS         = 'X'
      FRAME_-49809000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49809000_SEC_OBSERVER     = 'GSAT0223'
      FRAME_-49809000_SEC_TARGET       = 'SUN'
      FRAME_-49809000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0223_MEC               = -49809001
      FRAME_-49809001_NAME             = 'GSAT0223_MEC'
      FRAME_-49809001_CLASS            =  4
      FRAME_-49809001_CLASS_ID         = -49809001
      FRAME_-49809001_CENTER           = -49809
      TKFRAME_-49809001_RELATIVE       = 'GSAT0223_IGS'
      TKFRAME_-49809001_SPEC           = 'ANGLES'
      TKFRAME_-49809001_UNITS          = 'DEGREES'
      TKFRAME_-49809001_AXES           = (   3, 2, 1)
      TKFRAME_-49809001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0224_IGS               = -49810000
      FRAME_-49810000_NAME             = 'GSAT0224_IGS'
      FRAME_-49810000_CLASS            =  5
      FRAME_-49810000_CLASS_ID         = -49810000
      FRAME_-49810000_CENTER           = -49810
      FRAME_-49810000_RELATIVE         = 'J2000'
      FRAME_-49810000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-49810000_FAMILY           = 'TWO-VECTOR'
      FRAME_-49810000_PRI_AXIS         = 'Z'
      FRAME_-49810000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49810000_PRI_OBSERVER     = 'GSAT0224'
      FRAME_-49810000_PRI_TARGET       = 'EARTH'
      FRAME_-49810000_PRI_ABCORR       = 'NONE'
      FRAME_-49810000_SEC_AXIS         = 'X'
      FRAME_-49810000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49810000_SEC_OBSERVER     = 'GSAT0224'
      FRAME_-49810000_SEC_TARGET       = 'SUN'
      FRAME_-49810000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0224_MEC               = -49810001
      FRAME_-49810001_NAME             = 'GSAT0224_MEC'
      FRAME_-49810001_CLASS            =  4
      FRAME_-49810001_CLASS_ID         = -49810001
      FRAME_-49810001_CENTER           = -49810
      TKFRAME_-49810001_RELATIVE       = 'GSAT0224_IGS'
      TKFRAME_-49810001_SPEC           = 'ANGLES'
      TKFRAME_-49810001_UNITS          = 'DEGREES'
      TKFRAME_-49810001_AXES           = (   3, 2, 1)
      TKFRAME_-49810001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0225_IGS               = -59598000
      FRAME_-59598000_NAME             = 'GSAT0225_IGS'
      FRAME_-59598000_CLASS            =  5
      FRAME_-59598000_CLASS_ID         = -59598000
      FRAME_-59598000_CENTER           = -59598
      FRAME_-59598000_RELATIVE         = 'J2000'
      FRAME_-59598000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-59598000_FAMILY           = 'TWO-VECTOR'
      FRAME_-59598000_PRI_AXIS         = 'Z'
      FRAME_-59598000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-59598000_PRI_OBSERVER     = 'GSAT0225'
      FRAME_-59598000_PRI_TARGET       = 'EARTH'
      FRAME_-59598000_PRI_ABCORR       = 'NONE'
      FRAME_-59598000_SEC_AXIS         = 'X'
      FRAME_-59598000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-59598000_SEC_OBSERVER     = 'GSAT0225'
      FRAME_-59598000_SEC_TARGET       = 'SUN'
      FRAME_-59598000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0225_MEC               = -59598001
      FRAME_-59598001_NAME             = 'GSAT0225_MEC'
      FRAME_-59598001_CLASS            =  4
      FRAME_-59598001_CLASS_ID         = -59598001
      FRAME_-59598001_CENTER           = -59598
      TKFRAME_-59598001_RELATIVE       = 'GSAT0225_IGS'
      TKFRAME_-59598001_SPEC           = 'ANGLES'
      TKFRAME_-59598001_UNITS          = 'DEGREES'
      TKFRAME_-59598001_AXES           = (   3, 2, 1)
      TKFRAME_-59598001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0226_IGS               = -61183000
      FRAME_-61183000_NAME             = 'GSAT0226_IGS'
      FRAME_-61183000_CLASS            =  5
      FRAME_-61183000_CLASS_ID         = -61183000
      FRAME_-61183000_CENTER           = -61183
      FRAME_-61183000_RELATIVE         = 'J2000'
      FRAME_-61183000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-61183000_FAMILY           = 'TWO-VECTOR'
      FRAME_-61183000_PRI_AXIS         = 'Z'
      FRAME_-61183000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61183000_PRI_OBSERVER     = 'GSAT0226'
      FRAME_-61183000_PRI_TARGET       = 'EARTH'
      FRAME_-61183000_PRI_ABCORR       = 'NONE'
      FRAME_-61183000_SEC_AXIS         = 'X'
      FRAME_-61183000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61183000_SEC_OBSERVER     = 'GSAT0226'
      FRAME_-61183000_SEC_TARGET       = 'SUN'
      FRAME_-61183000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0226_MEC               = -61183001
      FRAME_-61183001_NAME             = 'GSAT0226_MEC'
      FRAME_-61183001_CLASS            =  4
      FRAME_-61183001_CLASS_ID         = -61183001
      FRAME_-61183001_CENTER           = -61183
      TKFRAME_-61183001_RELATIVE       = 'GSAT0226_IGS'
      TKFRAME_-61183001_SPEC           = 'ANGLES'
      TKFRAME_-61183001_UNITS          = 'DEGREES'
      TKFRAME_-61183001_AXES           = (   3, 2, 1)
      TKFRAME_-61183001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0227_IGS               = -59600000
      FRAME_-59600000_NAME             = 'GSAT0227_IGS'
      FRAME_-59600000_CLASS            =  5
      FRAME_-59600000_CLASS_ID         = -59600000
      FRAME_-59600000_CENTER           = -59600
      FRAME_-59600000_RELATIVE         = 'J2000'
      FRAME_-59600000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-59600000_FAMILY           = 'TWO-VECTOR'
      FRAME_-59600000_PRI_AXIS         = 'Z'
      FRAME_-59600000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-59600000_PRI_OBSERVER     = 'GSAT0227'
      FRAME_-59600000_PRI_TARGET       = 'EARTH'
      FRAME_-59600000_PRI_ABCORR       = 'NONE'
      FRAME_-59600000_SEC_AXIS         = 'X'
      FRAME_-59600000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-59600000_SEC_OBSERVER     = 'GSAT0227'
      FRAME_-59600000_SEC_TARGET       = 'SUN'
      FRAME_-59600000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0227_MEC               = -59600001
      FRAME_-59600001_NAME             = 'GSAT0227_MEC'
      FRAME_-59600001_CLASS            =  4
      FRAME_-59600001_CLASS_ID         = -59600001
      FRAME_-59600001_CENTER           = -59600
      TKFRAME_-59600001_RELATIVE       = 'GSAT0227_IGS'
      TKFRAME_-59600001_SPEC           = 'ANGLES'
      TKFRAME_-59600001_UNITS          = 'DEGREES'
      TKFRAME_-59600001_AXES           = (   3, 2, 1)
      TKFRAME_-59600001_ANGLES         = ( 180, 0, 0)

      FRAME_GSAT0232_IGS               = -61182000
      FRAME_-61182000_NAME             = 'GSAT0232_IGS'
      FRAME_-61182000_CLASS            =  5
      FRAME_-61182000_CLASS_ID         = -61182000
      FRAME_-61182000_CENTER           = -61182
      FRAME_-61182000_RELATIVE         = 'J2000'
      FRAME_-61182000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-61182000_FAMILY           = 'TWO-VECTOR'
      FRAME_-61182000_PRI_AXIS         = 'Z'
      FRAME_-61182000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61182000_PRI_OBSERVER     = 'GSAT0232'
      FRAME_-61182000_PRI_TARGET       = 'EARTH'
      FRAME_-61182000_PRI_ABCORR       = 'NONE'
      FRAME_-61182000_SEC_AXIS         = 'X'
      FRAME_-61182000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61182000_SEC_OBSERVER     = 'GSAT0232'
      FRAME_-61182000_SEC_TARGET       = 'SUN'
      FRAME_-61182000_SEC_ABCORR       = 'NONE'

      FRAME_GSAT0232_MEC               = -61182001
      FRAME_-61182001_NAME             = 'GSAT0232_MEC'
      FRAME_-61182001_CLASS            =  4
      FRAME_-61182001_CLASS_ID         = -61182001
      FRAME_-61182001_CENTER           = -61182
      TKFRAME_-61182001_RELATIVE       = 'GSAT0232_IGS'
      TKFRAME_-61182001_SPEC           = 'ANGLES'
      TKFRAME_-61182001_UNITS          = 'DEGREES'
      TKFRAME_-61182001_AXES           = (   3, 2, 1)
      TKFRAME_-61182001_ANGLES         = ( 180, 0, 0)



      FRAME_GPS_BIIF-1_IGS             = -36585000
      FRAME_-36585000_NAME             = 'GPS_BIIF-1_IGS'
      FRAME_-36585000_CLASS            =  5
      FRAME_-36585000_CLASS_ID         = -36585000
      FRAME_-36585000_CENTER           = -36585
      FRAME_-36585000_RELATIVE         = 'J2000'
      FRAME_-36585000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-36585000_FAMILY           = 'TWO-VECTOR'
      FRAME_-36585000_PRI_AXIS         = 'Z'
      FRAME_-36585000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36585000_PRI_OBSERVER     = 'GPS_BIIF-1'
      FRAME_-36585000_PRI_TARGET       = 'EARTH'
      FRAME_-36585000_PRI_ABCORR       = 'NONE'
      FRAME_-36585000_SEC_AXIS         = 'X'
      FRAME_-36585000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36585000_SEC_OBSERVER     = 'GPS_BIIF-1'
      FRAME_-36585000_SEC_TARGET       = 'SUN'
      FRAME_-36585000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-10_IGS            = -40730000
      FRAME_-40730000_NAME             = 'GPS_BIIF-10_IGS'
      FRAME_-40730000_CLASS            =  5
      FRAME_-40730000_CLASS_ID         = -40730000
      FRAME_-40730000_CENTER           = -40730
      FRAME_-40730000_RELATIVE         = 'J2000'
      FRAME_-40730000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40730000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40730000_PRI_AXIS         = 'Z'
      FRAME_-40730000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40730000_PRI_OBSERVER     = 'GPS_BIIF-10'
      FRAME_-40730000_PRI_TARGET       = 'EARTH'
      FRAME_-40730000_PRI_ABCORR       = 'NONE'
      FRAME_-40730000_SEC_AXIS         = 'X'
      FRAME_-40730000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40730000_SEC_OBSERVER     = 'GPS_BIIF-10'
      FRAME_-40730000_SEC_TARGET       = 'SUN'
      FRAME_-40730000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-11_IGS            = -41019000
      FRAME_-41019000_NAME             = 'GPS_BIIF-11_IGS'
      FRAME_-41019000_CLASS            =  5
      FRAME_-41019000_CLASS_ID         = -41019000
      FRAME_-41019000_CENTER           = -41019
      FRAME_-41019000_RELATIVE         = 'J2000'
      FRAME_-41019000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41019000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41019000_PRI_AXIS         = 'Z'
      FRAME_-41019000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41019000_PRI_OBSERVER     = 'GPS_BIIF-11'
      FRAME_-41019000_PRI_TARGET       = 'EARTH'
      FRAME_-41019000_PRI_ABCORR       = 'NONE'
      FRAME_-41019000_SEC_AXIS         = 'X'
      FRAME_-41019000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41019000_SEC_OBSERVER     = 'GPS_BIIF-11'
      FRAME_-41019000_SEC_TARGET       = 'SUN'
      FRAME_-41019000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-12_IGS            = -41328000
      FRAME_-41328000_NAME             = 'GPS_BIIF-12_IGS'
      FRAME_-41328000_CLASS            =  5
      FRAME_-41328000_CLASS_ID         = -41328000
      FRAME_-41328000_CENTER           = -41328
      FRAME_-41328000_RELATIVE         = 'J2000'
      FRAME_-41328000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41328000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41328000_PRI_AXIS         = 'Z'
      FRAME_-41328000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41328000_PRI_OBSERVER     = 'GPS_BIIF-12'
      FRAME_-41328000_PRI_TARGET       = 'EARTH'
      FRAME_-41328000_PRI_ABCORR       = 'NONE'
      FRAME_-41328000_SEC_AXIS         = 'X'
      FRAME_-41328000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41328000_SEC_OBSERVER     = 'GPS_BIIF-12'
      FRAME_-41328000_SEC_TARGET       = 'SUN'
      FRAME_-41328000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-3_IGS             = -38833000
      FRAME_-38833000_NAME             = 'GPS_BIIF-3_IGS'
      FRAME_-38833000_CLASS            =  5
      FRAME_-38833000_CLASS_ID         = -38833000
      FRAME_-38833000_CENTER           = -38833
      FRAME_-38833000_RELATIVE         = 'J2000'
      FRAME_-38833000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38833000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38833000_PRI_AXIS         = 'Z'
      FRAME_-38833000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38833000_PRI_OBSERVER     = 'GPS_BIIF-3'
      FRAME_-38833000_PRI_TARGET       = 'EARTH'
      FRAME_-38833000_PRI_ABCORR       = 'NONE'
      FRAME_-38833000_SEC_AXIS         = 'X'
      FRAME_-38833000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38833000_SEC_OBSERVER     = 'GPS_BIIF-3'
      FRAME_-38833000_SEC_TARGET       = 'SUN'
      FRAME_-38833000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-4_IGS             = -39166000
      FRAME_-39166000_NAME             = 'GPS_BIIF-4_IGS'
      FRAME_-39166000_CLASS            =  5
      FRAME_-39166000_CLASS_ID         = -39166000
      FRAME_-39166000_CENTER           = -39166
      FRAME_-39166000_RELATIVE         = 'J2000'
      FRAME_-39166000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39166000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39166000_PRI_AXIS         = 'Z'
      FRAME_-39166000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39166000_PRI_OBSERVER     = 'GPS_BIIF-4'
      FRAME_-39166000_PRI_TARGET       = 'EARTH'
      FRAME_-39166000_PRI_ABCORR       = 'NONE'
      FRAME_-39166000_SEC_AXIS         = 'X'
      FRAME_-39166000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39166000_SEC_OBSERVER     = 'GPS_BIIF-4'
      FRAME_-39166000_SEC_TARGET       = 'SUN'
      FRAME_-39166000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-5_IGS             = -39533000
      FRAME_-39533000_NAME             = 'GPS_BIIF-5_IGS'
      FRAME_-39533000_CLASS            =  5
      FRAME_-39533000_CLASS_ID         = -39533000
      FRAME_-39533000_CENTER           = -39533
      FRAME_-39533000_RELATIVE         = 'J2000'
      FRAME_-39533000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39533000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39533000_PRI_AXIS         = 'Z'
      FRAME_-39533000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39533000_PRI_OBSERVER     = 'GPS_BIIF-5'
      FRAME_-39533000_PRI_TARGET       = 'EARTH'
      FRAME_-39533000_PRI_ABCORR       = 'NONE'
      FRAME_-39533000_SEC_AXIS         = 'X'
      FRAME_-39533000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39533000_SEC_OBSERVER     = 'GPS_BIIF-5'
      FRAME_-39533000_SEC_TARGET       = 'SUN'
      FRAME_-39533000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-6_IGS             = -39741000
      FRAME_-39741000_NAME             = 'GPS_BIIF-6_IGS'
      FRAME_-39741000_CLASS            =  5
      FRAME_-39741000_CLASS_ID         = -39741000
      FRAME_-39741000_CENTER           = -39741
      FRAME_-39741000_RELATIVE         = 'J2000'
      FRAME_-39741000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39741000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39741000_PRI_AXIS         = 'Z'
      FRAME_-39741000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39741000_PRI_OBSERVER     = 'GPS_BIIF-6'
      FRAME_-39741000_PRI_TARGET       = 'EARTH'
      FRAME_-39741000_PRI_ABCORR       = 'NONE'
      FRAME_-39741000_SEC_AXIS         = 'X'
      FRAME_-39741000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39741000_SEC_OBSERVER     = 'GPS_BIIF-6'
      FRAME_-39741000_SEC_TARGET       = 'SUN'
      FRAME_-39741000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-7_IGS             = -40105000
      FRAME_-40105000_NAME             = 'GPS_BIIF-7_IGS'
      FRAME_-40105000_CLASS            =  5
      FRAME_-40105000_CLASS_ID         = -40105000
      FRAME_-40105000_CENTER           = -40105
      FRAME_-40105000_RELATIVE         = 'J2000'
      FRAME_-40105000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40105000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40105000_PRI_AXIS         = 'Z'
      FRAME_-40105000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40105000_PRI_OBSERVER     = 'GPS_BIIF-7'
      FRAME_-40105000_PRI_TARGET       = 'EARTH'
      FRAME_-40105000_PRI_ABCORR       = 'NONE'
      FRAME_-40105000_SEC_AXIS         = 'X'
      FRAME_-40105000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40105000_SEC_OBSERVER     = 'GPS_BIIF-7'
      FRAME_-40105000_SEC_TARGET       = 'SUN'
      FRAME_-40105000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-8_IGS             = -40294000
      FRAME_-40294000_NAME             = 'GPS_BIIF-8_IGS'
      FRAME_-40294000_CLASS            =  5
      FRAME_-40294000_CLASS_ID         = -40294000
      FRAME_-40294000_CENTER           = -40294
      FRAME_-40294000_RELATIVE         = 'J2000'
      FRAME_-40294000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40294000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40294000_PRI_AXIS         = 'Z'
      FRAME_-40294000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40294000_PRI_OBSERVER     = 'GPS_BIIF-8'
      FRAME_-40294000_PRI_TARGET       = 'EARTH'
      FRAME_-40294000_PRI_ABCORR       = 'NONE'
      FRAME_-40294000_SEC_AXIS         = 'X'
      FRAME_-40294000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40294000_SEC_OBSERVER     = 'GPS_BIIF-8'
      FRAME_-40294000_SEC_TARGET       = 'SUN'
      FRAME_-40294000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIF-9_IGS             = -40534000
      FRAME_-40534000_NAME             = 'GPS_BIIF-9_IGS'
      FRAME_-40534000_CLASS            =  5
      FRAME_-40534000_CLASS_ID         = -40534000
      FRAME_-40534000_CENTER           = -40534
      FRAME_-40534000_RELATIVE         = 'J2000'
      FRAME_-40534000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40534000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40534000_PRI_AXIS         = 'Z'
      FRAME_-40534000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40534000_PRI_OBSERVER     = 'GPS_BIIF-9'
      FRAME_-40534000_PRI_TARGET       = 'EARTH'
      FRAME_-40534000_PRI_ABCORR       = 'NONE'
      FRAME_-40534000_SEC_AXIS         = 'X'
      FRAME_-40534000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40534000_SEC_OBSERVER     = 'GPS_BIIF-9'
      FRAME_-40534000_SEC_TARGET       = 'SUN'
      FRAME_-40534000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-1_IGS             = -43873000
      FRAME_-43873000_NAME             = 'GPS_BIII-1_IGS'
      FRAME_-43873000_CLASS            =  5
      FRAME_-43873000_CLASS_ID         = -43873000
      FRAME_-43873000_CENTER           = -43873
      FRAME_-43873000_RELATIVE         = 'J2000'
      FRAME_-43873000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43873000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43873000_PRI_AXIS         = 'Z'
      FRAME_-43873000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43873000_PRI_OBSERVER     = 'GPS_BIII-1'
      FRAME_-43873000_PRI_TARGET       = 'EARTH'
      FRAME_-43873000_PRI_ABCORR       = 'NONE'
      FRAME_-43873000_SEC_AXIS         = 'X'
      FRAME_-43873000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43873000_SEC_OBSERVER     = 'GPS_BIII-1'
      FRAME_-43873000_SEC_TARGET       = 'SUN'
      FRAME_-43873000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-2_IGS             = -44506000
      FRAME_-44506000_NAME             = 'GPS_BIII-2_IGS'
      FRAME_-44506000_CLASS            =  5
      FRAME_-44506000_CLASS_ID         = -44506000
      FRAME_-44506000_CENTER           = -44506
      FRAME_-44506000_RELATIVE         = 'J2000'
      FRAME_-44506000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44506000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44506000_PRI_AXIS         = 'Z'
      FRAME_-44506000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44506000_PRI_OBSERVER     = 'GPS_BIII-2'
      FRAME_-44506000_PRI_TARGET       = 'EARTH'
      FRAME_-44506000_PRI_ABCORR       = 'NONE'
      FRAME_-44506000_SEC_AXIS         = 'X'
      FRAME_-44506000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44506000_SEC_OBSERVER     = 'GPS_BIII-2'
      FRAME_-44506000_SEC_TARGET       = 'SUN'
      FRAME_-44506000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-3_IGS             = -45854000
      FRAME_-45854000_NAME             = 'GPS_BIII-3_IGS'
      FRAME_-45854000_CLASS            =  5
      FRAME_-45854000_CLASS_ID         = -45854000
      FRAME_-45854000_CENTER           = -45854
      FRAME_-45854000_RELATIVE         = 'J2000'
      FRAME_-45854000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-45854000_FAMILY           = 'TWO-VECTOR'
      FRAME_-45854000_PRI_AXIS         = 'Z'
      FRAME_-45854000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45854000_PRI_OBSERVER     = 'GPS_BIII-3'
      FRAME_-45854000_PRI_TARGET       = 'EARTH'
      FRAME_-45854000_PRI_ABCORR       = 'NONE'
      FRAME_-45854000_SEC_AXIS         = 'X'
      FRAME_-45854000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45854000_SEC_OBSERVER     = 'GPS_BIII-3'
      FRAME_-45854000_SEC_TARGET       = 'SUN'
      FRAME_-45854000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-4_IGS             = -46826000
      FRAME_-46826000_NAME             = 'GPS_BIII-4_IGS'
      FRAME_-46826000_CLASS            =  5
      FRAME_-46826000_CLASS_ID         = -46826000
      FRAME_-46826000_CENTER           = -46826
      FRAME_-46826000_RELATIVE         = 'J2000'
      FRAME_-46826000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-46826000_FAMILY           = 'TWO-VECTOR'
      FRAME_-46826000_PRI_AXIS         = 'Z'
      FRAME_-46826000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46826000_PRI_OBSERVER     = 'GPS_BIII-4'
      FRAME_-46826000_PRI_TARGET       = 'EARTH'
      FRAME_-46826000_PRI_ABCORR       = 'NONE'
      FRAME_-46826000_SEC_AXIS         = 'X'
      FRAME_-46826000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46826000_SEC_OBSERVER     = 'GPS_BIII-4'
      FRAME_-46826000_SEC_TARGET       = 'SUN'
      FRAME_-46826000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-5_IGS             = -48859000
      FRAME_-48859000_NAME             = 'GPS_BIII-5_IGS'
      FRAME_-48859000_CLASS            =  5
      FRAME_-48859000_CLASS_ID         = -48859000
      FRAME_-48859000_CENTER           = -48859
      FRAME_-48859000_RELATIVE         = 'J2000'
      FRAME_-48859000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-48859000_FAMILY           = 'TWO-VECTOR'
      FRAME_-48859000_PRI_AXIS         = 'Z'
      FRAME_-48859000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-48859000_PRI_OBSERVER     = 'GPS_BIII-5'
      FRAME_-48859000_PRI_TARGET       = 'EARTH'
      FRAME_-48859000_PRI_ABCORR       = 'NONE'
      FRAME_-48859000_SEC_AXIS         = 'X'
      FRAME_-48859000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-48859000_SEC_OBSERVER     = 'GPS_BIII-5'
      FRAME_-48859000_SEC_TARGET       = 'SUN'
      FRAME_-48859000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-6_IGS             = -55268000
      FRAME_-55268000_NAME             = 'GPS_BIII-6_IGS'
      FRAME_-55268000_CLASS            =  5
      FRAME_-55268000_CLASS_ID         = -55268000
      FRAME_-55268000_CENTER           = -55268
      FRAME_-55268000_RELATIVE         = 'J2000'
      FRAME_-55268000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-55268000_FAMILY           = 'TWO-VECTOR'
      FRAME_-55268000_PRI_AXIS         = 'Z'
      FRAME_-55268000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-55268000_PRI_OBSERVER     = 'GPS_BIII-6'
      FRAME_-55268000_PRI_TARGET       = 'EARTH'
      FRAME_-55268000_PRI_ABCORR       = 'NONE'
      FRAME_-55268000_SEC_AXIS         = 'X'
      FRAME_-55268000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-55268000_SEC_OBSERVER     = 'GPS_BIII-6'
      FRAME_-55268000_SEC_TARGET       = 'SUN'
      FRAME_-55268000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-7_IGS             = -62339000
      FRAME_-62339000_NAME             = 'GPS_BIII-7_IGS'
      FRAME_-62339000_CLASS            =  5
      FRAME_-62339000_CLASS_ID         = -62339000
      FRAME_-62339000_CENTER           = -62339
      FRAME_-62339000_RELATIVE         = 'J2000'
      FRAME_-62339000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-62339000_FAMILY           = 'TWO-VECTOR'
      FRAME_-62339000_PRI_AXIS         = 'Z'
      FRAME_-62339000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-62339000_PRI_OBSERVER     = 'GPS_BIII-7'
      FRAME_-62339000_PRI_TARGET       = 'EARTH'
      FRAME_-62339000_PRI_ABCORR       = 'NONE'
      FRAME_-62339000_SEC_AXIS         = 'X'
      FRAME_-62339000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-62339000_SEC_OBSERVER     = 'GPS_BIII-7'
      FRAME_-62339000_SEC_TARGET       = 'SUN'
      FRAME_-62339000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIII-8_IGS             = -64202000
      FRAME_-64202000_NAME             = 'GPS_BIII-8_IGS'
      FRAME_-64202000_CLASS            =  5
      FRAME_-64202000_CLASS_ID         = -64202000
      FRAME_-64202000_CENTER           = -64202
      FRAME_-64202000_RELATIVE         = 'J2000'
      FRAME_-64202000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-64202000_FAMILY           = 'TWO-VECTOR'
      FRAME_-64202000_PRI_AXIS         = 'Z'
      FRAME_-64202000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-64202000_PRI_OBSERVER     = 'GPS_BIII-8'
      FRAME_-64202000_PRI_TARGET       = 'EARTH'
      FRAME_-64202000_PRI_ABCORR       = 'NONE'
      FRAME_-64202000_SEC_AXIS         = 'X'
      FRAME_-64202000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-64202000_SEC_OBSERVER     = 'GPS_BIII-8'
      FRAME_-64202000_SEC_TARGET       = 'SUN'
      FRAME_-64202000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-11_IGS            = -28190000
      FRAME_-28190000_NAME             = 'GPS_BIIR-11_IGS'
      FRAME_-28190000_CLASS            =  5
      FRAME_-28190000_CLASS_ID         = -28190000
      FRAME_-28190000_CENTER           = -28190
      FRAME_-28190000_RELATIVE         = 'J2000'
      FRAME_-28190000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28190000_FAMILY           = 'TWO-VECTOR'
      FRAME_-28190000_PRI_AXIS         = 'Z'
      FRAME_-28190000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28190000_PRI_OBSERVER     = 'GPS_BIIR-11'
      FRAME_-28190000_PRI_TARGET       = 'EARTH'
      FRAME_-28190000_PRI_ABCORR       = 'NONE'
      FRAME_-28190000_SEC_AXIS         = 'X'
      FRAME_-28190000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28190000_SEC_OBSERVER     = 'GPS_BIIR-11'
      FRAME_-28190000_SEC_TARGET       = 'SUN'
      FRAME_-28190000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-13_IGS            = -28474000
      FRAME_-28474000_NAME             = 'GPS_BIIR-13_IGS'
      FRAME_-28474000_CLASS            =  5
      FRAME_-28474000_CLASS_ID         = -28474000
      FRAME_-28474000_CENTER           = -28474
      FRAME_-28474000_RELATIVE         = 'J2000'
      FRAME_-28474000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28474000_FAMILY           = 'TWO-VECTOR'
      FRAME_-28474000_PRI_AXIS         = 'Z'
      FRAME_-28474000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28474000_PRI_OBSERVER     = 'GPS_BIIR-13'
      FRAME_-28474000_PRI_TARGET       = 'EARTH'
      FRAME_-28474000_PRI_ABCORR       = 'NONE'
      FRAME_-28474000_SEC_AXIS         = 'X'
      FRAME_-28474000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28474000_SEC_OBSERVER     = 'GPS_BIIR-13'
      FRAME_-28474000_SEC_TARGET       = 'SUN'
      FRAME_-28474000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-2_IGS             = -24876000
      FRAME_-24876000_NAME             = 'GPS_BIIR-2_IGS'
      FRAME_-24876000_CLASS            =  5
      FRAME_-24876000_CLASS_ID         = -24876000
      FRAME_-24876000_CENTER           = -24876
      FRAME_-24876000_RELATIVE         = 'J2000'
      FRAME_-24876000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-24876000_FAMILY           = 'TWO-VECTOR'
      FRAME_-24876000_PRI_AXIS         = 'Z'
      FRAME_-24876000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-24876000_PRI_OBSERVER     = 'GPS_BIIR-2'
      FRAME_-24876000_PRI_TARGET       = 'EARTH'
      FRAME_-24876000_PRI_ABCORR       = 'NONE'
      FRAME_-24876000_SEC_AXIS         = 'X'
      FRAME_-24876000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-24876000_SEC_OBSERVER     = 'GPS_BIIR-2'
      FRAME_-24876000_SEC_TARGET       = 'SUN'
      FRAME_-24876000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-4_IGS             = -26360000
      FRAME_-26360000_NAME             = 'GPS_BIIR-4_IGS'
      FRAME_-26360000_CLASS            =  5
      FRAME_-26360000_CLASS_ID         = -26360000
      FRAME_-26360000_CENTER           = -26360
      FRAME_-26360000_RELATIVE         = 'J2000'
      FRAME_-26360000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-26360000_FAMILY           = 'TWO-VECTOR'
      FRAME_-26360000_PRI_AXIS         = 'Z'
      FRAME_-26360000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-26360000_PRI_OBSERVER     = 'GPS_BIIR-4'
      FRAME_-26360000_PRI_TARGET       = 'EARTH'
      FRAME_-26360000_PRI_ABCORR       = 'NONE'
      FRAME_-26360000_SEC_AXIS         = 'X'
      FRAME_-26360000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-26360000_SEC_OBSERVER     = 'GPS_BIIR-4'
      FRAME_-26360000_SEC_TARGET       = 'SUN'
      FRAME_-26360000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-5_IGS             = -26407000
      FRAME_-26407000_NAME             = 'GPS_BIIR-5_IGS'
      FRAME_-26407000_CLASS            =  5
      FRAME_-26407000_CLASS_ID         = -26407000
      FRAME_-26407000_CENTER           = -26407
      FRAME_-26407000_RELATIVE         = 'J2000'
      FRAME_-26407000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-26407000_FAMILY           = 'TWO-VECTOR'
      FRAME_-26407000_PRI_AXIS         = 'Z'
      FRAME_-26407000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-26407000_PRI_OBSERVER     = 'GPS_BIIR-5'
      FRAME_-26407000_PRI_TARGET       = 'EARTH'
      FRAME_-26407000_PRI_ABCORR       = 'NONE'
      FRAME_-26407000_SEC_AXIS         = 'X'
      FRAME_-26407000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-26407000_SEC_OBSERVER     = 'GPS_BIIR-5'
      FRAME_-26407000_SEC_TARGET       = 'SUN'
      FRAME_-26407000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-8_IGS             = -27663000
      FRAME_-27663000_NAME             = 'GPS_BIIR-8_IGS'
      FRAME_-27663000_CLASS            =  5
      FRAME_-27663000_CLASS_ID         = -27663000
      FRAME_-27663000_CENTER           = -27663
      FRAME_-27663000_RELATIVE         = 'J2000'
      FRAME_-27663000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-27663000_FAMILY           = 'TWO-VECTOR'
      FRAME_-27663000_PRI_AXIS         = 'Z'
      FRAME_-27663000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-27663000_PRI_OBSERVER     = 'GPS_BIIR-8'
      FRAME_-27663000_PRI_TARGET       = 'EARTH'
      FRAME_-27663000_PRI_ABCORR       = 'NONE'
      FRAME_-27663000_SEC_AXIS         = 'X'
      FRAME_-27663000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-27663000_SEC_OBSERVER     = 'GPS_BIIR-8'
      FRAME_-27663000_SEC_TARGET       = 'SUN'
      FRAME_-27663000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIR-9_IGS             = -27704000
      FRAME_-27704000_NAME             = 'GPS_BIIR-9_IGS'
      FRAME_-27704000_CLASS            =  5
      FRAME_-27704000_CLASS_ID         = -27704000
      FRAME_-27704000_CENTER           = -27704
      FRAME_-27704000_RELATIVE         = 'J2000'
      FRAME_-27704000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-27704000_FAMILY           = 'TWO-VECTOR'
      FRAME_-27704000_PRI_AXIS         = 'Z'
      FRAME_-27704000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-27704000_PRI_OBSERVER     = 'GPS_BIIR-9'
      FRAME_-27704000_PRI_TARGET       = 'EARTH'
      FRAME_-27704000_PRI_ABCORR       = 'NONE'
      FRAME_-27704000_SEC_AXIS         = 'X'
      FRAME_-27704000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-27704000_SEC_OBSERVER     = 'GPS_BIIR-9'
      FRAME_-27704000_SEC_TARGET       = 'SUN'
      FRAME_-27704000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-1_IGS            = -28874000
      FRAME_-28874000_NAME             = 'GPS_BIIRM-1_IGS'
      FRAME_-28874000_CLASS            =  5
      FRAME_-28874000_CLASS_ID         = -28874000
      FRAME_-28874000_CENTER           = -28874
      FRAME_-28874000_RELATIVE         = 'J2000'
      FRAME_-28874000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28874000_FAMILY           = 'TWO-VECTOR'
      FRAME_-28874000_PRI_AXIS         = 'Z'
      FRAME_-28874000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28874000_PRI_OBSERVER     = 'GPS_BIIRM-1'
      FRAME_-28874000_PRI_TARGET       = 'EARTH'
      FRAME_-28874000_PRI_ABCORR       = 'NONE'
      FRAME_-28874000_SEC_AXIS         = 'X'
      FRAME_-28874000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28874000_SEC_OBSERVER     = 'GPS_BIIRM-1'
      FRAME_-28874000_SEC_TARGET       = 'SUN'
      FRAME_-28874000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-2_IGS            = -29486000
      FRAME_-29486000_NAME             = 'GPS_BIIRM-2_IGS'
      FRAME_-29486000_CLASS            =  5
      FRAME_-29486000_CLASS_ID         = -29486000
      FRAME_-29486000_CENTER           = -29486
      FRAME_-29486000_RELATIVE         = 'J2000'
      FRAME_-29486000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-29486000_FAMILY           = 'TWO-VECTOR'
      FRAME_-29486000_PRI_AXIS         = 'Z'
      FRAME_-29486000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-29486000_PRI_OBSERVER     = 'GPS_BIIRM-2'
      FRAME_-29486000_PRI_TARGET       = 'EARTH'
      FRAME_-29486000_PRI_ABCORR       = 'NONE'
      FRAME_-29486000_SEC_AXIS         = 'X'
      FRAME_-29486000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-29486000_SEC_OBSERVER     = 'GPS_BIIRM-2'
      FRAME_-29486000_SEC_TARGET       = 'SUN'
      FRAME_-29486000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-3_IGS            = -29601000
      FRAME_-29601000_NAME             = 'GPS_BIIRM-3_IGS'
      FRAME_-29601000_CLASS            =  5
      FRAME_-29601000_CLASS_ID         = -29601000
      FRAME_-29601000_CENTER           = -29601
      FRAME_-29601000_RELATIVE         = 'J2000'
      FRAME_-29601000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-29601000_FAMILY           = 'TWO-VECTOR'
      FRAME_-29601000_PRI_AXIS         = 'Z'
      FRAME_-29601000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-29601000_PRI_OBSERVER     = 'GPS_BIIRM-3'
      FRAME_-29601000_PRI_TARGET       = 'EARTH'
      FRAME_-29601000_PRI_ABCORR       = 'NONE'
      FRAME_-29601000_SEC_AXIS         = 'X'
      FRAME_-29601000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-29601000_SEC_OBSERVER     = 'GPS_BIIRM-3'
      FRAME_-29601000_SEC_TARGET       = 'SUN'
      FRAME_-29601000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-4_IGS            = -32260000
      FRAME_-32260000_NAME             = 'GPS_BIIRM-4_IGS'
      FRAME_-32260000_CLASS            =  5
      FRAME_-32260000_CLASS_ID         = -32260000
      FRAME_-32260000_CENTER           = -32260
      FRAME_-32260000_RELATIVE         = 'J2000'
      FRAME_-32260000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32260000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32260000_PRI_AXIS         = 'Z'
      FRAME_-32260000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32260000_PRI_OBSERVER     = 'GPS_BIIRM-4'
      FRAME_-32260000_PRI_TARGET       = 'EARTH'
      FRAME_-32260000_PRI_ABCORR       = 'NONE'
      FRAME_-32260000_SEC_AXIS         = 'X'
      FRAME_-32260000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32260000_SEC_OBSERVER     = 'GPS_BIIRM-4'
      FRAME_-32260000_SEC_TARGET       = 'SUN'
      FRAME_-32260000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-5_IGS            = -32384000
      FRAME_-32384000_NAME             = 'GPS_BIIRM-5_IGS'
      FRAME_-32384000_CLASS            =  5
      FRAME_-32384000_CLASS_ID         = -32384000
      FRAME_-32384000_CENTER           = -32384
      FRAME_-32384000_RELATIVE         = 'J2000'
      FRAME_-32384000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32384000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32384000_PRI_AXIS         = 'Z'
      FRAME_-32384000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32384000_PRI_OBSERVER     = 'GPS_BIIRM-5'
      FRAME_-32384000_PRI_TARGET       = 'EARTH'
      FRAME_-32384000_PRI_ABCORR       = 'NONE'
      FRAME_-32384000_SEC_AXIS         = 'X'
      FRAME_-32384000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32384000_SEC_OBSERVER     = 'GPS_BIIRM-5'
      FRAME_-32384000_SEC_TARGET       = 'SUN'
      FRAME_-32384000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-6_IGS            = -32711000
      FRAME_-32711000_NAME             = 'GPS_BIIRM-6_IGS'
      FRAME_-32711000_CLASS            =  5
      FRAME_-32711000_CLASS_ID         = -32711000
      FRAME_-32711000_CENTER           = -32711
      FRAME_-32711000_RELATIVE         = 'J2000'
      FRAME_-32711000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32711000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32711000_PRI_AXIS         = 'Z'
      FRAME_-32711000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32711000_PRI_OBSERVER     = 'GPS_BIIRM-6'
      FRAME_-32711000_PRI_TARGET       = 'EARTH'
      FRAME_-32711000_PRI_ABCORR       = 'NONE'
      FRAME_-32711000_SEC_AXIS         = 'X'
      FRAME_-32711000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32711000_SEC_OBSERVER     = 'GPS_BIIRM-6'
      FRAME_-32711000_SEC_TARGET       = 'SUN'
      FRAME_-32711000_SEC_ABCORR       = 'NONE'

      FRAME_GPS_BIIRM-8_IGS            = -35752000
      FRAME_-35752000_NAME             = 'GPS_BIIRM-8_IGS'
      FRAME_-35752000_CLASS            =  5
      FRAME_-35752000_CLASS_ID         = -35752000
      FRAME_-35752000_CENTER           = -35752
      FRAME_-35752000_RELATIVE         = 'J2000'
      FRAME_-35752000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-35752000_FAMILY           = 'TWO-VECTOR'
      FRAME_-35752000_PRI_AXIS         = 'Z'
      FRAME_-35752000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-35752000_PRI_OBSERVER     = 'GPS_BIIRM-8'
      FRAME_-35752000_PRI_TARGET       = 'EARTH'
      FRAME_-35752000_PRI_ABCORR       = 'NONE'
      FRAME_-35752000_SEC_AXIS         = 'X'
      FRAME_-35752000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-35752000_SEC_OBSERVER     = 'GPS_BIIRM-8'
      FRAME_-35752000_SEC_TARGET       = 'SUN'
      FRAME_-35752000_SEC_ABCORR       = 'NONE'

      FRAME_NAVSTAR_66_IGS             = -37753000
      FRAME_-37753000_NAME             = 'NAVSTAR_66_IGS'
      FRAME_-37753000_CLASS            =  5
      FRAME_-37753000_CLASS_ID         = -37753000
      FRAME_-37753000_CENTER           = -37753
      FRAME_-37753000_RELATIVE         = 'J2000'
      FRAME_-37753000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37753000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37753000_PRI_AXIS         = 'Z'
      FRAME_-37753000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37753000_PRI_OBSERVER     = 'NAVSTAR_66'
      FRAME_-37753000_PRI_TARGET       = 'EARTH'
      FRAME_-37753000_PRI_ABCORR       = 'NONE'
      FRAME_-37753000_SEC_AXIS         = 'X'
      FRAME_-37753000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37753000_SEC_OBSERVER     = 'NAVSTAR_66'
      FRAME_-37753000_SEC_TARGET       = 'SUN'
      FRAME_-37753000_SEC_ABCORR       = 'NONE'

      FRAME_NAVSTAR_66_MEC             = -37753001
      FRAME_-37753001_NAME             = 'NAVSTAR_66_MEC'
      FRAME_-37753001_CLASS            =  4
      FRAME_-37753001_CLASS_ID         = -37753001
      FRAME_-37753001_CENTER           = -37753
      TKFRAME_-37753001_RELATIVE       = 'NAVSTAR_66_IGS'
      TKFRAME_-37753001_SPEC           = 'ANGLES'
      TKFRAME_-37753001_UNITS          = 'DEGREES'
      TKFRAME_-37753001_AXES           = ( 1, 3, 2)
      TKFRAME_-37753001_ANGLES         = ( 0, 0, 0)



      FRAME_COSMOS_2432_IGS            = -32276000
      FRAME_-32276000_NAME             = 'COSMOS_2432_IGS'
      FRAME_-32276000_CLASS            =  5
      FRAME_-32276000_CLASS_ID         = -32276000
      FRAME_-32276000_CENTER           = -32276
      FRAME_-32276000_RELATIVE         = 'J2000'
      FRAME_-32276000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32276000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32276000_PRI_AXIS         = 'Z'
      FRAME_-32276000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32276000_PRI_OBSERVER     = 'COSMOS_2432'
      FRAME_-32276000_PRI_TARGET       = 'EARTH'
      FRAME_-32276000_PRI_ABCORR       = 'NONE'
      FRAME_-32276000_SEC_AXIS         = 'X'
      FRAME_-32276000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32276000_SEC_OBSERVER     = 'COSMOS_2432'
      FRAME_-32276000_SEC_TARGET       = 'SUN'
      FRAME_-32276000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2432_MEC            = -32276001
      FRAME_-32276001_NAME             = 'COSMOS_2432_MEC'
      FRAME_-32276001_CLASS            =  4
      FRAME_-32276001_CLASS_ID         = -32276001
      FRAME_-32276001_CENTER           = -32276
      TKFRAME_-32276001_RELATIVE       = 'COSMOS_2432_IGS'
      TKFRAME_-32276001_SPEC           = 'ANGLES'
      TKFRAME_-32276001_UNITS          = 'DEGREES'
      TKFRAME_-32276001_AXES           = (  1,   3, 2)
      TKFRAME_-32276001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2433_IGS            = -32275000
      FRAME_-32275000_NAME             = 'COSMOS_2433_IGS'
      FRAME_-32275000_CLASS            =  5
      FRAME_-32275000_CLASS_ID         = -32275000
      FRAME_-32275000_CENTER           = -32275
      FRAME_-32275000_RELATIVE         = 'J2000'
      FRAME_-32275000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32275000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32275000_PRI_AXIS         = 'Z'
      FRAME_-32275000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32275000_PRI_OBSERVER     = 'COSMOS_2433'
      FRAME_-32275000_PRI_TARGET       = 'EARTH'
      FRAME_-32275000_PRI_ABCORR       = 'NONE'
      FRAME_-32275000_SEC_AXIS         = 'X'
      FRAME_-32275000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32275000_SEC_OBSERVER     = 'COSMOS_2433'
      FRAME_-32275000_SEC_TARGET       = 'SUN'
      FRAME_-32275000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2433_MEC            = -32275001
      FRAME_-32275001_NAME             = 'COSMOS_2433_MEC'
      FRAME_-32275001_CLASS            =  4
      FRAME_-32275001_CLASS_ID         = -32275001
      FRAME_-32275001_CENTER           = -32275
      TKFRAME_-32275001_RELATIVE       = 'COSMOS_2433_IGS'
      TKFRAME_-32275001_SPEC           = 'ANGLES'
      TKFRAME_-32275001_UNITS          = 'DEGREES'
      TKFRAME_-32275001_AXES           = (  1,   3, 2)
      TKFRAME_-32275001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2434_IGS            = -32393000
      FRAME_-32393000_NAME             = 'COSMOS_2434_IGS'
      FRAME_-32393000_CLASS            =  5
      FRAME_-32393000_CLASS_ID         = -32393000
      FRAME_-32393000_CENTER           = -32393
      FRAME_-32393000_RELATIVE         = 'J2000'
      FRAME_-32393000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32393000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32393000_PRI_AXIS         = 'Z'
      FRAME_-32393000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32393000_PRI_OBSERVER     = 'COSMOS_2434'
      FRAME_-32393000_PRI_TARGET       = 'EARTH'
      FRAME_-32393000_PRI_ABCORR       = 'NONE'
      FRAME_-32393000_SEC_AXIS         = 'X'
      FRAME_-32393000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32393000_SEC_OBSERVER     = 'COSMOS_2434'
      FRAME_-32393000_SEC_TARGET       = 'SUN'
      FRAME_-32393000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2434_MEC            = -32393001
      FRAME_-32393001_NAME             = 'COSMOS_2434_MEC'
      FRAME_-32393001_CLASS            =  4
      FRAME_-32393001_CLASS_ID         = -32393001
      FRAME_-32393001_CENTER           = -32393
      TKFRAME_-32393001_RELATIVE       = 'COSMOS_2434_IGS'
      TKFRAME_-32393001_SPEC           = 'ANGLES'
      TKFRAME_-32393001_UNITS          = 'DEGREES'
      TKFRAME_-32393001_AXES           = (  1,   3, 2)
      TKFRAME_-32393001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2436_IGS            = -32395000
      FRAME_-32395000_NAME             = 'COSMOS_2436_IGS'
      FRAME_-32395000_CLASS            =  5
      FRAME_-32395000_CLASS_ID         = -32395000
      FRAME_-32395000_CENTER           = -32395
      FRAME_-32395000_RELATIVE         = 'J2000'
      FRAME_-32395000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-32395000_FAMILY           = 'TWO-VECTOR'
      FRAME_-32395000_PRI_AXIS         = 'Z'
      FRAME_-32395000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32395000_PRI_OBSERVER     = 'COSMOS_2436'
      FRAME_-32395000_PRI_TARGET       = 'EARTH'
      FRAME_-32395000_PRI_ABCORR       = 'NONE'
      FRAME_-32395000_SEC_AXIS         = 'X'
      FRAME_-32395000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-32395000_SEC_OBSERVER     = 'COSMOS_2436'
      FRAME_-32395000_SEC_TARGET       = 'SUN'
      FRAME_-32395000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2436_MEC            = -32395001
      FRAME_-32395001_NAME             = 'COSMOS_2436_MEC'
      FRAME_-32395001_CLASS            =  4
      FRAME_-32395001_CLASS_ID         = -32395001
      FRAME_-32395001_CENTER           = -32395
      TKFRAME_-32395001_RELATIVE       = 'COSMOS_2436_IGS'
      TKFRAME_-32395001_SPEC           = 'ANGLES'
      TKFRAME_-32395001_UNITS          = 'DEGREES'
      TKFRAME_-32395001_AXES           = (  1,   3, 2)
      TKFRAME_-32395001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2456_IGS            = -36111000
      FRAME_-36111000_NAME             = 'COSMOS_2456_IGS'
      FRAME_-36111000_CLASS            =  5
      FRAME_-36111000_CLASS_ID         = -36111000
      FRAME_-36111000_CENTER           = -36111
      FRAME_-36111000_RELATIVE         = 'J2000'
      FRAME_-36111000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-36111000_FAMILY           = 'TWO-VECTOR'
      FRAME_-36111000_PRI_AXIS         = 'Z'
      FRAME_-36111000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36111000_PRI_OBSERVER     = 'COSMOS_2456'
      FRAME_-36111000_PRI_TARGET       = 'EARTH'
      FRAME_-36111000_PRI_ABCORR       = 'NONE'
      FRAME_-36111000_SEC_AXIS         = 'X'
      FRAME_-36111000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36111000_SEC_OBSERVER     = 'COSMOS_2456'
      FRAME_-36111000_SEC_TARGET       = 'SUN'
      FRAME_-36111000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2456_MEC            = -36111001
      FRAME_-36111001_NAME             = 'COSMOS_2456_MEC'
      FRAME_-36111001_CLASS            =  4
      FRAME_-36111001_CLASS_ID         = -36111001
      FRAME_-36111001_CENTER           = -36111
      TKFRAME_-36111001_RELATIVE       = 'COSMOS_2456_IGS'
      TKFRAME_-36111001_SPEC           = 'ANGLES'
      TKFRAME_-36111001_UNITS          = 'DEGREES'
      TKFRAME_-36111001_AXES           = (  1,   3, 2)
      TKFRAME_-36111001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2457_IGS            = -36112000
      FRAME_-36112000_NAME             = 'COSMOS_2457_IGS'
      FRAME_-36112000_CLASS            =  5
      FRAME_-36112000_CLASS_ID         = -36112000
      FRAME_-36112000_CENTER           = -36112
      FRAME_-36112000_RELATIVE         = 'J2000'
      FRAME_-36112000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-36112000_FAMILY           = 'TWO-VECTOR'
      FRAME_-36112000_PRI_AXIS         = 'Z'
      FRAME_-36112000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36112000_PRI_OBSERVER     = 'COSMOS_2457'
      FRAME_-36112000_PRI_TARGET       = 'EARTH'
      FRAME_-36112000_PRI_ABCORR       = 'NONE'
      FRAME_-36112000_SEC_AXIS         = 'X'
      FRAME_-36112000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36112000_SEC_OBSERVER     = 'COSMOS_2457'
      FRAME_-36112000_SEC_TARGET       = 'SUN'
      FRAME_-36112000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2457_MEC            = -36112001
      FRAME_-36112001_NAME             = 'COSMOS_2457_MEC'
      FRAME_-36112001_CLASS            =  4
      FRAME_-36112001_CLASS_ID         = -36112001
      FRAME_-36112001_CENTER           = -36112
      TKFRAME_-36112001_RELATIVE       = 'COSMOS_2457_IGS'
      TKFRAME_-36112001_SPEC           = 'ANGLES'
      TKFRAME_-36112001_UNITS          = 'DEGREES'
      TKFRAME_-36112001_AXES           = (  1,   3, 2)
      TKFRAME_-36112001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2460_IGS            = -36402000
      FRAME_-36402000_NAME             = 'COSMOS_2460_IGS'
      FRAME_-36402000_CLASS            =  5
      FRAME_-36402000_CLASS_ID         = -36402000
      FRAME_-36402000_CENTER           = -36402
      FRAME_-36402000_RELATIVE         = 'J2000'
      FRAME_-36402000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-36402000_FAMILY           = 'TWO-VECTOR'
      FRAME_-36402000_PRI_AXIS         = 'Z'
      FRAME_-36402000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36402000_PRI_OBSERVER     = 'COSMOS_2460'
      FRAME_-36402000_PRI_TARGET       = 'EARTH'
      FRAME_-36402000_PRI_ABCORR       = 'NONE'
      FRAME_-36402000_SEC_AXIS         = 'X'
      FRAME_-36402000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36402000_SEC_OBSERVER     = 'COSMOS_2460'
      FRAME_-36402000_SEC_TARGET       = 'SUN'
      FRAME_-36402000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2460_MEC            = -36402001
      FRAME_-36402001_NAME             = 'COSMOS_2460_MEC'
      FRAME_-36402001_CLASS            =  4
      FRAME_-36402001_CLASS_ID         = -36402001
      FRAME_-36402001_CENTER           = -36402
      TKFRAME_-36402001_RELATIVE       = 'COSMOS_2460_IGS'
      TKFRAME_-36402001_SPEC           = 'ANGLES'
      TKFRAME_-36402001_UNITS          = 'DEGREES'
      TKFRAME_-36402001_AXES           = (  1,   3, 2)
      TKFRAME_-36402001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2475_IGS            = -37869000
      FRAME_-37869000_NAME             = 'COSMOS_2475_IGS'
      FRAME_-37869000_CLASS            =  5
      FRAME_-37869000_CLASS_ID         = -37869000
      FRAME_-37869000_CENTER           = -37869
      FRAME_-37869000_RELATIVE         = 'J2000'
      FRAME_-37869000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37869000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37869000_PRI_AXIS         = 'Z'
      FRAME_-37869000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37869000_PRI_OBSERVER     = 'COSMOS_2475'
      FRAME_-37869000_PRI_TARGET       = 'EARTH'
      FRAME_-37869000_PRI_ABCORR       = 'NONE'
      FRAME_-37869000_SEC_AXIS         = 'X'
      FRAME_-37869000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37869000_SEC_OBSERVER     = 'COSMOS_2475'
      FRAME_-37869000_SEC_TARGET       = 'SUN'
      FRAME_-37869000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2475_MEC            = -37869001
      FRAME_-37869001_NAME             = 'COSMOS_2475_MEC'
      FRAME_-37869001_CLASS            =  4
      FRAME_-37869001_CLASS_ID         = -37869001
      FRAME_-37869001_CENTER           = -37869
      TKFRAME_-37869001_RELATIVE       = 'COSMOS_2475_IGS'
      TKFRAME_-37869001_SPEC           = 'ANGLES'
      TKFRAME_-37869001_UNITS          = 'DEGREES'
      TKFRAME_-37869001_AXES           = (  1,   3, 2)
      TKFRAME_-37869001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2476_IGS            = -37867000
      FRAME_-37867000_NAME             = 'COSMOS_2476_IGS'
      FRAME_-37867000_CLASS            =  5
      FRAME_-37867000_CLASS_ID         = -37867000
      FRAME_-37867000_CENTER           = -37867
      FRAME_-37867000_RELATIVE         = 'J2000'
      FRAME_-37867000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37867000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37867000_PRI_AXIS         = 'Z'
      FRAME_-37867000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37867000_PRI_OBSERVER     = 'COSMOS_2476'
      FRAME_-37867000_PRI_TARGET       = 'EARTH'
      FRAME_-37867000_PRI_ABCORR       = 'NONE'
      FRAME_-37867000_SEC_AXIS         = 'X'
      FRAME_-37867000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37867000_SEC_OBSERVER     = 'COSMOS_2476'
      FRAME_-37867000_SEC_TARGET       = 'SUN'
      FRAME_-37867000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2476_MEC            = -37867001
      FRAME_-37867001_NAME             = 'COSMOS_2476_MEC'
      FRAME_-37867001_CLASS            =  4
      FRAME_-37867001_CLASS_ID         = -37867001
      FRAME_-37867001_CENTER           = -37867
      TKFRAME_-37867001_RELATIVE       = 'COSMOS_2476_IGS'
      TKFRAME_-37867001_SPEC           = 'ANGLES'
      TKFRAME_-37867001_UNITS          = 'DEGREES'
      TKFRAME_-37867001_AXES           = (  1,   3, 2)
      TKFRAME_-37867001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2477_IGS            = -37868000
      FRAME_-37868000_NAME             = 'COSMOS_2477_IGS'
      FRAME_-37868000_CLASS            =  5
      FRAME_-37868000_CLASS_ID         = -37868000
      FRAME_-37868000_CENTER           = -37868
      FRAME_-37868000_RELATIVE         = 'J2000'
      FRAME_-37868000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37868000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37868000_PRI_AXIS         = 'Z'
      FRAME_-37868000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37868000_PRI_OBSERVER     = 'COSMOS_2477'
      FRAME_-37868000_PRI_TARGET       = 'EARTH'
      FRAME_-37868000_PRI_ABCORR       = 'NONE'
      FRAME_-37868000_SEC_AXIS         = 'X'
      FRAME_-37868000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37868000_SEC_OBSERVER     = 'COSMOS_2477'
      FRAME_-37868000_SEC_TARGET       = 'SUN'
      FRAME_-37868000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2477_MEC            = -37868001
      FRAME_-37868001_NAME             = 'COSMOS_2477_MEC'
      FRAME_-37868001_CLASS            =  4
      FRAME_-37868001_CLASS_ID         = -37868001
      FRAME_-37868001_CENTER           = -37868
      TKFRAME_-37868001_RELATIVE       = 'COSMOS_2477_IGS'
      TKFRAME_-37868001_SPEC           = 'ANGLES'
      TKFRAME_-37868001_UNITS          = 'DEGREES'
      TKFRAME_-37868001_AXES           = (  1,   3, 2)
      TKFRAME_-37868001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2485_IGS            = -39155000
      FRAME_-39155000_NAME             = 'COSMOS_2485_IGS'
      FRAME_-39155000_CLASS            =  5
      FRAME_-39155000_CLASS_ID         = -39155000
      FRAME_-39155000_CENTER           = -39155
      FRAME_-39155000_RELATIVE         = 'J2000'
      FRAME_-39155000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39155000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39155000_PRI_AXIS         = 'Z'
      FRAME_-39155000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39155000_PRI_OBSERVER     = 'COSMOS_2485'
      FRAME_-39155000_PRI_TARGET       = 'EARTH'
      FRAME_-39155000_PRI_ABCORR       = 'NONE'
      FRAME_-39155000_SEC_AXIS         = 'X'
      FRAME_-39155000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39155000_SEC_OBSERVER     = 'COSMOS_2485'
      FRAME_-39155000_SEC_TARGET       = 'SUN'
      FRAME_-39155000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2485_MEC            = -39155001
      FRAME_-39155001_NAME             = 'COSMOS_2485_MEC'
      FRAME_-39155001_CLASS            =  4
      FRAME_-39155001_CLASS_ID         = -39155001
      FRAME_-39155001_CENTER           = -39155
      TKFRAME_-39155001_RELATIVE       = 'COSMOS_2485_IGS'
      TKFRAME_-39155001_SPEC           = 'ANGLES'
      TKFRAME_-39155001_UNITS          = 'DEGREES'
      TKFRAME_-39155001_AXES           = (  1,   3, 2)
      TKFRAME_-39155001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2492_IGS            = -39620000
      FRAME_-39620000_NAME             = 'COSMOS_2492_IGS'
      FRAME_-39620000_CLASS            =  5
      FRAME_-39620000_CLASS_ID         = -39620000
      FRAME_-39620000_CENTER           = -39620
      FRAME_-39620000_RELATIVE         = 'J2000'
      FRAME_-39620000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39620000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39620000_PRI_AXIS         = 'Z'
      FRAME_-39620000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39620000_PRI_OBSERVER     = 'COSMOS_2492'
      FRAME_-39620000_PRI_TARGET       = 'EARTH'
      FRAME_-39620000_PRI_ABCORR       = 'NONE'
      FRAME_-39620000_SEC_AXIS         = 'X'
      FRAME_-39620000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39620000_SEC_OBSERVER     = 'COSMOS_2492'
      FRAME_-39620000_SEC_TARGET       = 'SUN'
      FRAME_-39620000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2492_MEC            = -39620001
      FRAME_-39620001_NAME             = 'COSMOS_2492_MEC'
      FRAME_-39620001_CLASS            =  4
      FRAME_-39620001_CLASS_ID         = -39620001
      FRAME_-39620001_CENTER           = -39620
      TKFRAME_-39620001_RELATIVE       = 'COSMOS_2492_IGS'
      TKFRAME_-39620001_SPEC           = 'ANGLES'
      TKFRAME_-39620001_UNITS          = 'DEGREES'
      TKFRAME_-39620001_AXES           = (  1,   3, 2)
      TKFRAME_-39620001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2500_IGS            = -40001000
      FRAME_-40001000_NAME             = 'COSMOS_2500_IGS'
      FRAME_-40001000_CLASS            =  5
      FRAME_-40001000_CLASS_ID         = -40001000
      FRAME_-40001000_CENTER           = -40001
      FRAME_-40001000_RELATIVE         = 'J2000'
      FRAME_-40001000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40001000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40001000_PRI_AXIS         = 'Z'
      FRAME_-40001000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40001000_PRI_OBSERVER     = 'COSMOS_2500'
      FRAME_-40001000_PRI_TARGET       = 'EARTH'
      FRAME_-40001000_PRI_ABCORR       = 'NONE'
      FRAME_-40001000_SEC_AXIS         = 'X'
      FRAME_-40001000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40001000_SEC_OBSERVER     = 'COSMOS_2500'
      FRAME_-40001000_SEC_TARGET       = 'SUN'
      FRAME_-40001000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2500_MEC            = -40001001
      FRAME_-40001001_NAME             = 'COSMOS_2500_MEC'
      FRAME_-40001001_CLASS            =  4
      FRAME_-40001001_CLASS_ID         = -40001001
      FRAME_-40001001_CENTER           = -40001
      TKFRAME_-40001001_RELATIVE       = 'COSMOS_2500_IGS'
      TKFRAME_-40001001_SPEC           = 'ANGLES'
      TKFRAME_-40001001_UNITS          = 'DEGREES'
      TKFRAME_-40001001_AXES           = (  1,   3, 2)
      TKFRAME_-40001001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2501_IGS            = -40315000
      FRAME_-40315000_NAME             = 'COSMOS_2501_IGS'
      FRAME_-40315000_CLASS            =  5
      FRAME_-40315000_CLASS_ID         = -40315000
      FRAME_-40315000_CENTER           = -40315
      FRAME_-40315000_RELATIVE         = 'J2000'
      FRAME_-40315000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40315000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40315000_PRI_AXIS         = 'Z'
      FRAME_-40315000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40315000_PRI_OBSERVER     = 'COSMOS_2501'
      FRAME_-40315000_PRI_TARGET       = 'EARTH'
      FRAME_-40315000_PRI_ABCORR       = 'NONE'
      FRAME_-40315000_SEC_AXIS         = 'X'
      FRAME_-40315000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40315000_SEC_OBSERVER     = 'COSMOS_2501'
      FRAME_-40315000_SEC_TARGET       = 'SUN'
      FRAME_-40315000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2501_MEC            = -40315001
      FRAME_-40315001_NAME             = 'COSMOS_2501_MEC'
      FRAME_-40315001_CLASS            =  4
      FRAME_-40315001_CLASS_ID         = -40315001
      FRAME_-40315001_CENTER           = -40315
      TKFRAME_-40315001_RELATIVE       = 'COSMOS_2501_IGS'
      TKFRAME_-40315001_SPEC           = 'ANGLES'
      TKFRAME_-40315001_UNITS          = 'DEGREES'
      TKFRAME_-40315001_AXES           = (  1,   3, 2)
      TKFRAME_-40315001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2514_IGS            = -41330000
      FRAME_-41330000_NAME             = 'COSMOS_2514_IGS'
      FRAME_-41330000_CLASS            =  5
      FRAME_-41330000_CLASS_ID         = -41330000
      FRAME_-41330000_CENTER           = -41330
      FRAME_-41330000_RELATIVE         = 'J2000'
      FRAME_-41330000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41330000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41330000_PRI_AXIS         = 'Z'
      FRAME_-41330000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41330000_PRI_OBSERVER     = 'COSMOS_2514'
      FRAME_-41330000_PRI_TARGET       = 'EARTH'
      FRAME_-41330000_PRI_ABCORR       = 'NONE'
      FRAME_-41330000_SEC_AXIS         = 'X'
      FRAME_-41330000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41330000_SEC_OBSERVER     = 'COSMOS_2514'
      FRAME_-41330000_SEC_TARGET       = 'SUN'
      FRAME_-41330000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2514_MEC            = -41330001
      FRAME_-41330001_NAME             = 'COSMOS_2514_MEC'
      FRAME_-41330001_CLASS            =  4
      FRAME_-41330001_CLASS_ID         = -41330001
      FRAME_-41330001_CENTER           = -41330
      TKFRAME_-41330001_RELATIVE       = 'COSMOS_2514_IGS'
      TKFRAME_-41330001_SPEC           = 'ANGLES'
      TKFRAME_-41330001_UNITS          = 'DEGREES'
      TKFRAME_-41330001_AXES           = (  1,   3, 2)
      TKFRAME_-41330001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2516_IGS            = -41554000
      FRAME_-41554000_NAME             = 'COSMOS_2516_IGS'
      FRAME_-41554000_CLASS            =  5
      FRAME_-41554000_CLASS_ID         = -41554000
      FRAME_-41554000_CENTER           = -41554
      FRAME_-41554000_RELATIVE         = 'J2000'
      FRAME_-41554000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41554000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41554000_PRI_AXIS         = 'Z'
      FRAME_-41554000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41554000_PRI_OBSERVER     = 'COSMOS_2516'
      FRAME_-41554000_PRI_TARGET       = 'EARTH'
      FRAME_-41554000_PRI_ABCORR       = 'NONE'
      FRAME_-41554000_SEC_AXIS         = 'X'
      FRAME_-41554000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41554000_SEC_OBSERVER     = 'COSMOS_2516'
      FRAME_-41554000_SEC_TARGET       = 'SUN'
      FRAME_-41554000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2516_MEC            = -41554001
      FRAME_-41554001_NAME             = 'COSMOS_2516_MEC'
      FRAME_-41554001_CLASS            =  4
      FRAME_-41554001_CLASS_ID         = -41554001
      FRAME_-41554001_CENTER           = -41554
      TKFRAME_-41554001_RELATIVE       = 'COSMOS_2516_IGS'
      TKFRAME_-41554001_SPEC           = 'ANGLES'
      TKFRAME_-41554001_UNITS          = 'DEGREES'
      TKFRAME_-41554001_AXES           = (  1,   3, 2)
      TKFRAME_-41554001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2522_IGS            = -42939000
      FRAME_-42939000_NAME             = 'COSMOS_2522_IGS'
      FRAME_-42939000_CLASS            =  5
      FRAME_-42939000_CLASS_ID         = -42939000
      FRAME_-42939000_CENTER           = -42939
      FRAME_-42939000_RELATIVE         = 'J2000'
      FRAME_-42939000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-42939000_FAMILY           = 'TWO-VECTOR'
      FRAME_-42939000_PRI_AXIS         = 'Z'
      FRAME_-42939000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42939000_PRI_OBSERVER     = 'COSMOS_2522'
      FRAME_-42939000_PRI_TARGET       = 'EARTH'
      FRAME_-42939000_PRI_ABCORR       = 'NONE'
      FRAME_-42939000_SEC_AXIS         = 'X'
      FRAME_-42939000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42939000_SEC_OBSERVER     = 'COSMOS_2522'
      FRAME_-42939000_SEC_TARGET       = 'SUN'
      FRAME_-42939000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2522_MEC            = -42939001
      FRAME_-42939001_NAME             = 'COSMOS_2522_MEC'
      FRAME_-42939001_CLASS            =  4
      FRAME_-42939001_CLASS_ID         = -42939001
      FRAME_-42939001_CENTER           = -42939
      TKFRAME_-42939001_RELATIVE       = 'COSMOS_2522_IGS'
      TKFRAME_-42939001_SPEC           = 'ANGLES'
      TKFRAME_-42939001_UNITS          = 'DEGREES'
      TKFRAME_-42939001_AXES           = (  1,   3, 2)
      TKFRAME_-42939001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2527_IGS            = -43508000
      FRAME_-43508000_NAME             = 'COSMOS_2527_IGS'
      FRAME_-43508000_CLASS            =  5
      FRAME_-43508000_CLASS_ID         = -43508000
      FRAME_-43508000_CENTER           = -43508
      FRAME_-43508000_RELATIVE         = 'J2000'
      FRAME_-43508000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43508000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43508000_PRI_AXIS         = 'Z'
      FRAME_-43508000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43508000_PRI_OBSERVER     = 'COSMOS_2527'
      FRAME_-43508000_PRI_TARGET       = 'EARTH'
      FRAME_-43508000_PRI_ABCORR       = 'NONE'
      FRAME_-43508000_SEC_AXIS         = 'X'
      FRAME_-43508000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43508000_SEC_OBSERVER     = 'COSMOS_2527'
      FRAME_-43508000_SEC_TARGET       = 'SUN'
      FRAME_-43508000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2527_MEC            = -43508001
      FRAME_-43508001_NAME             = 'COSMOS_2527_MEC'
      FRAME_-43508001_CLASS            =  4
      FRAME_-43508001_CLASS_ID         = -43508001
      FRAME_-43508001_CENTER           = -43508
      TKFRAME_-43508001_RELATIVE       = 'COSMOS_2527_IGS'
      TKFRAME_-43508001_SPEC           = 'ANGLES'
      TKFRAME_-43508001_UNITS          = 'DEGREES'
      TKFRAME_-43508001_AXES           = (  1,   3, 2)
      TKFRAME_-43508001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2529_IGS            = -43687000
      FRAME_-43687000_NAME             = 'COSMOS_2529_IGS'
      FRAME_-43687000_CLASS            =  5
      FRAME_-43687000_CLASS_ID         = -43687000
      FRAME_-43687000_CENTER           = -43687
      FRAME_-43687000_RELATIVE         = 'J2000'
      FRAME_-43687000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43687000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43687000_PRI_AXIS         = 'Z'
      FRAME_-43687000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43687000_PRI_OBSERVER     = 'COSMOS_2529'
      FRAME_-43687000_PRI_TARGET       = 'EARTH'
      FRAME_-43687000_PRI_ABCORR       = 'NONE'
      FRAME_-43687000_SEC_AXIS         = 'X'
      FRAME_-43687000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43687000_SEC_OBSERVER     = 'COSMOS_2529'
      FRAME_-43687000_SEC_TARGET       = 'SUN'
      FRAME_-43687000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2529_MEC            = -43687001
      FRAME_-43687001_NAME             = 'COSMOS_2529_MEC'
      FRAME_-43687001_CLASS            =  4
      FRAME_-43687001_CLASS_ID         = -43687001
      FRAME_-43687001_CENTER           = -43687
      TKFRAME_-43687001_RELATIVE       = 'COSMOS_2529_IGS'
      TKFRAME_-43687001_SPEC           = 'ANGLES'
      TKFRAME_-43687001_UNITS          = 'DEGREES'
      TKFRAME_-43687001_AXES           = (  1,   3, 2)
      TKFRAME_-43687001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2534_IGS            = -44299000
      FRAME_-44299000_NAME             = 'COSMOS_2534_IGS'
      FRAME_-44299000_CLASS            =  5
      FRAME_-44299000_CLASS_ID         = -44299000
      FRAME_-44299000_CENTER           = -44299
      FRAME_-44299000_RELATIVE         = 'J2000'
      FRAME_-44299000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44299000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44299000_PRI_AXIS         = 'Z'
      FRAME_-44299000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44299000_PRI_OBSERVER     = 'COSMOS_2534'
      FRAME_-44299000_PRI_TARGET       = 'EARTH'
      FRAME_-44299000_PRI_ABCORR       = 'NONE'
      FRAME_-44299000_SEC_AXIS         = 'X'
      FRAME_-44299000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44299000_SEC_OBSERVER     = 'COSMOS_2534'
      FRAME_-44299000_SEC_TARGET       = 'SUN'
      FRAME_-44299000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2534_MEC            = -44299001
      FRAME_-44299001_NAME             = 'COSMOS_2534_MEC'
      FRAME_-44299001_CLASS            =  4
      FRAME_-44299001_CLASS_ID         = -44299001
      FRAME_-44299001_CENTER           = -44299
      TKFRAME_-44299001_RELATIVE       = 'COSMOS_2534_IGS'
      TKFRAME_-44299001_SPEC           = 'ANGLES'
      TKFRAME_-44299001_UNITS          = 'DEGREES'
      TKFRAME_-44299001_AXES           = (  1,   3, 2)
      TKFRAME_-44299001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2544_IGS            = -44850000
      FRAME_-44850000_NAME             = 'COSMOS_2544_IGS'
      FRAME_-44850000_CLASS            =  5
      FRAME_-44850000_CLASS_ID         = -44850000
      FRAME_-44850000_CENTER           = -44850
      FRAME_-44850000_RELATIVE         = 'J2000'
      FRAME_-44850000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44850000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44850000_PRI_AXIS         = 'Z'
      FRAME_-44850000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44850000_PRI_OBSERVER     = 'COSMOS_2544'
      FRAME_-44850000_PRI_TARGET       = 'EARTH'
      FRAME_-44850000_PRI_ABCORR       = 'NONE'
      FRAME_-44850000_SEC_AXIS         = 'X'
      FRAME_-44850000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44850000_SEC_OBSERVER     = 'COSMOS_2544'
      FRAME_-44850000_SEC_TARGET       = 'SUN'
      FRAME_-44850000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2544_MEC            = -44850001
      FRAME_-44850001_NAME             = 'COSMOS_2544_MEC'
      FRAME_-44850001_CLASS            =  4
      FRAME_-44850001_CLASS_ID         = -44850001
      FRAME_-44850001_CENTER           = -44850
      TKFRAME_-44850001_RELATIVE       = 'COSMOS_2544_IGS'
      TKFRAME_-44850001_SPEC           = 'ANGLES'
      TKFRAME_-44850001_UNITS          = 'DEGREES'
      TKFRAME_-44850001_AXES           = (  1,   3, 2)
      TKFRAME_-44850001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2545_IGS            = -45358000
      FRAME_-45358000_NAME             = 'COSMOS_2545_IGS'
      FRAME_-45358000_CLASS            =  5
      FRAME_-45358000_CLASS_ID         = -45358000
      FRAME_-45358000_CENTER           = -45358
      FRAME_-45358000_RELATIVE         = 'J2000'
      FRAME_-45358000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-45358000_FAMILY           = 'TWO-VECTOR'
      FRAME_-45358000_PRI_AXIS         = 'Z'
      FRAME_-45358000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45358000_PRI_OBSERVER     = 'COSMOS_2545'
      FRAME_-45358000_PRI_TARGET       = 'EARTH'
      FRAME_-45358000_PRI_ABCORR       = 'NONE'
      FRAME_-45358000_SEC_AXIS         = 'X'
      FRAME_-45358000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45358000_SEC_OBSERVER     = 'COSMOS_2545'
      FRAME_-45358000_SEC_TARGET       = 'SUN'
      FRAME_-45358000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2545_MEC            = -45358001
      FRAME_-45358001_NAME             = 'COSMOS_2545_MEC'
      FRAME_-45358001_CLASS            =  4
      FRAME_-45358001_CLASS_ID         = -45358001
      FRAME_-45358001_CENTER           = -45358
      TKFRAME_-45358001_RELATIVE       = 'COSMOS_2545_IGS'
      TKFRAME_-45358001_SPEC           = 'ANGLES'
      TKFRAME_-45358001_UNITS          = 'DEGREES'
      TKFRAME_-45358001_AXES           = (  1,   3, 2)
      TKFRAME_-45358001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2547_IGS            = -46805000
      FRAME_-46805000_NAME             = 'COSMOS_2547_IGS'
      FRAME_-46805000_CLASS            =  5
      FRAME_-46805000_CLASS_ID         = -46805000
      FRAME_-46805000_CENTER           = -46805
      FRAME_-46805000_RELATIVE         = 'J2000'
      FRAME_-46805000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-46805000_FAMILY           = 'TWO-VECTOR'
      FRAME_-46805000_PRI_AXIS         = 'Z'
      FRAME_-46805000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46805000_PRI_OBSERVER     = 'COSMOS_2547'
      FRAME_-46805000_PRI_TARGET       = 'EARTH'
      FRAME_-46805000_PRI_ABCORR       = 'NONE'
      FRAME_-46805000_SEC_AXIS         = 'X'
      FRAME_-46805000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46805000_SEC_OBSERVER     = 'COSMOS_2547'
      FRAME_-46805000_SEC_TARGET       = 'SUN'
      FRAME_-46805000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2547_MEC            = -46805001
      FRAME_-46805001_NAME             = 'COSMOS_2547_MEC'
      FRAME_-46805001_CLASS            =  4
      FRAME_-46805001_CLASS_ID         = -46805001
      FRAME_-46805001_CENTER           = -46805
      TKFRAME_-46805001_RELATIVE       = 'COSMOS_2547_IGS'
      TKFRAME_-46805001_SPEC           = 'ANGLES'
      TKFRAME_-46805001_UNITS          = 'DEGREES'
      TKFRAME_-46805001_AXES           = (  1,   3, 2)
      TKFRAME_-46805001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2557_IGS            = -52984000
      FRAME_-52984000_NAME             = 'COSMOS_2557_IGS'
      FRAME_-52984000_CLASS            =  5
      FRAME_-52984000_CLASS_ID         = -52984000
      FRAME_-52984000_CENTER           = -52984
      FRAME_-52984000_RELATIVE         = 'J2000'
      FRAME_-52984000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-52984000_FAMILY           = 'TWO-VECTOR'
      FRAME_-52984000_PRI_AXIS         = 'Z'
      FRAME_-52984000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-52984000_PRI_OBSERVER     = 'COSMOS_2557'
      FRAME_-52984000_PRI_TARGET       = 'EARTH'
      FRAME_-52984000_PRI_ABCORR       = 'NONE'
      FRAME_-52984000_SEC_AXIS         = 'X'
      FRAME_-52984000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-52984000_SEC_OBSERVER     = 'COSMOS_2557'
      FRAME_-52984000_SEC_TARGET       = 'SUN'
      FRAME_-52984000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2557_MEC            = -52984001
      FRAME_-52984001_NAME             = 'COSMOS_2557_MEC'
      FRAME_-52984001_CLASS            =  4
      FRAME_-52984001_CLASS_ID         = -52984001
      FRAME_-52984001_CENTER           = -52984
      TKFRAME_-52984001_RELATIVE       = 'COSMOS_2557_IGS'
      TKFRAME_-52984001_SPEC           = 'ANGLES'
      TKFRAME_-52984001_UNITS          = 'DEGREES'
      TKFRAME_-52984001_AXES           = (  1,   3, 2)
      TKFRAME_-52984001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2559_IGS            = -54031000
      FRAME_-54031000_NAME             = 'COSMOS_2559_IGS'
      FRAME_-54031000_CLASS            =  5
      FRAME_-54031000_CLASS_ID         = -54031000
      FRAME_-54031000_CENTER           = -54031
      FRAME_-54031000_RELATIVE         = 'J2000'
      FRAME_-54031000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-54031000_FAMILY           = 'TWO-VECTOR'
      FRAME_-54031000_PRI_AXIS         = 'Z'
      FRAME_-54031000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-54031000_PRI_OBSERVER     = 'COSMOS_2559'
      FRAME_-54031000_PRI_TARGET       = 'EARTH'
      FRAME_-54031000_PRI_ABCORR       = 'NONE'
      FRAME_-54031000_SEC_AXIS         = 'X'
      FRAME_-54031000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-54031000_SEC_OBSERVER     = 'COSMOS_2559'
      FRAME_-54031000_SEC_TARGET       = 'SUN'
      FRAME_-54031000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2559_MEC            = -54031001
      FRAME_-54031001_NAME             = 'COSMOS_2559_MEC'
      FRAME_-54031001_CLASS            =  4
      FRAME_-54031001_CLASS_ID         = -54031001
      FRAME_-54031001_CENTER           = -54031
      TKFRAME_-54031001_RELATIVE       = 'COSMOS_2559_IGS'
      TKFRAME_-54031001_SPEC           = 'ANGLES'
      TKFRAME_-54031001_UNITS          = 'DEGREES'
      TKFRAME_-54031001_AXES           = (  1,   3, 2)
      TKFRAME_-54031001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2564_IGS            = -54377000
      FRAME_-54377000_NAME             = 'COSMOS_2564_IGS'
      FRAME_-54377000_CLASS            =  5
      FRAME_-54377000_CLASS_ID         = -54377000
      FRAME_-54377000_CENTER           = -54377
      FRAME_-54377000_RELATIVE         = 'J2000'
      FRAME_-54377000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-54377000_FAMILY           = 'TWO-VECTOR'
      FRAME_-54377000_PRI_AXIS         = 'Z'
      FRAME_-54377000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-54377000_PRI_OBSERVER     = 'COSMOS_2564'
      FRAME_-54377000_PRI_TARGET       = 'EARTH'
      FRAME_-54377000_PRI_ABCORR       = 'NONE'
      FRAME_-54377000_SEC_AXIS         = 'X'
      FRAME_-54377000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-54377000_SEC_OBSERVER     = 'COSMOS_2564'
      FRAME_-54377000_SEC_TARGET       = 'SUN'
      FRAME_-54377000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2564_MEC            = -54377001
      FRAME_-54377001_NAME             = 'COSMOS_2564_MEC'
      FRAME_-54377001_CLASS            =  4
      FRAME_-54377001_CLASS_ID         = -54377001
      FRAME_-54377001_CENTER           = -54377
      TKFRAME_-54377001_RELATIVE       = 'COSMOS_2564_IGS'
      TKFRAME_-54377001_SPEC           = 'ANGLES'
      TKFRAME_-54377001_UNITS          = 'DEGREES'
      TKFRAME_-54377001_AXES           = (  1,   3, 2)
      TKFRAME_-54377001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2569_IGS            = -57517000
      FRAME_-57517000_NAME             = 'COSMOS_2569_IGS'
      FRAME_-57517000_CLASS            =  5
      FRAME_-57517000_CLASS_ID         = -57517000
      FRAME_-57517000_CENTER           = -57517
      FRAME_-57517000_RELATIVE         = 'J2000'
      FRAME_-57517000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-57517000_FAMILY           = 'TWO-VECTOR'
      FRAME_-57517000_PRI_AXIS         = 'Z'
      FRAME_-57517000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-57517000_PRI_OBSERVER     = 'COSMOS_2569'
      FRAME_-57517000_PRI_TARGET       = 'EARTH'
      FRAME_-57517000_PRI_ABCORR       = 'NONE'
      FRAME_-57517000_SEC_AXIS         = 'X'
      FRAME_-57517000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-57517000_SEC_OBSERVER     = 'COSMOS_2569'
      FRAME_-57517000_SEC_TARGET       = 'SUN'
      FRAME_-57517000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2569_MEC            = -57517001
      FRAME_-57517001_NAME             = 'COSMOS_2569_MEC'
      FRAME_-57517001_CLASS            =  4
      FRAME_-57517001_CLASS_ID         = -57517001
      FRAME_-57517001_CENTER           = -57517
      TKFRAME_-57517001_RELATIVE       = 'COSMOS_2569_IGS'
      TKFRAME_-57517001_SPEC           = 'ANGLES'
      TKFRAME_-57517001_UNITS          = 'DEGREES'
      TKFRAME_-57517001_AXES           = (  1,   3, 2)
      TKFRAME_-57517001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2584_IGS            = -63130000
      FRAME_-63130000_NAME             = 'COSMOS_2584_IGS'
      FRAME_-63130000_CLASS            =  5
      FRAME_-63130000_CLASS_ID         = -63130000
      FRAME_-63130000_CENTER           = -63130
      FRAME_-63130000_RELATIVE         = 'J2000'
      FRAME_-63130000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-63130000_FAMILY           = 'TWO-VECTOR'
      FRAME_-63130000_PRI_AXIS         = 'Z'
      FRAME_-63130000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-63130000_PRI_OBSERVER     = 'COSMOS_2584'
      FRAME_-63130000_PRI_TARGET       = 'EARTH'
      FRAME_-63130000_PRI_ABCORR       = 'NONE'
      FRAME_-63130000_SEC_AXIS         = 'X'
      FRAME_-63130000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-63130000_SEC_OBSERVER     = 'COSMOS_2584'
      FRAME_-63130000_SEC_TARGET       = 'SUN'
      FRAME_-63130000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2584_MEC            = -63130001
      FRAME_-63130001_NAME             = 'COSMOS_2584_MEC'
      FRAME_-63130001_CLASS            =  4
      FRAME_-63130001_CLASS_ID         = -63130001
      FRAME_-63130001_CENTER           = -63130
      TKFRAME_-63130001_RELATIVE       = 'COSMOS_2584_IGS'
      TKFRAME_-63130001_SPEC           = 'ANGLES'
      TKFRAME_-63130001_UNITS          = 'DEGREES'
      TKFRAME_-63130001_AXES           = (  1,   3, 2)
      TKFRAME_-63130001_ANGLES         = ( 90, -90, 0)

      FRAME_COSMOS_2596_IGS            = -65590000
      FRAME_-65590000_NAME             = 'COSMOS_2596_IGS'
      FRAME_-65590000_CLASS            =  5
      FRAME_-65590000_CLASS_ID         = -65590000
      FRAME_-65590000_CENTER           = -65590
      FRAME_-65590000_RELATIVE         = 'J2000'
      FRAME_-65590000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-65590000_FAMILY           = 'TWO-VECTOR'
      FRAME_-65590000_PRI_AXIS         = 'Z'
      FRAME_-65590000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-65590000_PRI_OBSERVER     = 'COSMOS_2596'
      FRAME_-65590000_PRI_TARGET       = 'EARTH'
      FRAME_-65590000_PRI_ABCORR       = 'NONE'
      FRAME_-65590000_SEC_AXIS         = 'X'
      FRAME_-65590000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-65590000_SEC_OBSERVER     = 'COSMOS_2596'
      FRAME_-65590000_SEC_TARGET       = 'SUN'
      FRAME_-65590000_SEC_ABCORR       = 'NONE'

      FRAME_COSMOS_2596_MEC            = -65590001
      FRAME_-65590001_NAME             = 'COSMOS_2596_MEC'
      FRAME_-65590001_CLASS            =  4
      FRAME_-65590001_CLASS_ID         = -65590001
      FRAME_-65590001_CENTER           = -65590
      TKFRAME_-65590001_RELATIVE       = 'COSMOS_2596_IGS'
      TKFRAME_-65590001_SPEC           = 'ANGLES'
      TKFRAME_-65590001_UNITS          = 'DEGREES'
      TKFRAME_-65590001_AXES           = (  1,   3, 2)
      TKFRAME_-65590001_ANGLES         = ( 90, -90, 0)



      FRAME_BEIDOU-2_G4_IGS            = -37210000
      FRAME_-37210000_NAME             = 'BEIDOU-2_G4_IGS'
      FRAME_-37210000_CLASS            =  5
      FRAME_-37210000_CLASS_ID         = -37210000
      FRAME_-37210000_CENTER           = -37210
      FRAME_-37210000_RELATIVE         = 'J2000'
      FRAME_-37210000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37210000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37210000_PRI_AXIS         = 'Z'
      FRAME_-37210000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37210000_PRI_OBSERVER     = 'BEIDOU-2_G4'
      FRAME_-37210000_PRI_TARGET       = 'EARTH'
      FRAME_-37210000_PRI_ABCORR       = 'NONE'
      FRAME_-37210000_SEC_AXIS         = 'X'
      FRAME_-37210000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37210000_SEC_OBSERVER     = 'BEIDOU-2_G4'
      FRAME_-37210000_SEC_TARGET       = 'SUN'
      FRAME_-37210000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_G4_MEC            = -37210001
      FRAME_-37210001_NAME             = 'BEIDOU-2_G4_MEC'
      FRAME_-37210001_CLASS            =  4
      FRAME_-37210001_CLASS_ID         = -37210001
      FRAME_-37210001_CENTER           = -37210
      TKFRAME_-37210001_RELATIVE       = 'BEIDOU-2_G4_IGS'
      TKFRAME_-37210001_SPEC           = 'ANGLES'
      TKFRAME_-37210001_UNITS          = 'DEGREES'
      TKFRAME_-37210001_AXES           = (3, 2, 1)
      TKFRAME_-37210001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_G5_IGS            = -38091000
      FRAME_-38091000_NAME             = 'BEIDOU-2_G5_IGS'
      FRAME_-38091000_CLASS            =  5
      FRAME_-38091000_CLASS_ID         = -38091000
      FRAME_-38091000_CENTER           = -38091
      FRAME_-38091000_RELATIVE         = 'J2000'
      FRAME_-38091000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38091000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38091000_PRI_AXIS         = 'Z'
      FRAME_-38091000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38091000_PRI_OBSERVER     = 'BEIDOU-2_G5'
      FRAME_-38091000_PRI_TARGET       = 'EARTH'
      FRAME_-38091000_PRI_ABCORR       = 'NONE'
      FRAME_-38091000_SEC_AXIS         = 'X'
      FRAME_-38091000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38091000_SEC_OBSERVER     = 'BEIDOU-2_G5'
      FRAME_-38091000_SEC_TARGET       = 'SUN'
      FRAME_-38091000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_G5_MEC            = -38091001
      FRAME_-38091001_NAME             = 'BEIDOU-2_G5_MEC'
      FRAME_-38091001_CLASS            =  4
      FRAME_-38091001_CLASS_ID         = -38091001
      FRAME_-38091001_CENTER           = -38091
      TKFRAME_-38091001_RELATIVE       = 'BEIDOU-2_G5_IGS'
      TKFRAME_-38091001_SPEC           = 'ANGLES'
      TKFRAME_-38091001_UNITS          = 'DEGREES'
      TKFRAME_-38091001_AXES           = (3, 2, 1)
      TKFRAME_-38091001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_G6_IGS            = -38953000
      FRAME_-38953000_NAME             = 'BEIDOU-2_G6_IGS'
      FRAME_-38953000_CLASS            =  5
      FRAME_-38953000_CLASS_ID         = -38953000
      FRAME_-38953000_CENTER           = -38953
      FRAME_-38953000_RELATIVE         = 'J2000'
      FRAME_-38953000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38953000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38953000_PRI_AXIS         = 'Z'
      FRAME_-38953000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38953000_PRI_OBSERVER     = 'BEIDOU-2_G6'
      FRAME_-38953000_PRI_TARGET       = 'EARTH'
      FRAME_-38953000_PRI_ABCORR       = 'NONE'
      FRAME_-38953000_SEC_AXIS         = 'X'
      FRAME_-38953000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38953000_SEC_OBSERVER     = 'BEIDOU-2_G6'
      FRAME_-38953000_SEC_TARGET       = 'SUN'
      FRAME_-38953000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_G6_MEC            = -38953001
      FRAME_-38953001_NAME             = 'BEIDOU-2_G6_MEC'
      FRAME_-38953001_CLASS            =  4
      FRAME_-38953001_CLASS_ID         = -38953001
      FRAME_-38953001_CENTER           = -38953
      TKFRAME_-38953001_RELATIVE       = 'BEIDOU-2_G6_IGS'
      TKFRAME_-38953001_SPEC           = 'ANGLES'
      TKFRAME_-38953001_UNITS          = 'DEGREES'
      TKFRAME_-38953001_AXES           = (3, 2, 1)
      TKFRAME_-38953001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_G7_IGS            = -41586000
      FRAME_-41586000_NAME             = 'BEIDOU-2_G7_IGS'
      FRAME_-41586000_CLASS            =  5
      FRAME_-41586000_CLASS_ID         = -41586000
      FRAME_-41586000_CENTER           = -41586
      FRAME_-41586000_RELATIVE         = 'J2000'
      FRAME_-41586000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41586000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41586000_PRI_AXIS         = 'Z'
      FRAME_-41586000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41586000_PRI_OBSERVER     = 'BEIDOU-2_G7'
      FRAME_-41586000_PRI_TARGET       = 'EARTH'
      FRAME_-41586000_PRI_ABCORR       = 'NONE'
      FRAME_-41586000_SEC_AXIS         = 'X'
      FRAME_-41586000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41586000_SEC_OBSERVER     = 'BEIDOU-2_G7'
      FRAME_-41586000_SEC_TARGET       = 'SUN'
      FRAME_-41586000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_G7_MEC            = -41586001
      FRAME_-41586001_NAME             = 'BEIDOU-2_G7_MEC'
      FRAME_-41586001_CLASS            =  4
      FRAME_-41586001_CLASS_ID         = -41586001
      FRAME_-41586001_CENTER           = -41586
      TKFRAME_-41586001_RELATIVE       = 'BEIDOU-2_G7_IGS'
      TKFRAME_-41586001_SPEC           = 'ANGLES'
      TKFRAME_-41586001_UNITS          = 'DEGREES'
      TKFRAME_-41586001_AXES           = (3, 2, 1)
      TKFRAME_-41586001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_G8_IGS            = -44231000
      FRAME_-44231000_NAME             = 'BEIDOU-2_G8_IGS'
      FRAME_-44231000_CLASS            =  5
      FRAME_-44231000_CLASS_ID         = -44231000
      FRAME_-44231000_CENTER           = -44231
      FRAME_-44231000_RELATIVE         = 'J2000'
      FRAME_-44231000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44231000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44231000_PRI_AXIS         = 'Z'
      FRAME_-44231000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44231000_PRI_OBSERVER     = 'BEIDOU-2_G8'
      FRAME_-44231000_PRI_TARGET       = 'EARTH'
      FRAME_-44231000_PRI_ABCORR       = 'NONE'
      FRAME_-44231000_SEC_AXIS         = 'X'
      FRAME_-44231000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44231000_SEC_OBSERVER     = 'BEIDOU-2_G8'
      FRAME_-44231000_SEC_TARGET       = 'SUN'
      FRAME_-44231000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_G8_MEC            = -44231001
      FRAME_-44231001_NAME             = 'BEIDOU-2_G8_MEC'
      FRAME_-44231001_CLASS            =  4
      FRAME_-44231001_CLASS_ID         = -44231001
      FRAME_-44231001_CENTER           = -44231
      TKFRAME_-44231001_RELATIVE       = 'BEIDOU-2_G8_IGS'
      TKFRAME_-44231001_SPEC           = 'ANGLES'
      TKFRAME_-44231001_UNITS          = 'DEGREES'
      TKFRAME_-44231001_AXES           = (3, 2, 1)
      TKFRAME_-44231001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-1_IGS        = -36828000
      FRAME_-36828000_NAME             = 'BEIDOU-2_IGSO-1_IGS'
      FRAME_-36828000_CLASS            =  5
      FRAME_-36828000_CLASS_ID         = -36828000
      FRAME_-36828000_CENTER           = -36828
      FRAME_-36828000_RELATIVE         = 'J2000'
      FRAME_-36828000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-36828000_FAMILY           = 'TWO-VECTOR'
      FRAME_-36828000_PRI_AXIS         = 'Z'
      FRAME_-36828000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36828000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-1'
      FRAME_-36828000_PRI_TARGET       = 'EARTH'
      FRAME_-36828000_PRI_ABCORR       = 'NONE'
      FRAME_-36828000_SEC_AXIS         = 'X'
      FRAME_-36828000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-36828000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-1'
      FRAME_-36828000_SEC_TARGET       = 'SUN'
      FRAME_-36828000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-1_MEC        = -36828001
      FRAME_-36828001_NAME             = 'BEIDOU-2_IGSO-1_MEC'
      FRAME_-36828001_CLASS            =  4
      FRAME_-36828001_CLASS_ID         = -36828001
      FRAME_-36828001_CENTER           = -36828
      TKFRAME_-36828001_RELATIVE       = 'BEIDOU-2_IGSO-1_IGS'
      TKFRAME_-36828001_SPEC           = 'ANGLES'
      TKFRAME_-36828001_UNITS          = 'DEGREES'
      TKFRAME_-36828001_AXES           = (3, 2, 1)
      TKFRAME_-36828001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-2_IGS        = -37256000
      FRAME_-37256000_NAME             = 'BEIDOU-2_IGSO-2_IGS'
      FRAME_-37256000_CLASS            =  5
      FRAME_-37256000_CLASS_ID         = -37256000
      FRAME_-37256000_CENTER           = -37256
      FRAME_-37256000_RELATIVE         = 'J2000'
      FRAME_-37256000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37256000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37256000_PRI_AXIS         = 'Z'
      FRAME_-37256000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37256000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-2'
      FRAME_-37256000_PRI_TARGET       = 'EARTH'
      FRAME_-37256000_PRI_ABCORR       = 'NONE'
      FRAME_-37256000_SEC_AXIS         = 'X'
      FRAME_-37256000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37256000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-2'
      FRAME_-37256000_SEC_TARGET       = 'SUN'
      FRAME_-37256000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-2_MEC        = -37256001
      FRAME_-37256001_NAME             = 'BEIDOU-2_IGSO-2_MEC'
      FRAME_-37256001_CLASS            =  4
      FRAME_-37256001_CLASS_ID         = -37256001
      FRAME_-37256001_CENTER           = -37256
      TKFRAME_-37256001_RELATIVE       = 'BEIDOU-2_IGSO-2_IGS'
      TKFRAME_-37256001_SPEC           = 'ANGLES'
      TKFRAME_-37256001_UNITS          = 'DEGREES'
      TKFRAME_-37256001_AXES           = (3, 2, 1)
      TKFRAME_-37256001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-3_IGS        = -37384000
      FRAME_-37384000_NAME             = 'BEIDOU-2_IGSO-3_IGS'
      FRAME_-37384000_CLASS            =  5
      FRAME_-37384000_CLASS_ID         = -37384000
      FRAME_-37384000_CENTER           = -37384
      FRAME_-37384000_RELATIVE         = 'J2000'
      FRAME_-37384000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37384000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37384000_PRI_AXIS         = 'Z'
      FRAME_-37384000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37384000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-3'
      FRAME_-37384000_PRI_TARGET       = 'EARTH'
      FRAME_-37384000_PRI_ABCORR       = 'NONE'
      FRAME_-37384000_SEC_AXIS         = 'X'
      FRAME_-37384000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37384000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-3'
      FRAME_-37384000_SEC_TARGET       = 'SUN'
      FRAME_-37384000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-3_MEC        = -37384001
      FRAME_-37384001_NAME             = 'BEIDOU-2_IGSO-3_MEC'
      FRAME_-37384001_CLASS            =  4
      FRAME_-37384001_CLASS_ID         = -37384001
      FRAME_-37384001_CENTER           = -37384
      TKFRAME_-37384001_RELATIVE       = 'BEIDOU-2_IGSO-3_IGS'
      TKFRAME_-37384001_SPEC           = 'ANGLES'
      TKFRAME_-37384001_UNITS          = 'DEGREES'
      TKFRAME_-37384001_AXES           = (3, 2, 1)
      TKFRAME_-37384001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-4_IGS        = -37763000
      FRAME_-37763000_NAME             = 'BEIDOU-2_IGSO-4_IGS'
      FRAME_-37763000_CLASS            =  5
      FRAME_-37763000_CLASS_ID         = -37763000
      FRAME_-37763000_CENTER           = -37763
      FRAME_-37763000_RELATIVE         = 'J2000'
      FRAME_-37763000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37763000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37763000_PRI_AXIS         = 'Z'
      FRAME_-37763000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37763000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-4'
      FRAME_-37763000_PRI_TARGET       = 'EARTH'
      FRAME_-37763000_PRI_ABCORR       = 'NONE'
      FRAME_-37763000_SEC_AXIS         = 'X'
      FRAME_-37763000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37763000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-4'
      FRAME_-37763000_SEC_TARGET       = 'SUN'
      FRAME_-37763000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-4_MEC        = -37763001
      FRAME_-37763001_NAME             = 'BEIDOU-2_IGSO-4_MEC'
      FRAME_-37763001_CLASS            =  4
      FRAME_-37763001_CLASS_ID         = -37763001
      FRAME_-37763001_CENTER           = -37763
      TKFRAME_-37763001_RELATIVE       = 'BEIDOU-2_IGSO-4_IGS'
      TKFRAME_-37763001_SPEC           = 'ANGLES'
      TKFRAME_-37763001_UNITS          = 'DEGREES'
      TKFRAME_-37763001_AXES           = (3, 2, 1)
      TKFRAME_-37763001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-5_IGS        = -37948000
      FRAME_-37948000_NAME             = 'BEIDOU-2_IGSO-5_IGS'
      FRAME_-37948000_CLASS            =  5
      FRAME_-37948000_CLASS_ID         = -37948000
      FRAME_-37948000_CENTER           = -37948
      FRAME_-37948000_RELATIVE         = 'J2000'
      FRAME_-37948000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37948000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37948000_PRI_AXIS         = 'Z'
      FRAME_-37948000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37948000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-5'
      FRAME_-37948000_PRI_TARGET       = 'EARTH'
      FRAME_-37948000_PRI_ABCORR       = 'NONE'
      FRAME_-37948000_SEC_AXIS         = 'X'
      FRAME_-37948000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37948000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-5'
      FRAME_-37948000_SEC_TARGET       = 'SUN'
      FRAME_-37948000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-5_MEC        = -37948001
      FRAME_-37948001_NAME             = 'BEIDOU-2_IGSO-5_MEC'
      FRAME_-37948001_CLASS            =  4
      FRAME_-37948001_CLASS_ID         = -37948001
      FRAME_-37948001_CENTER           = -37948
      TKFRAME_-37948001_RELATIVE       = 'BEIDOU-2_IGSO-5_IGS'
      TKFRAME_-37948001_SPEC           = 'ANGLES'
      TKFRAME_-37948001_UNITS          = 'DEGREES'
      TKFRAME_-37948001_AXES           = (3, 2, 1)
      TKFRAME_-37948001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-6_IGS        = -41434000
      FRAME_-41434000_NAME             = 'BEIDOU-2_IGSO-6_IGS'
      FRAME_-41434000_CLASS            =  5
      FRAME_-41434000_CLASS_ID         = -41434000
      FRAME_-41434000_CENTER           = -41434
      FRAME_-41434000_RELATIVE         = 'J2000'
      FRAME_-41434000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41434000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41434000_PRI_AXIS         = 'Z'
      FRAME_-41434000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41434000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-6'
      FRAME_-41434000_PRI_TARGET       = 'EARTH'
      FRAME_-41434000_PRI_ABCORR       = 'NONE'
      FRAME_-41434000_SEC_AXIS         = 'X'
      FRAME_-41434000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41434000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-6'
      FRAME_-41434000_SEC_TARGET       = 'SUN'
      FRAME_-41434000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-6_MEC        = -41434001
      FRAME_-41434001_NAME             = 'BEIDOU-2_IGSO-6_MEC'
      FRAME_-41434001_CLASS            =  4
      FRAME_-41434001_CLASS_ID         = -41434001
      FRAME_-41434001_CENTER           = -41434
      TKFRAME_-41434001_RELATIVE       = 'BEIDOU-2_IGSO-6_IGS'
      TKFRAME_-41434001_SPEC           = 'ANGLES'
      TKFRAME_-41434001_UNITS          = 'DEGREES'
      TKFRAME_-41434001_AXES           = (3, 2, 1)
      TKFRAME_-41434001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_IGSO-7_IGS        = -43539000
      FRAME_-43539000_NAME             = 'BEIDOU-2_IGSO-7_IGS'
      FRAME_-43539000_CLASS            =  5
      FRAME_-43539000_CLASS_ID         = -43539000
      FRAME_-43539000_CENTER           = -43539
      FRAME_-43539000_RELATIVE         = 'J2000'
      FRAME_-43539000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43539000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43539000_PRI_AXIS         = 'Z'
      FRAME_-43539000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43539000_PRI_OBSERVER     = 'BEIDOU-2_IGSO-7'
      FRAME_-43539000_PRI_TARGET       = 'EARTH'
      FRAME_-43539000_PRI_ABCORR       = 'NONE'
      FRAME_-43539000_SEC_AXIS         = 'X'
      FRAME_-43539000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43539000_SEC_OBSERVER     = 'BEIDOU-2_IGSO-7'
      FRAME_-43539000_SEC_TARGET       = 'SUN'
      FRAME_-43539000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_IGSO-7_MEC        = -43539001
      FRAME_-43539001_NAME             = 'BEIDOU-2_IGSO-7_MEC'
      FRAME_-43539001_CLASS            =  4
      FRAME_-43539001_CLASS_ID         = -43539001
      FRAME_-43539001_CENTER           = -43539
      TKFRAME_-43539001_RELATIVE       = 'BEIDOU-2_IGSO-7_IGS'
      TKFRAME_-43539001_SPEC           = 'ANGLES'
      TKFRAME_-43539001_UNITS          = 'DEGREES'
      TKFRAME_-43539001_AXES           = (3, 2, 1)
      TKFRAME_-43539001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_M3_IGS            = -38250000
      FRAME_-38250000_NAME             = 'BEIDOU-2_M3_IGS'
      FRAME_-38250000_CLASS            =  5
      FRAME_-38250000_CLASS_ID         = -38250000
      FRAME_-38250000_CENTER           = -38250
      FRAME_-38250000_RELATIVE         = 'J2000'
      FRAME_-38250000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38250000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38250000_PRI_AXIS         = 'Z'
      FRAME_-38250000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38250000_PRI_OBSERVER     = 'BEIDOU-2_M3'
      FRAME_-38250000_PRI_TARGET       = 'EARTH'
      FRAME_-38250000_PRI_ABCORR       = 'NONE'
      FRAME_-38250000_SEC_AXIS         = 'X'
      FRAME_-38250000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38250000_SEC_OBSERVER     = 'BEIDOU-2_M3'
      FRAME_-38250000_SEC_TARGET       = 'SUN'
      FRAME_-38250000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_M3_MEC            = -38250001
      FRAME_-38250001_NAME             = 'BEIDOU-2_M3_MEC'
      FRAME_-38250001_CLASS            =  4
      FRAME_-38250001_CLASS_ID         = -38250001
      FRAME_-38250001_CENTER           = -38250
      TKFRAME_-38250001_RELATIVE       = 'BEIDOU-2_M3_IGS'
      TKFRAME_-38250001_SPEC           = 'ANGLES'
      TKFRAME_-38250001_UNITS          = 'DEGREES'
      TKFRAME_-38250001_AXES           = (3, 2, 1)
      TKFRAME_-38250001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_M4_IGS            = -38251000
      FRAME_-38251000_NAME             = 'BEIDOU-2_M4_IGS'
      FRAME_-38251000_CLASS            =  5
      FRAME_-38251000_CLASS_ID         = -38251000
      FRAME_-38251000_CENTER           = -38251
      FRAME_-38251000_RELATIVE         = 'J2000'
      FRAME_-38251000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38251000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38251000_PRI_AXIS         = 'Z'
      FRAME_-38251000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38251000_PRI_OBSERVER     = 'BEIDOU-2_M4'
      FRAME_-38251000_PRI_TARGET       = 'EARTH'
      FRAME_-38251000_PRI_ABCORR       = 'NONE'
      FRAME_-38251000_SEC_AXIS         = 'X'
      FRAME_-38251000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38251000_SEC_OBSERVER     = 'BEIDOU-2_M4'
      FRAME_-38251000_SEC_TARGET       = 'SUN'
      FRAME_-38251000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_M4_MEC            = -38251001
      FRAME_-38251001_NAME             = 'BEIDOU-2_M4_MEC'
      FRAME_-38251001_CLASS            =  4
      FRAME_-38251001_CLASS_ID         = -38251001
      FRAME_-38251001_CENTER           = -38251
      TKFRAME_-38251001_RELATIVE       = 'BEIDOU-2_M4_IGS'
      TKFRAME_-38251001_SPEC           = 'ANGLES'
      TKFRAME_-38251001_UNITS          = 'DEGREES'
      TKFRAME_-38251001_AXES           = (3, 2, 1)
      TKFRAME_-38251001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-2_M6_IGS            = -38775000
      FRAME_-38775000_NAME             = 'BEIDOU-2_M6_IGS'
      FRAME_-38775000_CLASS            =  5
      FRAME_-38775000_CLASS_ID         = -38775000
      FRAME_-38775000_CENTER           = -38775
      FRAME_-38775000_RELATIVE         = 'J2000'
      FRAME_-38775000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38775000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38775000_PRI_AXIS         = 'Z'
      FRAME_-38775000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38775000_PRI_OBSERVER     = 'BEIDOU-2_M6'
      FRAME_-38775000_PRI_TARGET       = 'EARTH'
      FRAME_-38775000_PRI_ABCORR       = 'NONE'
      FRAME_-38775000_SEC_AXIS         = 'X'
      FRAME_-38775000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38775000_SEC_OBSERVER     = 'BEIDOU-2_M6'
      FRAME_-38775000_SEC_TARGET       = 'SUN'
      FRAME_-38775000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-2_M6_MEC            = -38775001
      FRAME_-38775001_NAME             = 'BEIDOU-2_M6_MEC'
      FRAME_-38775001_CLASS            =  4
      FRAME_-38775001_CLASS_ID         = -38775001
      FRAME_-38775001_CENTER           = -38775
      TKFRAME_-38775001_RELATIVE       = 'BEIDOU-2_M6_IGS'
      TKFRAME_-38775001_SPEC           = 'ANGLES'
      TKFRAME_-38775001_UNITS          = 'DEGREES'
      TKFRAME_-38775001_AXES           = (3, 2, 1)
      TKFRAME_-38775001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3S_IGSO-1S_IGS      = -40549000
      FRAME_-40549000_NAME             = 'BEIDOU-3S_IGSO-1S_IGS'
      FRAME_-40549000_CLASS            =  5
      FRAME_-40549000_CLASS_ID         = -40549000
      FRAME_-40549000_CENTER           = -40549
      FRAME_-40549000_RELATIVE         = 'J2000'
      FRAME_-40549000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40549000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40549000_PRI_AXIS         = 'Z'
      FRAME_-40549000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40549000_PRI_OBSERVER     = 'BEIDOU-3S_IGSO-1S'
      FRAME_-40549000_PRI_TARGET       = 'EARTH'
      FRAME_-40549000_PRI_ABCORR       = 'NONE'
      FRAME_-40549000_SEC_AXIS         = 'X'
      FRAME_-40549000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40549000_SEC_OBSERVER     = 'BEIDOU-3S_IGSO-1S'
      FRAME_-40549000_SEC_TARGET       = 'SUN'
      FRAME_-40549000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3S_IGSO-1S_MEC      = -40549001
      FRAME_-40549001_NAME             = 'BEIDOU-3S_IGSO-1S_MEC'
      FRAME_-40549001_CLASS            =  4
      FRAME_-40549001_CLASS_ID         = -40549001
      FRAME_-40549001_CENTER           = -40549
      TKFRAME_-40549001_RELATIVE       = 'BEIDOU-3S_IGSO-1S_IGS'
      TKFRAME_-40549001_SPEC           = 'ANGLES'
      TKFRAME_-40549001_UNITS          = 'DEGREES'
      TKFRAME_-40549001_AXES           = (3, 2, 1)
      TKFRAME_-40549001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3S_IGSO-2S_IGS      = -40938000
      FRAME_-40938000_NAME             = 'BEIDOU-3S_IGSO-2S_IGS'
      FRAME_-40938000_CLASS            =  5
      FRAME_-40938000_CLASS_ID         = -40938000
      FRAME_-40938000_CENTER           = -40938
      FRAME_-40938000_RELATIVE         = 'J2000'
      FRAME_-40938000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40938000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40938000_PRI_AXIS         = 'Z'
      FRAME_-40938000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40938000_PRI_OBSERVER     = 'BEIDOU-3S_IGSO-2S'
      FRAME_-40938000_PRI_TARGET       = 'EARTH'
      FRAME_-40938000_PRI_ABCORR       = 'NONE'
      FRAME_-40938000_SEC_AXIS         = 'X'
      FRAME_-40938000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40938000_SEC_OBSERVER     = 'BEIDOU-3S_IGSO-2S'
      FRAME_-40938000_SEC_TARGET       = 'SUN'
      FRAME_-40938000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3S_IGSO-2S_MEC      = -40938001
      FRAME_-40938001_NAME             = 'BEIDOU-3S_IGSO-2S_MEC'
      FRAME_-40938001_CLASS            =  4
      FRAME_-40938001_CLASS_ID         = -40938001
      FRAME_-40938001_CENTER           = -40938
      TKFRAME_-40938001_RELATIVE       = 'BEIDOU-3S_IGSO-2S_IGS'
      TKFRAME_-40938001_SPEC           = 'ANGLES'
      TKFRAME_-40938001_UNITS          = 'DEGREES'
      TKFRAME_-40938001_AXES           = (3, 2, 1)
      TKFRAME_-40938001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3S_M1S_IGS          = -40749000
      FRAME_-40749000_NAME             = 'BEIDOU-3S_M1S_IGS'
      FRAME_-40749000_CLASS            =  5
      FRAME_-40749000_CLASS_ID         = -40749000
      FRAME_-40749000_CENTER           = -40749
      FRAME_-40749000_RELATIVE         = 'J2000'
      FRAME_-40749000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40749000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40749000_PRI_AXIS         = 'Z'
      FRAME_-40749000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40749000_PRI_OBSERVER     = 'BEIDOU-3S_M1S'
      FRAME_-40749000_PRI_TARGET       = 'EARTH'
      FRAME_-40749000_PRI_ABCORR       = 'NONE'
      FRAME_-40749000_SEC_AXIS         = 'X'
      FRAME_-40749000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40749000_SEC_OBSERVER     = 'BEIDOU-3S_M1S'
      FRAME_-40749000_SEC_TARGET       = 'SUN'
      FRAME_-40749000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3S_M1S_MEC          = -40749001
      FRAME_-40749001_NAME             = 'BEIDOU-3S_M1S_MEC'
      FRAME_-40749001_CLASS            =  4
      FRAME_-40749001_CLASS_ID         = -40749001
      FRAME_-40749001_CENTER           = -40749
      TKFRAME_-40749001_RELATIVE       = 'BEIDOU-3S_M1S_IGS'
      TKFRAME_-40749001_SPEC           = 'ANGLES'
      TKFRAME_-40749001_UNITS          = 'DEGREES'
      TKFRAME_-40749001_AXES           = (3, 2, 1)
      TKFRAME_-40749001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3S_M2S_IGS          = -40748000
      FRAME_-40748000_NAME             = 'BEIDOU-3S_M2S_IGS'
      FRAME_-40748000_CLASS            =  5
      FRAME_-40748000_CLASS_ID         = -40748000
      FRAME_-40748000_CENTER           = -40748
      FRAME_-40748000_RELATIVE         = 'J2000'
      FRAME_-40748000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40748000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40748000_PRI_AXIS         = 'Z'
      FRAME_-40748000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40748000_PRI_OBSERVER     = 'BEIDOU-3S_M2S'
      FRAME_-40748000_PRI_TARGET       = 'EARTH'
      FRAME_-40748000_PRI_ABCORR       = 'NONE'
      FRAME_-40748000_SEC_AXIS         = 'X'
      FRAME_-40748000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40748000_SEC_OBSERVER     = 'BEIDOU-3S_M2S'
      FRAME_-40748000_SEC_TARGET       = 'SUN'
      FRAME_-40748000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3S_M2S_MEC          = -40748001
      FRAME_-40748001_NAME             = 'BEIDOU-3S_M2S_MEC'
      FRAME_-40748001_CLASS            =  4
      FRAME_-40748001_CLASS_ID         = -40748001
      FRAME_-40748001_CENTER           = -40748
      TKFRAME_-40748001_RELATIVE       = 'BEIDOU-3S_M2S_IGS'
      TKFRAME_-40748001_SPEC           = 'ANGLES'
      TKFRAME_-40748001_UNITS          = 'DEGREES'
      TKFRAME_-40748001_AXES           = (3, 2, 1)
      TKFRAME_-40748001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_G1_IGS            = -43683000
      FRAME_-43683000_NAME             = 'BEIDOU-3_G1_IGS'
      FRAME_-43683000_CLASS            =  5
      FRAME_-43683000_CLASS_ID         = -43683000
      FRAME_-43683000_CENTER           = -43683
      FRAME_-43683000_RELATIVE         = 'J2000'
      FRAME_-43683000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43683000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43683000_PRI_AXIS         = 'Z'
      FRAME_-43683000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43683000_PRI_OBSERVER     = 'BEIDOU-3_G1'
      FRAME_-43683000_PRI_TARGET       = 'EARTH'
      FRAME_-43683000_PRI_ABCORR       = 'NONE'
      FRAME_-43683000_SEC_AXIS         = 'X'
      FRAME_-43683000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43683000_SEC_OBSERVER     = 'BEIDOU-3_G1'
      FRAME_-43683000_SEC_TARGET       = 'SUN'
      FRAME_-43683000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_G1_MEC            = -43683001
      FRAME_-43683001_NAME             = 'BEIDOU-3_G1_MEC'
      FRAME_-43683001_CLASS            =  4
      FRAME_-43683001_CLASS_ID         = -43683001
      FRAME_-43683001_CENTER           = -43683
      TKFRAME_-43683001_RELATIVE       = 'BEIDOU-3_G1_IGS'
      TKFRAME_-43683001_SPEC           = 'ANGLES'
      TKFRAME_-43683001_UNITS          = 'DEGREES'
      TKFRAME_-43683001_AXES           = (3, 2, 1)
      TKFRAME_-43683001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_G2_IGS            = -45344000
      FRAME_-45344000_NAME             = 'BEIDOU-3_G2_IGS'
      FRAME_-45344000_CLASS            =  5
      FRAME_-45344000_CLASS_ID         = -45344000
      FRAME_-45344000_CENTER           = -45344
      FRAME_-45344000_RELATIVE         = 'J2000'
      FRAME_-45344000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-45344000_FAMILY           = 'TWO-VECTOR'
      FRAME_-45344000_PRI_AXIS         = 'Z'
      FRAME_-45344000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45344000_PRI_OBSERVER     = 'BEIDOU-3_G2'
      FRAME_-45344000_PRI_TARGET       = 'EARTH'
      FRAME_-45344000_PRI_ABCORR       = 'NONE'
      FRAME_-45344000_SEC_AXIS         = 'X'
      FRAME_-45344000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45344000_SEC_OBSERVER     = 'BEIDOU-3_G2'
      FRAME_-45344000_SEC_TARGET       = 'SUN'
      FRAME_-45344000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_G2_MEC            = -45344001
      FRAME_-45344001_NAME             = 'BEIDOU-3_G2_MEC'
      FRAME_-45344001_CLASS            =  4
      FRAME_-45344001_CLASS_ID         = -45344001
      FRAME_-45344001_CENTER           = -45344
      TKFRAME_-45344001_RELATIVE       = 'BEIDOU-3_G2_IGS'
      TKFRAME_-45344001_SPEC           = 'ANGLES'
      TKFRAME_-45344001_UNITS          = 'DEGREES'
      TKFRAME_-45344001_AXES           = (3, 2, 1)
      TKFRAME_-45344001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_G3_IGS            = -45807000
      FRAME_-45807000_NAME             = 'BEIDOU-3_G3_IGS'
      FRAME_-45807000_CLASS            =  5
      FRAME_-45807000_CLASS_ID         = -45807000
      FRAME_-45807000_CENTER           = -45807
      FRAME_-45807000_RELATIVE         = 'J2000'
      FRAME_-45807000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-45807000_FAMILY           = 'TWO-VECTOR'
      FRAME_-45807000_PRI_AXIS         = 'Z'
      FRAME_-45807000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45807000_PRI_OBSERVER     = 'BEIDOU-3_G3'
      FRAME_-45807000_PRI_TARGET       = 'EARTH'
      FRAME_-45807000_PRI_ABCORR       = 'NONE'
      FRAME_-45807000_SEC_AXIS         = 'X'
      FRAME_-45807000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-45807000_SEC_OBSERVER     = 'BEIDOU-3_G3'
      FRAME_-45807000_SEC_TARGET       = 'SUN'
      FRAME_-45807000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_G3_MEC            = -45807001
      FRAME_-45807001_NAME             = 'BEIDOU-3_G3_MEC'
      FRAME_-45807001_CLASS            =  4
      FRAME_-45807001_CLASS_ID         = -45807001
      FRAME_-45807001_CENTER           = -45807
      TKFRAME_-45807001_RELATIVE       = 'BEIDOU-3_G3_IGS'
      TKFRAME_-45807001_SPEC           = 'ANGLES'
      TKFRAME_-45807001_UNITS          = 'DEGREES'
      TKFRAME_-45807001_AXES           = (3, 2, 1)
      TKFRAME_-45807001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_G4_IGS            = -56564000
      FRAME_-56564000_NAME             = 'BEIDOU-3_G4_IGS'
      FRAME_-56564000_CLASS            =  5
      FRAME_-56564000_CLASS_ID         = -56564000
      FRAME_-56564000_CENTER           = -56564
      FRAME_-56564000_RELATIVE         = 'J2000'
      FRAME_-56564000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-56564000_FAMILY           = 'TWO-VECTOR'
      FRAME_-56564000_PRI_AXIS         = 'Z'
      FRAME_-56564000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-56564000_PRI_OBSERVER     = 'BEIDOU-3_G4'
      FRAME_-56564000_PRI_TARGET       = 'EARTH'
      FRAME_-56564000_PRI_ABCORR       = 'NONE'
      FRAME_-56564000_SEC_AXIS         = 'X'
      FRAME_-56564000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-56564000_SEC_OBSERVER     = 'BEIDOU-3_G4'
      FRAME_-56564000_SEC_TARGET       = 'SUN'
      FRAME_-56564000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_G4_MEC            = -56564001
      FRAME_-56564001_NAME             = 'BEIDOU-3_G4_MEC'
      FRAME_-56564001_CLASS            =  4
      FRAME_-56564001_CLASS_ID         = -56564001
      FRAME_-56564001_CENTER           = -56564
      TKFRAME_-56564001_RELATIVE       = 'BEIDOU-3_G4_IGS'
      TKFRAME_-56564001_SPEC           = 'ANGLES'
      TKFRAME_-56564001_UNITS          = 'DEGREES'
      TKFRAME_-56564001_AXES           = (3, 2, 1)
      TKFRAME_-56564001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_IGSO-1_IGS        = -44204000
      FRAME_-44204000_NAME             = 'BEIDOU-3_IGSO-1_IGS'
      FRAME_-44204000_CLASS            =  5
      FRAME_-44204000_CLASS_ID         = -44204000
      FRAME_-44204000_CENTER           = -44204
      FRAME_-44204000_RELATIVE         = 'J2000'
      FRAME_-44204000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44204000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44204000_PRI_AXIS         = 'Z'
      FRAME_-44204000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44204000_PRI_OBSERVER     = 'BEIDOU-3_IGSO-1'
      FRAME_-44204000_PRI_TARGET       = 'EARTH'
      FRAME_-44204000_PRI_ABCORR       = 'NONE'
      FRAME_-44204000_SEC_AXIS         = 'X'
      FRAME_-44204000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44204000_SEC_OBSERVER     = 'BEIDOU-3_IGSO-1'
      FRAME_-44204000_SEC_TARGET       = 'SUN'
      FRAME_-44204000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_IGSO-1_MEC        = -44204001
      FRAME_-44204001_NAME             = 'BEIDOU-3_IGSO-1_MEC'
      FRAME_-44204001_CLASS            =  4
      FRAME_-44204001_CLASS_ID         = -44204001
      FRAME_-44204001_CENTER           = -44204
      TKFRAME_-44204001_RELATIVE       = 'BEIDOU-3_IGSO-1_IGS'
      TKFRAME_-44204001_SPEC           = 'ANGLES'
      TKFRAME_-44204001_UNITS          = 'DEGREES'
      TKFRAME_-44204001_AXES           = (3, 2, 1)
      TKFRAME_-44204001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_IGSO-2_IGS        = -44337000
      FRAME_-44337000_NAME             = 'BEIDOU-3_IGSO-2_IGS'
      FRAME_-44337000_CLASS            =  5
      FRAME_-44337000_CLASS_ID         = -44337000
      FRAME_-44337000_CENTER           = -44337
      FRAME_-44337000_RELATIVE         = 'J2000'
      FRAME_-44337000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44337000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44337000_PRI_AXIS         = 'Z'
      FRAME_-44337000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44337000_PRI_OBSERVER     = 'BEIDOU-3_IGSO-2'
      FRAME_-44337000_PRI_TARGET       = 'EARTH'
      FRAME_-44337000_PRI_ABCORR       = 'NONE'
      FRAME_-44337000_SEC_AXIS         = 'X'
      FRAME_-44337000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44337000_SEC_OBSERVER     = 'BEIDOU-3_IGSO-2'
      FRAME_-44337000_SEC_TARGET       = 'SUN'
      FRAME_-44337000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_IGSO-2_MEC        = -44337001
      FRAME_-44337001_NAME             = 'BEIDOU-3_IGSO-2_MEC'
      FRAME_-44337001_CLASS            =  4
      FRAME_-44337001_CLASS_ID         = -44337001
      FRAME_-44337001_CENTER           = -44337
      TKFRAME_-44337001_RELATIVE       = 'BEIDOU-3_IGSO-2_IGS'
      TKFRAME_-44337001_SPEC           = 'ANGLES'
      TKFRAME_-44337001_UNITS          = 'DEGREES'
      TKFRAME_-44337001_AXES           = (3, 2, 1)
      TKFRAME_-44337001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_IGSO-3_IGS        = -44709000
      FRAME_-44709000_NAME             = 'BEIDOU-3_IGSO-3_IGS'
      FRAME_-44709000_CLASS            =  5
      FRAME_-44709000_CLASS_ID         = -44709000
      FRAME_-44709000_CENTER           = -44709
      FRAME_-44709000_RELATIVE         = 'J2000'
      FRAME_-44709000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44709000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44709000_PRI_AXIS         = 'Z'
      FRAME_-44709000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44709000_PRI_OBSERVER     = 'BEIDOU-3_IGSO-3'
      FRAME_-44709000_PRI_TARGET       = 'EARTH'
      FRAME_-44709000_PRI_ABCORR       = 'NONE'
      FRAME_-44709000_SEC_AXIS         = 'X'
      FRAME_-44709000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44709000_SEC_OBSERVER     = 'BEIDOU-3_IGSO-3'
      FRAME_-44709000_SEC_TARGET       = 'SUN'
      FRAME_-44709000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_IGSO-3_MEC        = -44709001
      FRAME_-44709001_NAME             = 'BEIDOU-3_IGSO-3_MEC'
      FRAME_-44709001_CLASS            =  4
      FRAME_-44709001_CLASS_ID         = -44709001
      FRAME_-44709001_CENTER           = -44709
      TKFRAME_-44709001_RELATIVE       = 'BEIDOU-3_IGSO-3_IGS'
      TKFRAME_-44709001_SPEC           = 'ANGLES'
      TKFRAME_-44709001_UNITS          = 'DEGREES'
      TKFRAME_-44709001_AXES           = (3, 2, 1)
      TKFRAME_-44709001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M1_IGS            = -43001000
      FRAME_-43001000_NAME             = 'BEIDOU-3_M1_IGS'
      FRAME_-43001000_CLASS            =  5
      FRAME_-43001000_CLASS_ID         = -43001000
      FRAME_-43001000_CENTER           = -43001
      FRAME_-43001000_RELATIVE         = 'J2000'
      FRAME_-43001000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43001000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43001000_PRI_AXIS         = 'Z'
      FRAME_-43001000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43001000_PRI_OBSERVER     = 'BEIDOU-3_M1'
      FRAME_-43001000_PRI_TARGET       = 'EARTH'
      FRAME_-43001000_PRI_ABCORR       = 'NONE'
      FRAME_-43001000_SEC_AXIS         = 'X'
      FRAME_-43001000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43001000_SEC_OBSERVER     = 'BEIDOU-3_M1'
      FRAME_-43001000_SEC_TARGET       = 'SUN'
      FRAME_-43001000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M1_MEC            = -43001001
      FRAME_-43001001_NAME             = 'BEIDOU-3_M1_MEC'
      FRAME_-43001001_CLASS            =  4
      FRAME_-43001001_CLASS_ID         = -43001001
      FRAME_-43001001_CENTER           = -43001
      TKFRAME_-43001001_RELATIVE       = 'BEIDOU-3_M1_IGS'
      TKFRAME_-43001001_SPEC           = 'ANGLES'
      TKFRAME_-43001001_UNITS          = 'DEGREES'
      TKFRAME_-43001001_AXES           = (3, 2, 1)
      TKFRAME_-43001001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M10_IGS           = -43246000
      FRAME_-43246000_NAME             = 'BEIDOU-3_M10_IGS'
      FRAME_-43246000_CLASS            =  5
      FRAME_-43246000_CLASS_ID         = -43246000
      FRAME_-43246000_CENTER           = -43246
      FRAME_-43246000_RELATIVE         = 'J2000'
      FRAME_-43246000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43246000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43246000_PRI_AXIS         = 'Z'
      FRAME_-43246000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43246000_PRI_OBSERVER     = 'BEIDOU-3_M10'
      FRAME_-43246000_PRI_TARGET       = 'EARTH'
      FRAME_-43246000_PRI_ABCORR       = 'NONE'
      FRAME_-43246000_SEC_AXIS         = 'X'
      FRAME_-43246000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43246000_SEC_OBSERVER     = 'BEIDOU-3_M10'
      FRAME_-43246000_SEC_TARGET       = 'SUN'
      FRAME_-43246000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M10_MEC           = -43246001
      FRAME_-43246001_NAME             = 'BEIDOU-3_M10_MEC'
      FRAME_-43246001_CLASS            =  4
      FRAME_-43246001_CLASS_ID         = -43246001
      FRAME_-43246001_CENTER           = -43246
      TKFRAME_-43246001_RELATIVE       = 'BEIDOU-3_M10_IGS'
      TKFRAME_-43246001_SPEC           = 'ANGLES'
      TKFRAME_-43246001_UNITS          = 'DEGREES'
      TKFRAME_-43246001_AXES           = (3, 2, 1)
      TKFRAME_-43246001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M11_IGS           = -43603000
      FRAME_-43603000_NAME             = 'BEIDOU-3_M11_IGS'
      FRAME_-43603000_CLASS            =  5
      FRAME_-43603000_CLASS_ID         = -43603000
      FRAME_-43603000_CENTER           = -43603
      FRAME_-43603000_RELATIVE         = 'J2000'
      FRAME_-43603000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43603000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43603000_PRI_AXIS         = 'Z'
      FRAME_-43603000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43603000_PRI_OBSERVER     = 'BEIDOU-3_M11'
      FRAME_-43603000_PRI_TARGET       = 'EARTH'
      FRAME_-43603000_PRI_ABCORR       = 'NONE'
      FRAME_-43603000_SEC_AXIS         = 'X'
      FRAME_-43603000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43603000_SEC_OBSERVER     = 'BEIDOU-3_M11'
      FRAME_-43603000_SEC_TARGET       = 'SUN'
      FRAME_-43603000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M11_MEC           = -43603001
      FRAME_-43603001_NAME             = 'BEIDOU-3_M11_MEC'
      FRAME_-43603001_CLASS            =  4
      FRAME_-43603001_CLASS_ID         = -43603001
      FRAME_-43603001_CENTER           = -43603
      TKFRAME_-43603001_RELATIVE       = 'BEIDOU-3_M11_IGS'
      TKFRAME_-43603001_SPEC           = 'ANGLES'
      TKFRAME_-43603001_UNITS          = 'DEGREES'
      TKFRAME_-43603001_AXES           = (3, 2, 1)
      TKFRAME_-43603001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M12_IGS           = -43602000
      FRAME_-43602000_NAME             = 'BEIDOU-3_M12_IGS'
      FRAME_-43602000_CLASS            =  5
      FRAME_-43602000_CLASS_ID         = -43602000
      FRAME_-43602000_CENTER           = -43602
      FRAME_-43602000_RELATIVE         = 'J2000'
      FRAME_-43602000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43602000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43602000_PRI_AXIS         = 'Z'
      FRAME_-43602000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43602000_PRI_OBSERVER     = 'BEIDOU-3_M12'
      FRAME_-43602000_PRI_TARGET       = 'EARTH'
      FRAME_-43602000_PRI_ABCORR       = 'NONE'
      FRAME_-43602000_SEC_AXIS         = 'X'
      FRAME_-43602000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43602000_SEC_OBSERVER     = 'BEIDOU-3_M12'
      FRAME_-43602000_SEC_TARGET       = 'SUN'
      FRAME_-43602000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M12_MEC           = -43602001
      FRAME_-43602001_NAME             = 'BEIDOU-3_M12_MEC'
      FRAME_-43602001_CLASS            =  4
      FRAME_-43602001_CLASS_ID         = -43602001
      FRAME_-43602001_CENTER           = -43602
      TKFRAME_-43602001_RELATIVE       = 'BEIDOU-3_M12_IGS'
      TKFRAME_-43602001_SPEC           = 'ANGLES'
      TKFRAME_-43602001_UNITS          = 'DEGREES'
      TKFRAME_-43602001_AXES           = (3, 2, 1)
      TKFRAME_-43602001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M13_IGS           = -43622000
      FRAME_-43622000_NAME             = 'BEIDOU-3_M13_IGS'
      FRAME_-43622000_CLASS            =  5
      FRAME_-43622000_CLASS_ID         = -43622000
      FRAME_-43622000_CENTER           = -43622
      FRAME_-43622000_RELATIVE         = 'J2000'
      FRAME_-43622000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43622000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43622000_PRI_AXIS         = 'Z'
      FRAME_-43622000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43622000_PRI_OBSERVER     = 'BEIDOU-3_M13'
      FRAME_-43622000_PRI_TARGET       = 'EARTH'
      FRAME_-43622000_PRI_ABCORR       = 'NONE'
      FRAME_-43622000_SEC_AXIS         = 'X'
      FRAME_-43622000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43622000_SEC_OBSERVER     = 'BEIDOU-3_M13'
      FRAME_-43622000_SEC_TARGET       = 'SUN'
      FRAME_-43622000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M13_MEC           = -43622001
      FRAME_-43622001_NAME             = 'BEIDOU-3_M13_MEC'
      FRAME_-43622001_CLASS            =  4
      FRAME_-43622001_CLASS_ID         = -43622001
      FRAME_-43622001_CENTER           = -43622
      TKFRAME_-43622001_RELATIVE       = 'BEIDOU-3_M13_IGS'
      TKFRAME_-43622001_SPEC           = 'ANGLES'
      TKFRAME_-43622001_UNITS          = 'DEGREES'
      TKFRAME_-43622001_AXES           = (3, 2, 1)
      TKFRAME_-43622001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M14_IGS           = -43623000
      FRAME_-43623000_NAME             = 'BEIDOU-3_M14_IGS'
      FRAME_-43623000_CLASS            =  5
      FRAME_-43623000_CLASS_ID         = -43623000
      FRAME_-43623000_CENTER           = -43623
      FRAME_-43623000_RELATIVE         = 'J2000'
      FRAME_-43623000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43623000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43623000_PRI_AXIS         = 'Z'
      FRAME_-43623000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43623000_PRI_OBSERVER     = 'BEIDOU-3_M14'
      FRAME_-43623000_PRI_TARGET       = 'EARTH'
      FRAME_-43623000_PRI_ABCORR       = 'NONE'
      FRAME_-43623000_SEC_AXIS         = 'X'
      FRAME_-43623000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43623000_SEC_OBSERVER     = 'BEIDOU-3_M14'
      FRAME_-43623000_SEC_TARGET       = 'SUN'
      FRAME_-43623000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M14_MEC           = -43623001
      FRAME_-43623001_NAME             = 'BEIDOU-3_M14_MEC'
      FRAME_-43623001_CLASS            =  4
      FRAME_-43623001_CLASS_ID         = -43623001
      FRAME_-43623001_CENTER           = -43623
      TKFRAME_-43623001_RELATIVE       = 'BEIDOU-3_M14_IGS'
      TKFRAME_-43623001_SPEC           = 'ANGLES'
      TKFRAME_-43623001_UNITS          = 'DEGREES'
      TKFRAME_-43623001_AXES           = (3, 2, 1)
      TKFRAME_-43623001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M15_IGS           = -43648000
      FRAME_-43648000_NAME             = 'BEIDOU-3_M15_IGS'
      FRAME_-43648000_CLASS            =  5
      FRAME_-43648000_CLASS_ID         = -43648000
      FRAME_-43648000_CENTER           = -43648
      FRAME_-43648000_RELATIVE         = 'J2000'
      FRAME_-43648000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43648000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43648000_PRI_AXIS         = 'Z'
      FRAME_-43648000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43648000_PRI_OBSERVER     = 'BEIDOU-3_M15'
      FRAME_-43648000_PRI_TARGET       = 'EARTH'
      FRAME_-43648000_PRI_ABCORR       = 'NONE'
      FRAME_-43648000_SEC_AXIS         = 'X'
      FRAME_-43648000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43648000_SEC_OBSERVER     = 'BEIDOU-3_M15'
      FRAME_-43648000_SEC_TARGET       = 'SUN'
      FRAME_-43648000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M15_MEC           = -43648001
      FRAME_-43648001_NAME             = 'BEIDOU-3_M15_MEC'
      FRAME_-43648001_CLASS            =  4
      FRAME_-43648001_CLASS_ID         = -43648001
      FRAME_-43648001_CENTER           = -43648
      TKFRAME_-43648001_RELATIVE       = 'BEIDOU-3_M15_IGS'
      TKFRAME_-43648001_SPEC           = 'ANGLES'
      TKFRAME_-43648001_UNITS          = 'DEGREES'
      TKFRAME_-43648001_AXES           = (3, 2, 1)
      TKFRAME_-43648001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M16_IGS           = -43647000
      FRAME_-43647000_NAME             = 'BEIDOU-3_M16_IGS'
      FRAME_-43647000_CLASS            =  5
      FRAME_-43647000_CLASS_ID         = -43647000
      FRAME_-43647000_CENTER           = -43647
      FRAME_-43647000_RELATIVE         = 'J2000'
      FRAME_-43647000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43647000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43647000_PRI_AXIS         = 'Z'
      FRAME_-43647000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43647000_PRI_OBSERVER     = 'BEIDOU-3_M16'
      FRAME_-43647000_PRI_TARGET       = 'EARTH'
      FRAME_-43647000_PRI_ABCORR       = 'NONE'
      FRAME_-43647000_SEC_AXIS         = 'X'
      FRAME_-43647000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43647000_SEC_OBSERVER     = 'BEIDOU-3_M16'
      FRAME_-43647000_SEC_TARGET       = 'SUN'
      FRAME_-43647000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M16_MEC           = -43647001
      FRAME_-43647001_NAME             = 'BEIDOU-3_M16_MEC'
      FRAME_-43647001_CLASS            =  4
      FRAME_-43647001_CLASS_ID         = -43647001
      FRAME_-43647001_CENTER           = -43647
      TKFRAME_-43647001_RELATIVE       = 'BEIDOU-3_M16_IGS'
      TKFRAME_-43647001_SPEC           = 'ANGLES'
      TKFRAME_-43647001_UNITS          = 'DEGREES'
      TKFRAME_-43647001_AXES           = (3, 2, 1)
      TKFRAME_-43647001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M17_IGS           = -43706000
      FRAME_-43706000_NAME             = 'BEIDOU-3_M17_IGS'
      FRAME_-43706000_CLASS            =  5
      FRAME_-43706000_CLASS_ID         = -43706000
      FRAME_-43706000_CENTER           = -43706
      FRAME_-43706000_RELATIVE         = 'J2000'
      FRAME_-43706000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43706000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43706000_PRI_AXIS         = 'Z'
      FRAME_-43706000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43706000_PRI_OBSERVER     = 'BEIDOU-3_M17'
      FRAME_-43706000_PRI_TARGET       = 'EARTH'
      FRAME_-43706000_PRI_ABCORR       = 'NONE'
      FRAME_-43706000_SEC_AXIS         = 'X'
      FRAME_-43706000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43706000_SEC_OBSERVER     = 'BEIDOU-3_M17'
      FRAME_-43706000_SEC_TARGET       = 'SUN'
      FRAME_-43706000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M17_MEC           = -43706001
      FRAME_-43706001_NAME             = 'BEIDOU-3_M17_MEC'
      FRAME_-43706001_CLASS            =  4
      FRAME_-43706001_CLASS_ID         = -43706001
      FRAME_-43706001_CENTER           = -43706
      TKFRAME_-43706001_RELATIVE       = 'BEIDOU-3_M17_IGS'
      TKFRAME_-43706001_SPEC           = 'ANGLES'
      TKFRAME_-43706001_UNITS          = 'DEGREES'
      TKFRAME_-43706001_AXES           = (3, 2, 1)
      TKFRAME_-43706001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M18_IGS           = -43707000
      FRAME_-43707000_NAME             = 'BEIDOU-3_M18_IGS'
      FRAME_-43707000_CLASS            =  5
      FRAME_-43707000_CLASS_ID         = -43707000
      FRAME_-43707000_CENTER           = -43707
      FRAME_-43707000_RELATIVE         = 'J2000'
      FRAME_-43707000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43707000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43707000_PRI_AXIS         = 'Z'
      FRAME_-43707000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43707000_PRI_OBSERVER     = 'BEIDOU-3_M18'
      FRAME_-43707000_PRI_TARGET       = 'EARTH'
      FRAME_-43707000_PRI_ABCORR       = 'NONE'
      FRAME_-43707000_SEC_AXIS         = 'X'
      FRAME_-43707000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43707000_SEC_OBSERVER     = 'BEIDOU-3_M18'
      FRAME_-43707000_SEC_TARGET       = 'SUN'
      FRAME_-43707000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M18_MEC           = -43707001
      FRAME_-43707001_NAME             = 'BEIDOU-3_M18_MEC'
      FRAME_-43707001_CLASS            =  4
      FRAME_-43707001_CLASS_ID         = -43707001
      FRAME_-43707001_CENTER           = -43707
      TKFRAME_-43707001_RELATIVE       = 'BEIDOU-3_M18_IGS'
      TKFRAME_-43707001_SPEC           = 'ANGLES'
      TKFRAME_-43707001_UNITS          = 'DEGREES'
      TKFRAME_-43707001_AXES           = (3, 2, 1)
      TKFRAME_-43707001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M19_IGS           = -44864000
      FRAME_-44864000_NAME             = 'BEIDOU-3_M19_IGS'
      FRAME_-44864000_CLASS            =  5
      FRAME_-44864000_CLASS_ID         = -44864000
      FRAME_-44864000_CENTER           = -44864
      FRAME_-44864000_RELATIVE         = 'J2000'
      FRAME_-44864000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44864000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44864000_PRI_AXIS         = 'Z'
      FRAME_-44864000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44864000_PRI_OBSERVER     = 'BEIDOU-3_M19'
      FRAME_-44864000_PRI_TARGET       = 'EARTH'
      FRAME_-44864000_PRI_ABCORR       = 'NONE'
      FRAME_-44864000_SEC_AXIS         = 'X'
      FRAME_-44864000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44864000_SEC_OBSERVER     = 'BEIDOU-3_M19'
      FRAME_-44864000_SEC_TARGET       = 'SUN'
      FRAME_-44864000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M19_MEC           = -44864001
      FRAME_-44864001_NAME             = 'BEIDOU-3_M19_MEC'
      FRAME_-44864001_CLASS            =  4
      FRAME_-44864001_CLASS_ID         = -44864001
      FRAME_-44864001_CENTER           = -44864
      TKFRAME_-44864001_RELATIVE       = 'BEIDOU-3_M19_IGS'
      TKFRAME_-44864001_SPEC           = 'ANGLES'
      TKFRAME_-44864001_UNITS          = 'DEGREES'
      TKFRAME_-44864001_AXES           = (3, 2, 1)
      TKFRAME_-44864001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M2_IGS            = -43002000
      FRAME_-43002000_NAME             = 'BEIDOU-3_M2_IGS'
      FRAME_-43002000_CLASS            =  5
      FRAME_-43002000_CLASS_ID         = -43002000
      FRAME_-43002000_CENTER           = -43002
      FRAME_-43002000_RELATIVE         = 'J2000'
      FRAME_-43002000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43002000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43002000_PRI_AXIS         = 'Z'
      FRAME_-43002000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43002000_PRI_OBSERVER     = 'BEIDOU-3_M2'
      FRAME_-43002000_PRI_TARGET       = 'EARTH'
      FRAME_-43002000_PRI_ABCORR       = 'NONE'
      FRAME_-43002000_SEC_AXIS         = 'X'
      FRAME_-43002000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43002000_SEC_OBSERVER     = 'BEIDOU-3_M2'
      FRAME_-43002000_SEC_TARGET       = 'SUN'
      FRAME_-43002000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M2_MEC            = -43002001
      FRAME_-43002001_NAME             = 'BEIDOU-3_M2_MEC'
      FRAME_-43002001_CLASS            =  4
      FRAME_-43002001_CLASS_ID         = -43002001
      FRAME_-43002001_CENTER           = -43002
      TKFRAME_-43002001_RELATIVE       = 'BEIDOU-3_M2_IGS'
      TKFRAME_-43002001_SPEC           = 'ANGLES'
      TKFRAME_-43002001_UNITS          = 'DEGREES'
      TKFRAME_-43002001_AXES           = (3, 2, 1)
      TKFRAME_-43002001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M20_IGS           = -44865000
      FRAME_-44865000_NAME             = 'BEIDOU-3_M20_IGS'
      FRAME_-44865000_CLASS            =  5
      FRAME_-44865000_CLASS_ID         = -44865000
      FRAME_-44865000_CENTER           = -44865
      FRAME_-44865000_RELATIVE         = 'J2000'
      FRAME_-44865000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44865000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44865000_PRI_AXIS         = 'Z'
      FRAME_-44865000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44865000_PRI_OBSERVER     = 'BEIDOU-3_M20'
      FRAME_-44865000_PRI_TARGET       = 'EARTH'
      FRAME_-44865000_PRI_ABCORR       = 'NONE'
      FRAME_-44865000_SEC_AXIS         = 'X'
      FRAME_-44865000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44865000_SEC_OBSERVER     = 'BEIDOU-3_M20'
      FRAME_-44865000_SEC_TARGET       = 'SUN'
      FRAME_-44865000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M20_MEC           = -44865001
      FRAME_-44865001_NAME             = 'BEIDOU-3_M20_MEC'
      FRAME_-44865001_CLASS            =  4
      FRAME_-44865001_CLASS_ID         = -44865001
      FRAME_-44865001_CENTER           = -44865
      TKFRAME_-44865001_RELATIVE       = 'BEIDOU-3_M20_IGS'
      TKFRAME_-44865001_SPEC           = 'ANGLES'
      TKFRAME_-44865001_UNITS          = 'DEGREES'
      TKFRAME_-44865001_AXES           = (3, 2, 1)
      TKFRAME_-44865001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M21_IGS           = -44794000
      FRAME_-44794000_NAME             = 'BEIDOU-3_M21_IGS'
      FRAME_-44794000_CLASS            =  5
      FRAME_-44794000_CLASS_ID         = -44794000
      FRAME_-44794000_CENTER           = -44794
      FRAME_-44794000_RELATIVE         = 'J2000'
      FRAME_-44794000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44794000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44794000_PRI_AXIS         = 'Z'
      FRAME_-44794000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44794000_PRI_OBSERVER     = 'BEIDOU-3_M21'
      FRAME_-44794000_PRI_TARGET       = 'EARTH'
      FRAME_-44794000_PRI_ABCORR       = 'NONE'
      FRAME_-44794000_SEC_AXIS         = 'X'
      FRAME_-44794000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44794000_SEC_OBSERVER     = 'BEIDOU-3_M21'
      FRAME_-44794000_SEC_TARGET       = 'SUN'
      FRAME_-44794000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M21_MEC           = -44794001
      FRAME_-44794001_NAME             = 'BEIDOU-3_M21_MEC'
      FRAME_-44794001_CLASS            =  4
      FRAME_-44794001_CLASS_ID         = -44794001
      FRAME_-44794001_CENTER           = -44794
      TKFRAME_-44794001_RELATIVE       = 'BEIDOU-3_M21_IGS'
      TKFRAME_-44794001_SPEC           = 'ANGLES'
      TKFRAME_-44794001_UNITS          = 'DEGREES'
      TKFRAME_-44794001_AXES           = (3, 2, 1)
      TKFRAME_-44794001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M22_IGS           = -44793000
      FRAME_-44793000_NAME             = 'BEIDOU-3_M22_IGS'
      FRAME_-44793000_CLASS            =  5
      FRAME_-44793000_CLASS_ID         = -44793000
      FRAME_-44793000_CENTER           = -44793
      FRAME_-44793000_RELATIVE         = 'J2000'
      FRAME_-44793000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44793000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44793000_PRI_AXIS         = 'Z'
      FRAME_-44793000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44793000_PRI_OBSERVER     = 'BEIDOU-3_M22'
      FRAME_-44793000_PRI_TARGET       = 'EARTH'
      FRAME_-44793000_PRI_ABCORR       = 'NONE'
      FRAME_-44793000_SEC_AXIS         = 'X'
      FRAME_-44793000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44793000_SEC_OBSERVER     = 'BEIDOU-3_M22'
      FRAME_-44793000_SEC_TARGET       = 'SUN'
      FRAME_-44793000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M22_MEC           = -44793001
      FRAME_-44793001_NAME             = 'BEIDOU-3_M22_MEC'
      FRAME_-44793001_CLASS            =  4
      FRAME_-44793001_CLASS_ID         = -44793001
      FRAME_-44793001_CENTER           = -44793
      TKFRAME_-44793001_RELATIVE       = 'BEIDOU-3_M22_IGS'
      TKFRAME_-44793001_SPEC           = 'ANGLES'
      TKFRAME_-44793001_UNITS          = 'DEGREES'
      TKFRAME_-44793001_AXES           = (3, 2, 1)
      TKFRAME_-44793001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M23_IGS           = -44543000
      FRAME_-44543000_NAME             = 'BEIDOU-3_M23_IGS'
      FRAME_-44543000_CLASS            =  5
      FRAME_-44543000_CLASS_ID         = -44543000
      FRAME_-44543000_CENTER           = -44543
      FRAME_-44543000_RELATIVE         = 'J2000'
      FRAME_-44543000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44543000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44543000_PRI_AXIS         = 'Z'
      FRAME_-44543000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44543000_PRI_OBSERVER     = 'BEIDOU-3_M23'
      FRAME_-44543000_PRI_TARGET       = 'EARTH'
      FRAME_-44543000_PRI_ABCORR       = 'NONE'
      FRAME_-44543000_SEC_AXIS         = 'X'
      FRAME_-44543000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44543000_SEC_OBSERVER     = 'BEIDOU-3_M23'
      FRAME_-44543000_SEC_TARGET       = 'SUN'
      FRAME_-44543000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M23_MEC           = -44543001
      FRAME_-44543001_NAME             = 'BEIDOU-3_M23_MEC'
      FRAME_-44543001_CLASS            =  4
      FRAME_-44543001_CLASS_ID         = -44543001
      FRAME_-44543001_CENTER           = -44543
      TKFRAME_-44543001_RELATIVE       = 'BEIDOU-3_M23_IGS'
      TKFRAME_-44543001_SPEC           = 'ANGLES'
      TKFRAME_-44543001_UNITS          = 'DEGREES'
      TKFRAME_-44543001_AXES           = (3, 2, 1)
      TKFRAME_-44543001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M24_IGS           = -44542000
      FRAME_-44542000_NAME             = 'BEIDOU-3_M24_IGS'
      FRAME_-44542000_CLASS            =  5
      FRAME_-44542000_CLASS_ID         = -44542000
      FRAME_-44542000_CENTER           = -44542
      FRAME_-44542000_RELATIVE         = 'J2000'
      FRAME_-44542000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44542000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44542000_PRI_AXIS         = 'Z'
      FRAME_-44542000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44542000_PRI_OBSERVER     = 'BEIDOU-3_M24'
      FRAME_-44542000_PRI_TARGET       = 'EARTH'
      FRAME_-44542000_PRI_ABCORR       = 'NONE'
      FRAME_-44542000_SEC_AXIS         = 'X'
      FRAME_-44542000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44542000_SEC_OBSERVER     = 'BEIDOU-3_M24'
      FRAME_-44542000_SEC_TARGET       = 'SUN'
      FRAME_-44542000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M24_MEC           = -44542001
      FRAME_-44542001_NAME             = 'BEIDOU-3_M24_MEC'
      FRAME_-44542001_CLASS            =  4
      FRAME_-44542001_CLASS_ID         = -44542001
      FRAME_-44542001_CENTER           = -44542
      TKFRAME_-44542001_RELATIVE       = 'BEIDOU-3_M24_IGS'
      TKFRAME_-44542001_SPEC           = 'ANGLES'
      TKFRAME_-44542001_UNITS          = 'DEGREES'
      TKFRAME_-44542001_AXES           = (3, 2, 1)
      TKFRAME_-44542001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M25_IGS           = -61186000
      FRAME_-61186000_NAME             = 'BEIDOU-3_M25_IGS'
      FRAME_-61186000_CLASS            =  5
      FRAME_-61186000_CLASS_ID         = -61186000
      FRAME_-61186000_CENTER           = -61186
      FRAME_-61186000_RELATIVE         = 'J2000'
      FRAME_-61186000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-61186000_FAMILY           = 'TWO-VECTOR'
      FRAME_-61186000_PRI_AXIS         = 'Z'
      FRAME_-61186000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61186000_PRI_OBSERVER     = 'BEIDOU-3_M25'
      FRAME_-61186000_PRI_TARGET       = 'EARTH'
      FRAME_-61186000_PRI_ABCORR       = 'NONE'
      FRAME_-61186000_SEC_AXIS         = 'X'
      FRAME_-61186000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61186000_SEC_OBSERVER     = 'BEIDOU-3_M25'
      FRAME_-61186000_SEC_TARGET       = 'SUN'
      FRAME_-61186000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M25_MEC           = -61186001
      FRAME_-61186001_NAME             = 'BEIDOU-3_M25_MEC'
      FRAME_-61186001_CLASS            =  4
      FRAME_-61186001_CLASS_ID         = -61186001
      FRAME_-61186001_CENTER           = -61186
      TKFRAME_-61186001_RELATIVE       = 'BEIDOU-3_M25_IGS'
      TKFRAME_-61186001_SPEC           = 'ANGLES'
      TKFRAME_-61186001_UNITS          = 'DEGREES'
      TKFRAME_-61186001_AXES           = (3, 2, 1)
      TKFRAME_-61186001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M26_IGS           = -58655000
      FRAME_-58655000_NAME             = 'BEIDOU-3_M26_IGS'
      FRAME_-58655000_CLASS            =  5
      FRAME_-58655000_CLASS_ID         = -58655000
      FRAME_-58655000_CENTER           = -58655
      FRAME_-58655000_RELATIVE         = 'J2000'
      FRAME_-58655000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-58655000_FAMILY           = 'TWO-VECTOR'
      FRAME_-58655000_PRI_AXIS         = 'Z'
      FRAME_-58655000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-58655000_PRI_OBSERVER     = 'BEIDOU-3_M26'
      FRAME_-58655000_PRI_TARGET       = 'EARTH'
      FRAME_-58655000_PRI_ABCORR       = 'NONE'
      FRAME_-58655000_SEC_AXIS         = 'X'
      FRAME_-58655000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-58655000_SEC_OBSERVER     = 'BEIDOU-3_M26'
      FRAME_-58655000_SEC_TARGET       = 'SUN'
      FRAME_-58655000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M26_MEC           = -58655001
      FRAME_-58655001_NAME             = 'BEIDOU-3_M26_MEC'
      FRAME_-58655001_CLASS            =  4
      FRAME_-58655001_CLASS_ID         = -58655001
      FRAME_-58655001_CENTER           = -58655
      TKFRAME_-58655001_RELATIVE       = 'BEIDOU-3_M26_IGS'
      TKFRAME_-58655001_SPEC           = 'ANGLES'
      TKFRAME_-58655001_UNITS          = 'DEGREES'
      TKFRAME_-58655001_AXES           = (3, 2, 1)
      TKFRAME_-58655001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M27_IGS           = -61187000
      FRAME_-61187000_NAME             = 'BEIDOU-3_M27_IGS'
      FRAME_-61187000_CLASS            =  5
      FRAME_-61187000_CLASS_ID         = -61187000
      FRAME_-61187000_CENTER           = -61187
      FRAME_-61187000_RELATIVE         = 'J2000'
      FRAME_-61187000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-61187000_FAMILY           = 'TWO-VECTOR'
      FRAME_-61187000_PRI_AXIS         = 'Z'
      FRAME_-61187000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61187000_PRI_OBSERVER     = 'BEIDOU-3_M27'
      FRAME_-61187000_PRI_TARGET       = 'EARTH'
      FRAME_-61187000_PRI_ABCORR       = 'NONE'
      FRAME_-61187000_SEC_AXIS         = 'X'
      FRAME_-61187000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-61187000_SEC_OBSERVER     = 'BEIDOU-3_M27'
      FRAME_-61187000_SEC_TARGET       = 'SUN'
      FRAME_-61187000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M27_MEC           = -61187001
      FRAME_-61187001_NAME             = 'BEIDOU-3_M27_MEC'
      FRAME_-61187001_CLASS            =  4
      FRAME_-61187001_CLASS_ID         = -61187001
      FRAME_-61187001_CENTER           = -61187
      TKFRAME_-61187001_RELATIVE       = 'BEIDOU-3_M27_IGS'
      TKFRAME_-61187001_SPEC           = 'ANGLES'
      TKFRAME_-61187001_UNITS          = 'DEGREES'
      TKFRAME_-61187001_AXES           = (3, 2, 1)
      TKFRAME_-61187001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M28_IGS           = -58654000
      FRAME_-58654000_NAME             = 'BEIDOU-3_M28_IGS'
      FRAME_-58654000_CLASS            =  5
      FRAME_-58654000_CLASS_ID         = -58654000
      FRAME_-58654000_CENTER           = -58654
      FRAME_-58654000_RELATIVE         = 'J2000'
      FRAME_-58654000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-58654000_FAMILY           = 'TWO-VECTOR'
      FRAME_-58654000_PRI_AXIS         = 'Z'
      FRAME_-58654000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-58654000_PRI_OBSERVER     = 'BEIDOU-3_M28'
      FRAME_-58654000_PRI_TARGET       = 'EARTH'
      FRAME_-58654000_PRI_ABCORR       = 'NONE'
      FRAME_-58654000_SEC_AXIS         = 'X'
      FRAME_-58654000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-58654000_SEC_OBSERVER     = 'BEIDOU-3_M28'
      FRAME_-58654000_SEC_TARGET       = 'SUN'
      FRAME_-58654000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M28_MEC           = -58654001
      FRAME_-58654001_NAME             = 'BEIDOU-3_M28_MEC'
      FRAME_-58654001_CLASS            =  4
      FRAME_-58654001_CLASS_ID         = -58654001
      FRAME_-58654001_CENTER           = -58654
      TKFRAME_-58654001_RELATIVE       = 'BEIDOU-3_M28_IGS'
      TKFRAME_-58654001_SPEC           = 'ANGLES'
      TKFRAME_-58654001_UNITS          = 'DEGREES'
      TKFRAME_-58654001_AXES           = (3, 2, 1)
      TKFRAME_-58654001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M3_IGS            = -43208000
      FRAME_-43208000_NAME             = 'BEIDOU-3_M3_IGS'
      FRAME_-43208000_CLASS            =  5
      FRAME_-43208000_CLASS_ID         = -43208000
      FRAME_-43208000_CENTER           = -43208
      FRAME_-43208000_RELATIVE         = 'J2000'
      FRAME_-43208000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43208000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43208000_PRI_AXIS         = 'Z'
      FRAME_-43208000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43208000_PRI_OBSERVER     = 'BEIDOU-3_M3'
      FRAME_-43208000_PRI_TARGET       = 'EARTH'
      FRAME_-43208000_PRI_ABCORR       = 'NONE'
      FRAME_-43208000_SEC_AXIS         = 'X'
      FRAME_-43208000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43208000_SEC_OBSERVER     = 'BEIDOU-3_M3'
      FRAME_-43208000_SEC_TARGET       = 'SUN'
      FRAME_-43208000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M3_MEC            = -43208001
      FRAME_-43208001_NAME             = 'BEIDOU-3_M3_MEC'
      FRAME_-43208001_CLASS            =  4
      FRAME_-43208001_CLASS_ID         = -43208001
      FRAME_-43208001_CENTER           = -43208
      TKFRAME_-43208001_RELATIVE       = 'BEIDOU-3_M3_IGS'
      TKFRAME_-43208001_SPEC           = 'ANGLES'
      TKFRAME_-43208001_UNITS          = 'DEGREES'
      TKFRAME_-43208001_AXES           = (3, 2, 1)
      TKFRAME_-43208001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M4_IGS            = -43207000
      FRAME_-43207000_NAME             = 'BEIDOU-3_M4_IGS'
      FRAME_-43207000_CLASS            =  5
      FRAME_-43207000_CLASS_ID         = -43207000
      FRAME_-43207000_CENTER           = -43207
      FRAME_-43207000_RELATIVE         = 'J2000'
      FRAME_-43207000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43207000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43207000_PRI_AXIS         = 'Z'
      FRAME_-43207000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43207000_PRI_OBSERVER     = 'BEIDOU-3_M4'
      FRAME_-43207000_PRI_TARGET       = 'EARTH'
      FRAME_-43207000_PRI_ABCORR       = 'NONE'
      FRAME_-43207000_SEC_AXIS         = 'X'
      FRAME_-43207000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43207000_SEC_OBSERVER     = 'BEIDOU-3_M4'
      FRAME_-43207000_SEC_TARGET       = 'SUN'
      FRAME_-43207000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M4_MEC            = -43207001
      FRAME_-43207001_NAME             = 'BEIDOU-3_M4_MEC'
      FRAME_-43207001_CLASS            =  4
      FRAME_-43207001_CLASS_ID         = -43207001
      FRAME_-43207001_CENTER           = -43207
      TKFRAME_-43207001_RELATIVE       = 'BEIDOU-3_M4_IGS'
      TKFRAME_-43207001_SPEC           = 'ANGLES'
      TKFRAME_-43207001_UNITS          = 'DEGREES'
      TKFRAME_-43207001_AXES           = (3, 2, 1)
      TKFRAME_-43207001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M5_IGS            = -43581000
      FRAME_-43581000_NAME             = 'BEIDOU-3_M5_IGS'
      FRAME_-43581000_CLASS            =  5
      FRAME_-43581000_CLASS_ID         = -43581000
      FRAME_-43581000_CENTER           = -43581
      FRAME_-43581000_RELATIVE         = 'J2000'
      FRAME_-43581000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43581000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43581000_PRI_AXIS         = 'Z'
      FRAME_-43581000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43581000_PRI_OBSERVER     = 'BEIDOU-3_M5'
      FRAME_-43581000_PRI_TARGET       = 'EARTH'
      FRAME_-43581000_PRI_ABCORR       = 'NONE'
      FRAME_-43581000_SEC_AXIS         = 'X'
      FRAME_-43581000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43581000_SEC_OBSERVER     = 'BEIDOU-3_M5'
      FRAME_-43581000_SEC_TARGET       = 'SUN'
      FRAME_-43581000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M5_MEC            = -43581001
      FRAME_-43581001_NAME             = 'BEIDOU-3_M5_MEC'
      FRAME_-43581001_CLASS            =  4
      FRAME_-43581001_CLASS_ID         = -43581001
      FRAME_-43581001_CENTER           = -43581
      TKFRAME_-43581001_RELATIVE       = 'BEIDOU-3_M5_IGS'
      TKFRAME_-43581001_SPEC           = 'ANGLES'
      TKFRAME_-43581001_UNITS          = 'DEGREES'
      TKFRAME_-43581001_AXES           = (3, 2, 1)
      TKFRAME_-43581001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M6_IGS            = -43582000
      FRAME_-43582000_NAME             = 'BEIDOU-3_M6_IGS'
      FRAME_-43582000_CLASS            =  5
      FRAME_-43582000_CLASS_ID         = -43582000
      FRAME_-43582000_CENTER           = -43582
      FRAME_-43582000_RELATIVE         = 'J2000'
      FRAME_-43582000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43582000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43582000_PRI_AXIS         = 'Z'
      FRAME_-43582000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43582000_PRI_OBSERVER     = 'BEIDOU-3_M6'
      FRAME_-43582000_PRI_TARGET       = 'EARTH'
      FRAME_-43582000_PRI_ABCORR       = 'NONE'
      FRAME_-43582000_SEC_AXIS         = 'X'
      FRAME_-43582000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43582000_SEC_OBSERVER     = 'BEIDOU-3_M6'
      FRAME_-43582000_SEC_TARGET       = 'SUN'
      FRAME_-43582000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M6_MEC            = -43582001
      FRAME_-43582001_NAME             = 'BEIDOU-3_M6_MEC'
      FRAME_-43582001_CLASS            =  4
      FRAME_-43582001_CLASS_ID         = -43582001
      FRAME_-43582001_CENTER           = -43582
      TKFRAME_-43582001_RELATIVE       = 'BEIDOU-3_M6_IGS'
      TKFRAME_-43582001_SPEC           = 'ANGLES'
      TKFRAME_-43582001_UNITS          = 'DEGREES'
      TKFRAME_-43582001_AXES           = (3, 2, 1)
      TKFRAME_-43582001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M7_IGS            = -43107000
      FRAME_-43107000_NAME             = 'BEIDOU-3_M7_IGS'
      FRAME_-43107000_CLASS            =  5
      FRAME_-43107000_CLASS_ID         = -43107000
      FRAME_-43107000_CENTER           = -43107
      FRAME_-43107000_RELATIVE         = 'J2000'
      FRAME_-43107000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43107000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43107000_PRI_AXIS         = 'Z'
      FRAME_-43107000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43107000_PRI_OBSERVER     = 'BEIDOU-3_M7'
      FRAME_-43107000_PRI_TARGET       = 'EARTH'
      FRAME_-43107000_PRI_ABCORR       = 'NONE'
      FRAME_-43107000_SEC_AXIS         = 'X'
      FRAME_-43107000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43107000_SEC_OBSERVER     = 'BEIDOU-3_M7'
      FRAME_-43107000_SEC_TARGET       = 'SUN'
      FRAME_-43107000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M7_MEC            = -43107001
      FRAME_-43107001_NAME             = 'BEIDOU-3_M7_MEC'
      FRAME_-43107001_CLASS            =  4
      FRAME_-43107001_CLASS_ID         = -43107001
      FRAME_-43107001_CENTER           = -43107
      TKFRAME_-43107001_RELATIVE       = 'BEIDOU-3_M7_IGS'
      TKFRAME_-43107001_SPEC           = 'ANGLES'
      TKFRAME_-43107001_UNITS          = 'DEGREES'
      TKFRAME_-43107001_AXES           = (3, 2, 1)
      TKFRAME_-43107001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M8_IGS            = -43108000
      FRAME_-43108000_NAME             = 'BEIDOU-3_M8_IGS'
      FRAME_-43108000_CLASS            =  5
      FRAME_-43108000_CLASS_ID         = -43108000
      FRAME_-43108000_CENTER           = -43108
      FRAME_-43108000_RELATIVE         = 'J2000'
      FRAME_-43108000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43108000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43108000_PRI_AXIS         = 'Z'
      FRAME_-43108000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43108000_PRI_OBSERVER     = 'BEIDOU-3_M8'
      FRAME_-43108000_PRI_TARGET       = 'EARTH'
      FRAME_-43108000_PRI_ABCORR       = 'NONE'
      FRAME_-43108000_SEC_AXIS         = 'X'
      FRAME_-43108000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43108000_SEC_OBSERVER     = 'BEIDOU-3_M8'
      FRAME_-43108000_SEC_TARGET       = 'SUN'
      FRAME_-43108000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M8_MEC            = -43108001
      FRAME_-43108001_NAME             = 'BEIDOU-3_M8_MEC'
      FRAME_-43108001_CLASS            =  4
      FRAME_-43108001_CLASS_ID         = -43108001
      FRAME_-43108001_CENTER           = -43108
      TKFRAME_-43108001_RELATIVE       = 'BEIDOU-3_M8_IGS'
      TKFRAME_-43108001_SPEC           = 'ANGLES'
      TKFRAME_-43108001_UNITS          = 'DEGREES'
      TKFRAME_-43108001_AXES           = (3, 2, 1)
      TKFRAME_-43108001_ANGLES         = (0, 0, 0)

      FRAME_BEIDOU-3_M9_IGS            = -43245000
      FRAME_-43245000_NAME             = 'BEIDOU-3_M9_IGS'
      FRAME_-43245000_CLASS            =  5
      FRAME_-43245000_CLASS_ID         = -43245000
      FRAME_-43245000_CENTER           = -43245
      FRAME_-43245000_RELATIVE         = 'J2000'
      FRAME_-43245000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43245000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43245000_PRI_AXIS         = 'Z'
      FRAME_-43245000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43245000_PRI_OBSERVER     = 'BEIDOU-3_M9'
      FRAME_-43245000_PRI_TARGET       = 'EARTH'
      FRAME_-43245000_PRI_ABCORR       = 'NONE'
      FRAME_-43245000_SEC_AXIS         = 'X'
      FRAME_-43245000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43245000_SEC_OBSERVER     = 'BEIDOU-3_M9'
      FRAME_-43245000_SEC_TARGET       = 'SUN'
      FRAME_-43245000_SEC_ABCORR       = 'NONE'

      FRAME_BEIDOU-3_M9_MEC            = -43245001
      FRAME_-43245001_NAME             = 'BEIDOU-3_M9_MEC'
      FRAME_-43245001_CLASS            =  4
      FRAME_-43245001_CLASS_ID         = -43245001
      FRAME_-43245001_CENTER           = -43245
      TKFRAME_-43245001_RELATIVE       = 'BEIDOU-3_M9_IGS'
      TKFRAME_-43245001_SPEC           = 'ANGLES'
      TKFRAME_-43245001_UNITS          = 'DEGREES'
      TKFRAME_-43245001_AXES           = (3, 2, 1)
      TKFRAME_-43245001_ANGLES         = (0, 0, 0)



      FRAME_ASTRA_5B_IGS               = -39617000
      FRAME_-39617000_NAME             = 'ASTRA_5B_IGS'
      FRAME_-39617000_CLASS            =  5
      FRAME_-39617000_CLASS_ID         = -39617000
      FRAME_-39617000_CENTER           = -39617
      FRAME_-39617000_RELATIVE         = 'J2000'
      FRAME_-39617000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39617000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39617000_PRI_AXIS         = 'Z'
      FRAME_-39617000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39617000_PRI_OBSERVER     = 'ASTRA_5B'
      FRAME_-39617000_PRI_TARGET       = 'EARTH'
      FRAME_-39617000_PRI_ABCORR       = 'NONE'
      FRAME_-39617000_SEC_AXIS         = 'X'
      FRAME_-39617000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39617000_SEC_OBSERVER     = 'ASTRA_5B'
      FRAME_-39617000_SEC_TARGET       = 'SUN'
      FRAME_-39617000_SEC_ABCORR       = 'NONE'

      FRAME_CRE_IGS                    = -28868000
      FRAME_-28868000_NAME             = 'CRE_IGS'
      FRAME_-28868000_CLASS            =  5
      FRAME_-28868000_CLASS_ID         = -28868000
      FRAME_-28868000_CENTER           = -28868
      FRAME_-28868000_RELATIVE         = 'J2000'
      FRAME_-28868000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28868000_FAMILY           = 'TWO-VECTOR'
      FRAME_-28868000_PRI_AXIS         = 'Z'
      FRAME_-28868000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28868000_PRI_OBSERVER     = 'CRE'
      FRAME_-28868000_PRI_TARGET       = 'EARTH'
      FRAME_-28868000_PRI_ABCORR       = 'NONE'
      FRAME_-28868000_SEC_AXIS         = 'X'
      FRAME_-28868000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28868000_SEC_OBSERVER     = 'CRE'
      FRAME_-28868000_SEC_TARGET       = 'SUN'
      FRAME_-28868000_SEC_ABCORR       = 'NONE'

      FRAME_EUTELSAT_117_WEST_B_IGS    = -41589000
      FRAME_-41589000_NAME             = 'EUTELSAT_117_WEST_B_IGS'
      FRAME_-41589000_CLASS            =  5
      FRAME_-41589000_CLASS_ID         = -41589000
      FRAME_-41589000_CENTER           = -41589
      FRAME_-41589000_RELATIVE         = 'J2000'
      FRAME_-41589000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41589000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41589000_PRI_AXIS         = 'Z'
      FRAME_-41589000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41589000_PRI_OBSERVER     = 'EUTELSAT_117_WEST_B'
      FRAME_-41589000_PRI_TARGET       = 'EARTH'
      FRAME_-41589000_PRI_ABCORR       = 'NONE'
      FRAME_-41589000_SEC_AXIS         = 'X'
      FRAME_-41589000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41589000_SEC_OBSERVER     = 'EUTELSAT_117_WEST_B'
      FRAME_-41589000_SEC_TARGET       = 'SUN'
      FRAME_-41589000_SEC_ABCORR       = 'NONE'

      FRAME_EUTELSAT_5_WEST_B_IGS      = -44624000
      FRAME_-44624000_NAME             = 'EUTELSAT_5_WEST_B_IGS'
      FRAME_-44624000_CLASS            =  5
      FRAME_-44624000_CLASS_ID         = -44624000
      FRAME_-44624000_CENTER           = -44624
      FRAME_-44624000_RELATIVE         = 'J2000'
      FRAME_-44624000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-44624000_FAMILY           = 'TWO-VECTOR'
      FRAME_-44624000_PRI_AXIS         = 'Z'
      FRAME_-44624000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44624000_PRI_OBSERVER     = 'EUTELSAT_5_WEST_B'
      FRAME_-44624000_PRI_TARGET       = 'EARTH'
      FRAME_-44624000_PRI_ABCORR       = 'NONE'
      FRAME_-44624000_SEC_AXIS         = 'X'
      FRAME_-44624000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-44624000_SEC_OBSERVER     = 'EUTELSAT_5_WEST_B'
      FRAME_-44624000_SEC_TARGET       = 'SUN'
      FRAME_-44624000_SEC_ABCORR       = 'NONE'

      FRAME_GALAXY_30_IGS              = -46114000
      FRAME_-46114000_NAME             = 'GALAXY_30_IGS'
      FRAME_-46114000_CLASS            =  5
      FRAME_-46114000_CLASS_ID         = -46114000
      FRAME_-46114000_CENTER           = -46114
      FRAME_-46114000_RELATIVE         = 'J2000'
      FRAME_-46114000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-46114000_FAMILY           = 'TWO-VECTOR'
      FRAME_-46114000_PRI_AXIS         = 'Z'
      FRAME_-46114000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46114000_PRI_OBSERVER     = 'GALAXY_30'
      FRAME_-46114000_PRI_TARGET       = 'EARTH'
      FRAME_-46114000_PRI_ABCORR       = 'NONE'
      FRAME_-46114000_SEC_AXIS         = 'X'
      FRAME_-46114000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-46114000_SEC_OBSERVER     = 'GALAXY_30'
      FRAME_-46114000_SEC_TARGET       = 'SUN'
      FRAME_-46114000_SEC_ABCORR       = 'NONE'

      FRAME_INMARSAT_4-F2_IGS          = -28899000
      FRAME_-28899000_NAME             = 'INMARSAT_4-F2_IGS'
      FRAME_-28899000_CLASS            =  5
      FRAME_-28899000_CLASS_ID         = -28899000
      FRAME_-28899000_CENTER           = -28899
      FRAME_-28899000_RELATIVE         = 'J2000'
      FRAME_-28899000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28899000_FAMILY           = 'TWO-VECTOR'
      FRAME_-28899000_PRI_AXIS         = 'Z'
      FRAME_-28899000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28899000_PRI_OBSERVER     = 'INMARSAT_4-F2'
      FRAME_-28899000_PRI_TARGET       = 'EARTH'
      FRAME_-28899000_PRI_ABCORR       = 'NONE'
      FRAME_-28899000_SEC_AXIS         = 'X'
      FRAME_-28899000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28899000_SEC_OBSERVER     = 'INMARSAT_4-F2'
      FRAME_-28899000_SEC_TARGET       = 'SUN'
      FRAME_-28899000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1A_IGS               = -39199000
      FRAME_-39199000_NAME             = 'IRNSS-1A_IGS'
      FRAME_-39199000_CLASS            =  5
      FRAME_-39199000_CLASS_ID         = -39199000
      FRAME_-39199000_CENTER           = -39199
      FRAME_-39199000_RELATIVE         = 'J2000'
      FRAME_-39199000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39199000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39199000_PRI_AXIS         = 'Z'
      FRAME_-39199000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39199000_PRI_OBSERVER     = 'IRNSS-1A'
      FRAME_-39199000_PRI_TARGET       = 'EARTH'
      FRAME_-39199000_PRI_ABCORR       = 'NONE'
      FRAME_-39199000_SEC_AXIS         = 'X'
      FRAME_-39199000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39199000_SEC_OBSERVER     = 'IRNSS-1A'
      FRAME_-39199000_SEC_TARGET       = 'SUN'
      FRAME_-39199000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1A_MEC               = -39199001
      FRAME_-39199001_NAME             = 'IRNSS-1A_MEC'
      FRAME_-39199001_CLASS            =  4
      FRAME_-39199001_CLASS_ID         = -39199001
      FRAME_-39199001_CENTER           = -39199
      TKFRAME_-39199001_RELATIVE       = 'IRNSS-1A_IGS'
      TKFRAME_-39199001_SPEC           = 'ANGLES'
      TKFRAME_-39199001_UNITS          = 'DEGREES'
      TKFRAME_-39199001_AXES           = (  2,   1, 3)
      TKFRAME_-39199001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1B_IGS               = -39635000
      FRAME_-39635000_NAME             = 'IRNSS-1B_IGS'
      FRAME_-39635000_CLASS            =  5
      FRAME_-39635000_CLASS_ID         = -39635000
      FRAME_-39635000_CENTER           = -39635
      FRAME_-39635000_RELATIVE         = 'J2000'
      FRAME_-39635000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39635000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39635000_PRI_AXIS         = 'Z'
      FRAME_-39635000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39635000_PRI_OBSERVER     = 'IRNSS-1B'
      FRAME_-39635000_PRI_TARGET       = 'EARTH'
      FRAME_-39635000_PRI_ABCORR       = 'NONE'
      FRAME_-39635000_SEC_AXIS         = 'X'
      FRAME_-39635000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39635000_SEC_OBSERVER     = 'IRNSS-1B'
      FRAME_-39635000_SEC_TARGET       = 'SUN'
      FRAME_-39635000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1B_MEC               = -39635001
      FRAME_-39635001_NAME             = 'IRNSS-1B_MEC'
      FRAME_-39635001_CLASS            =  4
      FRAME_-39635001_CLASS_ID         = -39635001
      FRAME_-39635001_CENTER           = -39635
      TKFRAME_-39635001_RELATIVE       = 'IRNSS-1B_IGS'
      TKFRAME_-39635001_SPEC           = 'ANGLES'
      TKFRAME_-39635001_UNITS          = 'DEGREES'
      TKFRAME_-39635001_AXES           = (  2,   1, 3)
      TKFRAME_-39635001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1C_IGS               = -40269000
      FRAME_-40269000_NAME             = 'IRNSS-1C_IGS'
      FRAME_-40269000_CLASS            =  5
      FRAME_-40269000_CLASS_ID         = -40269000
      FRAME_-40269000_CENTER           = -40269
      FRAME_-40269000_RELATIVE         = 'J2000'
      FRAME_-40269000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40269000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40269000_PRI_AXIS         = 'Z'
      FRAME_-40269000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40269000_PRI_OBSERVER     = 'IRNSS-1C'
      FRAME_-40269000_PRI_TARGET       = 'EARTH'
      FRAME_-40269000_PRI_ABCORR       = 'NONE'
      FRAME_-40269000_SEC_AXIS         = 'X'
      FRAME_-40269000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40269000_SEC_OBSERVER     = 'IRNSS-1C'
      FRAME_-40269000_SEC_TARGET       = 'SUN'
      FRAME_-40269000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1C_MEC               = -40269001
      FRAME_-40269001_NAME             = 'IRNSS-1C_MEC'
      FRAME_-40269001_CLASS            =  4
      FRAME_-40269001_CLASS_ID         = -40269001
      FRAME_-40269001_CENTER           = -40269
      TKFRAME_-40269001_RELATIVE       = 'IRNSS-1C_IGS'
      TKFRAME_-40269001_SPEC           = 'ANGLES'
      TKFRAME_-40269001_UNITS          = 'DEGREES'
      TKFRAME_-40269001_AXES           = (  2,   1, 3)
      TKFRAME_-40269001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1D_IGS               = -40547000
      FRAME_-40547000_NAME             = 'IRNSS-1D_IGS'
      FRAME_-40547000_CLASS            =  5
      FRAME_-40547000_CLASS_ID         = -40547000
      FRAME_-40547000_CENTER           = -40547
      FRAME_-40547000_RELATIVE         = 'J2000'
      FRAME_-40547000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-40547000_FAMILY           = 'TWO-VECTOR'
      FRAME_-40547000_PRI_AXIS         = 'Z'
      FRAME_-40547000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40547000_PRI_OBSERVER     = 'IRNSS-1D'
      FRAME_-40547000_PRI_TARGET       = 'EARTH'
      FRAME_-40547000_PRI_ABCORR       = 'NONE'
      FRAME_-40547000_SEC_AXIS         = 'X'
      FRAME_-40547000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-40547000_SEC_OBSERVER     = 'IRNSS-1D'
      FRAME_-40547000_SEC_TARGET       = 'SUN'
      FRAME_-40547000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1D_MEC               = -40547001
      FRAME_-40547001_NAME             = 'IRNSS-1D_MEC'
      FRAME_-40547001_CLASS            =  4
      FRAME_-40547001_CLASS_ID         = -40547001
      FRAME_-40547001_CENTER           = -40547
      TKFRAME_-40547001_RELATIVE       = 'IRNSS-1D_IGS'
      TKFRAME_-40547001_SPEC           = 'ANGLES'
      TKFRAME_-40547001_UNITS          = 'DEGREES'
      TKFRAME_-40547001_AXES           = (  2,   1, 3)
      TKFRAME_-40547001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1E_IGS               = -41241000
      FRAME_-41241000_NAME             = 'IRNSS-1E_IGS'
      FRAME_-41241000_CLASS            =  5
      FRAME_-41241000_CLASS_ID         = -41241000
      FRAME_-41241000_CENTER           = -41241
      FRAME_-41241000_RELATIVE         = 'J2000'
      FRAME_-41241000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41241000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41241000_PRI_AXIS         = 'Z'
      FRAME_-41241000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41241000_PRI_OBSERVER     = 'IRNSS-1E'
      FRAME_-41241000_PRI_TARGET       = 'EARTH'
      FRAME_-41241000_PRI_ABCORR       = 'NONE'
      FRAME_-41241000_SEC_AXIS         = 'X'
      FRAME_-41241000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41241000_SEC_OBSERVER     = 'IRNSS-1E'
      FRAME_-41241000_SEC_TARGET       = 'SUN'
      FRAME_-41241000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1E_MEC               = -41241001
      FRAME_-41241001_NAME             = 'IRNSS-1E_MEC'
      FRAME_-41241001_CLASS            =  4
      FRAME_-41241001_CLASS_ID         = -41241001
      FRAME_-41241001_CENTER           = -41241
      TKFRAME_-41241001_RELATIVE       = 'IRNSS-1E_IGS'
      TKFRAME_-41241001_SPEC           = 'ANGLES'
      TKFRAME_-41241001_UNITS          = 'DEGREES'
      TKFRAME_-41241001_AXES           = (  2,   1, 3)
      TKFRAME_-41241001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1F_IGS               = -41384000
      FRAME_-41384000_NAME             = 'IRNSS-1F_IGS'
      FRAME_-41384000_CLASS            =  5
      FRAME_-41384000_CLASS_ID         = -41384000
      FRAME_-41384000_CENTER           = -41384
      FRAME_-41384000_RELATIVE         = 'J2000'
      FRAME_-41384000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41384000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41384000_PRI_AXIS         = 'Z'
      FRAME_-41384000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41384000_PRI_OBSERVER     = 'IRNSS-1F'
      FRAME_-41384000_PRI_TARGET       = 'EARTH'
      FRAME_-41384000_PRI_ABCORR       = 'NONE'
      FRAME_-41384000_SEC_AXIS         = 'X'
      FRAME_-41384000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41384000_SEC_OBSERVER     = 'IRNSS-1F'
      FRAME_-41384000_SEC_TARGET       = 'SUN'
      FRAME_-41384000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1F_MEC               = -41384001
      FRAME_-41384001_NAME             = 'IRNSS-1F_MEC'
      FRAME_-41384001_CLASS            =  4
      FRAME_-41384001_CLASS_ID         = -41384001
      FRAME_-41384001_CENTER           = -41384
      TKFRAME_-41384001_RELATIVE       = 'IRNSS-1F_IGS'
      TKFRAME_-41384001_SPEC           = 'ANGLES'
      TKFRAME_-41384001_UNITS          = 'DEGREES'
      TKFRAME_-41384001_AXES           = (  2,   1, 3)
      TKFRAME_-41384001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1G_IGS               = -41469000
      FRAME_-41469000_NAME             = 'IRNSS-1G_IGS'
      FRAME_-41469000_CLASS            =  5
      FRAME_-41469000_CLASS_ID         = -41469000
      FRAME_-41469000_CENTER           = -41469
      FRAME_-41469000_RELATIVE         = 'J2000'
      FRAME_-41469000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-41469000_FAMILY           = 'TWO-VECTOR'
      FRAME_-41469000_PRI_AXIS         = 'Z'
      FRAME_-41469000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41469000_PRI_OBSERVER     = 'IRNSS-1G'
      FRAME_-41469000_PRI_TARGET       = 'EARTH'
      FRAME_-41469000_PRI_ABCORR       = 'NONE'
      FRAME_-41469000_SEC_AXIS         = 'X'
      FRAME_-41469000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-41469000_SEC_OBSERVER     = 'IRNSS-1G'
      FRAME_-41469000_SEC_TARGET       = 'SUN'
      FRAME_-41469000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1G_MEC               = -41469001
      FRAME_-41469001_NAME             = 'IRNSS-1G_MEC'
      FRAME_-41469001_CLASS            =  4
      FRAME_-41469001_CLASS_ID         = -41469001
      FRAME_-41469001_CENTER           = -41469
      TKFRAME_-41469001_RELATIVE       = 'IRNSS-1G_IGS'
      TKFRAME_-41469001_SPEC           = 'ANGLES'
      TKFRAME_-41469001_UNITS          = 'DEGREES'
      TKFRAME_-41469001_AXES           = (  2,   1, 3)
      TKFRAME_-41469001_ANGLES         = ( 90, -90, 0)

      FRAME_IRNSS-1I_IGS               = -43286000
      FRAME_-43286000_NAME             = 'IRNSS-1I_IGS'
      FRAME_-43286000_CLASS            =  5
      FRAME_-43286000_CLASS_ID         = -43286000
      FRAME_-43286000_CENTER           = -43286
      FRAME_-43286000_RELATIVE         = 'J2000'
      FRAME_-43286000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-43286000_FAMILY           = 'TWO-VECTOR'
      FRAME_-43286000_PRI_AXIS         = 'Z'
      FRAME_-43286000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43286000_PRI_OBSERVER     = 'IRNSS-1I'
      FRAME_-43286000_PRI_TARGET       = 'EARTH'
      FRAME_-43286000_PRI_ABCORR       = 'NONE'
      FRAME_-43286000_SEC_AXIS         = 'X'
      FRAME_-43286000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-43286000_SEC_OBSERVER     = 'IRNSS-1I'
      FRAME_-43286000_SEC_TARGET       = 'SUN'
      FRAME_-43286000_SEC_ABCORR       = 'NONE'

      FRAME_IRNSS-1I_MEC               = -43286001
      FRAME_-43286001_NAME             = 'IRNSS-1I_MEC'
      FRAME_-43286001_CLASS            =  4
      FRAME_-43286001_CLASS_ID         = -43286001
      FRAME_-43286001_CENTER           = -43286
      TKFRAME_-43286001_RELATIVE       = 'IRNSS-1I_IGS'
      TKFRAME_-43286001_SPEC           = 'ANGLES'
      TKFRAME_-43286001_UNITS          = 'DEGREES'
      TKFRAME_-43286001_AXES           = (  2,   1, 3)
      TKFRAME_-43286001_ANGLES         = ( 90, -90, 0)

      FRAME_LUCH_5A_IGS                = -37951000
      FRAME_-37951000_NAME             = 'LUCH_5A_IGS'
      FRAME_-37951000_CLASS            =  5
      FRAME_-37951000_CLASS_ID         = -37951000
      FRAME_-37951000_CENTER           = -37951
      FRAME_-37951000_RELATIVE         = 'J2000'
      FRAME_-37951000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37951000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37951000_PRI_AXIS         = 'Z'
      FRAME_-37951000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37951000_PRI_OBSERVER     = 'LUCH_5A'
      FRAME_-37951000_PRI_TARGET       = 'EARTH'
      FRAME_-37951000_PRI_ABCORR       = 'NONE'
      FRAME_-37951000_SEC_AXIS         = 'X'
      FRAME_-37951000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37951000_SEC_OBSERVER     = 'LUCH_5A'
      FRAME_-37951000_SEC_TARGET       = 'SUN'
      FRAME_-37951000_SEC_ABCORR       = 'NONE'

      FRAME_LUCH_5B_IGS                = -38977000
      FRAME_-38977000_NAME             = 'LUCH_5B_IGS'
      FRAME_-38977000_CLASS            =  5
      FRAME_-38977000_CLASS_ID         = -38977000
      FRAME_-38977000_CENTER           = -38977
      FRAME_-38977000_RELATIVE         = 'J2000'
      FRAME_-38977000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38977000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38977000_PRI_AXIS         = 'Z'
      FRAME_-38977000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38977000_PRI_OBSERVER     = 'LUCH_5B'
      FRAME_-38977000_PRI_TARGET       = 'EARTH'
      FRAME_-38977000_PRI_ABCORR       = 'NONE'
      FRAME_-38977000_SEC_AXIS         = 'X'
      FRAME_-38977000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38977000_SEC_OBSERVER     = 'LUCH_5B'
      FRAME_-38977000_SEC_TARGET       = 'SUN'
      FRAME_-38977000_SEC_ABCORR       = 'NONE'

      FRAME_LUCH_5V_IGS                = -39727000
      FRAME_-39727000_NAME             = 'LUCH_5V_IGS'
      FRAME_-39727000_CLASS            =  5
      FRAME_-39727000_CLASS_ID         = -39727000
      FRAME_-39727000_CENTER           = -39727
      FRAME_-39727000_RELATIVE         = 'J2000'
      FRAME_-39727000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-39727000_FAMILY           = 'TWO-VECTOR'
      FRAME_-39727000_PRI_AXIS         = 'Z'
      FRAME_-39727000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39727000_PRI_OBSERVER     = 'LUCH_5V'
      FRAME_-39727000_PRI_TARGET       = 'EARTH'
      FRAME_-39727000_PRI_ABCORR       = 'NONE'
      FRAME_-39727000_SEC_AXIS         = 'X'
      FRAME_-39727000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-39727000_SEC_OBSERVER     = 'LUCH_5V'
      FRAME_-39727000_SEC_TARGET       = 'SUN'
      FRAME_-39727000_SEC_ABCORR       = 'NONE'

      FRAME_NVS-01_IGS                 = -56759000
      FRAME_-56759000_NAME             = 'NVS-01_IGS'
      FRAME_-56759000_CLASS            =  5
      FRAME_-56759000_CLASS_ID         = -56759000
      FRAME_-56759000_CENTER           = -56759
      FRAME_-56759000_RELATIVE         = 'J2000'
      FRAME_-56759000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-56759000_FAMILY           = 'TWO-VECTOR'
      FRAME_-56759000_PRI_AXIS         = 'Z'
      FRAME_-56759000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-56759000_PRI_OBSERVER     = 'NVS-01'
      FRAME_-56759000_PRI_TARGET       = 'EARTH'
      FRAME_-56759000_PRI_ABCORR       = 'NONE'
      FRAME_-56759000_SEC_AXIS         = 'X'
      FRAME_-56759000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-56759000_SEC_OBSERVER     = 'NVS-01'
      FRAME_-56759000_SEC_TARGET       = 'SUN'
      FRAME_-56759000_SEC_ABCORR       = 'NONE'

      FRAME_NVS-02_IGS                 = -62850000
      FRAME_-62850000_NAME             = 'NVS-02_IGS'
      FRAME_-62850000_CLASS            =  5
      FRAME_-62850000_CLASS_ID         = -62850000
      FRAME_-62850000_CENTER           = -62850
      FRAME_-62850000_RELATIVE         = 'J2000'
      FRAME_-62850000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-62850000_FAMILY           = 'TWO-VECTOR'
      FRAME_-62850000_PRI_AXIS         = 'Z'
      FRAME_-62850000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-62850000_PRI_OBSERVER     = 'NVS-02'
      FRAME_-62850000_PRI_TARGET       = 'EARTH'
      FRAME_-62850000_PRI_ABCORR       = 'NONE'
      FRAME_-62850000_SEC_AXIS         = 'X'
      FRAME_-62850000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-62850000_SEC_OBSERVER     = 'NVS-02'
      FRAME_-62850000_SEC_TARGET       = 'SUN'
      FRAME_-62850000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-1_IGS                  = -37158000
      FRAME_-37158000_NAME             = 'QZS-1_IGS'
      FRAME_-37158000_CLASS            =  5
      FRAME_-37158000_CLASS_ID         = -37158000
      FRAME_-37158000_CENTER           = -37158
      FRAME_-37158000_RELATIVE         = 'J2000'
      FRAME_-37158000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-37158000_FAMILY           = 'TWO-VECTOR'
      FRAME_-37158000_PRI_AXIS         = 'Z'
      FRAME_-37158000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37158000_PRI_OBSERVER     = 'QZS-1'
      FRAME_-37158000_PRI_TARGET       = 'EARTH'
      FRAME_-37158000_PRI_ABCORR       = 'NONE'
      FRAME_-37158000_SEC_AXIS         = 'X'
      FRAME_-37158000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-37158000_SEC_OBSERVER     = 'QZS-1'
      FRAME_-37158000_SEC_TARGET       = 'SUN'
      FRAME_-37158000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-1_MEC                  = -37158001
      FRAME_-37158001_NAME             = 'QZS-1_MEC'
      FRAME_-37158001_CLASS            =  4
      FRAME_-37158001_CLASS_ID         = -37158001
      FRAME_-37158001_CENTER           = -37158
      TKFRAME_-37158001_RELATIVE       = 'QZS-1_IGS'
      TKFRAME_-37158001_SPEC           = 'ANGLES'
      TKFRAME_-37158001_UNITS          = 'DEGREES'
      TKFRAME_-37158001_AXES           = (   3, 2, 1)
      TKFRAME_-37158001_ANGLES         = ( 180, 0, 0)

      FRAME_QZS-1R_IGS                 = -49336000
      FRAME_-49336000_NAME             = 'QZS-1R_IGS'
      FRAME_-49336000_CLASS            =  5
      FRAME_-49336000_CLASS_ID         = -49336000
      FRAME_-49336000_CENTER           = -49336
      FRAME_-49336000_RELATIVE         = 'J2000'
      FRAME_-49336000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-49336000_FAMILY           = 'TWO-VECTOR'
      FRAME_-49336000_PRI_AXIS         = 'Z'
      FRAME_-49336000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49336000_PRI_OBSERVER     = 'QZS-1R'
      FRAME_-49336000_PRI_TARGET       = 'EARTH'
      FRAME_-49336000_PRI_ABCORR       = 'NONE'
      FRAME_-49336000_SEC_AXIS         = 'X'
      FRAME_-49336000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-49336000_SEC_OBSERVER     = 'QZS-1R'
      FRAME_-49336000_SEC_TARGET       = 'SUN'
      FRAME_-49336000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-1R_MEC                 = -49336001
      FRAME_-49336001_NAME             = 'QZS-1R_MEC'
      FRAME_-49336001_CLASS            =  4
      FRAME_-49336001_CLASS_ID         = -49336001
      FRAME_-49336001_CENTER           = -49336
      TKFRAME_-49336001_RELATIVE       = 'QZS-1R_IGS'
      TKFRAME_-49336001_SPEC           = 'ANGLES'
      TKFRAME_-49336001_UNITS          = 'DEGREES'
      TKFRAME_-49336001_AXES           = (   3, 2, 1)
      TKFRAME_-49336001_ANGLES         = ( 180, 0, 0)

      FRAME_QZS-2_IGS                  = -42738000
      FRAME_-42738000_NAME             = 'QZS-2_IGS'
      FRAME_-42738000_CLASS            =  5
      FRAME_-42738000_CLASS_ID         = -42738000
      FRAME_-42738000_CENTER           = -42738
      FRAME_-42738000_RELATIVE         = 'J2000'
      FRAME_-42738000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-42738000_FAMILY           = 'TWO-VECTOR'
      FRAME_-42738000_PRI_AXIS         = 'Z'
      FRAME_-42738000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42738000_PRI_OBSERVER     = 'QZS-2'
      FRAME_-42738000_PRI_TARGET       = 'EARTH'
      FRAME_-42738000_PRI_ABCORR       = 'NONE'
      FRAME_-42738000_SEC_AXIS         = 'X'
      FRAME_-42738000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42738000_SEC_OBSERVER     = 'QZS-2'
      FRAME_-42738000_SEC_TARGET       = 'SUN'
      FRAME_-42738000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-2_MEC                  = -42738001
      FRAME_-42738001_NAME             = 'QZS-2_MEC'
      FRAME_-42738001_CLASS            =  4
      FRAME_-42738001_CLASS_ID         = -42738001
      FRAME_-42738001_CENTER           = -42738
      TKFRAME_-42738001_RELATIVE       = 'QZS-2_IGS'
      TKFRAME_-42738001_SPEC           = 'ANGLES'
      TKFRAME_-42738001_UNITS          = 'DEGREES'
      TKFRAME_-42738001_AXES           = (   3, 2, 1)
      TKFRAME_-42738001_ANGLES         = ( 180, 0, 0)

      FRAME_QZS-3_IGS                  = -42917000
      FRAME_-42917000_NAME             = 'QZS-3_IGS'
      FRAME_-42917000_CLASS            =  5
      FRAME_-42917000_CLASS_ID         = -42917000
      FRAME_-42917000_CENTER           = -42917
      FRAME_-42917000_RELATIVE         = 'J2000'
      FRAME_-42917000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-42917000_FAMILY           = 'TWO-VECTOR'
      FRAME_-42917000_PRI_AXIS         = 'Z'
      FRAME_-42917000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42917000_PRI_OBSERVER     = 'QZS-3'
      FRAME_-42917000_PRI_TARGET       = 'EARTH'
      FRAME_-42917000_PRI_ABCORR       = 'NONE'
      FRAME_-42917000_SEC_AXIS         = 'X'
      FRAME_-42917000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42917000_SEC_OBSERVER     = 'QZS-3'
      FRAME_-42917000_SEC_TARGET       = 'SUN'
      FRAME_-42917000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-3_MEC                  = -42917001
      FRAME_-42917001_NAME             = 'QZS-3_MEC'
      FRAME_-42917001_CLASS            =  4
      FRAME_-42917001_CLASS_ID         = -42917001
      FRAME_-42917001_CENTER           = -42917
      TKFRAME_-42917001_RELATIVE       = 'QZS-3_IGS'
      TKFRAME_-42917001_SPEC           = 'ANGLES'
      TKFRAME_-42917001_UNITS          = 'DEGREES'
      TKFRAME_-42917001_AXES           = (   3, 2, 1)
      TKFRAME_-42917001_ANGLES         = ( 180, 0, 0)

      FRAME_QZS-4_IGS                  = -42965000
      FRAME_-42965000_NAME             = 'QZS-4_IGS'
      FRAME_-42965000_CLASS            =  5
      FRAME_-42965000_CLASS_ID         = -42965000
      FRAME_-42965000_CENTER           = -42965
      FRAME_-42965000_RELATIVE         = 'J2000'
      FRAME_-42965000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-42965000_FAMILY           = 'TWO-VECTOR'
      FRAME_-42965000_PRI_AXIS         = 'Z'
      FRAME_-42965000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42965000_PRI_OBSERVER     = 'QZS-4'
      FRAME_-42965000_PRI_TARGET       = 'EARTH'
      FRAME_-42965000_PRI_ABCORR       = 'NONE'
      FRAME_-42965000_SEC_AXIS         = 'X'
      FRAME_-42965000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42965000_SEC_OBSERVER     = 'QZS-4'
      FRAME_-42965000_SEC_TARGET       = 'SUN'
      FRAME_-42965000_SEC_ABCORR       = 'NONE'

      FRAME_QZS-4_MEC                  = -42965001
      FRAME_-42965001_NAME             = 'QZS-4_MEC'
      FRAME_-42965001_CLASS            =  4
      FRAME_-42965001_CLASS_ID         = -42965001
      FRAME_-42965001_CENTER           = -42965
      TKFRAME_-42965001_RELATIVE       = 'QZS-4_IGS'
      TKFRAME_-42965001_SPEC           = 'ANGLES'
      TKFRAME_-42965001_UNITS          = 'DEGREES'
      TKFRAME_-42965001_AXES           = (   3, 2, 1)
      TKFRAME_-42965001_ANGLES         = ( 180, 0, 0)

      FRAME_SES-15_IGS                 = -42709000
      FRAME_-42709000_NAME             = 'SES-15_IGS'
      FRAME_-42709000_CLASS            =  5
      FRAME_-42709000_CLASS_ID         = -42709000
      FRAME_-42709000_CENTER           = -42709
      FRAME_-42709000_RELATIVE         = 'J2000'
      FRAME_-42709000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-42709000_FAMILY           = 'TWO-VECTOR'
      FRAME_-42709000_PRI_AXIS         = 'Z'
      FRAME_-42709000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42709000_PRI_OBSERVER     = 'SES-15'
      FRAME_-42709000_PRI_TARGET       = 'EARTH'
      FRAME_-42709000_PRI_ABCORR       = 'NONE'
      FRAME_-42709000_SEC_AXIS         = 'X'
      FRAME_-42709000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-42709000_SEC_OBSERVER     = 'SES-15'
      FRAME_-42709000_SEC_TARGET       = 'SUN'
      FRAME_-42709000_SEC_ABCORR       = 'NONE'

      FRAME_SES-5_IGS                  = -38652000
      FRAME_-38652000_NAME             = 'SES-5_IGS'
      FRAME_-38652000_CLASS            =  5
      FRAME_-38652000_CLASS_ID         = -38652000
      FRAME_-38652000_CENTER           = -38652
      FRAME_-38652000_RELATIVE         = 'J2000'
      FRAME_-38652000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-38652000_FAMILY           = 'TWO-VECTOR'
      FRAME_-38652000_PRI_AXIS         = 'Z'
      FRAME_-38652000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38652000_PRI_OBSERVER     = 'SES-5'
      FRAME_-38652000_PRI_TARGET       = 'EARTH'
      FRAME_-38652000_PRI_ABCORR       = 'NONE'
      FRAME_-38652000_SEC_AXIS         = 'X'
      FRAME_-38652000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-38652000_SEC_OBSERVER     = 'SES-5'
      FRAME_-38652000_SEC_TARGET       = 'SUN'
      FRAME_-38652000_SEC_ABCORR       = 'NONE'



   \begintext

GNSS NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the GNSS spacecrafts.
   Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  Spacecrafts:
  ----------------------------------------------------------------

      This table presents the GNSS Spacecrafts names.

      ---------------------  -------  ------------------  -------------------
      Name                   ID       Synonyms            Type
      ---------------------  -------  ------------------  -------------------

      Galileo:
      --------
      GSAT-10                -38779   GAGAN_PRN_128
      GSAT-15                -41028   GAGAN_PRN_139
      GSAT-8                 -37605   GAGAN_PRN_127
      GSAT0101               -37846   GALILEO-PFM         Galileo IOV
      GSAT0102               -37847   GALILEO-FM2         Galileo IOV
      GSAT0103               -38857   GALILEO-FM3         Galileo IOV
      GSAT0104               -38858   GALILEO-FM4         Galileo IOV
      GSAT0201               -40128   GALILEO_5           Galileo FOC
      GSAT0202               -40129   GALILEO_6           Galileo FOC
      GSAT0203               -40544   GALILEO_7           Galileo FOC
      GSAT0204               -40545   GALILEO_8           Galileo FOC
      GSAT0205               -40889   GALILEO_9           Galileo FOC
      GSAT0206               -40890   GALILEO_10          Galileo FOC
      GSAT0207               -41859   GALILEO_15          Galileo FOC
      GSAT0208               -41175   GALILEO_11          Galileo FOC
      GSAT0209               -41174   GALILEO_12          Galileo FOC
      GSAT0210               -41550   GALILEO_13          Galileo FOC
      GSAT0211               -41549   GALILEO_14          Galileo FOC
      GSAT0212               -41860   GALILEO_16          Galileo FOC
      GSAT0213               -41861   GALILEO_17          Galileo FOC
      GSAT0214               -41862   GALILEO_18          Galileo FOC
      GSAT0215               -43055   GALILEO_19          Galileo FOC
      GSAT0216               -43056   GALILEO_20          Galileo FOC
      GSAT0217               -43057   GALILEO_21          Galileo FOC
      GSAT0218               -43058   GALILEO_22          Galileo FOC
      GSAT0219               -43566   GALILEO_23          Galileo FOC
      GSAT0220               -43567   GALILEO_24          Galileo FOC
      GSAT0221               -43564   GALILEO_25          Galileo FOC
      GSAT0222               -43565   GALILEO_26          Galileo FOC
      GSAT0223               -49809   GALILEO_27          Galileo FOC
      GSAT0224               -49810   GALILEO_28          Galileo FOC
      GSAT0225               -59598   GALILEO_29          Galileo FOC
      GSAT0226               -61183   GALILEO_31          Galileo FOC
      GSAT0227               -59600   GALILEO_30          Galileo FOC
      GSAT0232               -61182   GALILEO_32          Galileo FOC


      GPS:
      ----
      GPS_BIIF-1             -36585   PRN_25
      GPS_BIIF-10            -40730   PRN_08
      GPS_BIIF-11            -41019   PRN_10
      GPS_BIIF-12            -41328   PRN_32
      GPS_BIIF-3             -38833   PRN_24
      GPS_BIIF-4             -39166   PRN_27
      GPS_BIIF-5             -39533   PRN_30
      GPS_BIIF-6             -39741   PRN_06
      GPS_BIIF-7             -40105   PRN_09
      GPS_BIIF-8             -40294   PRN_03
      GPS_BIIF-9             -40534   PRN_26
      GPS_BIII-1             -43873   PRN_04
      GPS_BIII-2             -44506   PRN_18
      GPS_BIII-3             -45854   PRN_23
      GPS_BIII-4             -46826   PRN_14
      GPS_BIII-5             -48859   PRN_11
      GPS_BIII-6             -55268   PRN_28
      GPS_BIII-7             -62339   PRN_01
      GPS_BIII-8             -64202   PRN_21
      GPS_BIIR-11            -28190   PRN_19
      GPS_BIIR-13            -28474   PRN_02
      GPS_BIIR-2             -24876   PRN_13
      GPS_BIIR-4             -26360   PRN_20
      GPS_BIIR-5             -26407   PRN_22
      GPS_BIIR-8             -27663   PRN_16
      GPS_BIIR-9             -27704   PRN_21_GPS_BIIR-9
      GPS_BIIRM-1            -28874   PRN_17
      GPS_BIIRM-2            -29486   PRN_31
      GPS_BIIRM-3            -29601   PRN_12
      GPS_BIIRM-4            -32260   PRN_15
      GPS_BIIRM-5            -32384   PRN_29
      GPS_BIIRM-6            -32711   PRN_07
      GPS_BIIRM-8            -35752   PRN_05
      NAVSTAR_66             -37753   USA_232             Block IIF


      Glonass:
      --------
      COSMOS_2432            -32276                       Glonass-M&K1
      COSMOS_2433            -32275                       Glonass-M&K1
      COSMOS_2434            -32393                       Glonass-M&K1
      COSMOS_2436            -32395                       Glonass-M&K1
      COSMOS_2456            -36111                       Glonass-M&K1
      COSMOS_2457            -36112                       Glonass-M&K1
      COSMOS_2460            -36402                       Glonass-M&K1
      COSMOS_2475            -37869                       Glonass-M&K1
      COSMOS_2476            -37867                       Glonass-M&K1
      COSMOS_2477            -37868                       Glonass-M&K1
      COSMOS_2485            -39155                       Glonass-M&K1
      COSMOS_2492            -39620                       Glonass-M&K1
      COSMOS_2500            -40001                       Glonass-M&K1
      COSMOS_2501            -40315   702K                Glonass-M&K1
      COSMOS_2514            -41330                       Glonass-M&K1
      COSMOS_2516            -41554                       Glonass-M&K1
      COSMOS_2522            -42939                       Glonass-M&K1
      COSMOS_2527            -43508                       Glonass-M&K1
      COSMOS_2529            -43687                       Glonass-M&K1
      COSMOS_2534            -44299                       Glonass-M&K1
      COSMOS_2544            -44850                       Glonass-M&K1
      COSMOS_2545            -45358                       Glonass-M&K1
      COSMOS_2547            -46805   705K                Glonass-M&K1
      COSMOS_2557            -52984   706K                Glonass-M&K1
      COSMOS_2559            -54031   707K                Glonass-M&K1
      COSMOS_2564            -54377                       Glonass-M&K1
      COSMOS_2569            -57517   703K                Glonass-M&K1
      COSMOS_2584            -63130   704K                Glonass-M&K1
      COSMOS_2596            -65590   708K                Glonass-M&K1


      BeiDou:
      -------
      BEIDOU-2_G4            -37210   C04                 BeiDou GEO
      BEIDOU-2_G5            -38091   C05                 BeiDou GEO
      BEIDOU-2_G6            -38953   C02                 BeiDou GEO
      BEIDOU-2_G7            -41586   C03                 BeiDou GEO
      BEIDOU-2_G8            -44231   C01                 BeiDou GEO
      BEIDOU-2_IGSO-1        -36828   C06                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-2        -37256   C07                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-3        -37384   C08                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-4        -37763   C09                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-5        -37948   C10                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-6        -41434   C13                 BeiDou MEO/IGSO
      BEIDOU-2_IGSO-7        -43539   C16                 BeiDou MEO/IGSO
      BEIDOU-2_M3            -38250   C11                 BeiDou MEO/IGSO
      BEIDOU-2_M4            -38251   C12                 BeiDou MEO/IGSO
      BEIDOU-2_M6            -38775   C14                 BeiDou MEO/IGSO
      BEIDOU-3S_IGSO-1S      -40549   C31                 BeiDou MEO/IGSO
      BEIDOU-3S_IGSO-2S      -40938   C56                 BeiDou MEO/IGSO
      BEIDOU-3S_M1S          -40749   C57                 BeiDou MEO/IGSO
      BEIDOU-3S_M2S          -40748   C58                 BeiDou MEO/IGSO
      BEIDOU-3_G1            -43683   C59                 BeiDou GEO
      BEIDOU-3_G2            -45344   C60                 BeiDou GEO
      BEIDOU-3_G3            -45807   C61                 BeiDou GEO
      BEIDOU-3_G4            -56564   C62                 BeiDou GEO
      BEIDOU-3_IGSO-1        -44204   C38                 BeiDou MEO/IGSO
      BEIDOU-3_IGSO-2        -44337   C39                 BeiDou MEO/IGSO
      BEIDOU-3_IGSO-3        -44709   C40                 BeiDou MEO/IGSO
      BEIDOU-3_M1            -43001   C19                 BeiDou MEO/IGSO
      BEIDOU-3_M10           -43246   C30                 BeiDou MEO/IGSO
      BEIDOU-3_M11           -43603   C25                 BeiDou MEO/IGSO
      BEIDOU-3_M12           -43602   C26                 BeiDou MEO/IGSO
      BEIDOU-3_M13           -43622   C32                 BeiDou MEO/IGSO
      BEIDOU-3_M14           -43623   C33                 BeiDou MEO/IGSO
      BEIDOU-3_M15           -43648   C34                 BeiDou MEO/IGSO
      BEIDOU-3_M16           -43647   C35                 BeiDou MEO/IGSO
      BEIDOU-3_M17           -43706   C36                 BeiDou MEO/IGSO
      BEIDOU-3_M18           -43707   C37                 BeiDou MEO/IGSO
      BEIDOU-3_M19           -44864   C41                 BeiDou MEO/IGSO
      BEIDOU-3_M2            -43002   C20                 BeiDou MEO/IGSO
      BEIDOU-3_M20           -44865   C42                 BeiDou MEO/IGSO
      BEIDOU-3_M21           -44794   C43                 BeiDou MEO/IGSO
      BEIDOU-3_M22           -44793   C44                 BeiDou MEO/IGSO
      BEIDOU-3_M23           -44543   C45                 BeiDou MEO/IGSO
      BEIDOU-3_M24           -44542   C46                 BeiDou MEO/IGSO
      BEIDOU-3_M25           -61186   C47                 BeiDou MEO/IGSO
      BEIDOU-3_M26           -58655   C48                 BeiDou MEO/IGSO
      BEIDOU-3_M27           -61187   C49                 BeiDou MEO/IGSO
      BEIDOU-3_M28           -58654   C50                 BeiDou MEO/IGSO
      BEIDOU-3_M3            -43208   C21                 BeiDou MEO/IGSO
      BEIDOU-3_M4            -43207   C22                 BeiDou MEO/IGSO
      BEIDOU-3_M5            -43581   C23                 BeiDou MEO/IGSO
      BEIDOU-3_M6            -43582   C24                 BeiDou MEO/IGSO
      BEIDOU-3_M7            -43107   C27                 BeiDou MEO/IGSO
      BEIDOU-3_M8            -43108   C28                 BeiDou MEO/IGSO
      BEIDOU-3_M9            -43245   C29                 BeiDou MEO/IGSO


      Other:
      ------
      ASTRA_5B               -39617   EGNOS_PRN_123
      CRE                    -28868   WAAS_PRN_138
      EUTELSAT_117_WEST_B    -41589   W*
      EUTELSAT_5_WEST_B      -44624   EGN*
      GALAXY_30              -46114   WAAS_PRN_135
      INMARSAT_4-F2          -28899   SOUTHPA*
      IRNSS-1A               -39199                       IRNSS
      IRNSS-1B               -39635                       IRNSS
      IRNSS-1C               -40269                       IRNSS
      IRNSS-1D               -40547                       IRNSS
      IRNSS-1E               -41241                       IRNSS
      IRNSS-1F               -41384                       IRNSS
      IRNSS-1G               -41469                       IRNSS
      IRNSS-1I               -43286                       IRNSS
      LUCH_5A                -37951   SDCM_PRN_140
      LUCH_5B                -38977   SDCM_PRN_125
      LUCH_5V                -39727   SDCM_PRN_141
      NVS-01                 -56759   IRNSS-1J
      NVS-02                 -62850   IRNSS-1K
      QZS-1                  -37158   MICHIBIKI-1         QZSS
      QZS-1R                 -49336   QZSS_PRN_196        QZSS
      QZS-2                  -42738   QZSS_PRN_194        QZSS
      QZS-3                  -42917   QZSS_PRN_199        QZSS
      QZS-4                  -42965   QZSS_PRN_195        QZSS
      SES-15                 -42709   WAAS_PRN_133
      SES-5                  -38652   EGNOS_PRN_136
      ---------------------  -------  --------------------------

     \begindata

        NAIF_BODY_NAME += ( 'GAGAN_PRN_128'                )
        NAIF_BODY_CODE += ( -38779                         )

        NAIF_BODY_NAME += ( 'GSAT-10'                      )
        NAIF_BODY_CODE += ( -38779                         )

        NAIF_BODY_NAME += ( 'GAGAN_PRN_139'                )
        NAIF_BODY_CODE += ( -41028                         )

        NAIF_BODY_NAME += ( 'GSAT-15'                      )
        NAIF_BODY_CODE += ( -41028                         )

        NAIF_BODY_NAME += ( 'GAGAN_PRN_127'                )
        NAIF_BODY_CODE += ( -37605                         )

        NAIF_BODY_NAME += ( 'GSAT-8'                       )
        NAIF_BODY_CODE += ( -37605                         )

        NAIF_BODY_NAME += ( 'GALILEO-PFM'                  )
        NAIF_BODY_CODE += ( -37846                         )

        NAIF_BODY_NAME += ( 'GSAT0101'                     )
        NAIF_BODY_CODE += ( -37846                         )

        NAIF_BODY_NAME += ( 'GALILEO-FM2'                  )
        NAIF_BODY_CODE += ( -37847                         )

        NAIF_BODY_NAME += ( 'GSAT0102'                     )
        NAIF_BODY_CODE += ( -37847                         )

        NAIF_BODY_NAME += ( 'GALILEO-FM3'                  )
        NAIF_BODY_CODE += ( -38857                         )

        NAIF_BODY_NAME += ( 'GSAT0103'                     )
        NAIF_BODY_CODE += ( -38857                         )

        NAIF_BODY_NAME += ( 'GALILEO-FM4'                  )
        NAIF_BODY_CODE += ( -38858                         )

        NAIF_BODY_NAME += ( 'GSAT0104'                     )
        NAIF_BODY_CODE += ( -38858                         )

        NAIF_BODY_NAME += ( 'GALILEO_5'                    )
        NAIF_BODY_CODE += ( -40128                         )

        NAIF_BODY_NAME += ( 'GSAT0201'                     )
        NAIF_BODY_CODE += ( -40128                         )

        NAIF_BODY_NAME += ( 'GALILEO_6'                    )
        NAIF_BODY_CODE += ( -40129                         )

        NAIF_BODY_NAME += ( 'GSAT0202'                     )
        NAIF_BODY_CODE += ( -40129                         )

        NAIF_BODY_NAME += ( 'GALILEO_7'                    )
        NAIF_BODY_CODE += ( -40544                         )

        NAIF_BODY_NAME += ( 'GSAT0203'                     )
        NAIF_BODY_CODE += ( -40544                         )

        NAIF_BODY_NAME += ( 'GALILEO_8'                    )
        NAIF_BODY_CODE += ( -40545                         )

        NAIF_BODY_NAME += ( 'GSAT0204'                     )
        NAIF_BODY_CODE += ( -40545                         )

        NAIF_BODY_NAME += ( 'GALILEO_9'                    )
        NAIF_BODY_CODE += ( -40889                         )

        NAIF_BODY_NAME += ( 'GSAT0205'                     )
        NAIF_BODY_CODE += ( -40889                         )

        NAIF_BODY_NAME += ( 'GALILEO_10'                   )
        NAIF_BODY_CODE += ( -40890                         )

        NAIF_BODY_NAME += ( 'GSAT0206'                     )
        NAIF_BODY_CODE += ( -40890                         )

        NAIF_BODY_NAME += ( 'GALILEO_15'                   )
        NAIF_BODY_CODE += ( -41859                         )

        NAIF_BODY_NAME += ( 'GSAT0207'                     )
        NAIF_BODY_CODE += ( -41859                         )

        NAIF_BODY_NAME += ( 'GALILEO_11'                   )
        NAIF_BODY_CODE += ( -41175                         )

        NAIF_BODY_NAME += ( 'GSAT0208'                     )
        NAIF_BODY_CODE += ( -41175                         )

        NAIF_BODY_NAME += ( 'GALILEO_12'                   )
        NAIF_BODY_CODE += ( -41174                         )

        NAIF_BODY_NAME += ( 'GSAT0209'                     )
        NAIF_BODY_CODE += ( -41174                         )

        NAIF_BODY_NAME += ( 'GALILEO_13'                   )
        NAIF_BODY_CODE += ( -41550                         )

        NAIF_BODY_NAME += ( 'GSAT0210'                     )
        NAIF_BODY_CODE += ( -41550                         )

        NAIF_BODY_NAME += ( 'GALILEO_14'                   )
        NAIF_BODY_CODE += ( -41549                         )

        NAIF_BODY_NAME += ( 'GSAT0211'                     )
        NAIF_BODY_CODE += ( -41549                         )

        NAIF_BODY_NAME += ( 'GALILEO_16'                   )
        NAIF_BODY_CODE += ( -41860                         )

        NAIF_BODY_NAME += ( 'GSAT0212'                     )
        NAIF_BODY_CODE += ( -41860                         )

        NAIF_BODY_NAME += ( 'GALILEO_17'                   )
        NAIF_BODY_CODE += ( -41861                         )

        NAIF_BODY_NAME += ( 'GSAT0213'                     )
        NAIF_BODY_CODE += ( -41861                         )

        NAIF_BODY_NAME += ( 'GALILEO_18'                   )
        NAIF_BODY_CODE += ( -41862                         )

        NAIF_BODY_NAME += ( 'GSAT0214'                     )
        NAIF_BODY_CODE += ( -41862                         )

        NAIF_BODY_NAME += ( 'GALILEO_19'                   )
        NAIF_BODY_CODE += ( -43055                         )

        NAIF_BODY_NAME += ( 'GSAT0215'                     )
        NAIF_BODY_CODE += ( -43055                         )

        NAIF_BODY_NAME += ( 'GALILEO_20'                   )
        NAIF_BODY_CODE += ( -43056                         )

        NAIF_BODY_NAME += ( 'GSAT0216'                     )
        NAIF_BODY_CODE += ( -43056                         )

        NAIF_BODY_NAME += ( 'GALILEO_21'                   )
        NAIF_BODY_CODE += ( -43057                         )

        NAIF_BODY_NAME += ( 'GSAT0217'                     )
        NAIF_BODY_CODE += ( -43057                         )

        NAIF_BODY_NAME += ( 'GALILEO_22'                   )
        NAIF_BODY_CODE += ( -43058                         )

        NAIF_BODY_NAME += ( 'GSAT0218'                     )
        NAIF_BODY_CODE += ( -43058                         )

        NAIF_BODY_NAME += ( 'GALILEO_23'                   )
        NAIF_BODY_CODE += ( -43566                         )

        NAIF_BODY_NAME += ( 'GSAT0219'                     )
        NAIF_BODY_CODE += ( -43566                         )

        NAIF_BODY_NAME += ( 'GALILEO_24'                   )
        NAIF_BODY_CODE += ( -43567                         )

        NAIF_BODY_NAME += ( 'GSAT0220'                     )
        NAIF_BODY_CODE += ( -43567                         )

        NAIF_BODY_NAME += ( 'GALILEO_25'                   )
        NAIF_BODY_CODE += ( -43564                         )

        NAIF_BODY_NAME += ( 'GSAT0221'                     )
        NAIF_BODY_CODE += ( -43564                         )

        NAIF_BODY_NAME += ( 'GALILEO_26'                   )
        NAIF_BODY_CODE += ( -43565                         )

        NAIF_BODY_NAME += ( 'GSAT0222'                     )
        NAIF_BODY_CODE += ( -43565                         )

        NAIF_BODY_NAME += ( 'GALILEO_27'                   )
        NAIF_BODY_CODE += ( -49809                         )

        NAIF_BODY_NAME += ( 'GSAT0223'                     )
        NAIF_BODY_CODE += ( -49809                         )

        NAIF_BODY_NAME += ( 'GALILEO_28'                   )
        NAIF_BODY_CODE += ( -49810                         )

        NAIF_BODY_NAME += ( 'GSAT0224'                     )
        NAIF_BODY_CODE += ( -49810                         )

        NAIF_BODY_NAME += ( 'GALILEO_29'                   )
        NAIF_BODY_CODE += ( -59598                         )

        NAIF_BODY_NAME += ( 'GSAT0225'                     )
        NAIF_BODY_CODE += ( -59598                         )

        NAIF_BODY_NAME += ( 'GALILEO_31'                   )
        NAIF_BODY_CODE += ( -61183                         )

        NAIF_BODY_NAME += ( 'GSAT0226'                     )
        NAIF_BODY_CODE += ( -61183                         )

        NAIF_BODY_NAME += ( 'GALILEO_30'                   )
        NAIF_BODY_CODE += ( -59600                         )

        NAIF_BODY_NAME += ( 'GSAT0227'                     )
        NAIF_BODY_CODE += ( -59600                         )

        NAIF_BODY_NAME += ( 'GALILEO_32'                   )
        NAIF_BODY_CODE += ( -61182                         )

        NAIF_BODY_NAME += ( 'GSAT0232'                     )
        NAIF_BODY_CODE += ( -61182                         )


        NAIF_BODY_NAME += ( 'PRN_25'                       )
        NAIF_BODY_CODE += ( -36585                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-1'                   )
        NAIF_BODY_CODE += ( -36585                         )

        NAIF_BODY_NAME += ( 'PRN_08'                       )
        NAIF_BODY_CODE += ( -40730                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-10'                  )
        NAIF_BODY_CODE += ( -40730                         )

        NAIF_BODY_NAME += ( 'PRN_10'                       )
        NAIF_BODY_CODE += ( -41019                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-11'                  )
        NAIF_BODY_CODE += ( -41019                         )

        NAIF_BODY_NAME += ( 'PRN_32'                       )
        NAIF_BODY_CODE += ( -41328                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-12'                  )
        NAIF_BODY_CODE += ( -41328                         )

        NAIF_BODY_NAME += ( 'PRN_24'                       )
        NAIF_BODY_CODE += ( -38833                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-3'                   )
        NAIF_BODY_CODE += ( -38833                         )

        NAIF_BODY_NAME += ( 'PRN_27'                       )
        NAIF_BODY_CODE += ( -39166                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-4'                   )
        NAIF_BODY_CODE += ( -39166                         )

        NAIF_BODY_NAME += ( 'PRN_30'                       )
        NAIF_BODY_CODE += ( -39533                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-5'                   )
        NAIF_BODY_CODE += ( -39533                         )

        NAIF_BODY_NAME += ( 'PRN_06'                       )
        NAIF_BODY_CODE += ( -39741                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-6'                   )
        NAIF_BODY_CODE += ( -39741                         )

        NAIF_BODY_NAME += ( 'PRN_09'                       )
        NAIF_BODY_CODE += ( -40105                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-7'                   )
        NAIF_BODY_CODE += ( -40105                         )

        NAIF_BODY_NAME += ( 'PRN_03'                       )
        NAIF_BODY_CODE += ( -40294                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-8'                   )
        NAIF_BODY_CODE += ( -40294                         )

        NAIF_BODY_NAME += ( 'PRN_26'                       )
        NAIF_BODY_CODE += ( -40534                         )

        NAIF_BODY_NAME += ( 'GPS_BIIF-9'                   )
        NAIF_BODY_CODE += ( -40534                         )

        NAIF_BODY_NAME += ( 'PRN_04'                       )
        NAIF_BODY_CODE += ( -43873                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-1'                   )
        NAIF_BODY_CODE += ( -43873                         )

        NAIF_BODY_NAME += ( 'PRN_18'                       )
        NAIF_BODY_CODE += ( -44506                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-2'                   )
        NAIF_BODY_CODE += ( -44506                         )

        NAIF_BODY_NAME += ( 'PRN_23'                       )
        NAIF_BODY_CODE += ( -45854                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-3'                   )
        NAIF_BODY_CODE += ( -45854                         )

        NAIF_BODY_NAME += ( 'PRN_14'                       )
        NAIF_BODY_CODE += ( -46826                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-4'                   )
        NAIF_BODY_CODE += ( -46826                         )

        NAIF_BODY_NAME += ( 'PRN_11'                       )
        NAIF_BODY_CODE += ( -48859                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-5'                   )
        NAIF_BODY_CODE += ( -48859                         )

        NAIF_BODY_NAME += ( 'PRN_28'                       )
        NAIF_BODY_CODE += ( -55268                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-6'                   )
        NAIF_BODY_CODE += ( -55268                         )

        NAIF_BODY_NAME += ( 'PRN_01'                       )
        NAIF_BODY_CODE += ( -62339                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-7'                   )
        NAIF_BODY_CODE += ( -62339                         )

        NAIF_BODY_NAME += ( 'PRN_21'                       )
        NAIF_BODY_CODE += ( -64202                         )

        NAIF_BODY_NAME += ( 'GPS_BIII-8'                   )
        NAIF_BODY_CODE += ( -64202                         )

        NAIF_BODY_NAME += ( 'PRN_19'                       )
        NAIF_BODY_CODE += ( -28190                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-11'                  )
        NAIF_BODY_CODE += ( -28190                         )

        NAIF_BODY_NAME += ( 'PRN_02'                       )
        NAIF_BODY_CODE += ( -28474                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-13'                  )
        NAIF_BODY_CODE += ( -28474                         )

        NAIF_BODY_NAME += ( 'PRN_13'                       )
        NAIF_BODY_CODE += ( -24876                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-2'                   )
        NAIF_BODY_CODE += ( -24876                         )

        NAIF_BODY_NAME += ( 'PRN_20'                       )
        NAIF_BODY_CODE += ( -26360                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-4'                   )
        NAIF_BODY_CODE += ( -26360                         )

        NAIF_BODY_NAME += ( 'PRN_22'                       )
        NAIF_BODY_CODE += ( -26407                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-5'                   )
        NAIF_BODY_CODE += ( -26407                         )

        NAIF_BODY_NAME += ( 'PRN_16'                       )
        NAIF_BODY_CODE += ( -27663                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-8'                   )
        NAIF_BODY_CODE += ( -27663                         )

        NAIF_BODY_NAME += ( 'PRN_21_GPS_BIIR-9'            )
        NAIF_BODY_CODE += ( -27704                         )

        NAIF_BODY_NAME += ( 'GPS_BIIR-9'                   )
        NAIF_BODY_CODE += ( -27704                         )

        NAIF_BODY_NAME += ( 'PRN_17'                       )
        NAIF_BODY_CODE += ( -28874                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-1'                  )
        NAIF_BODY_CODE += ( -28874                         )

        NAIF_BODY_NAME += ( 'PRN_31'                       )
        NAIF_BODY_CODE += ( -29486                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-2'                  )
        NAIF_BODY_CODE += ( -29486                         )

        NAIF_BODY_NAME += ( 'PRN_12'                       )
        NAIF_BODY_CODE += ( -29601                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-3'                  )
        NAIF_BODY_CODE += ( -29601                         )

        NAIF_BODY_NAME += ( 'PRN_15'                       )
        NAIF_BODY_CODE += ( -32260                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-4'                  )
        NAIF_BODY_CODE += ( -32260                         )

        NAIF_BODY_NAME += ( 'PRN_29'                       )
        NAIF_BODY_CODE += ( -32384                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-5'                  )
        NAIF_BODY_CODE += ( -32384                         )

        NAIF_BODY_NAME += ( 'PRN_07'                       )
        NAIF_BODY_CODE += ( -32711                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-6'                  )
        NAIF_BODY_CODE += ( -32711                         )

        NAIF_BODY_NAME += ( 'PRN_05'                       )
        NAIF_BODY_CODE += ( -35752                         )

        NAIF_BODY_NAME += ( 'GPS_BIIRM-8'                  )
        NAIF_BODY_CODE += ( -35752                         )

        NAIF_BODY_NAME += ( 'USA_232'                      )
        NAIF_BODY_CODE += ( -37753                         )

        NAIF_BODY_NAME += ( 'NAVSTAR_66'                   )
        NAIF_BODY_CODE += ( -37753                         )


        NAIF_BODY_NAME += ( 'COSMOS_2432'                  )
        NAIF_BODY_CODE += ( -32276                         )

        NAIF_BODY_NAME += ( 'COSMOS_2433'                  )
        NAIF_BODY_CODE += ( -32275                         )

        NAIF_BODY_NAME += ( 'COSMOS_2434'                  )
        NAIF_BODY_CODE += ( -32393                         )

        NAIF_BODY_NAME += ( 'COSMOS_2436'                  )
        NAIF_BODY_CODE += ( -32395                         )

        NAIF_BODY_NAME += ( 'COSMOS_2456'                  )
        NAIF_BODY_CODE += ( -36111                         )

        NAIF_BODY_NAME += ( 'COSMOS_2457'                  )
        NAIF_BODY_CODE += ( -36112                         )

        NAIF_BODY_NAME += ( 'COSMOS_2460'                  )
        NAIF_BODY_CODE += ( -36402                         )

        NAIF_BODY_NAME += ( 'COSMOS_2475'                  )
        NAIF_BODY_CODE += ( -37869                         )

        NAIF_BODY_NAME += ( 'COSMOS_2476'                  )
        NAIF_BODY_CODE += ( -37867                         )

        NAIF_BODY_NAME += ( 'COSMOS_2477'                  )
        NAIF_BODY_CODE += ( -37868                         )

        NAIF_BODY_NAME += ( 'COSMOS_2485'                  )
        NAIF_BODY_CODE += ( -39155                         )

        NAIF_BODY_NAME += ( 'COSMOS_2492'                  )
        NAIF_BODY_CODE += ( -39620                         )

        NAIF_BODY_NAME += ( 'COSMOS_2500'                  )
        NAIF_BODY_CODE += ( -40001                         )

        NAIF_BODY_NAME += ( '702K'                         )
        NAIF_BODY_CODE += ( -40315                         )

        NAIF_BODY_NAME += ( 'COSMOS_2501'                  )
        NAIF_BODY_CODE += ( -40315                         )

        NAIF_BODY_NAME += ( 'COSMOS_2514'                  )
        NAIF_BODY_CODE += ( -41330                         )

        NAIF_BODY_NAME += ( 'COSMOS_2516'                  )
        NAIF_BODY_CODE += ( -41554                         )

        NAIF_BODY_NAME += ( 'COSMOS_2522'                  )
        NAIF_BODY_CODE += ( -42939                         )

        NAIF_BODY_NAME += ( 'COSMOS_2527'                  )
        NAIF_BODY_CODE += ( -43508                         )

        NAIF_BODY_NAME += ( 'COSMOS_2529'                  )
        NAIF_BODY_CODE += ( -43687                         )

        NAIF_BODY_NAME += ( 'COSMOS_2534'                  )
        NAIF_BODY_CODE += ( -44299                         )

        NAIF_BODY_NAME += ( 'COSMOS_2544'                  )
        NAIF_BODY_CODE += ( -44850                         )

        NAIF_BODY_NAME += ( 'COSMOS_2545'                  )
        NAIF_BODY_CODE += ( -45358                         )

        NAIF_BODY_NAME += ( '705K'                         )
        NAIF_BODY_CODE += ( -46805                         )

        NAIF_BODY_NAME += ( 'COSMOS_2547'                  )
        NAIF_BODY_CODE += ( -46805                         )

        NAIF_BODY_NAME += ( '706K'                         )
        NAIF_BODY_CODE += ( -52984                         )

        NAIF_BODY_NAME += ( 'COSMOS_2557'                  )
        NAIF_BODY_CODE += ( -52984                         )

        NAIF_BODY_NAME += ( '707K'                         )
        NAIF_BODY_CODE += ( -54031                         )

        NAIF_BODY_NAME += ( 'COSMOS_2559'                  )
        NAIF_BODY_CODE += ( -54031                         )

        NAIF_BODY_NAME += ( 'COSMOS_2564'                  )
        NAIF_BODY_CODE += ( -54377                         )

        NAIF_BODY_NAME += ( '703K'                         )
        NAIF_BODY_CODE += ( -57517                         )

        NAIF_BODY_NAME += ( 'COSMOS_2569'                  )
        NAIF_BODY_CODE += ( -57517                         )

        NAIF_BODY_NAME += ( '704K'                         )
        NAIF_BODY_CODE += ( -63130                         )

        NAIF_BODY_NAME += ( 'COSMOS_2584'                  )
        NAIF_BODY_CODE += ( -63130                         )

        NAIF_BODY_NAME += ( '708K'                         )
        NAIF_BODY_CODE += ( -65590                         )

        NAIF_BODY_NAME += ( 'COSMOS_2596'                  )
        NAIF_BODY_CODE += ( -65590                         )


        NAIF_BODY_NAME += ( 'C04'                          )
        NAIF_BODY_CODE += ( -37210                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_G4'                  )
        NAIF_BODY_CODE += ( -37210                         )

        NAIF_BODY_NAME += ( 'C05'                          )
        NAIF_BODY_CODE += ( -38091                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_G5'                  )
        NAIF_BODY_CODE += ( -38091                         )

        NAIF_BODY_NAME += ( 'C02'                          )
        NAIF_BODY_CODE += ( -38953                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_G6'                  )
        NAIF_BODY_CODE += ( -38953                         )

        NAIF_BODY_NAME += ( 'C03'                          )
        NAIF_BODY_CODE += ( -41586                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_G7'                  )
        NAIF_BODY_CODE += ( -41586                         )

        NAIF_BODY_NAME += ( 'C01'                          )
        NAIF_BODY_CODE += ( -44231                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_G8'                  )
        NAIF_BODY_CODE += ( -44231                         )

        NAIF_BODY_NAME += ( 'C06'                          )
        NAIF_BODY_CODE += ( -36828                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-1'              )
        NAIF_BODY_CODE += ( -36828                         )

        NAIF_BODY_NAME += ( 'C07'                          )
        NAIF_BODY_CODE += ( -37256                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-2'              )
        NAIF_BODY_CODE += ( -37256                         )

        NAIF_BODY_NAME += ( 'C08'                          )
        NAIF_BODY_CODE += ( -37384                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-3'              )
        NAIF_BODY_CODE += ( -37384                         )

        NAIF_BODY_NAME += ( 'C09'                          )
        NAIF_BODY_CODE += ( -37763                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-4'              )
        NAIF_BODY_CODE += ( -37763                         )

        NAIF_BODY_NAME += ( 'C10'                          )
        NAIF_BODY_CODE += ( -37948                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-5'              )
        NAIF_BODY_CODE += ( -37948                         )

        NAIF_BODY_NAME += ( 'C13'                          )
        NAIF_BODY_CODE += ( -41434                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-6'              )
        NAIF_BODY_CODE += ( -41434                         )

        NAIF_BODY_NAME += ( 'C16'                          )
        NAIF_BODY_CODE += ( -43539                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_IGSO-7'              )
        NAIF_BODY_CODE += ( -43539                         )

        NAIF_BODY_NAME += ( 'C11'                          )
        NAIF_BODY_CODE += ( -38250                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_M3'                  )
        NAIF_BODY_CODE += ( -38250                         )

        NAIF_BODY_NAME += ( 'C12'                          )
        NAIF_BODY_CODE += ( -38251                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_M4'                  )
        NAIF_BODY_CODE += ( -38251                         )

        NAIF_BODY_NAME += ( 'C14'                          )
        NAIF_BODY_CODE += ( -38775                         )

        NAIF_BODY_NAME += ( 'BEIDOU-2_M6'                  )
        NAIF_BODY_CODE += ( -38775                         )

        NAIF_BODY_NAME += ( 'C31'                          )
        NAIF_BODY_CODE += ( -40549                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3S_IGSO-1S'            )
        NAIF_BODY_CODE += ( -40549                         )

        NAIF_BODY_NAME += ( 'C56'                          )
        NAIF_BODY_CODE += ( -40938                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3S_IGSO-2S'            )
        NAIF_BODY_CODE += ( -40938                         )

        NAIF_BODY_NAME += ( 'C57'                          )
        NAIF_BODY_CODE += ( -40749                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3S_M1S'                )
        NAIF_BODY_CODE += ( -40749                         )

        NAIF_BODY_NAME += ( 'C58'                          )
        NAIF_BODY_CODE += ( -40748                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3S_M2S'                )
        NAIF_BODY_CODE += ( -40748                         )

        NAIF_BODY_NAME += ( 'C59'                          )
        NAIF_BODY_CODE += ( -43683                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_G1'                  )
        NAIF_BODY_CODE += ( -43683                         )

        NAIF_BODY_NAME += ( 'C60'                          )
        NAIF_BODY_CODE += ( -45344                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_G2'                  )
        NAIF_BODY_CODE += ( -45344                         )

        NAIF_BODY_NAME += ( 'C61'                          )
        NAIF_BODY_CODE += ( -45807                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_G3'                  )
        NAIF_BODY_CODE += ( -45807                         )

        NAIF_BODY_NAME += ( 'C62'                          )
        NAIF_BODY_CODE += ( -56564                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_G4'                  )
        NAIF_BODY_CODE += ( -56564                         )

        NAIF_BODY_NAME += ( 'C38'                          )
        NAIF_BODY_CODE += ( -44204                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_IGSO-1'              )
        NAIF_BODY_CODE += ( -44204                         )

        NAIF_BODY_NAME += ( 'C39'                          )
        NAIF_BODY_CODE += ( -44337                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_IGSO-2'              )
        NAIF_BODY_CODE += ( -44337                         )

        NAIF_BODY_NAME += ( 'C40'                          )
        NAIF_BODY_CODE += ( -44709                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_IGSO-3'              )
        NAIF_BODY_CODE += ( -44709                         )

        NAIF_BODY_NAME += ( 'C19'                          )
        NAIF_BODY_CODE += ( -43001                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M1'                  )
        NAIF_BODY_CODE += ( -43001                         )

        NAIF_BODY_NAME += ( 'C30'                          )
        NAIF_BODY_CODE += ( -43246                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M10'                 )
        NAIF_BODY_CODE += ( -43246                         )

        NAIF_BODY_NAME += ( 'C25'                          )
        NAIF_BODY_CODE += ( -43603                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M11'                 )
        NAIF_BODY_CODE += ( -43603                         )

        NAIF_BODY_NAME += ( 'C26'                          )
        NAIF_BODY_CODE += ( -43602                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M12'                 )
        NAIF_BODY_CODE += ( -43602                         )

        NAIF_BODY_NAME += ( 'C32'                          )
        NAIF_BODY_CODE += ( -43622                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M13'                 )
        NAIF_BODY_CODE += ( -43622                         )

        NAIF_BODY_NAME += ( 'C33'                          )
        NAIF_BODY_CODE += ( -43623                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M14'                 )
        NAIF_BODY_CODE += ( -43623                         )

        NAIF_BODY_NAME += ( 'C34'                          )
        NAIF_BODY_CODE += ( -43648                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M15'                 )
        NAIF_BODY_CODE += ( -43648                         )

        NAIF_BODY_NAME += ( 'C35'                          )
        NAIF_BODY_CODE += ( -43647                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M16'                 )
        NAIF_BODY_CODE += ( -43647                         )

        NAIF_BODY_NAME += ( 'C36'                          )
        NAIF_BODY_CODE += ( -43706                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M17'                 )
        NAIF_BODY_CODE += ( -43706                         )

        NAIF_BODY_NAME += ( 'C37'                          )
        NAIF_BODY_CODE += ( -43707                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M18'                 )
        NAIF_BODY_CODE += ( -43707                         )

        NAIF_BODY_NAME += ( 'C41'                          )
        NAIF_BODY_CODE += ( -44864                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M19'                 )
        NAIF_BODY_CODE += ( -44864                         )

        NAIF_BODY_NAME += ( 'C20'                          )
        NAIF_BODY_CODE += ( -43002                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M2'                  )
        NAIF_BODY_CODE += ( -43002                         )

        NAIF_BODY_NAME += ( 'C42'                          )
        NAIF_BODY_CODE += ( -44865                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M20'                 )
        NAIF_BODY_CODE += ( -44865                         )

        NAIF_BODY_NAME += ( 'C43'                          )
        NAIF_BODY_CODE += ( -44794                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M21'                 )
        NAIF_BODY_CODE += ( -44794                         )

        NAIF_BODY_NAME += ( 'C44'                          )
        NAIF_BODY_CODE += ( -44793                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M22'                 )
        NAIF_BODY_CODE += ( -44793                         )

        NAIF_BODY_NAME += ( 'C45'                          )
        NAIF_BODY_CODE += ( -44543                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M23'                 )
        NAIF_BODY_CODE += ( -44543                         )

        NAIF_BODY_NAME += ( 'C46'                          )
        NAIF_BODY_CODE += ( -44542                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M24'                 )
        NAIF_BODY_CODE += ( -44542                         )

        NAIF_BODY_NAME += ( 'C47'                          )
        NAIF_BODY_CODE += ( -61186                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M25'                 )
        NAIF_BODY_CODE += ( -61186                         )

        NAIF_BODY_NAME += ( 'C48'                          )
        NAIF_BODY_CODE += ( -58655                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M26'                 )
        NAIF_BODY_CODE += ( -58655                         )

        NAIF_BODY_NAME += ( 'C49'                          )
        NAIF_BODY_CODE += ( -61187                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M27'                 )
        NAIF_BODY_CODE += ( -61187                         )

        NAIF_BODY_NAME += ( 'C50'                          )
        NAIF_BODY_CODE += ( -58654                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M28'                 )
        NAIF_BODY_CODE += ( -58654                         )

        NAIF_BODY_NAME += ( 'C21'                          )
        NAIF_BODY_CODE += ( -43208                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M3'                  )
        NAIF_BODY_CODE += ( -43208                         )

        NAIF_BODY_NAME += ( 'C22'                          )
        NAIF_BODY_CODE += ( -43207                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M4'                  )
        NAIF_BODY_CODE += ( -43207                         )

        NAIF_BODY_NAME += ( 'C23'                          )
        NAIF_BODY_CODE += ( -43581                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M5'                  )
        NAIF_BODY_CODE += ( -43581                         )

        NAIF_BODY_NAME += ( 'C24'                          )
        NAIF_BODY_CODE += ( -43582                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M6'                  )
        NAIF_BODY_CODE += ( -43582                         )

        NAIF_BODY_NAME += ( 'C27'                          )
        NAIF_BODY_CODE += ( -43107                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M7'                  )
        NAIF_BODY_CODE += ( -43107                         )

        NAIF_BODY_NAME += ( 'C28'                          )
        NAIF_BODY_CODE += ( -43108                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M8'                  )
        NAIF_BODY_CODE += ( -43108                         )

        NAIF_BODY_NAME += ( 'C29'                          )
        NAIF_BODY_CODE += ( -43245                         )

        NAIF_BODY_NAME += ( 'BEIDOU-3_M9'                  )
        NAIF_BODY_CODE += ( -43245                         )


        NAIF_BODY_NAME += ( 'EGNOS_PRN_123'                )
        NAIF_BODY_CODE += ( -39617                         )

        NAIF_BODY_NAME += ( 'ASTRA_5B'                     )
        NAIF_BODY_CODE += ( -39617                         )

        NAIF_BODY_NAME += ( 'WAAS_PRN_138'                 )
        NAIF_BODY_CODE += ( -28868                         )

        NAIF_BODY_NAME += ( 'CRE'                          )
        NAIF_BODY_CODE += ( -28868                         )

        NAIF_BODY_NAME += ( 'W*'                           )
        NAIF_BODY_CODE += ( -41589                         )

        NAIF_BODY_NAME += ( 'EUTELSAT_117_WEST_B'          )
        NAIF_BODY_CODE += ( -41589                         )

        NAIF_BODY_NAME += ( 'EGN*'                         )
        NAIF_BODY_CODE += ( -44624                         )

        NAIF_BODY_NAME += ( 'EUTELSAT_5_WEST_B'            )
        NAIF_BODY_CODE += ( -44624                         )

        NAIF_BODY_NAME += ( 'WAAS_PRN_135'                 )
        NAIF_BODY_CODE += ( -46114                         )

        NAIF_BODY_NAME += ( 'GALAXY_30'                    )
        NAIF_BODY_CODE += ( -46114                         )

        NAIF_BODY_NAME += ( 'SOUTHPA*'                     )
        NAIF_BODY_CODE += ( -28899                         )

        NAIF_BODY_NAME += ( 'INMARSAT_4-F2'                )
        NAIF_BODY_CODE += ( -28899                         )

        NAIF_BODY_NAME += ( 'IRNSS-1A'                     )
        NAIF_BODY_CODE += ( -39199                         )

        NAIF_BODY_NAME += ( 'IRNSS-1B'                     )
        NAIF_BODY_CODE += ( -39635                         )

        NAIF_BODY_NAME += ( 'IRNSS-1C'                     )
        NAIF_BODY_CODE += ( -40269                         )

        NAIF_BODY_NAME += ( 'IRNSS-1D'                     )
        NAIF_BODY_CODE += ( -40547                         )

        NAIF_BODY_NAME += ( 'IRNSS-1E'                     )
        NAIF_BODY_CODE += ( -41241                         )

        NAIF_BODY_NAME += ( 'IRNSS-1F'                     )
        NAIF_BODY_CODE += ( -41384                         )

        NAIF_BODY_NAME += ( 'IRNSS-1G'                     )
        NAIF_BODY_CODE += ( -41469                         )

        NAIF_BODY_NAME += ( 'IRNSS-1I'                     )
        NAIF_BODY_CODE += ( -43286                         )

        NAIF_BODY_NAME += ( 'SDCM_PRN_140'                 )
        NAIF_BODY_CODE += ( -37951                         )

        NAIF_BODY_NAME += ( 'LUCH_5A'                      )
        NAIF_BODY_CODE += ( -37951                         )

        NAIF_BODY_NAME += ( 'SDCM_PRN_125'                 )
        NAIF_BODY_CODE += ( -38977                         )

        NAIF_BODY_NAME += ( 'LUCH_5B'                      )
        NAIF_BODY_CODE += ( -38977                         )

        NAIF_BODY_NAME += ( 'SDCM_PRN_141'                 )
        NAIF_BODY_CODE += ( -39727                         )

        NAIF_BODY_NAME += ( 'LUCH_5V'                      )
        NAIF_BODY_CODE += ( -39727                         )

        NAIF_BODY_NAME += ( 'IRNSS-1J'                     )
        NAIF_BODY_CODE += ( -56759                         )

        NAIF_BODY_NAME += ( 'NVS-01'                       )
        NAIF_BODY_CODE += ( -56759                         )

        NAIF_BODY_NAME += ( 'IRNSS-1K'                     )
        NAIF_BODY_CODE += ( -62850                         )

        NAIF_BODY_NAME += ( 'NVS-02'                       )
        NAIF_BODY_CODE += ( -62850                         )

        NAIF_BODY_NAME += ( 'MICHIBIKI-1'                  )
        NAIF_BODY_CODE += ( -37158                         )

        NAIF_BODY_NAME += ( 'QZS-1'                        )
        NAIF_BODY_CODE += ( -37158                         )

        NAIF_BODY_NAME += ( 'QZSS_PRN_196'                 )
        NAIF_BODY_CODE += ( -49336                         )

        NAIF_BODY_NAME += ( 'QZS-1R'                       )
        NAIF_BODY_CODE += ( -49336                         )

        NAIF_BODY_NAME += ( 'QZSS_PRN_194'                 )
        NAIF_BODY_CODE += ( -42738                         )

        NAIF_BODY_NAME += ( 'QZS-2'                        )
        NAIF_BODY_CODE += ( -42738                         )

        NAIF_BODY_NAME += ( 'QZSS_PRN_199'                 )
        NAIF_BODY_CODE += ( -42917                         )

        NAIF_BODY_NAME += ( 'QZS-3'                        )
        NAIF_BODY_CODE += ( -42917                         )

        NAIF_BODY_NAME += ( 'QZSS_PRN_195'                 )
        NAIF_BODY_CODE += ( -42965                         )

        NAIF_BODY_NAME += ( 'QZS-4'                        )
        NAIF_BODY_CODE += ( -42965                         )

        NAIF_BODY_NAME += ( 'WAAS_PRN_133'                 )
        NAIF_BODY_CODE += ( -42709                         )

        NAIF_BODY_NAME += ( 'SES-15'                       )
        NAIF_BODY_CODE += ( -42709                         )

        NAIF_BODY_NAME += ( 'EGNOS_PRN_136'                )
        NAIF_BODY_CODE += ( -38652                         )

        NAIF_BODY_NAME += ( 'SES-5'                        )
        NAIF_BODY_CODE += ( -38652                         )

     \begintext

End of FK file.