KPL/MK

Meta-kernel for gaia Dataset v110 -- Operational 20250708_001
============================================================================

   This meta-kernel lists the gaia Operational SPICE kernels
   that provide information for the Operational scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the gaia Operational scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.5.1.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/gaia/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/gaia/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the gaia SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on July 8, 2025 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was gaia_ops_v110_20250708_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/gaia_sc_ssm_20131219_20150101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20150101_20160101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20160101_20170101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20170101_20180101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20180101_20190101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20190101_20200101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20200101_20210101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20210101_20220101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20220101_20230101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20230101_20240101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20240101_20250101_f20191030_v01.bc'
                           '$KERNELS/ck/gaia_sc_ssm_20250101_20250328_f20191030_v01.bc'

                           '$KERNELS/fk/gaia_v01.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/de-403-masses.tpc'
                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/sclk/gaia_fict_20191030.tsc'

                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/inpop10e_20130101_21260101_v01.bsp'
                           '$KERNELS/spk/gaia_rec_20131219_20240101_v01.bsp'
                           '$KERNELS/spk/gaia_rec_20240101_20250101_v01.bsp'
                           '$KERNELS/spk/gaia_rec_20250101_20250328_v01.bsp'
                           '$KERNELS/spk/gaia_flp_20131219_21250328_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v110_20250708_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'gaia_ops_v110_20250708_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.