KPL/MK

Meta-kernel for ExoMarsRSP Dataset v087 -- Reconstruction 20240219_001
==========================================================================

   This meta-kernel lists the ExoMarsRSP Operational SPICE kernels
   providing information for the full mission based on predicted, test
   and/or measured data.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   The set of kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best available data and
   the most complete coverage based on the information about the
   kernels available at the time this meta-kernel was made for the
   ExoMarsRSP Operational scenario.

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   Reading the comments of the binary SPK and C-Kernels is very helpful to
   understand the implemented S/C position and orientation. You can use the
   following NAIF command line utility to extract that information from the
   kernels:

      > commnt -r emrsp_*

   The kernels listed below can be obtained from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/ExoMarsRSP/kernels/


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the ExoMarsRSP SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on February 19, 2024 by Alfredo Escalante Lopez ESA/ESAC.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/fk/emrsp_rm_v014.tf'
                           '$KERNELS/fk/emrsp_dsk_surfaces_v000.tf'
                           '$KERNELS/fk/emrsp_sp_v007.tf'
                           '$KERNELS/fk/earthstns_ru_20191031.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/sclk/emrsp_rm_test_ret_20191128_v001.tsc'
                           '$KERNELS/sclk/emrsp_sp_fict_20191031_v001.tsc'

                           '$KERNELS/pck/pck00010.tpc'
                           '$KERNELS/pck/de-403-masses.tpc'

                           '$KERNELS/ik/emrsp_rm_navcam_v001.ti'
                           '$KERNELS/ik/emrsp_rm_pancam_v001.ti'
                           '$KERNELS/ik/emrsp_rm_loccam_v000.ti'
                           '$KERNELS/ik/emrsp_rm_isem_v000.ti'
                           '$KERNELS/ik/emrsp_rm_adron-rm_v000.ti'
                           '$KERNELS/ik/emrsp_rm_wisdom_v000.ti'
                           '$KERNELS/ik/emrsp_rm_clupi_v002.ti'
                           '$KERNELS/ik/emrsp_sp_ts_v000.ti'

                           '$KERNELS/ck/emrsp_rm_surf_gnc-zero_v001.bc'
                           '$KERNELS/ck/emrsp_rm_surf_mech-zero_v001.bc'
                           '$KERNELS/ck/emrsp_rm_surf_test_interp-tlm_0003_v002.bc'
                           '$KERNELS/ck/emrsp_rm_surf_test_rec_0382_v001.bc'
                           '$KERNELS/ck/emrsp_rm_surf_test_mech_0382_v001.bc'
                           '$KERNELS/ck/emrsp_sp_surf_20200318_v001.bc'

                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/mar097_20160314_20300101.bsp'
                           '$KERNELS/spk/earthstns_ru_20191031.bsp'
                           '$KERNELS/spk/emrsp_ls-plan_v001.bsp'
                           '$KERNELS/spk/emrsp_rm_sites_v002.bsp'
                           '$KERNELS/spk/emrsp_sp_struct_v002.bsp'
                           '$KERNELS/spk/emrsp_rm_struct_v007.bsp'
                           '$KERNELS/spk/emrsp_sp_gnc-zero_v001.bsp'
                           '$KERNELS/spk/emrsp_rm_gnc-zero_v001.bsp'
                           '$KERNELS/spk/emrsp_rm_test_rec_0382_v002.bsp'

                           '$KERNELS/dsk/emrsp_rm_site_001_001_v001.bds'

                         )

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int

   or ROCC at Altec Space:

           Federico Salvioli
           +39 011 7430 097
           federico.salvioli@altecspace.it


End of MK file.
