#!/bin/bash

SKD_SCRIPTS_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
SKD_GIT_DIR="$(pwd)/.git"

if [ -d "$SKD_GIT_DIR" ]
then
  if [ -d "$SKD_GIT_DIR/../kernels" ]
  then
      echo "INSTALLING POST-MERGE AND POST-CHECKOUT HOOKS TO:"

      if [ ! -d "$SKD_GIT_DIR/hooks/" ]
      then
          echo "Creating git/hooks path..."
          mkdir "$SKD_GIT_DIR/hooks/"
      fi

      cp "$SKD_SCRIPTS_DIR/git_hooks/post-merge" "$SKD_GIT_DIR/hooks/"
      chmod +x "$SKD_GIT_DIR/hooks/post-merge"

      cp "$SKD_SCRIPTS_DIR/git_hooks/post-checkout" "$SKD_GIT_DIR/hooks/"
      chmod +x "$SKD_GIT_DIR/hooks/post-checkout"

      cp "$SKD_SCRIPTS_DIR/update_local_mks.sh" "$SKD_GIT_DIR/hooks/"
      chmod +x "$SKD_GIT_DIR/hooks/update_local_mks.sh"

      echo "Installed at $SKD_GIT_DIR"
      exit 0

  else
    echo "Error: kernels folder not found. Be sure that you are in the SKD root path."
    exit 1
  fi
else
    echo "Error: .git folder not found. Be sure that you are in the SKD root path."
    exit 1
fi
