KPL/FK

Comet-Interceptor Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   Comet-Interceptor including definitions for the Comet-Interceptor fixed
   and Comet-Interceptor science instrument frames. This kernel also contains
   NAIF ID/name mapping for the Comet-Interceptor science instruments and s/c
   structures (see the last section of the file).


Version and Date
-----------------------------------------------------------------------------

   Version 2.0 -- April 7, 2022 -- Jaime Fernandez Diz, ESAC/ESA
                                   Alfredo Escalante Lopez, ESAC/ESA

      Added body-fixed reference frames for sub-spacecrafts B1 and B2.

      Added NAIF body/ID associations for spacecraft instruments.

   Version 1.0 -- June 21, 2021 -- Alfredo Escalante Lopez, ESAC/ESA

      Corrected INTERCEPTOR NPO frame secondary axis to Interceptor velociry
      in order to avoid computation error when secondary axis is 180 degrees
      from primary axis.

   Version 0.0 -- January 2, 2019 -- Marc Costa Sitja, ESAC/ESA

      Preliminary Version. Only basic ID and frame definitions.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the ESA SPICE
   Service at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           mcosta@sciops.esa.int, esa_spice@sciops.esa.int


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


Comet-Interceptor Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the Comet-Interceptor
   spacecraft, its structures and science instruments (the keywords 
   implementing these definitions are located in the section
   "Comet-Interceptor Mission NAIF ID Codes -- Definition Section" at the end
   of this file):

      Comet-Interceptor Spacecraft and Spacecraft Structures names/IDs:

            INTERCEPTOR_SPACECRAFT           -1000701
		INTERCEPTOR				   -1000701
		INTERCEPTOR_SC                   -1000701
		INTERCEPTOR_B1			   -1000702
		INTERCEPTOR_B2                   -1000703


Comet-Interceptor Mission Frames
-----------------------------------------------------------------------------

   The following Comet-Interceptor frames are defined in this kernel file:

           Name                  Relative to               Type       NAIF ID
      ======================  ========================  ==========   =========

    Spacecraft frames:
    ------------------
      INTERCEPTOR_SPACECRAFT    J2000                    CK(3)       -1000701
      INTERCEPTOR_TUTTLE_NPO                             Dynamic(5)  -1000710
      INTERCEPTOR_TUTTLE_DUST                            Dynamic(5)  -1000900
      INTERCEPTOR_TUTTLE_ION                             Dynamic(5)  -1000901


Comet-Interceptor Frames Hierarchy
-----------------------------------------------------------------------------

  The diagram below shows the Comet-Interceptor spacecraft and its structures
  frame hierarchy (not including science instrument frames.)

                                 "J2000" INERTIAL
           +------------------------------------+
           |                            |                
           |<-pck                       |                
           |                            |                
           V                            |                
      "EARTH_FIXED"                     |                
      -------------                     |                
                                        |
                                        |<-ck
                                        |
                                        V
                                 "INTERCEPTOR_SPACECRAFT"
                                 ---------------------
                                        .
                                        .
                                        .
                                        .
                                        V
                   Individual instrument frame trees are provided
                     in the corresponding sections of this file


Comet-Interceptor Spacecraft and Spacecraft Structures Frames
========================================================================

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


Comet-Interceptor Spacecraft Frame
--------------------------------------

   The Comet-Interceptor spacecraft frame is defined as follows:

      -  +Z axis is along the nominal boresight direction of the science 
         deck;

      -  +X axis is along the nominal boresight direction of the HGA;

      -  +Y axis completes the right-hand frame;

      -  the origin of this frame is the launch vehicle interface point.

   These diagrams illustrate the INTERCEPTOR_SPACECRAFT frame:


   +X s/c side (HGA side) view:
   ----------------------------
                                    ^
                                    | toward comet
                                    |

                               Science Deck
                             ._____________.
   .__  _______________.     |   ._____.   |     .______________  ___.
   |  \ \               \    | .'       `. |    /               \ \  |
   |  / /                \   |/     |     \|   /                / /  |
   |  \ \                 `. .      |      . .'                 \ \  |
   |  / /                 | o|      o      |o |                 / /  |
   |  \ \                 .' .    .' `.    . `.                 \ \  |
   |  / /                /   |\ +Zsc^  `  /|   \                / /  |
   .__\ \_______________/    | `.   |   .' |    \_______________\ \__.
     -Y Solar Array          .___` -|- '___.       +Y Solar Array
                                  / | \
                                  `-o-----> +Ysc
                                  +Xsc
                                                     +Xsc is out of
                                                        the page

   +Z s/c side (science deck side) view:
   -------------------------------------

                             ._____________.
                             |             |
                             |             |
                             |  +Zsc    +Ysc
   o==/ /==================o |      o----->|o==================/ /==o
     -Y Solar Array          |      |      |        +Y Solar Array
                             |      |      |
                             .______|______.
                                 .--V +Xsc
                          HGA  .'       `.
                              /___________\
                                  `.|.'                 +Zsc is out
                                                       of the page


   Since the orientation of the INTERCEPTOR_SPACECRAFT frame is computed
   on-board, sent down in telemetry, and stored in the s/c CK files, it
   is defined as a CK-based frame.

   \begindata

      FRAME_INTERCEPTOR_TUTTLE_NPO   = -1000710
      FRAME_-1000710_NAME            = 'INTERCEPTOR_TUTTLE_NPO'
      FRAME_-1000710_CLASS           =  5
      FRAME_-1000710_CLASS_ID        = -1000710
      FRAME_-1000710_CENTER          = -1000701
      FRAME_-1000710_RELATIVE        = 'J2000'
      FRAME_-1000710_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_-1000710_FAMILY          = 'TWO-VECTOR'
      FRAME_-1000710_PRI_AXIS        = 'Z'
      FRAME_-1000710_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_-1000710_PRI_OBSERVER    = 'INTERCEPTOR'
      FRAME_-1000710_PRI_TARGET      = 'TUTTLE'
      FRAME_-1000710_PRI_ABCORR      = 'NONE'
      FRAME_-1000710_SEC_AXIS        = 'X'
      FRAME_-1000710_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-1000710_SEC_OBSERVER    = 'INTERCEPTOR'
      FRAME_-1000710_SEC_TARGET      = 'SUN'
      FRAME_-1000710_SEC_ABCORR      = 'LT+S'
      FRAME_-1000710_SEC_FRAME       = 'J2000'

   \begintext


   \begindata

      FRAME_INTERCEPTOR_SPACECRAFT      = -1000701
      FRAME_-1000701_NAME               = 'INTERCEPTOR_SPACECRAFT'
      FRAME_-1000701_CLASS              =  3
      FRAME_-1000701_CLASS_ID           = -1000701
      FRAME_-1000701_CENTER             = -1000701
      CK_-1000701_SCLK                  = -1000701
      CK_-1000701_SPK                   = -1000701

   \begintext


Comet-Interceptor Subspacecraft B1 Frame
----------------------------------------

   The Comet-Interceptor spacecraft frame is defined as follows:

      -  +Z axis is along the nominal boresight direction of the science
         deck;

      -  +X axis is along the nominal boresight direction of the HGA;

      -  +Y axis completes the right-hand frame;

      -  the origin of this frame is the launch vehicle interface point.

   These diagrams illustrate the INTERCEPTOR_B1 frame: #TODO prepare ascii diagrams


   Since the orientation of the INTERCEPTOR_B1 frame is computed
   on-board, sent down in telemetry, and stored in the s/c CK files, it
   is defined as a CK-based frame.

   \begindata

      FRAME_INTERCEPTOR_B1_NPO          = -1000702
      FRAME_-1000702_NAME               = 'INTERCEPTOR_B1_NPO'
      FRAME_-1000702_CLASS              =  5
      FRAME_-1000702_CLASS_ID           = -1000702
      FRAME_-1000702_CENTER             = -1000702
      FRAME_-1000702_RELATIVE           = 'J2000'
      FRAME_-1000702_DEF_STYLE          = 'PARAMETERIZED'
      FRAME_-1000702_FAMILY             = 'TWO-VECTOR'
      FRAME_-1000702_PRI_AXIS           = 'Z'
      FRAME_-1000702_PRI_VECTOR_DEF     = 'OBSERVER_TARGET_POSITION'
      FRAME_-1000702_PRI_OBSERVER       = 'INTERCEPTOR_B1'
      FRAME_-1000702_PRI_TARGET         = 'TUTTLE'
      FRAME_-1000702_PRI_ABCORR         = 'NONE'
      FRAME_-1000702_SEC_AXIS           = 'X'
      FRAME_-1000702_SEC_VECTOR_DEF     = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-1000702_SEC_OBSERVER       = 'INTERCEPTOR_B1'
      FRAME_-1000702_SEC_TARGET         = 'SUN'
      FRAME_-1000702_SEC_ABCORR         = 'LT+S'
      FRAME_-1000702_SEC_FRAME          = 'J2000'

   \begintext


Comet-Interceptor Subspacecraft B2 Frame
----------------------------------------

   The Comet-Interceptor spacecraft frame is defined as follows:

      -  +Z axis is along the nominal boresight direction of the science
         deck;

      -  +X axis is along the nominal boresight direction of the HGA;

      -  +Y axis completes the right-hand frame;

      -  the origin of this frame is the launch vehicle interface point.

   These diagrams illustrate the INTERCEPTOR_B2 frame: #TODO prepare ascii diagrams


   Since the orientation of the INTERCEPTOR_B2 frame is computed
   on-board, sent down in telemetry, and stored in the s/c CK files, it
   is defined as a CK-based frame.

   \begindata

      FRAME_INTERCEPTOR_B2_NPO          = -1000703
      FRAME_-1000703_NAME               = 'INTERCEPTOR_B2_NPO'
      FRAME_-1000703_CLASS              =  5
      FRAME_-1000703_CLASS_ID           = -1000703
      FRAME_-1000703_CENTER             = -1000703
      FRAME_-1000703_RELATIVE           = 'J2000'
      FRAME_-1000703_DEF_STYLE          = 'PARAMETERIZED'
      FRAME_-1000703_FAMILY             = 'TWO-VECTOR'
      FRAME_-1000703_PRI_AXIS           = 'Z'
      FRAME_-1000703_PRI_VECTOR_DEF     = 'OBSERVER_TARGET_POSITION'
      FRAME_-1000703_PRI_OBSERVER       = 'INTERCEPTOR_B2'
      FRAME_-1000703_PRI_TARGET         = 'TUTTLE'
      FRAME_-1000703_PRI_ABCORR         = 'NONE'
      FRAME_-1000703_SEC_AXIS           = 'X'
      FRAME_-1000703_SEC_VECTOR_DEF     = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-1000703_SEC_OBSERVER       = 'INTERCEPTOR_B2'
      FRAME_-1000703_SEC_TARGET         = 'SUN'
      FRAME_-1000703_SEC_ABCORR         = 'LT+S'
      FRAME_-1000703_SEC_FRAME          = 'J2000'

   \begintext

Comet-Interceptor Subspacecraft B2 Rotating Frame
----------------------------------------

   The Comet-Interceptor spacecraft frame is defined as follows:

      -  +Z axis is along the nominal boresight direction of the science
         deck;


   These diagrams illustrate the INTERCEPTOR_B2 frame: #TODO prepare ascii diagrams


   Since the orientation of the INTERCEPTOR_B2 frame is computed
   on-board, sent down in telemetry, and stored in the s/c CK files, it
   is defined as a CK-based frame.

   \begindata

      FRAME_INTERCEPTOR_B2_SPIN         = -1000704
      FRAME_-1000704_NAME               = 'INTERCEPTOR_B2_SPIN'
      FRAME_-1000704_CLASS              =  5
      FRAME_-1000704_CLASS_ID           = -1000704
      FRAME_-1000704_CENTER             = -1000703
      FRAME_-1000704_RELATIVE           = 'INTERCEPTOR_B2_NPO'
      FRAME_-1000704_DEF_STYLE          = 'PARAMETERIZED'
      FRAME_-1000704_FAMILY             = 'EULER'
      FRAME_-1000704_EPOCH              = @2035-MAR-10/12:00:00
      FRAME_-1000704_AXES               = ( 3 2 1)
      FRAME_-1000704_UNITS              = 'DEGREES'
      FRAME_-1000704_ANGLE_1_COEFFS     = (0.0 57)
      FRAME_-1000704_ANGLE_2_COEFFS     = (0.0)
      FRAME_-1000704_ANGLE_3_COEFFS     = (0.0)


   \begintext


INTERCEPTOR TUTTLE Comet Dust Coma (INTERCEPTOR_TUTTLE_DUST)
------------------------------------------------------------------------

   Definition:
   -----------

   The Tuttle Comet Dust Coma frame is defined as follows:

      -  the velocity of TUTTLE relative to the Sun is the
         primary vector: +Z axis points to the velocity direction;

      -  the position of TUTTLE relative to the Sun is the
         secondary vector: the projection of the TUTTLE-SUN vector
         perpendicular to the +Z axis defines the +X axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of the TUTTLE
         nucleus.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary and secondary vectors are defined as 'observer-target position'
   and 'observer-target velocity' vectors, therefore, the ephemeris data
   required to compute the Sun-TUTTLE position vector in the J2000
   reference frame must be loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Mars, Mars's Barycenter, the Sun, the Solar
   System Barycenter and the TUTTLE comet will lead to different frame
   orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   INTERCEPTOR_TUTTLE_DUST using the IAU 2009 constants, the DE405 ephemeris
   and the TUTTLE ephemeris version N.

   \begindata

      FRAME_INTERCEPTOR_TUTTLE_DUST  = -1000900
      FRAME_-1000900_NAME             = 'INTERCEPTOR_TUTTLE_DUST'
      FRAME_-1000900_CLASS            =  5
      FRAME_-1000900_CLASS_ID         = -1000900
      FRAME_-1000900_CENTER           =  1000099
      FRAME_-1000900_RELATIVE         = 'J2000'
      FRAME_-1000900_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-1000900_FAMILY           = 'TWO-VECTOR'
      FRAME_-1000900_PRI_AXIS         = '-Z'
      FRAME_-1000900_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-1000900_PRI_OBSERVER     = 'TUTTLE'
      FRAME_-1000900_PRI_TARGET       = 'SUN'
      FRAME_-1000900_PRI_ABCORR       = 'NONE'
      FRAME_-1000900_PRI_FRAME        = 'J2000'
      FRAME_-1000900_SEC_AXIS         = 'X'
      FRAME_-1000900_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-1000900_SEC_OBSERVER     = 'TUTTLE'
      FRAME_-1000900_SEC_TARGET       = 'SUN'
      FRAME_-1000900_SEC_ABCORR       = 'NONE'

  \begintext


INTERCEPTOR TUTTLE Comet Ion Coma (INTERCEPTOR_TUTTLE_ION)
------------------------------------------------------------------------

   Definition:
   -----------

   The INTERCEPTOR TUTTLE Comet Ion Coma frame is defined as follows:

      -  the position of TUTTLE relative to the Sun is the
         primary vector: +Z axis points from the TUTTLE to
         the Sun;

      -  the velocity of TUTTLE relative to the Sun is the
         secondary vector: the projection of the velocity vector
         perpendicular to the +Z axis defines the +X axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of the TUTTLE
         nucleus.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary and secondary vectors are defined as 'observer-target position'
   and 'observer-target velocity' vectors, therefore, the ephemeris data
   required to compute the Sun-TUTTLE position vector in the J2000
   reference frame must be loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Mars, Mars's Barycenter, the Sun, the Solar
   System Barycenter and the TUTTLE comet will lead to different frame
   orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   INTERCEPTOR_TUTTLE_ION using the IAU 2009 constants, the DE405 ephemeris
   and the TUTTLE ephemeris version N.

   \begindata

      FRAME_INTERCEPTOR_TUTTLE_ION   = -1000901
      FRAME_-1000901_NAME             = 'INTERCEPTOR_TUTTLE_ION'
      FRAME_-1000901_CLASS            =  5
      FRAME_-1000901_CLASS_ID         = -1000901
      FRAME_-1000901_CENTER           =  1000099
      FRAME_-1000901_RELATIVE         = 'J2000'
      FRAME_-1000901_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-1000901_FAMILY           = 'TWO-VECTOR'
      FRAME_-1000901_PRI_AXIS         = 'Z'
      FRAME_-1000901_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-1000901_PRI_OBSERVER     = 'TUTTLE'
      FRAME_-1000901_PRI_TARGET       = 'SUN'
      FRAME_-1000901_PRI_ABCORR       = 'NONE'
      FRAME_-1000901_SEC_AXIS         = 'X'
      FRAME_-1000901_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-1000901_SEC_OBSERVER     = 'TUTTLE'
      FRAME_-1000901_SEC_TARGET       = 'SUN'
      FRAME_-1000901_SEC_ABCORR       = 'NONE'
      FRAME_-1000901_SEC_FRAME        = 'J2000'

  \begintext


Comet-Interceptor NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the Comet-Interceptor
   mission. Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  Spacecraft:
  ----------------------------------------------------------------

      This table presents the Comet-Interceptor Spacecraft and its main
      structures' names.

      ---------------------   -------  --------------------------
       Name                    ID       Synonyms
      ---------------------   -------  --------------------------
       INTERCEPTOR_SPACECRAFT -1000701  INTERCEPTOR_SC
      ---------------------   -------  --------------------------

      Notes:

         -- 'INTERCEPTOR_SC' and 'INTERCEPTOR_SPACECRAFT' are synonyms and
            all map to the Comet-Interceptor s/c bus structure ID (-1000701);

     \begindata

        NAIF_BODY_NAME += ( 'INTERCEPTOR'                     )
        NAIF_BODY_CODE += ( -1000701                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_SC'                  )
        NAIF_BODY_CODE += ( -1000701                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_B1'                  )
        NAIF_BODY_CODE += ( -1000702                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_B2'                  )
        NAIF_BODY_CODE += ( -1000703                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_SPACECRAFT'          )
        NAIF_BODY_CODE += ( -1000701                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_COCA'                )
        NAIF_BODY_CODE += ( -1000699                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_DFP_SCIENA'          )
        NAIF_BODY_CODE += ( -1000679                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_DFP_LEES'            )
        NAIF_BODY_CODE += ( -1000678                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_ENVISS'              )
        NAIF_BODY_CODE += ( -1000694                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_HI'                  )
        NAIF_BODY_CODE += ( -1000698                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_MIRMIS_NIR'          )
        NAIF_BODY_CODE += ( -1000669                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_MIRMIS_MIR'          )
        NAIF_BODY_CODE += ( -1000668                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_MIRMIS_TIRI'         )
        NAIF_BODY_CODE += ( -1000667                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_OPIC'                )
        NAIF_BODY_CODE += ( -1000693                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_PS'                  )
        NAIF_BODY_CODE += ( -1000697                          )


        NAIF_BODY_NAME += ( 'INTERCEPTOR_NAC'                 )
        NAIF_BODY_CODE += ( -1000696                          )

        NAIF_BODY_NAME += ( 'INTERCEPTOR_WAC'                 )
        NAIF_BODY_CODE += ( -1000695                          )

     \begintext


End of FK file.