      PROGRAM READAF
C +----------------------+--------------------------+
C |   PROJECT ROS        |  MODULE READAF           |
C +----------------------|--------------------------+
C |   FDD                |  M. LAUER / G. PICKL     |
C +----------------------+--------------------------+------------------+
C |  FUNCTIONAL DESCRIPTION :                                          |
C |  ------------------------                                          |
C |  SAMPLE PROGRAM TO DEMONSTRATE THE USAGE OF ATTITUDE FILE ACCESS.  |    
C |                                                                    |
C |  THIS IS AN INTERACTIVE PROGRAM.                                   |
C |  FIRST THE USER IS PROMPTED TO GIVE THE NAME OF THE ATTITUDE FILE  |
C |  AND THE UNIT NUMBER WHICH IS TO BE USED FOR OPENING.              |
C |  THEN THE USER IS PROMPTED IN A LOOP TO GIVE THE EPOCH FOR WHICH   |
C |  ATTITUDE DATA IS REQUESTED. THE LOOP ENDS WHEN THE USER GIVES 0   |
C |  AS EPOCH.                                                         |
C +--------------------------------------------------------------------+
C  
C
C
C      CHARACTER*68 SCCS_INFO(2)
C      DATA SCCS_INFO
C     ./'@(#)/home/imsatt/auxiliary_data/SW_Delivery/main/SCCS/s.readaf.F	',
C     .'1.3	03/08/06 	IMSS_FDD\n'/
C    
C      
C  DATA DECLARATION
C
      CHARACTER*132 FNAME
      INTEGER IUNIT(3), IORDER, NVARS, IFRAME, ITSCAL, IF, IER
      INTEGER IYEAR, MONTH, IDAY, IHOUR, MINUTE 
      DOUBLE PRECISION TBEG, TEND, TIME, STATE(7),SEC
C      
C  USE 8 AS ORDER OF INTERPOLATION
C
      DATA IORDER/8/
C
C  PROMPT FOR FILENAME AND UNIT NUMBER
C
      WRITE(6,*) ' *** PROGRAM READAF ***'
      WRITE(6,*) ' '
      WRITE(6,*) ' GIVE NAME OF ATTITUDE FILE '               
      READ(5,*) FNAME
      WRITE(6,*) ' GIVE UNIT NUMBER '               
      READ(5,*) IUNIT(1)
C
C  OPEN ATTITUDE FILE
C  PROVIDE INFORMATION ON ATTITUDE FILE
C  IN CASE OF FAILURE STOP PROGRAM
C      
      CALL RAFOP (IUNIT, FNAME, IORDER, NVARS, IFRAME,
     .                         ITSCAL, TBEG, TEND, IF, IER)
      IF (IER.NE.0) THEN
         WRITE(6,*) 'CANNOT OPEN ATTITUDE FILE'
         WRITE(6,*) 'REASON CODE: ', IER 
         WRITE(6,*) 'PROGRAM READAF STOPPED'
         STOP
      END IF
      WRITE(6,*) ' '
      WRITE(6,*) 'ATTITUDE FILE'
      WRITE(6,*) FNAME
      WRITE(6,*) 'OPENED TO UNIT ',IUNIT
      WRITE(6,*) 'DATA COVER TIME SPAN FROM '
C
C  CONVERT MJD2000 START EPOCH TO CALENDER DATE AND TIME
C  TAKE CARE OF ROUNDING
      CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
      IF (SEC .GE. 59.999999995) THEN
         SEC = 0.0D0 
         MINUTE = MINUTE + 1
         IF (MINUTE .EQ. 60) THEN
            MINUTE = 0
            IHOUR = IHOUR + 1
            IF (IHOUR .EQ. 24) THEN
               TBEG = TBEG + 0.5D0
               CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
               SEC = 0.0D0
               MINUTE = 0
               IHOUR = 0
            ENDIF
         ENDIF
      ENDIF
      IF (SEC .LT. 10.0D0) THEN
         WRITE(6,1000) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ELSE 
         WRITE(6,1001) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ENDIF

      WRITE(6,*) 'TO'
C
C  CONVERT MJD2000 END EPOCH TO CALENDER DATE AND TIME
C  TAKE CARE OF ROUNDING
      CALL DJ2000(TEND,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
      IF (SEC .GE. 59.999999995) THEN
         SEC = 0.0D0
         MINUTE = MINUTE + 1
         IF (MINUTE .EQ. 60) THEN
            MINUTE = 0
            IHOUR = IHOUR + 1
            IF (IHOUR .EQ. 24) THEN
               TBEG = TBEG + 0.5D0
               CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
               SEC = 0.0D0
               MINUTE = 0
               IHOUR = 0
            ENDIF
         ENDIF
      ENDIF
      IF (SEC .LT. 10.0D0) THEN
         WRITE(6,1000) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ELSE 
         WRITE(6,1001) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ENDIF
C      
C  START LOOP
C
100   CONTINUE
C
C  PROMPT FOR CALENDER DATE AND TIME
C  FOR INPUT=0 STOP LOOP
C
      WRITE(6,*) ' '
      WRITE(6,*) ' GIVE CALENDER DATE IN THE FORMAT YYYY-MM-DDThh:mm:'
     .           // 'ss.sss (0 TO STOP PROGRAM) '
      READ(5,1010,ERR=910) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      IF (IYEAR .EQ. 0) GOTO 200
      IF ((IYEAR .LT. 1950) .OR. (MONTH .LT. 1) .OR. (MONTH .GT. 12)
     .   .OR. (IDAY .LT. 1) .OR. (IDAY .GT. 31) .OR. (IHOUR .LT. 0)
     .   .OR. (IHOUR .GT. 23) .OR. (MINUTE .LT. 0) .OR. (MINUTE .GT. 59)
     .   .OR. (SEC .LT. 0.0D0) .OR. (SEC .GE. 60.0D0))  THEN
         WRITE(6,*) 'INPUT DATE AND TIME MAKES NO SENSE'
         GOTO 100
      ENDIF
C
C  CONVERT CALENDER DATE TO MJD2000
C
      CALL JD2000(TIME,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
C
C  RETRIEVE STATE FROM ATTITUDE FILE
C  PROVIDE STATE AND ADDITIONAL INFORMATION
C  IN CASE OF FAILURE TRY AGAIN
C    
      CALL RAFRR (IF, TIME, STATE, IFRAME, IER)
      IF (IER.NE.0) THEN
         WRITE(6,*) 'CANNOT READ STATE'
         WRITE(6,*) 'REASON CODE: ', IER
      ELSE
         WRITE(6,*) ' S/C ATTITUDE QUATERNION:'
         WRITE(6,1020) STATE(1), STATE(2), STATE(3), STATE(4)
         WRITE(6,*) ' S/C ANGULAR RATE (RAD/S):'
         WRITE(6,1021) STATE(5), STATE(6), STATE(7)
      END IF
      GOTO 100
C
C  CLOSE ATTITUDE FILE
C     
200   CONTINUE 
      CALL RAFCL (IF, IER)
      WRITE(6,*) ' '
      WRITE(6,*) 'PROGRAM READAF STOPPED'
      STOP
C
C  ERROR READING INPUT TIME 
C    
 910  CONTINUE
      WRITE(6,*) ' '
      WRITE(6,*) ' CANNOT READ TIME'
      GOTO 100
C
C  FORMATS
C
 1000 FORMAT(I4.4,'-',I2.2,'-',I2.2,'T',I2.2,':',I2.2,':0',F10.8)
 1001 FORMAT(I4.4,'-',I2.2,'-',I2.2,'T',I2.2,':',I2.2,':',F11.8)
 1010 FORMAT(I4,4(1X,I2),1X,D24.0)
 1020 FORMAT(1X,4F15.10)
 1021 FORMAT(1X,3F15.10)
      END
