      PROGRAM READOF
C +----------------------+--------------------------+
C |   PROJECT ROS        |  MODULE READOF           |
C +----------------------|--------------------------+
C |   FDD                |  M. LAUER / G. PICKL     |
C +----------------------+--------------------------+------------------+
C |  FUNCTIONAL DESCRIPTION :                                          |
C |  ------------------------                                          |
C |  SAMPLE PROGRAM TO DEMONSTRATE THE USAGE OF ORBIT FILE ACCESS.     |    
C |                                                                    |
C |  THIS IS AN INTERACTIVE PROGRAM.                                   |
C |  FIRST THE USER IS PROMPTED TO GIVE THE NAME OF THE ORBIT FILE AND |
C |  THE UNIT NUMBER WHICH IS TO BE USED FOR OPENING.                  |
C |  THEN THE USER IS PROMPTED IN A LOOP TO GIVE THE EPOCH FOR WHICH   |
C |  THE STATE IS REQUESTED. THE LOOP ENDS WHEN THE USER GIVES 0 AS    |
C |  EPOCH.                                                            |
C +--------------------------------------------------------------------+
C 
C
C
C      CHARACTER*68 SCCS_INFO(2)
C      DATA SCCS_INFO
C     ./'@(#)/home/imsatt/auxiliary_data/SW_Delivery/main/SCCS/s.readof.F	',
C     .'1.1	01/10/30 	IMSS_FDD\n'/
C
C     
C  DATA DECLARATION
C
      CHARACTER*132 FNAME
      INTEGER IUNIT, IORDER, NVARS, IFRAME, IBODY, ITSCAL, IF, IER
      INTEGER IYEAR, MONTH, IDAY, IHOUR, MINUTE 
      DOUBLE PRECISION TBEG, TEND, TIME, STATE(6) ,SEC
C      
C  USE 8 AS ORDER OF INTERPOLATION
C
      DATA IORDER/8/
C
C  PROMPT FOR FILENAME AND UNIT NUMBER
C
      WRITE(6,*) ' *** PROGRAM READOF ***'
      WRITE(6,*) ' '
      WRITE(6,*) ' GIVE NAME OF ORBIT FILE '               
      READ(5,*) FNAME
      WRITE(6,*) ' GIVE UNIT NUMBER '               
      READ(5,*) IUNIT
C
C  OPEN ORBIT FILE
C  PROVIDE INFORMATION ON ORBIT FILE
C  IN CASE OF FAILURE STOP PROGRAM
C      
      CALL ROFOP (IUNIT, FNAME, IORDER, NVARS, IFRAME, IBODY,
     .                         ITSCAL, TBEG, TEND, IF, IER)
      IF (IER.NE.0) THEN
         WRITE(6,*) 'CANNOT OPEN ORBIT FILE'
         WRITE(6,*) 'REASON CODE: ', IER 
         WRITE(6,*) 'PROGRAM READOF STOPPED'
         STOP
      END IF
      WRITE(6,*) ' '
      WRITE(6,*) 'ORBIT FILE'
      WRITE(6,*) FNAME
      WRITE(6,*) 'OPENED TO UNIT ',IUNIT
      WRITE(6,*) 'DATA COVER TIME SPAN FROM '

C  CONVERT MJD2000 START EPOCH TO CALENDER DATE AND TIME
C  TAKE CARE OF ROUNDING
      CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
      IF (SEC .GE. 59.999999995) THEN
         SEC = 0.0D0 
         MINUTE = MINUTE + 1
         IF (MINUTE .EQ. 60) THEN
            MINUTE = 0
            IHOUR = IHOUR + 1
            IF (IHOUR .EQ. 24) THEN
               TBEG = TBEG + 0.5D0
               CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
               SEC = 0.0D0
               MINUTE = 0
               IHOUR = 0
            ENDIF
         ENDIF
      ENDIF
      IF (SEC .LT. 10.0D0) THEN
         WRITE(6,1000) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ELSE 
         WRITE(6,1001) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ENDIF

      WRITE(6,*) 'TO'

C  CONVERT MJD2000 END EPOCH TO CALENDER DATE AND TIME
C  TAKE CARE OF ROUNDING
      CALL DJ2000(TEND,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
      IF (SEC .GE. 59.999999995) THEN
         SEC = 0.0D0
         MINUTE = MINUTE + 1
         IF (MINUTE .EQ. 60) THEN
            MINUTE = 0
            IHOUR = IHOUR + 1
            IF (IHOUR .EQ. 24) THEN
               TBEG = TBEG + 0.5D0
               CALL DJ2000(TBEG,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
               SEC = 0.0D0
               MINUTE = 0
               IHOUR = 0
            ENDIF
         ENDIF
      ENDIF
      IF (SEC .LT. 10.0D0) THEN
         WRITE(6,1000) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ELSE 
         WRITE(6,1001) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      ENDIF
C      
C  START LOOP
C
100   CONTINUE
C
C  PROMPT FOR CALENDER DATE AND TIME
C  FOR INPUT=0 STOP LOOP
C
      WRITE(6,*) ' '
      WRITE(6,*) ' GIVE CALENDER DATE IN THE FORMAT YYYY-MM-DDThh:mm:'
     .           // 'ss.sss (0 TO STOP PROGRAM) '
      READ(5,1010,ERR=910) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      IF (IYEAR .EQ. 0) GOTO 200
      IF ((IYEAR .LT. 1950) .OR. (MONTH .LT. 1) .OR. (MONTH .GT. 12)
     .   .OR. (IDAY .LT. 1) .OR. (IDAY .GT. 31) .OR. (IHOUR .LT. 0)
     .   .OR. (IHOUR .GT. 23) .OR. (MINUTE .LT. 0) .OR. (MINUTE .GT. 59)
     .   .OR. (SEC .LT. 0.0D0) .OR. (SEC .GE. 60.0D0))  THEN
         WRITE(6,*) 'INPUT DATE AND TIME MAKES NO SENSE'
         GOTO 100
      ENDIF
C
C  CONVERT CALENDER DATE TO MJD2000
C
      CALL JD2000(TIME,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
C
C  RETRIEVE STATE FROM ORBIT FILE
C  PROVIDE STATE AND ADDITIONAL INFORMATION
C  IN CASE OF FAILURE TRY AGAIN
C    
      CALL ROFRR (IF, TIME, STATE, IFRAME, IBODY, IER)
      IF (IER.NE.0) THEN
         WRITE(6,*) 'CANNOT READ STATE'
         WRITE(6,*) 'REASON CODE: ', IER
      ELSE
         WRITE(6,*) ' S/C POSITION (KM):'
         WRITE(6,1020) STATE(1), STATE(2), STATE(3)
         WRITE(6,*) ' S/C VELOCITY (KM/S):'
         WRITE(6,1020) STATE(4), STATE(5), STATE(6)
         IF(IBODY.EQ.11)
     .    WRITE(6,*) ' S/C STATE IS GIVEN WRT SUN'
         IF(IBODY.EQ.3)
     .    WRITE(6,*) ' S/C STATE IS GIVEN WRT EARTH'
         IF(IBODY.EQ.4)
     .    WRITE(6,*) ' S/C STATE IS GIVEN WRT MARS'
      END IF
      GOTO 100
C
C  CLOSE ORBIT FILE
C     
200   CONTINUE 
      CALL ROFCL (IF, IER)
      WRITE(6,*) ' '
      WRITE(6,*) 'PROGRAM READOF STOPPED'
      STOP
C
C  ERROR READING INPUT TIME 
C    
 910  CONTINUE
      WRITE(6,*) ' '
      WRITE(6,*) ' CANNOT READ TIME'
      GOTO 100
C
C  FORMATS
C
 1000 FORMAT(I4.4,'-',I2.2,'-',I2.2,'T',I2.2,':',I2.2,':0',F10.8)
 1001 FORMAT(I4.4,'-',I2.2,'-',I2.2,'T',I2.2,':',I2.2,':',F11.8)
 1010 FORMAT(I4,4(1X,I2),1X,D24.0)
 1020 FORMAT(1X,3F21.6)
      END
      
