      PROGRAM AS2BIN
C  
CP  The program transforms ASCII versions of orbit or attitude files
CP  into binary versions.
C
CC  PROJ=GEN,SUBJ=AUX,UTIL=GEN,AUTH=G.PICKL TOS-G/FDD/IMSS
CC  07/12/2000
C
C
CV  The user is prompted to give the name of the ASCII version of the 
CV  interpolation file to be transformed and the name of the target
CV  binary version of the file.
C
C   COMMON blocks used
CB  (only via called functions)
C
C   SUBROUTINES called
CS  WOFOP   opens a new binary orbit file
CS  WAFOP   opens a new binary attitude file
CS  WOFNB   creates a new block in binary orbit file
CS  WAFNB   creates a new block in binary attitude file
CS  WOFNR   writes a new record to a block in orbit file
CS  WAFNR   writes a new record to a block in attitude file
CS  WOFCL   closes binary orbit file
CS  WAFCL   closes binary attitude file
C      

C-----------------------------------------------------------------------
C  DECLARATION OF VARIABLES
C-----------------------------------------------------------------------


C      CHARACTER*68 SCCS_INFO(2)
C      DATA SCCS_INFO
C     ./'@(#)/home/imsatt/auxiliary_data/SW_Delivery/main/SCCS/s.as2bin.F	',
C     .'1.8	02/05/23 	IMSS_FDD\n'/


      CHARACTER*132 FNAME1,FNAME2
      CHARACTER*255 LINE,VALUES,KEYBUF,KEYWDS
      CHARACTER*24  CBODY,CFORM
      CHARACTER*8   CFRAME

      DOUBLE PRECISION  SEC,ENDTIM,STATIM,TIME,STATE,DERIV

      INTEGER  NVARS,NDERIV,NTYPE,NFRAME,NCBODY,NSCALE,NLINE,NKEY,NVMAX,
     .         IERR,NBLOCK,I,J,IYEAR,MONTH,IDAY,IHOUR,MINUTE,IHEAD,
     .         IDENT,IBEG,ILA,ILEN


C
      PARAMETER (NKEY=17)
      PARAMETER (NVMAX=7)

      DIMENSION VALUES(NKEY),KEYWDS(NKEY),CBODY(0:11),CFRAME(0:3)
      DIMENSION STATE(NVMAX),DERIV(NVMAX)

      DATA CBODY/'SOLAR SYSTEM BARYCENTER','MERCURY','VENUS','EARTH',
     .    'MARS','JUPITER','SATURN','URANUS','NEPTUN','PLUTO','MOON',
     .    'SUN'/
      DATA CFRAME/'EME2000','EC2000','EME1950','EC1950'/
      
      DATA NBLOCK,IHEAD,NLINE/0,0,0/

      DATA KEYWDS/ 'START_TIME','STOP_TIME','REF_FRAME','CENTER_NAME',
     .             'TIME_SYSTEM','FILE_TYPE','VARIABLES_NUMBER',
     .             'DERIVATIVES_FLAG','CREATION_DATE','OBJECT_NAME',
     .             'OBJECT_ID','VERSION_NUMBER','COMMENT','META_START',
     .             'META_STOP','ESOC_TOS_GFI_ATTITUDE_FILE_VERSION',
     .             'ESOC_TOS_GFI_ORBIT_FILE_VERSION'/

C-----------------------------------------------------------------------
C  READ FILE NAMES AND OPEN INPUT FILE
C-----------------------------------------------------------------------
      WRITE (6,*) 'Give name of input ASCII interpolation file:'
      READ (5,'(A132)')  FNAME1
      WRITE (6,*) 'Give name of output binary file:'
      READ (5,'(A132)')  FNAME2
      WRITE (6,*) ' '
      
C  OPEN INPUT FILE      
      OPEN (UNIT = 15, FILE = FNAME1, STATUS = 'OLD', IOSTAT = IERR, 
     .      ERR = 910)

C-----------------------------------------------------------------------
C  READ HEADER INFORMATION
C-----------------------------------------------------------------------
      DO 1 I=1,NKEY
         VALUES(I) = ' '
 1    CONTINUE

 2    CONTINUE
      READ (15,'(A255)',END=901) LINE
      NLINE = NLINE + 1 
      IF (LINE .EQ. ' ') GOTO 2
      CALL KEYVAL(LINE,KEYWDS,NKEY,KEYBUF,VALUES,IERR)
      IF (IERR .NE. 0) GOTO 999
      IF (KEYBUF .EQ. 'COMMENT') GOTO 2
      IF (KEYBUF .EQ. 'META_START') GOTO 11
      IF ((KEYBUF .NE. 'ESOC_TOS_GFI_ATTITUDE_FILE_VERSION') .AND.
     .         (KEYBUF .NE. 'ESOC_TOS_GFI_ORBIT_FILE_VERSION')) 
     .   GOTO 911
C  
C-----------------------------------------------------------------------
C  READ METADATA BLOCK
C-----------------------------------------------------------------------
C  
 11   CONTINUE
      NBLOCK = NBLOCK+1
      DO 20 I=1,NKEY
         VALUES(I) = ' '
 20   CONTINUE

 30   CONTINUE
      READ (15,'(A255)',END = 925) LINE
      NLINE=NLINE+1
      IF (LINE .EQ. ' ') GOTO 30
      CALL KEYVAL(LINE,KEYWDS,NKEY,KEYBUF,VALUES,IERR)
      IF (IERR .NE. 0) GOTO 999
C
      IF (KEYBUF .EQ. 'COMMENT') GOTO 30
      IF (KEYBUF .EQ. 'META_STOP') GOTO 40
      GOTO 30
 40   CONTINUE

      IF ((IHEAD .EQ. 0)) THEN
C    NUMBER OF VARIABLES
         READ(VALUES(7),'(I4)',ERR=940) NVARS
C    DERIVATIVES
         READ(VALUES(8),'(I4)',ERR=941)  NDERIV
C    FILE TYPE
         IF (VALUES(6) .EQ. 'ORBIT FILE') THEN
            NTYPE = 1
         ELSE IF (VALUES(6) .EQ. 'ATTITUDE FILE') THEN
            NTYPE = 2
         ELSE 
            GOTO 948
         ENDIF
      ENDIF

C-----------------------------------------------------------------------
C  BLOCKHEADER VARIABLES
C-----------------------------------------------------------------------
C  TIME SCALE
      IF (IHEAD .EQ. 0) THEN
         IF (VALUES(5) .NE. 'TDB') GOTO 960
         NSCALE = 0
      ENDIF
C  REFERENCE FRAME
      DO 70 I=0,3
         IF (VALUES(3) .EQ. CFRAME(I)) THEN
            NFRAME=I
            GOTO 80
         ENDIF
 70   CONTINUE
      GOTO 961
 80   CONTINUE
C  CENTER NAME (ONLY FOR ORBIT FILES)
      IF (NTYPE .EQ. 1) THEN
         DO 90 I=0,11
            IF (VALUES(4) .EQ. CBODY(I)) THEN
               NCBODY=I
               GOTO 100
            ENDIF
 90      CONTINUE
         GOTO 962
 100     CONTINUE
      ENDIF

C  STARTTIME
      READ(VALUES(1),400,ERR=965) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      CALL JD2000(STATIM,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)
C  ENDTIME
      READ(VALUES(2),400,ERR=966) IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC
      CALL JD2000(ENDTIM,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)

C  OPEN BINARY FILE
      IF (IHEAD .EQ. 0) THEN
         IF (NTYPE .EQ. 1) THEN 
            CALL WOFOP (16, FNAME2, NVARS, NDERIV, NFRAME, NCBODY,
     .               NSCALE,IDENT,IERR)
         ELSE IF (NTYPE .EQ. 2) THEN 
            CALL WAFOP (16, FNAME2, NVARS, NDERIV, NFRAME,
     .               NSCALE,IDENT,IERR)
         ENDIF
         IF (IERR .NE. 0) GOTO 970
         IHEAD = 1
      ENDIF
C CREATE NEW BLOCK
      IF (NTYPE .EQ. 1) THEN
         CALL WOFNB(IDENT, NFRAME, NCBODY, IERR)
      ELSE
         CALL WAFNB(IDENT, NFRAME, NCBODY, IERR)
      ENDIF
      IF (IERR .NE. 0) GOTO 975
 
C-----------------------------------------------------------------------
C  BLOCK DATA
C-----------------------------------------------------------------------
C  WRITE STATES IN BLOCK
 130  READ (15,'(A255)',END=900) LINE
      NLINE=NLINE+1
      IF (LINE .EQ. ' ' .OR. LINE(1:7) .EQ. 'COMMENT') GOTO 130
C
C  NEW BLOCK BEGINS
      IF (LINE(1:10) .EQ. 'META_START') GOTO 11
C
      READ(LINE,410,IOSTAT=IERR,ERR=980) IYEAR,MONTH,IDAY,IHOUR,MINUTE

      IBEG = 18
C  READ SECONDS AND STATE FROM VARIABLE "LINE"
      DO 140 I=0,NVARS
         DO 145 J=IBEG,255
            IF ((LINE(J:J) .EQ. ' ') .OR. (LINE(J:J) .EQ. ',')) THEN
               GOTO 145
            ELSE
               IBEG = J
               GOTO 146
            ENDIF
 145     CONTINUE
 146     CONTINUE

         DO 148 J=IBEG,255
            IF ((LINE(J:J) .EQ. ' ') .OR. (LINE(J:J) .EQ. ',')) THEN
               ILA = J
               GOTO 149
            ENDIF
 148     CONTINUE
 149     CONTINUE
         ILEN = ILA-IBEG
         WRITE(CFORM,'(A2,I3,A3)',IOSTAT=IERR,ERR=982) 
     .        '(D',ILEN,'.1)'
         IF (I .EQ. 0) THEN
            READ(LINE(IBEG:),CFORM,IOSTAT=IERR,ERR=983) SEC
         ELSE 
            READ(LINE(IBEG:),CFORM,IOSTAT=IERR,ERR=984) STATE(I)
         ENDIF
         IBEG = ILA
         
 140  CONTINUE

      IF (NDERIV .EQ. 1) THEN
         NLINE = NLINE + 1
         READ(15,*,IOSTAT=IERR,ERR=985) (DERIV(J),J=1,NVARS)
      ENDIF
      CALL JD2000(TIME,IYEAR,MONTH,IDAY,IHOUR,MINUTE,SEC)

      IF (NTYPE .EQ. 1) THEN
         CALL WOFNR (IDENT, TIME, STATE, DERIV, IERR)
      ELSE 
         CALL WAFNR (IDENT, TIME, STATE, DERIV, IERR)
      ENDIF
      IF (IERR .NE. 0) GOTO 986
      GOTO 130

C-----------------------------------------------------------------------      
C  CLOSE FILES     
C-----------------------------------------------------------------------
900   CONTINUE
      CLOSE(15)
      IF (NTYPE .EQ. 1) THEN
         CALL WOFCL(IDENT,IERR)
         IF (IERR .NE. 0) GOTO 989
         WRITE(6,*) ' '
         WRITE(6,*) 'binary orbit file created'
         WRITE(6,*) 'number of blocks written: ', NBLOCK
      ELSE
         CALL WAFCL(IDENT,IERR)
         IF (IERR .NE. 0) GOTO 989
         WRITE(6,*) ' '
         WRITE(6,*) 'binary attitude file created'
         WRITE(6,*) 'number of blocks written: ', NBLOCK
      ENDIF
      GOTO 999

C-----------------------------------------------------------------------
C  FORMATS 
C-----------------------------------------------------------------------
 400  FORMAT(I4,1X,4(I2,1X),F12.9)
 410  FORMAT(I4,1X,4(I2,1X))
C-----------------------------------------------------------------------
C  ERROR HANDLING
C-----------------------------------------------------------------------

 901  CONTINUE 
      WRITE (0,*) 'Input file is empty or contains only comments'
      GOTO 999

 910  CONTINUE 
      WRITE (0,*) 'Cannot open input file '
      WRITE (0,*) 'Error code: ',IERR
      GOTO 999

 911  CONTINUE 
      WRITE (0,*) 'Wrong keyword in file header '
      WRITE (0,*) 'Keyword: ',KEYBUF
      GOTO 999

 920  CONTINUE
      WRITE(0,*) '"META_START" not first keyword in block number '
     .               ,NBLOCK+1
      GOTO 999

 925  CONTINUE
      WRITE(0,*) 'End of input file in metadata block number ',NBLOCK
      GOTO 999

 940  CONTINUE
      WRITE(0,*) 'Cannot get number of variables'
      GOTO 999 

 941  CONTINUE
      WRITE(0,*) 'Cannot get derivatives flag'
      GOTO 999 

 948  CONTINUE
      WRITE(0,*) 'Wrong "FILE_TYPE" in metadata block ',NBLOCK
      GOTO 999
  
 960  CONTINUE
      WRITE(0,*) 'Wrong "TIME_SCALE" in metadata block ',NBLOCK
      GOTO 999

 961  CONTINUE
      WRITE(0,*) 'Wrong "REF_FRAME" in metadata block ',NBLOCK
      GOTO 999

 962  CONTINUE
      WRITE(0,*) 'Wrong "CENTER_NAME" in metadata block ',NBLOCK
      GOTO 999

 965  CONTINUE
      WRITE(0,*) 'Cannot get "START_TIME" in metadata block ',NBLOCK
      GOTO 999 

 966  CONTINUE
      WRITE(0,*) 'Cannot get "STOP_TIME" in metadata block ',NBLOCK
      GOTO 999
   
 970  CONTINUE
      WRITE(0,*) 'Cannot open output file '
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999

 975  CONTINUE
      WRITE(0,*) 'Cannot create new block number ',NBLOCK
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999

 980  CONTINUE
      WRITE(0,*) 'Cannot read date/time from line ', NLINE
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999   

 982  CONTINUE
      WRITE(0,*) 'Cannot write format to read stste'
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999   

 983  CONTINUE
      WRITE(0,*) 'Cannot read seconds in line ', NLINE
      WRITE(0,*) 'Error code: ',IERR
      PRINT*, IBEG,ILEN,CFORM
      GOTO 999  

 984  CONTINUE
      WRITE(0,*) 'Cannot read states in line ', NLINE
      WRITE(0,*) 'Error code: ',IERR
      PRINT*, IBEG,ILEN,CFORM
      GOTO 999  

 985  CONTINUE
      WRITE(0,*) 'Cannot read derivatives in line ', NLINE
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999  

 986  CONTINUE
      WRITE(0,*) 'Cannot add new record to binary file'
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999

 989  CONTINUE
      WRITE(0,*) 'Cannot close binary file'
      WRITE(0,*) 'Error code: ',IERR
      GOTO 999

C-----------------------------------------------------------------------
 999  CONTINUE
      STOP
      END   
C-----------------------------------------------------------------------  




      SUBROUTINE KEYVAL(LINE,KEYWDS,NKEY,KEYWD,VALUE,IER)
C
CP  SETS KEYWORD = FIRST WORD FROM CHARACTER STRING "LINE".
CP  ALLOWED KEYWORDS ARE GIVEN IN ARRAY "KEYWDS".
CP  IF LINE HAS THE STRUCTURE "KEYWORD = VALUE", VALUE IS STORED IN 
CP  ARRAY "VALUE", POSITION CORRESPONDS TO KEYWORD IN ARRAY "KEYWDS".
CP  IF THERE IS NO "=" AFTER KEYWORD, REST OF LINE IS STORED AS VALUE.  
C
C
CI  INPUT DESCRIPTION:
CI    LINE:       CH*255   CHARACTER STRING
CI    KEYWDS(*):  CH*(*)   ARRAY WITH ALLOWED KEYWORDS
CI    NKEY:       I*4      NUMBER OF ALLOWED KEYWORDS
CO  OUTPUT DESCRIPTION:
CO    KEYWD:      CH*(*)   KEYWORD READ FROM "LINE"
CO    VALUE(*):   CH*(*)   ARRAY TO STORE VALUES
CO    IER:        I*4      ERROR CODE
CO                         0 IF NO ERROR OCCURED
CO                         1 IF WRONG KEYWORD
CO                         2 IF NO VALUE AFTER "="
C

C  HEADER VARIABLES
      CHARACTER*255 LINE
      CHARACTER*(*) VALUE(*),KEYWD,KEYWDS(*)
      INTEGER NKEY,IER

C  LOCAL VARIABLES 
      INTEGER I,J,K,IKEY


      KEYWD=' '
      IER=0
      K=0
C  READ KEYWORD
      DO 10 I=1,255
         IF (LINE(I:I) .NE. ' ' .AND. LINE(I:I) .NE. '=') THEN
            KEYWD=KEYWD(1:K)//LINE(I:I)
            K=K+1
         ELSE IF ((LINE(I:I) .EQ. ' ' .AND. K .NE. 0) .OR.
     .             LINE(I:I) .EQ. '=') THEN
            GOTO 20
         ENDIF
 10   CONTINUE
C  IDENTIFY KEYWORD  
 20   CONTINUE
      DO 25 IKEY=1,NKEY
            IF (KEYWD .EQ. KEYWDS(IKEY)) GOTO 26
 25   CONTINUE
C  WRONG KEYWORD
      GOTO 910
 26   CONTINUE
C
C 
C  SEARCH "="
      IF (LINE(I:I) .EQ. '=') THEN
         J=I
      ELSE
         DO 30 J=I+1,255
            IF (LINE(J:J) .EQ. '=') GO TO 40
            IF (LINE(J:J) .NE. ' ') THEN
               VALUE(IKEY) = LINE(J:255)
               GOTO 999
            ENDIF
 30      CONTINUE
         GOTO 999
      ENDIF
C  READ VALUE
 40   CONTINUE
      K=0
      DO 50 I=J+1,255
         IF ((LINE(I:I) .EQ. ' ' .OR. LINE(I:I) .EQ. '_')
     .       .AND. K .NE. 0) THEN
            IF (VALUE(IKEY)(K:K) .NE. ' ') THEN
               VALUE(IKEY)=VALUE(IKEY)(1:K)//' '
               K=K+1
            ENDIF
         ELSE IF (LINE(I:I) .NE. ' ' .AND. LINE(I:I) .NE. '_') THEN
            VALUE(IKEY)=VALUE(IKEY)(1:K) // LINE(I:I)
            K=K+1
         ENDIF 
 50   CONTINUE
      IF (K .EQ. 0) GOTO 920
      GOTO 999
C
C  ERROR HANDLING 
 910  CONTINUE
      WRITE(0,*) 'Wrong keyword. Input line:'
      WRITE(0,*) LINE
      IER = 1
      GOTO 999

 920  CONTINUE
      WRITE(0,*) 'No value found. Input line:'
      WRITE(0,*) LINE
      IER = 2
      GOTO 999

C
 999  CONTINUE
      RETURN
      END

