KPL/MK

Meta-kernel for ExoMars 2016 dataset v1.5.1 -- Operational 20170223_001
==========================================================================

   This meta-kernel lists the EXOMARS 2016 operational SPICE kernels 
   providing  information for the full mission based on reconstructed, 
   predicted, test and optionaly, measured data.

     
Usage of the Meta-kernel                               
-------------------------------------------------------------------------    

  The mission phases of the ExoMars 2016 mission are:

      Phase Name                    Acronym    Start Date   End Date   
     ----------------------------  ---------  ------------ ------------
      Launch and Early Orbit         leop      2016-03-14   2016-03-21  
      Near Earth Commissioning       necp      2016-03-22   2016-04-17  
      Interplanetary Cruise          icp       2016-04-18   2016-09-06  
      Mars Approach and MOI          mamp      2016-09-07   2016-12-19  
      Aerobraking                    ap        2017-01-04   2017-11-15  
      Primary Science                psp       2017-11-15   2019-11-15 
      Data Relay                     drp       2019-01-14   2022-12-31  

   The SPK kernels have cover the following coverage:

      Summary for: ../spk/em16_tgo_flp_002_01_20171120_20230301_v01.bsp
       
      Body: EXOMARS 2016 TGO (-143)
            Start of Interval (ET)              End of Interval (ET)
            -----------------------------       -----------------------------
            2017 NOV 20 12:01:08.182            2023 MAR 01 00:01:08.185
       
       
      Summary for: ../spk/em16_tgo_fpp_014_01_20160314_20170315_v01.bsp
       
      Body: EXOMARS 2016 TGO (-143)
            Start of Interval (ET)              End of Interval (ET)
            -----------------------------       -----------------------------
            2016 MAR 14 08:14:09.000            2017 MAR 15 12:00:57.796


   The CK kernels have cover the following coverage:

      Summary for: ../ck/em16_tgo_sc_slt_npo_20180101_20181231_s20170201_v01.bc
       
      Object:  -143000
        Interval Begin ET        Interval End ET          AV
        ------------------------ ------------------------ ---
        2018-JAN-01 00:00:00.073 2018-DEC-31 23:59:59.174 Y
       
       
      Summary for: ../ck/em16_tgo_sc_fpp_014_01_20160314_20170315_s20170201_v01.bc
       
      Object:  -143000
        Interval Begin ET        Interval End ET          AV
        ------------------------ ------------------------ ---
        2016-MAR-14 20:14:09.185 2017-MAR-15 00:01:09.185 Y
       
       
      Summary for: ../ck/em16_tgo_sc_fpp_d170207_pointing_20170305_20170309_s20170201_v01.bc
       
      Object:  -143000
        Interval Begin ET        Interval End ET          AV
        ------------------------ ------------------------ ---
        2017-MAR-05 12:01:09.185 2017-MAR-09 20:01:09.185 Y


   If you want to use a TGO CK with measured data from the you will need to 
   load kernels with the following name schema:

      em16_tgo_sc_scm_*_v01.bc
 
   Reading the comments of the binary SPK and C-Kernels is very helpful to 
   understand the implemented SC position and orientation. You can use the 
   following NAIF command line utility to extract that information from the 
   kernels:

      > commnt -r em16_tgo_sc_*.bc

   The kernels listed below can be obtained from the ESAC FTP server:
      
      ftp://spiftp.esac.esa.int/data/SPICE/ExoMars2016/kernels/


Implementation Notes
-------------------------------------------------------------------------    
  
   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the EXOMARS 2016 SPICE data set's ``data'' directory on 
   their system. Replacing ``/'' with ``\'' and converting line 
   terminators to the format native to the user's system may also be 
   required if this meta-kernel is to be used on a non-UNIX workstation.

-------------------   

   This file was created on February 28, 2017 by Marc Costa Sitja ESAC/ESA.


   \begindata

PATH_VALUES       = ( '/Users/mcosta/Dropbox/SPICE/SPICE_EM16/ftp/data/SPICE/ExoMars2016/kernels' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

        '$KERNELS/ck/em16_tgo_sc_slt_npo_20180101_20181231_s20170201_v01.bc'
        '$KERNELS/ck/em16_tgo_sc_fpp_014_01_20160314_20170315_s20170201_v01.bc'
        '$KERNELS/ck/em16_tgo_sc_fpp_d170207_pointing_20170305_20170309_s20170201_v01.bc'

        '$KERNELS/ck/em16_tgo_acs_sop_default_20160314_21000101_s20160719_v01.bc'
        '$KERNELS/ck/em16_tgo_cassis_scp_tel_20160314_20161019_s20160414_v01.bc'
        '$KERNELS/ck/em16_tgo_cassis_ipp_tel_20160407_20170309_s20170116_v02.bc'
        '$KERNELS/ck/em16_tgo_nomad_sop_default_20160404_21000101_s20160719_v01.bc'
        '$KERNELS/ck/em16_tgo_nomad_scp_20160404_20161019_s20160414_v01.bc'
        '$KERNELS/ck/em16_edm_sop_axis_20161016_20161019_f20160921_v01.bc'
        '$KERNELS/ck/em16_edm_sop_spin_20161016_20161019_f20160921_v01.bc'
          

        '$KERNELS/fk/em16_tgo_v10.tf'
        '$KERNELS/fk/em16_edm_v01.tf'
        '$KERNELS/fk/em16_tgo_ops_v02.tf'
        '$KERNELS/fk/rssd0002.tf'
          

        '$KERNELS/ik/em16_tgo_acs_v04.ti'
        '$KERNELS/ik/em16_tgo_cassis_v04.ti'
        '$KERNELS/ik/em16_tgo_frend_v04.ti'
        '$KERNELS/ik/em16_tgo_nomad_v04.ti'
        '$KERNELS/ik/em16_edm_deca_v00.ti'
          

        '$KERNELS/lsk/naif0012.tls'
          

        '$KERNELS/pck/pck00010.tpc'
        '$KERNELS/pck/de-403-masses.tpc'
          

        '$KERNELS/sclk/em16_tgo_step_20170201.tsc'
        '$KERNELS/sclk/em16_edm_fict_20160921.tsc'


        '$KERNELS/spk/em16_tgo_flp_002_01_20171120_20230301_v01.bsp'
        '$KERNELS/spk/em16_tgo_fpp_014_01_20160314_20170315_v01.bsp'

        '$KERNELS/spk/em16_edm_sot_landing_site_20161020_21000101_v01.bsp'
        '$KERNELS/spk/em16_edm_fpd_028_01_20161016_20161020_v01.bsp'
        '$KERNELS/spk/em16_edm_fpd_d161018_postsep_20161016_20161019_v01.bsp'

        '$KERNELS/spk/de432s.bsp'
        '$KERNELS/spk/mar097.bsp'

                        )

   \begintext


End of MK file. 