#
# This example script makes the program take users for a 2 minute trip
# to the Earth and Moon.
#
# Import Cosmographia scripting module.
#
import cosmoscripting
cosmo = cosmoscripting.Cosmo()

waittime    = 1
msgwaittime = 1
msgshowtime = 2

testjson = "/Users/mcosta/Dropbox/SPICE/SPICE_CROSS_MISSION/cosmographia/missions/BEPIC/scenarios/load_BEPIC_SCIENCE_PHASE_001.json"

#
# Display a welcome message that will stay on the screen for 3 seconds.
# Make Cosmographia wait for 4 seconds before moving onto the next step
# to give users a chance to read the message. In subsequent blocks the
# script will use displayNote to display a message before each set of
# commands but the post-message wait times will be smaller to make
# messages stay on the screen just as the steps themselves start being
# executed.
#
# cosmo.displayNote( "Welcome to Cosmographia Scripting Example!", 3 ).wait( 4 )

#
# Use hideToolBar to hide the left toolbar. Use hideStatusMessages to hide
# program's default status messages that might colide with
# annotations displayed by calls to displayNotes. Use hideInfoText to
# to hide informational blocks at the top left and top right corners.
# Use showFullScreen to switch to full screen mode. All commands are
# instanteneous and will occur during the 4 second wait set by wait.
#
# cosmo.displayNote( "Switch to full screen, hide toolbar and info text", 3 ).wait( 4 )
# cosmo.hideToolBar()
# cosmo.hideStatusMessages()
# cosmo.hideInfoText()
# cosmo.showFullScreen()

#
# Use gotoHome to go to the Solar System "home" view. Use
# setCameraToInertialFrame and setTimeRate to set the rendering
# frame to ICRF and the time rate to 1 second/second. The total time
# to run the commands below will be 7 seconds -- 1 second set by wait
# after displayNote + 5 seconds used by gotoHome + 1 second set by
# wait after gotoHome. The setCameraToInertialFrame and setTimeRate
# commands are instantaneous.
#
# cosmo.displayNote( "Start with the Solar System home view", 3 ).wait( 1 )
# cosmo.setCameraToInertialFrame()
# cosmo.setTimeRate( 1 )
# cosmo.gotoHome( 5 )
# cosmo.wait( 1 )


# cosmo.displayNote('cosmo.loadCatalogFile(testjson)', msgshowtime).wait(0)
cosmo.loadCatalogFile(testjson).wait( waittime )

#
# Set time using setTime to 2015-10-31 23:50:00 UTC. The total time to
# run the commands below will be 3 seconds -- 2 in wait + another 1 in
# wait. The setTime command is instantaneous.
#
# cosmo.displayNote( "Set time to 2025-10-27 23:50 UTC", 2 ).wait( 0 )
cosmo.setTime( "2026-04-17 13:00:00 UTC" )
# cosmo.wait( 1 )

# cosmo.displayNote( "Fly to MPO", 3 ).wait( 0 )
cosmo.gotoObject( "MPO", 2 )
# cosmo.moveToPov("Mercury", [0.0,-5000.0,-1000.0], [0.0,-1.0,0.0], [0.0,0.0,1.0], 1.0).wait(waittime * 2)
# cosmo.wait( 1 )


#
# Reset all visual attributes and settings that we changed.
# All commands are instanteneous and will occur during the 3
# second wait set by wait.
#
cosmo.showToolBar()
cosmo.showStatusMessages()
cosmo.showInfoText()
cosmo.showNormalWindow()



#
# End of the example script.
#
