#
# This example script makes the program take users for a 2 minute trip
# to the Earth and Moon.
#
# Import Cosmographia scripting module.
#

import cosmoscripting
cosmo = cosmoscripting.Cosmo()

cosmo.hidePlanetOrbits()
cosmo.setTimeRate(1)

# Europa flyby 1
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.setTime( "2030-09-17 09:22:00 UTC" )
cosmo.hideTrajectory( "JUICE" )
cosmo.faster10x()
cosmo.faster10x()
# speed 1e2
cosmo.wait(50)

cosmo.circleCenterLeft(110, 1)
cosmo.circleCenterUp(45, 1)
cosmo.pointAtObject( "Jupiter" )
cosmo.wait(0.5)
cosmo.trackObject( "Jupiter" )
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.wait(12.25)
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.wait(50)

# callisto flyby
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.setTime( "2031-05-29 06:28:00 UTC" )
cosmo.hideTrajectory( "JUICE" )
# speed 1e2
cosmo.wait(50)

# ganymedes flyby
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.setTime( "2032-09-16 21:30:00 UTC" )
cosmo.hideTrajectory( "JUICE" )
# speed 1e2
cosmo.wait(50)

# cosmo.gotoHome()
# cosmo.faster10x()
# cosmo.faster10x()
# cosmo.wait(32)
#
# #
# # Set time using setTime to 2015-10-31 23:50:00 UTC. The total time to
# # run the commands below will be 3 seconds -- 2 in wait + another 1 in
# # wait. The setTime command is instantaneous.
# #
# # cosmo.displayNote( "Set time to 2025-10-27 23:50 UTC", 2 ).wait( 0 )
# cosmo.setTime( "2030-09-17 09:36:36.718 UTC" )
#
# cosmo.gotoObject( "JUICE", 2 )
#
# #cosmo.rollLeft(90.0, 3.0).wait( waittime )
#
# cosmo.faster10x()
# cosmo.faster10x()
#
# cosmo.gotoObject( "GANYMEDE", 2 )
#
# #
# # Reset all visual attributes and settings that we changed.
# # All commands are instanteneous and will occur during the 3
# # second wait set by wait.
# #
# cosmo.showToolBar()
# cosmo.showStatusMessages()
# cosmo.showInfoText()
# cosmo.showNormalWindow()
#
#
# #
# # End of the example script.
# #
#