#
# This example script makes the program take users for a 2 minute trip
# to the Earth and Moon.
#
# Import Cosmographia scripting module.
#

import cosmoscripting
cosmo = cosmoscripting.Cosmo()

waittime    = 1
msgwaittime = 1
msgshowtime = 2

testjson = "/Users/mcosta/SPICE/JUICE/misc/cosmo/open_day/scenarios/load_JUICE_crema_4_0_001.json"

# cosmo.displayNote('cosmo.loadCatalogFile(testjson)', msgshowtime).wait(0)
cosmo.loadCatalogFile(testjson).wait( waittime )

cosmo.setTimeRate(1).wait( 1 )
cosmo.setTime( "2022-06-01 00:00:00 UTC" )

cosmo.gotoHome()
cosmo.showPlanetOrbits()
cosmo.wait(1)

cosmo.showTrajectory("JUICE")
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster2x()
cosmo.wait(14)
# speed 2e6

# earth flyby 1
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.hideTrajectory( "JUICE" )
cosmo.hidePlanetOrbits()
cosmo.setTime( "2023-05-30 16:00:00 UTC" )
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
# speed 5e2
cosmo.wait(50)

cosmo.showTrajectory("JUICE")
cosmo.gotoHome()
cosmo.showPlanetOrbits()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster2x()
cosmo.faster2x()
# speed 2e6
cosmo.wait(4)

# venus flyby
cosmo.gotoObject( "JUICE", 1 )
cosmo.hideTrajectory( "JUICE" )
cosmo.hidePlanetOrbits()
cosmo.setTime( "2023-10-22 12:00:00 UTC" )
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
# speed 5e2
cosmo.pointAtObject( "Venus" )
cosmo.wait(0.5)
cosmo.trackObject( "Venus" )
cosmo.wait(30)

cosmo.showTrajectory("JUICE")
cosmo.gotoHome()
cosmo.showPlanetOrbits()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster2x()
cosmo.faster2x()
# speed 2e6
cosmo.wait(19.3)

# mars flyby
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.hideTrajectory( "JUICE" )
cosmo.hidePlanetOrbits()
cosmo.setTime( "2025-02-10 17:05:00 UTC" )
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
# speed 2.5e2
cosmo.wait(30)

cosmo.showTrajectory("JUICE")
cosmo.gotoHome()
cosmo.showPlanetOrbits()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.faster2x()
# speed 4e6
cosmo.wait(13)

# earth flyby 3
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.setTime( "2026-11-25 23:25:00 UTC" )
cosmo.hideTrajectory( "JUICE" )
cosmo.hidePlanetOrbits()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
# speed 5e2
cosmo.wait(28.5)

cosmo.showTrajectory("JUICE")
cosmo.gotoHome()
cosmo.showPlanetOrbits()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster10x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.faster2x()
cosmo.moveAwayFromCenter( 1500000000 , 1)
# speed 8e6
cosmo.wait(10)

# jupiter arrival
cosmo.moveToPov( "JUICE" , [0.5, 0, -2], [0, 0, 1], [1, 0, 0], 2)
cosmo.setTime( "2029-10-06 22:10:00 UTC" )
cosmo.hideTrajectory( "JUICE" )
cosmo.hidePlanetOrbits()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower2x()
cosmo.slower10x()
cosmo.slower10x()
cosmo.slower10x()
# speed 2.5e2
cosmo.wait(20)
cosmo.pointAtObject( "Jupiter" )
cosmo.wait(1)
cosmo.trackObject( "Jupiter" )
cosmo.wait(10)

# cosmo.gotoHome()
# cosmo.faster10x()
# cosmo.faster10x()
# cosmo.wait(32)
#
# #
# # Set time using setTime to 2015-10-31 23:50:00 UTC. The total time to
# # run the commands below will be 3 seconds -- 2 in wait + another 1 in
# # wait. The setTime command is instantaneous.
# #
# # cosmo.displayNote( "Set time to 2025-10-27 23:50 UTC", 2 ).wait( 0 )
# cosmo.setTime( "2030-09-17 09:36:36.718 UTC" )
#
# cosmo.gotoObject( "JUICE", 2 )
#
# #cosmo.rollLeft(90.0, 3.0).wait( waittime )
#
# cosmo.faster10x()
# cosmo.faster10x()
#
# cosmo.gotoObject( "GANYMEDE", 2 )
#
# #
# # Reset all visual attributes and settings that we changed.
# # All commands are instanteneous and will occur during the 3
# # second wait set by wait.
# #
# cosmo.showToolBar()
# cosmo.showStatusMessages()
# cosmo.showInfoText()
# cosmo.showNormalWindow()
#
#
# #
# # End of the example script.
# #
#